﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using com.ast8.fw.forms;

namespace WitchPaper
{
    public partial class WitchMonitor : Form
    {
        com.ast8.fw.forms.WitchPaper m_watchObj;
        public WitchMonitor()
        {
            InitializeComponent();

            dataGridView1.RowHeadersVisible = false;
            dataGridView1.ReadOnly = false; //true;
            dataGridView1.RowHeadersWidthSizeMode = DataGridViewRowHeadersWidthSizeMode.DisableResizing;
            dataGridView1.CellBorderStyle = DataGridViewCellBorderStyle.Single;
            dataGridView1.EditMode = DataGridViewEditMode.EditOnEnter;//DataGridViewEditMode.EditProgrammatically;
            dataGridView1.AllowUserToResizeColumns = false;
            dataGridView1.AllowUserToResizeRows = false;

            dataGridView1.CellValueChanged += new DataGridViewCellEventHandler(dataGridView1_CellValueChanged);
        }

        protected virtual void dataGridView1_CellValueChanged(object sender, DataGridViewCellEventArgs e)
        {
            //throw new Exception("The method or operation is not implemented.");
        }

        public virtual void init(com.ast8.fw.forms.WitchPaper watchObj)
        {
            m_watchObj = watchObj;
            refreshWindow();
        }

        private void refreshWindow()
        {
            if (ClientSize.Width <= 100)
                return;
            dataGridView1.Width = ClientSize.Width - dataGridView1.Left;
            //dataGridView1.SelectionMode = DataGridViewSelectionMode.FullRowSelect;
            //dataGridView1.ReadOnly = true;
            dataGridView1.Rows.Clear();
            dataGridView1.ColumnCount = 2;
            dataGridView1.RowCount = getColumnCount();
            dataGridView1.Columns[0].HeaderText = "項目";
            dataGridView1.Columns[1].HeaderText = "内容";
            dataGridView1.Columns[0].Width = 100;
            dataGridView1.Columns[1].Width = ClientSize.Width - 100 - dataGridView1.Margin.Size.Width;
            DataGridViewRowCollection col = dataGridView1.Rows;
            string[] header = getHeader();
            for (int i = 0; i < header.Length; i++)
            {
                col[i].Cells[0].Value = header[i];
            }
            refreshValues();
        }


        protected virtual int getColumnCount()
        {
            return 10;
        }

        protected virtual string[] getHeader()
        {
            return new string[] {
                "CurrentLineIndex",
                "CurrentX",
                "CurrentY",
                "StartX",
                "StartY",
                "EndX",
                "EndY",
                "InputMode",
                "SelectMode",
                "Lines.Count"
            };
        }

        protected virtual string[] getValues()
        {
            return new string[] {
                m_watchObj.CurrentLineIndex.ToString(),
                m_watchObj.SelectionArea.CurrentX.ToString(),
                m_watchObj.SelectionArea.CurrentY.ToString(),
                m_watchObj.SelectionArea.StartX.ToString(),
                m_watchObj.SelectionArea.StartY.ToString(),
                m_watchObj.SelectionArea.EndX.ToString(),
                m_watchObj.SelectionArea.EndY.ToString(),
                m_watchObj.InputMode.ToString(),
                m_watchObj.SelectMode.ToString(),
                m_watchObj.Lines.Count.ToString()
            };
        }

        private void refreshValues()
        {
            DataGridViewRowCollection col = dataGridView1.Rows;
            string[] values = getValues();
            for (int i = 0; i < values.Length; i++)
            {
                col[i].Cells[1].Value = values[i];
            }
        }

        private void WitchMonitor_Load(object sender, EventArgs e)
        {
                
        }

        private void button1_Click(object sender, EventArgs e)
        {
            refreshValues();
        }

        private void WitchMonitor_Resize(object sender, EventArgs e)
        {
            refreshWindow();
        }

        private bool isRefresh = false;
        private void timer1_Tick(object sender, EventArgs e)
        {
            if (isRefresh)
                return;
            isRefresh = true;
            refreshValues();
            isRefresh = false;
        }

        private void checkBox1_CheckedChanged(object sender, EventArgs e)
        {
            timer1.Enabled = checkBox1.Checked;
        }

        private void button2_Click(object sender, EventArgs e)
        {
            Close();
        }

        private void label1_Click(object sender, EventArgs e)
        {

        }

        private void numericUpDown1_ValueChanged(object sender, EventArgs e)
        {
            timer1.Interval = decimal.ToInt32(numericUpDown1.Value);
        }
    }
}