﻿using System;
using System.Collections.Generic;
using System.Text;

namespace com.ast8.fw.forms
{
    public static class ScrollMagician
    {
        #region 型
        /// <summary>
        /// スクロールについての構造体
        /// </summary>
        [System.Runtime.InteropServices.StructLayout(System.Runtime.InteropServices.LayoutKind.Sequential)]
        public struct SCROLLINFO
        {
            /// <summary>この構造体のサイズ</summary>
            public uint cbSize;
            /// <summary>フラグ。SIF系定数から指定する</summary>
            public uint fMask;
            /// <summary>スクロールバーの最小値</summary>
            public int nMin;
            /// <summary>スクロールバーの最大値</summary>
            public int nMax;
            /// <summary>スクロールバーのページ移動時の移動量</summary>
            public uint nPage;
            /// <summary>スクロールバーの現在位置</summary>
            public int nPos;
            /// <summary>スライダードラッグ時の位置</summary>
            public int nTrackPos;
        }
        #endregion

        #region 定数

        #region WndProc
        public const int WM_HSCROLL = 0x0114;
        public const int WM_VSCROLL = 0x0115;
        public const int WM_MOUSEWHEEL = 0x20A;
        public const int WHEEL_DELTA = 120;
        /*
         * Scroll bar messages
         */
        public const int SBM_SETPOS          =         0x00E0; // not in win3.1
        public const int SBM_GETPOS          =         0x00E1; // not in win3.1
        public const int SBM_SETRANGE        =         0x00E2; // not in win3.1
        public const int SBM_SETRANGEREDRAW  =         0x00E6; // not in win3.1
        public const int SBM_GETRANGE        =         0x00E3; // not in win3.1
        public const int SBM_ENABLE_ARROWS   =         0x00E4; // not in win3.1
        public const int SBM_SETSCROLLINFO   =         0x00E9;
        public const int SBM_GETSCROLLINFO   =         0x00EA;

        /// <summary>スクロール範囲をnMinとnMaxにします。</summary>
        public const int SIF_RANGE           = 0x0001;
        /// <summary>スクロールページをnPageに指定した値にします。</summary>
        public const int SIF_PAGE = 0x0002;
        /// <summary>スクロール位置をnPosで指定した値にします。</summary>
        public const int SIF_POS = 0x0004;
        /// <summary>スクロールバーが不要の時は除去せずに使用不能にします。</summary>
        public const int SIF_DISABLENOSCROLL = 0x0008;
        /// <summary>スクロールボックス（つまみ）の現在の位置を、lpsi パラメータが指す SCROLLINFO 構造体の nTrackPos メンバに格納します。</summary>
        public const int SIF_TRACKPOS = 0x0010;
        /// <summary>全指定時の便利定数</summary>
        public const int SIF_ALL = (SIF_RANGE | SIF_PAGE | SIF_POS | SIF_TRACKPOS);
        /*
         * Scroll Bar Constants
         */
        public const int SB_HORZ          = 0;
        public const int SB_VERT          = 1;
        public const int SB_CTL           = 2;
        public const int SB_BOTH          = 3;

        /*
         * Scroll Bar Commands
         */
        public const int SB_LINEUP        = 0;
        public const int SB_LINELEFT      = 0;
        public const int SB_LINEDOWN      = 1;
        public const int SB_LINERIGHT     = 1;
        public const int SB_PAGEUP        = 2;
        public const int SB_PAGELEFT      = 2;
        public const int SB_PAGEDOWN      = 3;
        public const int SB_PAGERIGHT     = 3;
        public const int SB_THUMBPOSITION = 4;
        public const int SB_THUMBTRACK    = 5;
        public const int SB_TOP           = 6;
        public const int SB_LEFT          = 6;
        public const int SB_BOTTOM        = 7;
        public const int SB_RIGHT         = 7;
        public const int SB_ENDSCROLL     = 8;
        #endregion

        #region CreateWindow(Ex)
        /// <summary>ウィンドウスタイルの垂直スクロールバー表示ビット</summary>
        public const int WS_VSCROLL = 0x00200000;
        /// <summary>ウィンドウスタイルの水平スクロールバー表示ビット</summary>
        public const int WS_HSCROLL = 0x00100000;
        #endregion

        #region GetSystemMetrics
        /// <summary>水平スクロールバーの矢印の幅</summary>
        public const int SM_CXHSCROLL = 21;
        /// <summary>水平スクロールバーの矢印の高さ</summary>
        public const int SM_CYHSCROLL = 3;
        /// <summary>水平スクロールバーのつまみの幅</summary>
        public const int SM_CXHTHUMB = 10;
        /// <summary>垂直スクロールバーの矢印の幅</summary>
        public const int SM_CXVSCROLL = 2;
        /// <summary>垂直スクロールバーの矢印の高さ</summary>
        public const int SM_CYVSCROLL = 20;
        /// <summary>垂直スクロールバーのつまみの高さ</summary>
        public const int SM_CYVTHUMB = 9;
        #endregion
        #endregion

        #region API
        [System.Runtime.InteropServices.DllImport("user32.dll")]
        public static extern int GetSystemMetrics(int nIndex);
        [System.Runtime.InteropServices.DllImport("user32.dll")]
        public static extern int SetScrollInfo(IntPtr hwnd, int fnBar, ref SCROLLINFO lpsi, bool fRedraw);
        [System.Runtime.InteropServices.DllImport("user32.dll")]
        public static extern bool GetScrollInfo(IntPtr hwnd, int fnBar, ref SCROLLINFO lpsi);
        #endregion
    }
}
