﻿using System;
using System.Collections.Generic;
using System.Text;

namespace WitchPaperDebugger
{
    public class WitchTextMonitor : WitchMonitor
    {
        com.ast8.fw.forms.MicrosoftSelectionAreaIF m_watchIF;
        public WitchTextMonitor()
            : base()
        {
        }

        public override void init(com.ast8.fw.forms.WitchPaper watchObj)
        {
            m_watchIF = watchObj;
            base.init(watchObj);
        }

        protected override string[] getValues()
        {
            return new string[] {
                m_watchIF.SelectionStart.ToString(),
                m_watchIF.SelectionLength.ToString(),
                System.Text.RegularExpressions.Regex.Escape(m_watchIF.SelectedText)
            };
        }

        protected override int getColumnCount()
        {
            return 3;
        }

        protected override string[] getHeader()
        {
            return new string[] {
                "SelectionStart",
                "SelectionLength",
                "SelectedText"
            };
        }
    }
}
