/*
 * Decompiled with CFR 0.152.
 */
package woolpack;

public class TestConcurrent {
    private final String label;
    private final Object lock;
    private final int minConcurrent;
    private final int maxConcurrent;
    private final int threshold;
    private final double failOdds;
    private final int[] concurrentArray;
    private final int[] threadArray;
    private final ThreadLocal<Integer> threadLocal;
    private int currentConcurrent;
    private int count;
    private boolean minValidFlag;
    private boolean maxValidFlag;

    public TestConcurrent(String label, Object lock, int minConcurrent, int maxConcurrent, int threadCount, int threshold) {
        this(label, lock, minConcurrent, maxConcurrent, threadCount, threshold, 0.5);
    }

    public TestConcurrent(String label, Object lock, int minConcurrent, int maxConcurrent, int threadCount, int threshold, double failOdds) {
        this.label = label;
        this.lock = lock;
        this.minConcurrent = minConcurrent;
        this.maxConcurrent = maxConcurrent;
        this.threshold = threshold;
        this.failOdds = failOdds;
        this.concurrentArray = new int[maxConcurrent];
        this.threadArray = new int[threadCount];
        this.threadLocal = new ThreadLocal();
        this.currentConcurrent = 0;
        this.count = 0;
        this.minValidFlag = true;
        this.maxValidFlag = true;
    }

    public int getCount() {
        return this.count;
    }

    public void setThreadId(int i) {
        this.threadLocal.set(i);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void increaseCount() {
        Object object = this.lock;
        synchronized (object) {
            ++this.count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recodeThread() {
        Object object = this.lock;
        synchronized (object) {
            int n = this.threadLocal.get();
            this.threadArray[n] = this.threadArray[n] + 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recodeConcurrent() {
        Object object = this.lock;
        synchronized (object) {
            int n = this.currentConcurrent - 1;
            this.concurrentArray[n] = this.concurrentArray[n] + 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void increaseConcurrent() {
        Object object = this.lock;
        synchronized (object) {
            ++this.currentConcurrent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decreaseConcurrent() {
        Object object = this.lock;
        synchronized (object) {
            --this.currentConcurrent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void check() {
        Object object = this.lock;
        synchronized (object) {
            this.minValidFlag &= this.minConcurrent <= this.currentConcurrent;
            this.maxValidFlag &= this.currentConcurrent <= this.maxConcurrent;
        }
    }

    private void failRandom() {
        if (Math.random() < this.failOdds) {
            throw new RuntimeException("random fail.");
        }
    }

    public void execute() {
        Thread.yield();
        this.increaseCount();
        Thread.yield();
        this.recodeThread();
        Thread.yield();
        this.increaseConcurrent();
        Thread.yield();
        this.recodeConcurrent();
        Thread.yield();
        this.check();
        Thread.yield();
        this.decreaseConcurrent();
        Thread.yield();
        this.failRandom();
        Thread.yield();
    }

    public void print() {
        System.out.print(this.label);
        System.out.print(": ");
        if (this.count == 0) {
            System.out.print("count:0");
        } else {
            System.out.print("thread");
            this.print(this.threadArray);
            System.out.print(", ");
            System.out.print("mean:");
            System.out.print(this.culcMean(this.threadArray));
            System.out.print(", ");
            System.out.print("concurrent");
            this.print(this.concurrentArray);
            System.out.print(", ");
            System.out.print("min:");
            System.out.print(this.minValidFlag);
            System.out.print(", ");
            System.out.print("max:");
            System.out.print(this.maxValidFlag);
        }
        System.out.println();
    }

    public boolean assertValid() {
        return this.minValidFlag && this.maxValidFlag && this.assertThreshold(this.threadArray);
    }

    private void print(int[] array) {
        int i = 0;
        while (i < array.length) {
            System.out.print("-");
            System.out.print(array[i]);
            ++i;
        }
    }

    private int culcMean(int[] array) {
        if (array.length == 0) {
            return 0;
        }
        int mean = 0;
        int i = 0;
        while (i < array.length) {
            mean += array[i];
            ++i;
        }
        return mean /= array.length;
    }

    private boolean assertThreshold(int[] array) {
        int mean = this.culcMean(array);
        int i = 0;
        while (i < array.length) {
            if (Math.abs(mean - array[i]) > this.threshold) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

