/*
 * Decompiled with CFR 0.152.
 */
package woolpack;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import woolpack.dom.DomConstants;
import woolpack.dom.DomContext;
import woolpack.dom.DomExpression;
import woolpack.dom.XmlToNode;
import woolpack.utils.StringReaderFactory;
import woolpack.utils.UtilsConstants;

public class TestUtils {
    private static final String FORM_HEAD = "<HTML><BODY><FORM>";
    private static final String FORM_TAIL = "</FORM></BODY></HTML>";
    private static final String BODY_HEAD = "<HTML><BODY>";
    private static final String BODY_TAIL = "</BODY></HTML>";

    private TestUtils() {
    }

    public static void print(DomContext context) {
        DomConstants.write(context.getNode(), new OutputStreamWriter(System.out));
    }

    public static DomExpression getToNodeForm(String s) {
        return TestUtils.getToNode(FORM_HEAD + s + FORM_TAIL);
    }

    public static DomExpression getToNodeBody(String s) {
        return TestUtils.getToNode(BODY_HEAD + s + BODY_TAIL);
    }

    public static DomExpression getToNode(String s) {
        return new XmlToNode(new StringReaderFactory(s));
    }

    public static boolean equalsForm(DomContext context, String expected) {
        return TestUtils.equals(context, FORM_HEAD + expected + FORM_TAIL);
    }

    public static boolean equalsBody(DomContext context, String expected) {
        return TestUtils.equals(context, BODY_HEAD + expected + BODY_TAIL);
    }

    public static boolean equals(DomContext context, String expected) {
        DomContext c = new DomContext();
        TestUtils.getToNode(expected).interpret(c);
        context.getNode().normalize();
        c.getNode().normalize();
        boolean result = TestUtils.equals(c.getNode(), context.getNode());
        if (!result) {
            System.out.print("-- report start -- expected --");
            TestUtils.print(c);
            System.out.print("-- but --");
            TestUtils.print(context);
            System.out.println("-- report end --");
        }
        return result;
    }

    public static boolean equals(Node node0, Node node1) {
        if (node0 == null) {
            return node1 == null;
        }
        if (node1 == null) {
            return false;
        }
        if (node0.getNodeType() != node1.getNodeType()) {
            return false;
        }
        if (node0.getNodeType() == 3 || node0.getNodeType() == 8) {
            return node0.getNodeValue().equals(node1.getNodeValue());
        }
        if (node0.getNodeType() == 2) {
            return node0.getNodeName().equals(node1.getNodeName()) && node0.getNodeValue().equals(node1.getNodeValue());
        }
        if (node0.getNodeType() == 9) {
            return TestUtils.equals(((Document)node0).getDocumentElement(), ((Document)node1).getDocumentElement());
        }
        if (!node0.getNodeName().equals(node1.getNodeName())) {
            return false;
        }
        Element e0 = (Element)node0;
        Element e1 = (Element)node1;
        NamedNodeMap map0 = e0.getAttributes();
        NamedNodeMap map1 = e1.getAttributes();
        if (map0.getLength() != map1.getLength()) {
            return false;
        }
        int i = 0;
        while (i < map0.getLength()) {
            if (!TestUtils.equals(map0.item(i), map1.item(i))) {
                return false;
            }
            ++i;
        }
        Node child0 = node0.getFirstChild();
        Node child1 = node1.getFirstChild();
        while (child0 != null || child1 != null) {
            if (!TestUtils.equals(child0, child1)) {
                return false;
            }
            child0 = child0.getNextSibling();
            child1 = child1.getNextSibling();
        }
        return true;
    }

    public static String toString(Reader reader) throws IOException {
        try {
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while ((i = reader.read()) >= 0) {
                sb.append((char)i);
            }
            String string = sb.toString();
            return string;
        }
        finally {
            reader.close();
        }
    }

    public static boolean equals(Object a, Object b) {
        boolean result = TestUtils.equalsPrivate(a, b);
        if (!result) {
            System.out.print("-- equals start -- expected --");
            System.out.print(a);
            System.out.print("-- but --");
            System.out.print(b);
            System.out.println("-- equals end --");
        }
        return result;
    }

    private static boolean equalsPrivate(Object a, Object b) {
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return false;
        }
        if (a instanceof LinkedHashMap && b instanceof LinkedHashMap) {
            LinkedHashMap aMap = (LinkedHashMap)a;
            LinkedHashMap bMap = (LinkedHashMap)b;
            if (!TestUtils.equalsMap(aMap, bMap)) {
                return false;
            }
            Iterator aIterator = aMap.keySet().iterator();
            Iterator bIterator = bMap.keySet().iterator();
            while (aIterator.hasNext()) {
                if (TestUtils.equalsPrivate(aIterator.next(), bIterator.next())) continue;
                return false;
            }
            return true;
        }
        if (a instanceof Map) {
            if (b instanceof Map) {
                Map aMap = (Map)a;
                Map bMap = (Map)b;
                return TestUtils.equalsMap(aMap, bMap);
            }
            return false;
        }
        if (b instanceof Map) {
            return false;
        }
        if ((a instanceof List || a.getClass().isArray()) && (b instanceof List || a.getClass().isArray())) {
            List aList = UtilsConstants.toList(a);
            List bList = UtilsConstants.toList(b);
            if (aList.size() != bList.size()) {
                return false;
            }
            int length = aList.size();
            int i = 0;
            while (i < length) {
                if (!TestUtils.equalsPrivate(aList.get(i), bList.get(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        if (a instanceof Collection && b instanceof Collection) {
            return TestUtils.equalsCollection((Collection)a, (Collection)b);
        }
        return a.equals(b);
    }

    private static boolean equalsMap(Map a, Map b) {
        if (!TestUtils.equalsCollection(a.keySet(), b.keySet())) {
            return false;
        }
        for (Object key : a.keySet()) {
            if (TestUtils.equalsPrivate(a.get(key), b.get(key))) continue;
            return false;
        }
        return true;
    }

    private static boolean equalsCollection(Collection a, Collection b) {
        return TestUtils.containsAll(a, b) && TestUtils.containsAll(b, a);
    }

    private static boolean containsAll(Collection a, Collection b) {
        return a.containsAll(b);
    }
}

