/*
 * Decompiled with CFR 0.152.
 */
package woolpack.text;

import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.util.HashMap;
import java.util.Map;
import woolpack.utils.UtilsConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LimitedValueFormat
extends Format {
    private static final long serialVersionUID = 1L;
    private final Map<String, ? extends Object> parseMap;
    private final Object defaultParsedValue;
    private final Map<? extends Object, String> formatMap;
    private final String defaultFormattedValue;

    protected LimitedValueFormat(LimitedValueFormat format) {
        this.parseMap = format.parseMap;
        this.defaultParsedValue = format.defaultParsedValue;
        this.formatMap = format.formatMap;
        this.defaultFormattedValue = format.defaultFormattedValue;
    }

    public LimitedValueFormat(Map<? extends Object, String> formatMap, String defaultFormattedValue, Map<String, ? extends Object> parseMap, Object defaultParsedValue) {
        this.parseMap = parseMap == null ? LimitedValueFormat.inverse(formatMap) : new HashMap<String, Object>(parseMap);
        this.defaultParsedValue = defaultParsedValue;
        this.formatMap = formatMap == null ? LimitedValueFormat.inverse(parseMap) : new HashMap<Object, String>(formatMap);
        this.defaultFormattedValue = defaultFormattedValue;
    }

    public LimitedValueFormat(Map<? extends Object, String> formatMap, Map<String, ? extends Object> parseMap) {
        this(formatMap, null, parseMap, null);
    }

    public LimitedValueFormat(Map<? extends Object, String> formatMap, String defaultFormattedValue) {
        this(formatMap, defaultFormattedValue, null, null);
    }

    public LimitedValueFormat(Map<? extends Object, String> formatMap) {
        this(formatMap, null, null, null);
    }

    private static <K, V> Map<V, K> inverse(Map<K, V> before) {
        HashMap after = new HashMap();
        Map<V, K> m = UtilsConstants.unoverwritableMap(after);
        for (K key : before.keySet()) {
            m.put(before.get(key), key);
        }
        return after;
    }

    @Override
    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        int start = toAppendTo.length();
        String o = this.formatMap.get(obj);
        if (o == null) {
            o = this.defaultFormattedValue;
        }
        if (o != null) {
            toAppendTo.append(o);
        } else {
            toAppendTo.append(obj);
        }
        pos.setBeginIndex(start);
        pos.setEndIndex(toAppendTo.length());
        return toAppendTo;
    }

    @Override
    public Object parseObject(String source, ParsePosition pos) {
        for (String key : this.parseMap.keySet()) {
            if (!source.startsWith(key, pos.getIndex())) continue;
            pos.setIndex(pos.getIndex() + key.length());
            return this.parseMap.get(key);
        }
        if (this.defaultParsedValue != null) {
            pos.setIndex(source.length());
            return this.defaultParsedValue;
        }
        pos.setErrorIndex(pos.getIndex());
        return null;
    }

    @Override
    public Object clone() {
        return new LimitedValueFormat(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("new LimitedValueFormat({");
        boolean flag = false;
        for (Object object : this.formatMap.keySet()) {
            if (flag) {
                sb.append(",");
            }
            flag = true;
            sb.append("\"");
            sb.append(object);
            sb.append("\":\"");
            sb.append(this.formatMap.get(object));
            sb.append("\"");
        }
        sb.append("},\"");
        sb.append(this.defaultFormattedValue);
        sb.append("\",{");
        flag = false;
        for (String string : this.parseMap.keySet()) {
            if (flag) {
                sb.append(",");
            }
            flag = true;
            sb.append("\"");
            sb.append(string);
            sb.append("\":\"");
            sb.append(this.parseMap.get(string));
            sb.append("\"");
        }
        sb.append("},\"");
        sb.append(this.defaultParsedValue);
        sb.append("\")");
        return sb.toString();
    }
}

