/*
 * Decompiled with CFR 0.152.
 */
package woolpack.utils;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import woolpack.utils.Switchable;
import woolpack.utils.UtilsConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwitchBuilder<K, V> {
    private Map<K, V> map;
    private Map<K, V> checkedMap;
    private V beforeValue;

    public SwitchBuilder() {
        this.init();
    }

    private void init() {
        this.map = null;
        this.checkedMap = null;
        this.beforeValue = null;
    }

    private Map<K, V> getMap() {
        if (this.map == null) {
            this.map = new HashMap();
        }
        return this.map;
    }

    private Map<K, V> getCheckedMap() {
        if (this.checkedMap == null) {
            this.checkedMap = UtilsConstants.notNullMap(UtilsConstants.unoverwritableMap(this.getMap()));
        }
        return this.checkedMap;
    }

    public SwitchBuilder<K, V> put(K key, V value) {
        this.getCheckedMap().put(key, value);
        this.beforeValue = value;
        return this;
    }

    public SwitchBuilder<K, V> put(K key) {
        this.getCheckedMap().put(key, this.beforeValue);
        return this;
    }

    public Switchable<K, V> get() {
        return this.get(null);
    }

    public Switchable<K, V> get(final V defaultValue) {
        final Map<K, V> localMap = this.getMap();
        final Collection c = Collections.unmodifiableCollection((Collection)localMap.keySet());
        this.init();
        return new Switchable<K, V>(){

            @Override
            public V get(K key) {
                Object v = localMap.get(key);
                if (v != null) {
                    return v;
                }
                return defaultValue;
            }

            @Override
            public Collection<K> keys() {
                return c;
            }

            @Override
            public V getDefault() {
                return defaultValue;
            }
        };
    }
}

