/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.dom;

/**
 * DOM エレメントの属性名と属性値でノードを検索し委譲先を分岐する{@link DomExpression}。
 * @author nakamura
 *
 */
public class XPathAttrValue extends XPath {
	
	/**
	 * コンストラクタ。
	 * new XPath("//*[@" + attrName + "=\"" + attrValue + "\"]", firstExpression, otherExpression)
	 * と同一。
	 * @param attrName 属性名。
	 * @param attrValue 属性値。
	 * @param firstExpression 最初の検索結果に対する委譲先。
	 * @param otherExpression 2番目以降の検索結果に対する委譲先。
	 * @throws NullPointerException 引数のいずれかが null の場合。
	 * @throws RuntimeException XPath のコンパイルに失敗した場合。
	 */
	public XPathAttrValue(final String attrName, final String attrValue, final DomExpression firstExpression, final DomExpression otherExpression){
		super("//*[@" + attrName + "=\"" + attrValue + "\"]", firstExpression, otherExpression);
		attrName.getClass();
		attrValue.getClass();
	}
	
	/**
	 * コンストラクタ。
	 * new XPath("//*[@" + attrName + "=\"" + attrValue + "\"]", expression)
	 * と同一。
	 * @param attrName 属性名。
	 * @param attrValue 属性値。
	 * @param expression 検索結果に対する委譲先。
	 * @throws NullPointerException 引数のいずれかが null の場合。
	 * @throws RuntimeException XPath のコンパイルに失敗した場合。
	 */
	public XPathAttrValue(final String attrName, final String attrValue, final DomExpression expression){
		this(attrName, attrValue, expression, expression);
	}
}
