/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.validator;

import java.io.IOException;

/**
 * 整数の最大値を検証してその結果を返す{@link ValidatorExpression}。
 * {@link ValidatorContext}に対して状態を変更する操作を行わない。
 * @author nakamura
 *
 */
public class MaxValidator extends ValidatorExpressionAdapter {
	private final long value;
	
	/**
	 * コンストラクタ。
	 * @param value 最大値。
	 * @throws NullPointerException 引数が null の場合。
	 */
	public MaxValidator(final long value){
		this.value = value;
	}

	/**
	 * @throws NullPointerException 引数または{@link ValidatorContext#getTmpValue()}が null の場合。
	 * @throws ClassCastException {@link ValidatorContext#getTmpValue()}が{@link Number}でない場合。
	 */
	@Override public boolean interpret(final ValidatorContext context) {
		return ((Number)context.getTmpValue()).longValue() <= value;
	}

	@Override public void appendArgumentTo(final Appendable sb) throws IOException{
		sb.append(String.valueOf(value));
	}
}
