/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.config;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

import junit.framework.TestCase;

public class ToLinkedHashMapTest extends TestCase {

	public void testConstructor(){
		try{
			new ToLinkedHashMap(null, "a", "a", "a");
			fail();
		}catch(final NullPointerException expected){
		}
		try{
			new ToLinkedHashMap("", "a", "a", "a");
			fail();
		}catch(final StringIndexOutOfBoundsException expected){
		}
		try{
			new ToLinkedHashMap("a", null, "a", "a");
			fail();
		}catch(final NullPointerException expected){
		}
		try{
			new ToLinkedHashMap("a", "", "a", "a");
			fail();
		}catch(final StringIndexOutOfBoundsException expected){
		}
		try{
			new ToLinkedHashMap("a", "a", null, "a");
			fail();
		}catch(final NullPointerException expected){
		}
		try{
			new ToLinkedHashMap("a", "a", "", "a");
			fail();
		}catch(final StringIndexOutOfBoundsException expected){
		}
		try{
			new ToLinkedHashMap("a", "a", "a", null);
			fail();
		}catch(final NullPointerException expected){
		}
		try{
			new ToLinkedHashMap("a", "a", "a", "");
			fail();
		}catch(final StringIndexOutOfBoundsException expected){
		}
	}
	
	public void testNormal0(){
		final Map<String,Object> map = new HashMap<String,Object>();
		map.put("valueList0", "value0,value1,value2");
		map.put("labelList0", "label0,label1,label2");
		
		final ConfigExpression expression = new ToLinkedHashMap("optionList0", "valueList0", "labelList0", ",");
		final ConfigContext context = new ConfigContext();
		context.setMap(map);
		expression.interpret(context);
		
		final Map<String,String> expected = new LinkedHashMap<String,String>();
		expected.put("value0", "label0");
		expected.put("value1", "label1");
		expected.put("value2", "label2");
		assertEquals(expected, context.getMap().get("optionList0"));
	}
	
	public void testUnmatchLength(){
		final Map<String,Object> map = new HashMap<String,Object>();
		map.put("valueList0", "value0,value1,value2,value3");
		map.put("labelList0", "label0,label1,label2");
		
		final ConfigExpression expression = new ToLinkedHashMap("optionList0", "valueList0", "labelList0", ",");
		final ConfigContext context = new ConfigContext();
		context.setMap(map);
		
		try{
			expression.interpret(context);
			fail();
		}catch(final ArrayIndexOutOfBoundsException expected){
		}
	}
	
	public void testSameValueLabel(){
		final Map<String,Object> map = new HashMap<String,Object>();
		map.put("valueList0", "value0,value1,value2");
		
		final ConfigExpression expression = new ToLinkedHashMap("valueList0", "valueList0", "valueList0", ",");
		final ConfigContext context = new ConfigContext();
		context.setMap(map);		
		expression.interpret(context);
		
		final Map<String,String> expected = new LinkedHashMap<String,String>();
		expected.put("value0", "value0");
		expected.put("value1", "value1");
		expected.put("value2", "value2");
		assertEquals(expected, context.getMap().get("valueList0"));
	}
}
