/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.dom;

import java.text.Format;

import junit.framework.TestCase;
import woolpack.text.FormatFactory;
import woolpack.text.RegExpFormat;

public class FormatIdTest extends TestCase {

	public void testConstructor(){
		try{
			new FormatId((FormatFactory)null);
			fail();
		}catch(final NullPointerException expected){
		}
		try{
			new FormatId((Format)null);
			fail();
		}catch(final NullPointerException expected){
		}
	}
	
	public void testNormal(){
		final DomExpression expression = new FormatId(new RegExpFormat("V(\\d+)V", "v$1v"));
			final DomContext context = new DomContext();
			context.setId("V7V");
			expression.interpret(context);
			assertEquals("v7v", context.getId());
	}
}
