/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.dom;

import woolpack.el.PathEL;
import woolpack.text.FixFormat;
import junit.framework.TestCase;

public class ResetIdTest extends TestCase {

	public void testConstructor(){
		try{
			new ResetId(null);
			fail();
		}catch(final NullPointerException expected){
		}
	}
	
	public void testNormal(){
		final Count count = new Count(new FormatId(new FixFormat("newId")));
		final DomExpression expression = new ResetId(count);
		final DomContext context = new DomContext();
		context.setId("oldId");
		expression.interpret(context);
		assertEquals(1, count.getCount());
		assertEquals("oldId", context.getId());
	}
	
	public void testException(){
		final DomExpression expression = new ResetId(new Exec(new PathEL("context.session.empty")));
		final DomContext context = new DomContext();
		context.setId("oldId");
		try{
			expression.interpret(context);
			fail();
		}catch(final RuntimeException expected){
		}
		assertEquals("oldId", context.getId());
	}
}
