/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.el;

import java.text.ParseException;
import java.text.SimpleDateFormat;

import junit.framework.TestCase;

public class EEConstantsTest extends TestCase {

	public void testSimpleConverter() throws ParseException{
		assertNull(ELConstants.SIMPLE_CONVERTER.convert(null, null, Object.class));
		assertEquals("1", ELConstants.SIMPLE_CONVERTER.convert(null, 1, String.class));
		assertEquals("1", ELConstants.SIMPLE_CONVERTER.convert(null, "1", String.class));
		assertEquals(Boolean.TRUE, ELConstants.SIMPLE_CONVERTER.convert(null, "true", Boolean.class));
		assertEquals(Boolean.FALSE, ELConstants.SIMPLE_CONVERTER.convert(null, "false", Boolean.class));
		assertEquals(new Character('a'), ELConstants.SIMPLE_CONVERTER.convert(null, "abc", Character.class));
		
		assertEquals(new SimpleDateFormat("yyyyMMdd").parse("20060708"), ELConstants.SIMPLE_CONVERTER.convert(null, "20060708", java.util.Date.class));
		assertEquals(new java.sql.Date(new SimpleDateFormat("yyyyMMdd").parse("20060708").getTime()), ELConstants.SIMPLE_CONVERTER.convert(null, "20060708", java.sql.Date.class));
		
		assertEquals(new SimpleDateFormat("yyyyMMddHHmmss").parse("20060708005958"), ELConstants.SIMPLE_CONVERTER.convert(null, "20060708005958", java.util.Date.class));
		assertEquals(new java.sql.Date(new SimpleDateFormat("yyyyMMddHHmmss").parse("20060708005958").getTime()), ELConstants.SIMPLE_CONVERTER.convert(null, "20060708005958", java.sql.Date.class));
		
		assertEquals("20060708005958a", ELConstants.SIMPLE_CONVERTER.convert(null, "20060708005958a", java.util.Date.class));
		assertEquals("a0060708005958", ELConstants.SIMPLE_CONVERTER.convert(null, "a0060708005958", java.util.Date.class));
		
		
		assertEquals(new Byte((byte)1), ELConstants.SIMPLE_CONVERTER.convert(null, "1", Byte.class));
		assertEquals(new Double(1), ELConstants.SIMPLE_CONVERTER.convert(null, "1", Double.class));
		assertEquals(new Float(1), ELConstants.SIMPLE_CONVERTER.convert(null, "1", Float.class));
		assertEquals(new Integer(1), ELConstants.SIMPLE_CONVERTER.convert(null, "1", Integer.class));
		assertEquals(new Long(1), ELConstants.SIMPLE_CONVERTER.convert(null, "1", Long.class));
		assertEquals(new Short((short)1), ELConstants.SIMPLE_CONVERTER.convert(null, "1", Short.class));
		
		assertEquals(new Byte((byte)1), ELConstants.SIMPLE_CONVERTER.convert(null, new Integer(1), Byte.class));
		assertEquals(new Double(1), ELConstants.SIMPLE_CONVERTER.convert(null, new Integer(1), Double.class));
		assertEquals(new Float(1), ELConstants.SIMPLE_CONVERTER.convert(null, new Integer(1), Float.class));
		assertEquals(new Integer(1), ELConstants.SIMPLE_CONVERTER.convert(null, new Long(1), Integer.class));
		assertEquals(new Long(1), ELConstants.SIMPLE_CONVERTER.convert(null, new Integer(1), Long.class));
		assertEquals(new Short((short)1), ELConstants.SIMPLE_CONVERTER.convert(null, new Integer(1), Short.class));
		
		assertEquals(new Byte((byte)1), ELConstants.SIMPLE_CONVERTER.convert(null, "1", byte.class));
		assertEquals(new Double(1), ELConstants.SIMPLE_CONVERTER.convert(null, "1", double.class));
		assertEquals(new Float(1), ELConstants.SIMPLE_CONVERTER.convert(null, "1", float.class));
		assertEquals(new Integer(1), ELConstants.SIMPLE_CONVERTER.convert(null, "1", int.class));
		assertEquals(new Long(1), ELConstants.SIMPLE_CONVERTER.convert(null, "1", long.class));
		assertEquals(new Short((short)1), ELConstants.SIMPLE_CONVERTER.convert(null, "1", short.class));
		
		assertEquals(new Byte((byte)1), ELConstants.SIMPLE_CONVERTER.convert(null, new Integer(1), byte.class));
		assertEquals(new Double(1), ELConstants.SIMPLE_CONVERTER.convert(null, new Integer(1), double.class));
		assertEquals(new Float(1), ELConstants.SIMPLE_CONVERTER.convert(null, new Integer(1), float.class));
		assertEquals(new Integer(1), ELConstants.SIMPLE_CONVERTER.convert(null, new Long(1), int.class));
		assertEquals(new Long(1), ELConstants.SIMPLE_CONVERTER.convert(null, new Integer(1), long.class));
		assertEquals(new Short((short)1), ELConstants.SIMPLE_CONVERTER.convert(null, new Integer(1), short.class));
	}
}
