/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.html;

import java.util.Arrays;
import java.util.LinkedHashMap;

import junit.framework.TestCase;
import woolpack.TestUtils;
import woolpack.dom.DomConstants;
import woolpack.dom.DomContext;
import woolpack.dom.DomExpression;
import woolpack.dom.Serial;
import woolpack.dom.XPath;
import woolpack.el.EL;
import woolpack.utils.MapBuilder;

public class HiddenAllToChildTest extends TestCase {

	public void testConstructor(){
		try{
			new HiddenAllToChild(null, Arrays.asList("name2"));
			fail();
		}catch(final NullPointerException expected){
		}
		try{
			new HiddenAllToChild(EL.NULL, null);
			fail();
		}catch(final NullPointerException expected){
		}
	}

	public void testNormal() {
		final DomExpression expression = new Serial(
				TestUtils.getToNodeForm(""),
				new XPath("//FORM", new HiddenAllToChild(DomConstants.INPUT_EL, Arrays.asList("name2"))));
		final DomContext context = new DomContext();
		context.setInput(
				MapBuilder.get(new LinkedHashMap<String,Object>())
				.put("name0", "value0")
				.put("name1", Arrays.asList("value10", "value11"))
				.put("name2", "value2")
				.get());
		expression.interpret(context);

		assertTrue(TestUtils.equalsForm(context, 
				"<INPUT type=\"hidden\" name=\"name0\" value=\"value0\" />"+
				"<INPUT type=\"hidden\" name=\"name1\" value=\"value10\" />"+
				"<INPUT type=\"hidden\" name=\"name1\" value=\"value11\" />"));
	}
}
