/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.text;

import java.text.Format;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

import junit.framework.TestCase;

public class DelegateDateFormatTest extends TestCase {

	public void testConstructor(){
		try{
			new DelegateDateFormat(null, "new DateFormat()");
			fail();
		}catch(final NullPointerException e){
		}
		new DelegateDateFormat(new SimpleDateFormat(), null);
		new DelegateDateFormat(new SimpleDateFormat(), "");
	}

	private void scenario(final Format format) throws ParseException{
		final Date date = new SimpleDateFormat("yyyyMMdd").parse("20060601");
		assertEquals("20060601", format.format(date));
		assertEquals(date, format.parseObject("20060601"));
	}

	public void testNormal() throws ParseException{
		final Format format0 = new DelegateDateFormat(new SimpleDateFormat("yyyyMMdd"));
		scenario(format0);
		final Format format1 = (Format)format0.clone();
		assertTrue(format0 != format1);
		scenario(format1);
	}
	
	public void testToString(){
		assertEquals("", new DelegateDateFormat(new SimpleDateFormat(), "").toString());
		assertEquals("new SimpleDateFormat()", new DelegateDateFormat(new SimpleDateFormat(), "new SimpleDateFormat()").toString());
		assertEquals(new SimpleDateFormat().toString(), new DelegateDateFormat(new SimpleDateFormat(), null).toString());
	}
}
