/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.utils;

import junit.framework.TestCase;

public class FixSwitchTest extends TestCase {

	public void testNormal(){
		assertEquals(new Integer(7), new FixSwitch<String,Integer>(7).get("a1"));
		assertEquals(new Integer(7), new FixSwitch<String,Integer>(7).get(null));
		assertEquals(null, new FixSwitch<String,Integer>(null).get("a1"));
		assertEquals(null, new FixSwitch<String,Integer>(null).get(null));

		assertTrue(new FixSwitch<String,Integer>(null).keys().isEmpty());
		assertTrue(new FixSwitch<String,Integer>(7).keys().isEmpty());
		
		assertEquals(new Integer(7), new FixSwitch<String,Integer>(7).getDefault());
		assertEquals(null, new FixSwitch<String,Integer>(null).getDefault());
	}
}
