/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.utils;

import java.io.IOException;

import woolpack.TestUtils;

import junit.framework.TestCase;

public class InputStreamReaderFactoryTest extends TestCase {

	public void testConstructor(){
		try{
			new InputStreamReaderFactory(null, "UTF-8");
			fail();
		}catch(final NullPointerException expected){
		}
	}
	
	public void testNormal() throws IOException{
		{
			final ReaderFactory factory = new InputStreamReaderFactory(
					new StringInputStreamFactory("US-ASCII", "hoge"), "US-ASCII");
			assertEquals("hoge", TestUtils.toString(factory.newInstance(null)));
		}
		{
			final ReaderFactory factory = new InputStreamReaderFactory(
					new StringInputStreamFactory(null, "hoge"), null);
			assertEquals("hoge", TestUtils.toString(factory.newInstance(null)));
		}
		{
			final ReaderFactory factory = new InputStreamReaderFactory(
					new StringInputStreamFactory("UTF-8", "hoあge"), "UTF-8");
			assertEquals("hoあge", TestUtils.toString(factory.newInstance(null)));
		}
		{
			final ReaderFactory factory = new InputStreamReaderFactory(
					new NullInputStreamFactory(), null);
			assertNull(factory.newInstance(null));
		}
	}
}
