<?php
// $Id: weblinks_link_view_handler.php,v 1.17 2007/08/08 04:18:34 ohwada Exp $

// 2007-08-01 K.OHWADA
// get_link_list_create()

// 2007-06-10 K.OHWADA
// link_catlink_basic_handler
// get_forum_threads_for_cat() etc

// 2007-04-08 K.OHWADA
// use get_desc_disp() get_album_photos()

// 2007-03-25 K.OHWADA
// get_cat_album_photos_by_cid()
// get_cat_gm_value_by_cid()

// 2007-03-08 K.OHWADA
// change get_category_by_cid() get_category_list_by_pid()
// remove build_category_image_link()

// 2007-03-01 K.OHWADA
// happy_linux_time
// category_basic_handler
// expand subcategories
// cat_count in get_all_link_count_by_cid()
// get_cat_forum_threads()

// 2007-02-04 K.OHWADA
// BUG 4477: topten is unlimited

// 2006-12-10 K.OHWADA
// add build_sql_where_exclude()
// change get_link_count_by_cid()

// 2006-10-14 K.OHWADA
// add get_link_list_by_where(), get_cid_array_patent_children(), build_selbox()

// 2006-10-01 K.OHWADA
// use happy_linux
// weblinks_criteria_compo -> criteriaCompo
// highlight_keyword
// add get_link_by_obj()
// add get_objects_by_sql() : remove get_link_list_by_sq()

// 2006-07-22 K.OHWADA
// BUG 4152: not show catpath in link list

// 2006-05-15 K.OHWADA
// this is new file
// use new handler

//=========================================================
// WebLinks Module
// 2006-05-15 K.OHWADA
//=========================================================

// === class begin ===
if( !class_exists('weblinks_link_view_handler') ) 
{

//=========================================================
// class weblinks_link_view_handler
//=========================================================
class weblinks_link_view_handler extends happy_linux_error
{
	var $_DIRNAME;

	var $_config_handler;
	var $_link_handler;
	var $_category_handler;
	var $_catlink_handler;
	var $_link_catlink_handler;
	var $_link_view;
	var $_plugin;

	var $_system;
	var $_strings;
	var $_remote_image;
	var $_image_size;
	var $_post;
	var $_form;
	var $_time;

// config
	var $_conf = array();
	var $_conf_cat_img_width     = 0;
	var $_conf_cat_img_height    = 0;
	var $_conf_list_image_width  = 0;
	var $_conf_list_image_height = 0;
	var $_conf_link_image_width  = 0;
	var $_conf_link_image_height = 0;
	var $_conf_link_image_auto;
	var $_conf_descshort;
	var $_conf_newdays;
	var $_conf_popular;
	var $_conf_view_url;
	var $_conf_broken;
	var $_conf_recommend_pri;
	var $_conf_mutual_pri;

// system
	var $_system_is_admin;
	var $_system_uid;

// keyword
	var $_flag_highlight = false;
	var $_keyword_array  = null;

// atomfeed
	var $_feed_mode_title    = 0;	// not allow HTML tag
	var $_feed_mode_content  = 0;	// not allow HTML tag
	var $_feed_max_content   = 100;
	var $_feed_max_summary   = 100;
	var $_feed_title_default = '---';

// banner
	var $_banner_error_code = 0;
	var $_banner_errors     = null;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function weblinks_link_view_handler( $dirname )
{
	$this->happy_linux_error();
	$this->set_debug_print_time( WEBLINKS_DEBUG_TIME );

	$this->_DIRNAME = $dirname;

	$this->_config_handler       =& weblinks_get_handler( 'config2_basic',      $dirname );
	$this->_link_handler         =& weblinks_get_handler( 'link_basic',         $dirname );
	$this->_category_handler     =& weblinks_get_handler( 'category_basic',     $dirname );
	$this->_catlink_handler      =& weblinks_get_handler( 'catlink_basic',      $dirname );
	$this->_link_catlink_handler =& weblinks_get_handler( 'link_catlink_basic', $dirname );
	$this->_plugin               =& weblinks_plugin::getInstance( $dirname );
	$this->_link_view            =& weblinks_link_view::getInstance( $dirname );

	$this->_system       =& happy_linux_system::getInstance();
	$this->_strings      =& happy_linux_strings::getInstance();
	$this->_remote_image =& happy_linux_remote_image::getInstance();
	$this->_image_size   =& happy_linux_image_size::getInstance();
	$this->_post         =& happy_linux_post::getInstance();
	$this->_form         =& happy_linux_form::getInstance();
	$this->_time         =& happy_linux_time::getInstance();

	$conf = $this->_config_handler->get_conf();
	$this->_conf             = $conf;
	$this->_conf_cat_img_width     = $conf['cat_img_width'];
	$this->_conf_cat_img_height    = $conf['cat_img_height'];
	$this->_conf_list_image_width  = $conf['list_image_width'];
	$this->_conf_list_image_height = $conf['list_image_height'];
	$this->_conf_link_image_width  = $conf['link_image_width'];
	$this->_conf_link_image_height = $conf['link_image_height'];
	$this->_conf_link_image_auto   = $conf['link_image_auto'];
	$this->_conf_descshort         = $conf['descshort'];
	$this->_conf_newdays           = $conf['newdays'];
	$this->_conf_popular           = $conf['popular'];
	$this->_conf_view_url          = $conf['view_url'];
	$this->_conf_broken            = $conf['broken_threshold'];
	$this->_conf_recommend_pri     = $conf['recommend_pri'];
	$this->_conf_mutual_pri        = $conf['mutual_pri'];

	$this->_system_is_admin = $this->_system->is_module_admin();
	$this->_system_uid      = $this->_system->get_uid();

}

//---------------------------------------------------------
// init
//---------------------------------------------------------
function init()
{
	$this->_category_handler->load_once();
}

//=========================================================
// category
//=========================================================
//---------------------------------------------------------
// category_link count
//---------------------------------------------------------
function get_catlink_count_by_cid($cid)
{
	$count = $this->_catlink_handler->get_count_by_cid($cid);
	return $count;
}

//---------------------------------------------------------
// get category list
//---------------------------------------------------------
function get_cid_array_by_lid($lid, $limit=0, $start=0)
{
	$lid   = intval($lid);
	$limit = intval($limit);
	$start = intval($start);
	$arr   = $this->_catlink_handler->get_cid_array_by_lid($lid, $limit, $start);
	return $arr;
}

//---------------------------------------------------------
// get category
//---------------------------------------------------------
function &get_category_by_cid( $cid, $flag_catpath=false, $flag_parent_image=false, $flag_parent_desc=false )
{
	$arr =& $this->_category_handler->get_cache($cid);

	$catpath = '';
	if ($flag_catpath)
	{
		$catpath = $this->_category_handler->get_parent_path($cid);
	}

	if ( $flag_parent_image && empty($arr['imgurl']) )
	{
		$parent =& $this->_category_handler->get_parent_imgurl_size($cid);
		$arr['imgurl']          = $parent['imgurl'];
		$arr['img_show_width']  = $parent['img_show_width'];
		$arr['img_show_height'] = $parent['img_show_height'];
	}

	$desc_disp = '';
	if ( $arr['description'] )
	{
		$desc_disp = $this->_category_handler->get_desc_disp($cid);
	}
	elseif ( $flag_parent_desc )
	{
		$desc_disp = $this->_category_handler->get_parent_desc_disp($cid);
	}

	$arr['title_s']    = $this->sanitize_text( $arr['title']);
	$arr['imgurl_s']   = $this->sanitize_url(  $arr['imgurl'] );
	$arr['link_count'] = $this->get_all_link_count_by_cid($cid);
	$arr['catpath']    = $catpath;
	$arr['desc_disp']  = $desc_disp;

	return $arr;
}

//---------------------------------------------------------
// get category list
//---------------------------------------------------------
function &get_category_list_by_pid($pid, $flag_catpath=0, $sub_num=-1, $sub_mode=1)
{
	if ($pid == 0)
	{
		$cid_arr = $this->_category_handler->get_cid_array_by_pid($pid);
	}
	else
	{
		$cid_arr = $this->_category_handler->get_cid_child_array_from_cache_by_cid($pid);
	}

	$arr = array();

	foreach ($cid_arr as $cid)
	{
		$temp_arr =& $this->get_category_by_cid($cid, $flag_catpath);

// admin can change the display number of subcategory 
		$temp_arr['sub_categories'] =
			$this->_category_handler->build_sub_categories($cid, $sub_num, $sub_mode);

		$arr[] = $temp_arr;
	}

	return $arr;
}

function &get_cid_array_children($cid)
{
	$arr =& $this->_category_handler->getAllChildId($cid);
	return $arr;
}

function &get_cid_array_patent_children($cid)
{
	$arr =& $this->_category_handler->get_parent_and_all_child_id($cid);
	return $arr;
}

//---------------------------------------------------------
// category path
//---------------------------------------------------------
function &get_catpath_array_by_lid($lid)
{
	$cid_arr = $this->_catlink_handler->get_cid_array_by_lid($lid);
	$catpath_arr = array();

	foreach ($cid_arr as $cid)
	{
		if ( $this->_category_handler->cache_exists($cid) )
		{
			$catpath_arr[] =& $this->_category_handler->get_parent_path($cid);
		}
	}

	return $catpath_arr;
}

function get_all_catlist()
{
	$tree_array = $this->_category_handler->get_tree();

	$catlist = array();

	foreach ($tree_array as $cid) 
	{
		$catpath = $this->_category_handler->build_cat_path($cid, 's');
		$count   = $this->get_all_link_count_by_cid($cid);

		$catlist[] = array(
			'cid'   => $cid,
			'count' => $count,
			'path'  => $catpath,
		);
	}

	return $catlist;
}

function build_selbox( $cid=0 )
{
	$selbox = $this->_category_handler->build_selbox( $cid, 1, "cid", '', _HAPPY_LINUX_SEARCH_NOT_SELECT, 1 );
	return $selbox;
}

//---------------------------------------------------------
// google map
//---------------------------------------------------------
function &get_cat_gm_value_by_cid( $cid )
{
	$arr =& $this->_get_gm_value_null();

	if ( !$this->_conf['gm_use'] )
	{	return $arr;	}

	$cache =& $this->_category_handler->get_gm_value($cid);

	if ( !isset($cache['gm_mode']) )
	{	return $arr;	}

	switch( $cache['gm_mode'] )
	{
	// config
		case 1:
			$arr =& $this->_get_gm_value_conf();
			break;

	// parent
		case 2:
			$arr =& $this->_get_cat_parent_gm_value_by_cid($cid);
			break;

	// self
		case 3:
			$arr =& $cache;
			$arr['show_gm'] = true;
			break;

	// not show
		case 0:
		default:
			break;
	}

	return $arr;
}

function &_get_cat_parent_gm_value_by_cid( $cid )
{
	$arr =& $this->_get_gm_value_null();

	if ( !$this->_conf['gm_use'] )
	{	return $arr;	}

	$cache =& $this->_category_handler->get_parent_gm_value($cid);

	if ( !isset($cache['gm_mode']) )
	{	return $arr;	}

	switch( $cache['gm_mode'] )
	{
	// config
		case 1:
			$arr =& $this->_get_gm_value_conf();
			break;

	// self
		case 3:
			$arr =& $cache;
			$arr['show_gm'] = true;
			break;

	// not show
		case 0:
	// parent
		case 2:
		default:
			break;
	}

	return $arr;
}

function &_get_gm_value_null()
{
	$arr = array(
		'show_gm'      => false,
		'gm_latitude'  => null,
		'gm_longitude' => null,
		'gm_zoom'      => null,
	);
	return $arr;
}

function &_get_gm_value_conf()
{
	$arr = array(
		'show_gm'      => true,
		'gm_latitude'  => $this->_conf['gm_latitude'],
		'gm_longitude' => $this->_conf['gm_longitude'],
		'gm_zoom'      => $this->_conf['gm_zoom'],
	);
	return $arr;
}

//=========================================================
// link
//=========================================================
//---------------------------------------------------------
// get link item
//---------------------------------------------------------
function get_link_rssc_lid($lid)
{
	$ret = $this->_link_handler->get_rssc_lid($lid);
	return $ret;
}

//---------------------------------------------------------
// get link count
//---------------------------------------------------------
function get_link_count_public()
{
	$count = $this->_link_handler->get_count_public();
	return $count;
}

function get_top_link_count_by_cid($cid)
{
	$count = $this->_link_catlink_handler->get_count_by_cid_array( array($cid) );
	return $count;
}

function get_all_link_count_by_cid($cid)
{
	if ( $this->_conf['cat_count'] )
	{
		$count = $this->_category_handler->get_link_count($cid);
	}
	else
	{
		$cid_arr =& $this->get_cid_array_patent_children($cid);
		$count   = $this->_link_catlink_handler->get_count_by_cid_array($cid_arr);
	}

	return $count;
}

function get_count_by_mark( $mark )
{
	if ($mark == 'rss')
	{
		$count = $this->_link_handler->get_count_rss_flag();
	}
	else
	{
		$count = $this->_link_handler->get_count_by_mark($mark);
	}

	return $count;
}

function get_count_by_where($where)
{
	$ret = $this->_link_handler->get_count_by_where($where);
	return $ret;
}

//---------------------------------------------------------
// lid array
//---------------------------------------------------------
function &get_lid_array_by_cid($cid, $orderby, $limit=0, $start=0)
{
	$arr =& $this->_link_catlink_handler->get_lid_array_by_cid($cid, $orderby, $limit, $start);
	return $arr;
}

//---------------------------------------------------------
// link list for index
//---------------------------------------------------------
function &get_link_list_latest($limit=0, $start=0)
{
	if ( $this->get_debug_print_time() )
	{
		$happy_linux_time =& happy_linux_time::getInstance();
		$happy_linux_time->print_lap_time( "weblinks_link_basic_handler: latest" );
	}

	$arr =& $this->_link_handler->get_lid_array_latest($limit, $start);
	$list =& $this->get_link_list_by_lid_array( $arr );

	if ( $this->get_debug_print_time() )
	{
		$happy_linux_time->print_lap_time();
	}

	return $list;
}

function &get_link_list_create($limit=0, $start=0)
{
	$orderby = 'time_create DESC, lid DESC';
	$arr =& $this->_link_handler->get_lid_array_orderby($orderby, $limit, $start);
	$list =& $this->get_link_list_by_lid_array( $arr );
	return $list;
}

function &get_link_list_by_lid_array( &$lid_arr )
{
	$arr = array();
	if ( is_array($lid_arr) && ( count($lid_arr) > 0 ) )
	{
		foreach ($lid_arr as $lid)
		{
			$arr[] = $this->get_link_by_lid( $lid );
		}
	}
	return $arr;
}

function &get_link_by_lid($lid)
{
	$ret =& $this->_link_view->get_show_by_lid( $lid, $this->_flag_highlight, $this->_keyword_array );
	return $ret;
}

//---------------------------------------------------------
// link list for top ten
//---------------------------------------------------------
function &get_link_list_orderby($orderby, $limit=0, $start=0)
{
// BUG: topten is unlimited
	$arr  =& $this->_link_handler->get_lid_array_orderby($orderby, $limit, $start);
	$list =& $this->get_link_list_by_lid_array($arr);
	return $list;
}

function &get_topten_list($topten_cats, $orderby, $limit=0, $start=0)
{
	$this->_clear_errors();

	$i = 0;
	$rank_arr = array();

	$cid_arr = $this->_category_handler->get_cid_array_by_pid(0);

	if ( count($cid_arr) > $topten_cats )
	{
		$this->_set_errors( sprintf(_WLS_TOPTEN_ERROR, $topten_cats) );
	}

	foreach ($cid_arr as $cid)
	{
		$ctitle_s = $this->_category_handler->get_title($cid, 's');

// get all child cat ids for a given cat id
		$links =& $this->get_link_parent_child_list_by_cid_orderby($cid, $orderby, $limit, $start);

		$rank_arr[$i]['cid']   = $cid;
		$rank_arr[$i]['title'] = sprintf(_WLS_TOPTEN_TITLE, $ctitle_s, $limit);
		$rank_arr[$i]['links'] = $links;

		$i++;
		if ($i >= $topten_cats ) break;
	}

	return $rank_arr;
}

//---------------------------------------------------------
// link list for search
//---------------------------------------------------------
function &get_link_list_by_where($where, $limit=0, $start=0)
{
	$arr  =& $this->_link_handler->get_lid_array_by_where($where, $limit, $start);
	$list =& $this->get_link_list_by_lid_array($arr);
	return $list;
}

function build_sql_where_exclude()
{
	$where = $this->_link_handler->build_sql_where_exclude();
	return $where;
}

function build_sql_where_exclude_join()
{
	$where = $this->_link_handler->build_sql_where_exclude_join();
	return $where;
}

//---------------------------------------------------------
// view mark & rss : link list orderby xxx
//---------------------------------------------------------
function &get_link_by_mark_sort($mark, $sort, $limit=0, $start=0)
{
	$orderby = 'lid ASC';
	if ( isset($sort['sort']) && isset($sort['order']) )
	{
		$orderby = $sort['sort'].' '.$sort['order'];
	}

	if ($mark == 'rss')
	{
		$arr =& $this->_link_handler->get_lid_array_rss_by_orderby($orderby, $limit, $start);
	}
	else
	{
		$arr =& $this->_link_handler->get_lid_array_by_mark_orderby($mark, $orderby, $limit, $start);
	}

	$list =& $this->get_link_list_by_lid_array($arr);
	return $list;
}

//---------------------------------------------------------
// link list belongs category
//---------------------------------------------------------
function &get_link_list_by_cid_sort($cid, $sort, $limit=0, $start=0)
{
	$sort_arr = array();

	if ( $this->_conf_recommend_pri == 2 )
	{
		$sort_arr[] = 'recommend DESC';
	}

	if ( $this->_conf_mutual_pri == 2 )
	{
		$sort_arr[] = 'mutual DESC';
	}

	if ( isset($sort['sort']) && isset($sort['order']) )
	{
		$sort_arr[] = $sort['sort'].' '.$sort['order'];
	}
	else
	{
		$sort_arr[] = 'lid ASC';
	}

	$orderby = implode(',', $sort_arr);

	$lid_arr =& $this->_link_catlink_handler->get_lid_array_by_cid_orderby($cid, $orderby, $limit, $start);
	$link_list =& $this->get_link_list_by_lid_array($lid_arr);
	return $link_list;
}

// viewcat
function &get_link_all_child_list_latest_by_cid($cid, $limit=0, $start=0)
{
	$cid_arr =& $this->get_cid_array_children($cid);
	$orderby = 'time_update DESC';

	$lid_arr   = $this->_link_catlink_handler->get_lid_array_by_cid_array_orderby($cid_arr, $orderby, $limit, $start);
	$link_list =& $this->get_link_list_by_lid_array($lid_arr);

	return $link_list;
}

//---------------------------------------------------------
// Top Ten: link list belongs parent & child category
//---------------------------------------------------------
function &get_link_parent_child_list_by_cid_orderby($cid, $orderby, $limit=0, $start=0)
{
	$cid_arr =& $this->get_cid_array_patent_children($cid);
	$lid_arr =& $this->_link_catlink_handler->get_lid_array_by_cid_array_orderby($cid_arr, $orderby, $limit, $start);
	$link_list =& $this->get_link_list_by_lid_array($lid_arr);

	return $link_list;
}

//---------------------------------------------------------
// forum threads
//---------------------------------------------------------
function &get_cat_forum_threads_by_cid($cid)
{
	$forum_id = $this->_category_handler->get_forum_id($cid);

// same parent
	if (($this->_conf['cat_forum_mode'] == 1)&&($forum_id == 0))
	{
		$forum_id = $this->_category_handler->get_parent_forum_id($cid);
	}

	$opts = array(
		'forum_id'     => $forum_id, 
		'dirname'      => $this->_conf['cat_forum_dirname'], 
		'thread_limit' => $this->_conf['cat_forum_thread_limit'], 
		'post_limit'   => $this->_conf['cat_forum_post_limit'], 
		'post_order'   => $this->get_forum_post_order('cat_forum_post_order'),
	);

	$arr =& $this->_plugin->get_forum_threads_for_cat( $opts );
	return $arr;
}

function &get_link_forum_threads_by_lid($lid)
{
	$forum_id = $this->_link_handler->get_forum_id($lid);

	$opts = array(
		'forum_id'     => $forum_id, 
		'dirname'      => $this->_conf['link_forum_dirname'], 
		'thread_limit' => $this->_conf['link_forum_thread_limit'], 
		'post_limit'   => $this->_conf['link_forum_post_limit'], 
		'post_order'   => $this->get_forum_post_order('link_forum_post_order'),
	);

	$arr =& $this->_plugin->get_forum_threads_for_link( $opts );
	return $arr;
}

function get_forum_post_order($conf_name)
{
	$post_order_num = $this->_conf[ $conf_name ];
	switch ($post_order_num)
	{
		case 1:
			$post_order = 'DESC';
			break;

		case 0:
		default:
			$post_order = 'ASC';
			break;
	}
	return $post_order;
}

//---------------------------------------------------------
// album photos
//---------------------------------------------------------
function &get_cat_album_photos_by_cid($cid)
{
	$album_id = $this->_category_handler->get_album_id($cid);

// same parent
	if (($this->_conf['cat_album_mode'] == 1)&&($album_id == 0))
	{
		$album_id = $this->_category_handler->get_parent_album_id($cid);
	}

	$opts = array(
		'album_id'    => $album_id, 
		'dirname'     => $this->_conf['cat_album_dirname'], 
		'album_limit' => $this->_conf['cat_album_limit'], 
	);

	$arr =& $this->_plugin->get_album_photos_for_cat( $opts );
	return $arr;
}

function &get_link_album_photos_by_lid($lid)
{
	$album_id = $this->_link_handler->get_album_id($lid);

	$opts = array(
		'album_id'    => $album_id, 
		'dirname'     => $this->_conf['link_album_dirname'], 
		'album_limit' => $this->_conf['link_album_limit'], 
	);

	$arr =& $this->_plugin->get_album_photos_for_link( $opts );
	return $arr;
}

//=========================================================
// others
//=========================================================

//---------------------------------------------------------
// sanitize
//---------------------------------------------------------
function sanitize_text($text)
{
	$text = $this->_strings->sanitize_text($text);
	return $text;
}

function sanitize_url($text)
{
	$text = $this->_strings->sanitize_url($text);
	return $text;
}

function shorten_text($text, $max)
{
	$text = $this->_strings->shorten_text($text, $max);
	return $text;
}

//---------------------------------------------------------
// get GET & POST
//---------------------------------------------------------
function get_get_lid()
{
	$ret = $this->_post->get_get_int('lid');
	return $ret;
}

function get_get_cid()
{
	$ret = $this->_post->get_get_int('cid');
	return $ret;
}

function get_get_mark()
{
	$ret = $this->_post->get_get_text('mark');
	return $ret;
}

function get_get_keyword_array()
{
	return $this->_post->get_get_keyword_array();
}

//---------------------------------------------------------
// get property
//---------------------------------------------------------
function is_admin()
{
	return $this->_system_is_admin;
}

function get_config()
{
	return $this->_conf;
}

//---------------------------------------------------------
// set property
//---------------------------------------------------------
function set_feed_mode_title($value)
{
	$this->_feed_mode_title = intval($value);
}

function set_feed_mode_content($value)
{
	$this->_feed_mode_content = intval($value);
}

function set_feed_max_content($value)
{
	$this->_feed_max_content = intval($value);
}

function set_feed_max_summary($value)
{
	$this->_feed_max_summary = intval($value);
}

function set_feed_title_default($value)
{
	$this->_feed_title_default = $value;
}

//---------------------------------------------------------
// set keyword property
//---------------------------------------------------------
function set_highlight($value)
{
	$this->_flag_highlight = (bool)$value;
}

function set_keyword_array($arr)
{
	if ( is_array($arr) && count($arr) )
	{
		$this->_keyword_array = $arr;
	}
}

function set_keyword_by_request()
{
	$this->set_keyword_array( $this->get_get_keyword_array() );
}

function get_keywords_urlencode()
{
	return $this->_strings->urlencode_from_array( $this->_keyword_array );
}

// --- class end ---
}

// === class end ===
}

?>