<?php
// $Id: viewmark.php,v 1.16 2007/08/08 04:18:22 ohwada Exp $

// 2007-08-01 K.OHWADA
// weblinks_header

// 2007-07-14 K.OHWADA
// use_highlight

// 2007-03-01 K.OHWADA
// execution_time
// view_style_mark

// 2006-10-14 K.OHWADA
// search with mark

// 2006-10-01 K.OHWADA
// use happy_linux
// use assignHeader

// 2006-07-30 K.OHWADA
// BUG 4168: not show catpath in viewmark

// 2006-05-15 K.OHWADA
// add weblinks_viewmark_main()
// use new handler

// 2006-03-15 K.OHWADA
// use weblinks_pagenavi::getInstance()

// 2006-01-01 K.OHWADA
// weblinks ver 1.0
// module depulication

//================================================================
// WebLinks Module
// view link by mark ( mutual site, recommend site )
// 2004-10-20 K.OHWADA
//================================================================

include 'header.php';
include_once XOOPS_ROOT_PATH.'/modules/happy_linux/class/pagenavi.php';
include_once WEBLINKS_ROOT_PATH.'/class/weblinks_pagenavi_menu.php';

$weblinks_view_handler =& weblinks_get_handler( 'link_view',  WEBLINKS_DIRNAME );
$weblinks_template     =& weblinks_template::getInstance( WEBLINKS_DIRNAME );
$weblinks_header       =& weblinks_header::getInstance(   WEBLINKS_DIRNAME );

$show_mark = 0;

// --- template start ---
// xoopsOption[template_main] should be defined before including header.php
$xoopsOption['template_main'] = WEBLINKS_DIRNAME."_viewmark.html";
include XOOPS_ROOT_PATH.'/header.php';

// BUG: not show catpath in viewmark
$weblinks_view_handler->init();

$conf = $weblinks_view_handler->get_config();
$weblinks_view_handler->set_highlight( $conf['use_highlight'] );
$weblinks_view_handler->set_keyword_by_request();
$keywords = $weblinks_view_handler->get_keywords_urlencode();

$weblinks_header->assign_module_header();
$weblinks_template->set_keywords_urlencode( $keywords );
$weblinks_template->assignIndex();
$weblinks_template->assignHeader();

// mark
$mark = $weblinks_view_handler->get_get_mark();
if ($mark == 'rss')
{
	$title = _WLS_SITE_RSS;
}
elseif ($mark == 'mutual')
{
	$title = _WLS_SITE_MUTUAL;
	$show_mark = 1;
}
else
{
	$mark = 'recommend';
	$title = _WLS_SITE_RECOMMEND;
	$show_mark = 1;
}

// search form
$show_cat  = 0;
$show_br1  = 1;
$show_br2  = 1;
$weblinks_template->assignSearch( $show_mark, $show_cat, $show_br1, $show_br2 ); 

$xoopsTpl->assign('keywords',        $keywords);
$xoopsTpl->assign('lang_mark_title', $title);
$xoopsTpl->assign('mark',            $mark);

// --- link list ---
$total = $weblinks_view_handler->get_count_by_mark($mark);
$xoopsTpl->assign('mark_total', $total);

if ($total > 0)
{
	weblinks_viewmark_main($total, $mark);
}

$xoopsTpl->assign('execution_time', $happy_linux_time->get_elapse_time() );
include XOOPS_ROOT_PATH.'/footer.php';
exit();
// --- main end ---


//---------------------------------------------------------
// function
//---------------------------------------------------------
function weblinks_viewmark_main($total, $mark)
{
	global $xoopsTpl;

	$link_view_handler =& weblinks_get_handler( 'link_view',  WEBLINKS_DIRNAME );
	$template =& weblinks_template::getInstance( WEBLINKS_DIRNAME );
	$pagenavi =& weblinks_pagenavi_menu::getInstance();

	$conf = $link_view_handler->get_config();

	$pagenavi->setPerpage(         $conf['perpage'] );
	$pagenavi->set_sortid_default( $conf['orderby'] );
	$pagenavi->setTotal($total);

	$pagenavi->getGetPage();
	$pagenavi->getGetSortid();
	$start = $pagenavi->calcStart();
	$sort  = $pagenavi->get_sort();

	$xoopsTpl->assign('show_links', true);
	$template->assignDisplayLink();

// link list
	$link_list =& $link_view_handler->get_link_by_mark_sort($mark, $sort, $conf['perpage'], $start);

	if ( $conf['view_style_mark'] )
	{
		$links_full = $template->fetch_links_full( $link_list );
	}
	else
	{
		$links_full = $template->fetch_links_list( $link_list );
	}

	$xoopsTpl->assign('weblinks_links_full', $links_full);

	$script = WEBLINKS_URL.'/viewmark.php?mark='.$mark;
	$pagenavi->assign_navi($xoopsTpl, $script);

}

?>