<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/**
 * 会員テーブル表示用クラス
 *
 * @package     NetCommons Components
 * @author      Noriko Arai,Ryuji Masukawa
 * @copyright   2006-2007 NetCommons Project
 * @license     http://www.netcommons.org/license.txt  NetCommons License
 * @project     NetCommons Project, supported by National Institute of Informatics
 * @access      public
 */
class Users_View
{
	/**
	 * @var DBオブジェクトを保持
	 *
	 * @access	private
	 */
	var $_db = null;

	/**
	 * @var DIコンテナを保持
	 *
	 * @access	private
	 */
	var $_container = null;

	/**
	 * コンストラクター
	 *
	 * @access	public
	 */
	function Users_View()
	{
		$this->_container =& DIContainerFactory::getContainer();
		$this->_db =& $this->_container->getComponent("DbObject");
	}

	/**
	 * user_idからusers情報を取得する
	 * @param int user_id
	 * @return array users
	 * @access	public
	 */
	function &getUserById($id, $func = null, $func_params = null) {
		$params = array("user_id" => $id);
		$result =& $this->getUsers($params, null, $func, $func_params);
		if($result === false || !isset($result[0])) {
			// エラーが発生した場合、エラーリストに追加
			$result = false;
			return $result;
		}
		return $result[0];
	}

	/**
	 *
	 * Item情報取得取得
	 * @param int user_id
	 * @param int user_auth_id
	 * @param array where_params
	 * @param boolean init_flag user_idのチェックされたデータを初期化するかどうか
	 * @return array items
	 */
	function &getShowItems($user_id, $user_auth_id, $where_params = array("display_flag"=>_ON), $init_flag = false) {
		//_AUTH_ADMIN _AUTH_CHIEF _AUTH_MODERATE _AUTH_GENERAL _AUTH_GUEST
		$params = array(); //array("user_id"=>$user_id);
		//
		// すべての項目を取得
		//
		$sql = "SELECT {items}.* , {items_desc}.description, {items_desc}.attribute, {items_options}.options, {items_options}.default_selected," .
					"{users_items_link}.public_flag,{users_items_link}.email_reception_flag, {users_items_link}.content, ".
					"{items_authorities_link}.under_public_flag, {items_authorities_link}.self_public_flag,{items_authorities_link}.over_public_flag ".
					"FROM {items}  ".
					" LEFT JOIN {items_desc} ON ({items}.item_id={items_desc}.item_id)".
					" LEFT JOIN {items_options} ON ({items}.item_id={items_options}.item_id)".
					" LEFT JOIN {users_items_link} ON ({items}.item_id={users_items_link}.item_id AND {users_items_link}.user_id='".$user_id."')".
					" LEFT JOIN {items_authorities_link} ON ({items}.item_id={items_authorities_link}.item_id AND {items_authorities_link}.user_authority_id=".intval($user_auth_id).")".
					" WHERE {items}.type != \"" . USER_TYPE_SYSTEM."\"";
		$sql_where = "";
		if (isset($where_params)) {
	        foreach ($where_params as $key=>$value) {
				if (isset($value)) {
					$params[] = $value;
					$sql_where .= " AND ".$key."=?";
				} else {
					$sql_where .= " AND ".$key;
				}
			}
		}
		$sql .= $sql_where;
		////$sql .= $sql_where ? " WHERE ".substr($sql_where,5) : "";
		$sql .= " ORDER BY {items}.col_num,{items}.row_num ";
		$func_params = array(false, $init_flag);
		$result = $this->_db->execute($sql, $params, null, null, true, array($this,"_getShowItemsFetchcallback"), $func_params);
		if ( $result === false ) {
			// エラーが発生した場合、エラーリストに追加
			$this->_db->addError();
			return $result;
		}
		return $result;
	}

	/**
	 * fetch時コールバックメソッド
	 * @param result adodb object
	 * @return array
	 * @access	private
	 */
	function &_getShowItemsFetchcallback($result, $params= array()) {
		$container =& DIContainerFactory::getContainer();
		$session =& $container->getComponent("Session");
		$commonMain =& $container->getComponent("commonMain");
		$languagesView =& $commonMain->registerClass(WEBAPP_DIR.'/components/languages/View.class.php', "Languages_View", "languagesView");
        $timezoneMain =& $commonMain->registerClass(WEBAPP_DIR.'/components/timezone/Main.class.php', "Timezone_Main", "timezoneMain");

		$languages =& $languagesView->getLanguagesList();
		$id_flag = false;
		if(isset($params[0])) {
			$id_flag = $params[0];
		}
		$init_flag = isset($params[1]) ? $params[1] : false;

		$ret = array();
		while ($row = $result->fetchRow()) {
			if ($row["define_flag"] == _ON) {
				if (defined($row["item_name"])) {
					$row["item_name"] = constant($row["item_name"]);
				}
				if (isset($row["description"]) && defined($row["description"])) {
					$row["description"] = constant($row["description"]);
				}
			}
			if($row["type"] == USER_TYPE_CHECKBOX || $row["type"] == USER_TYPE_RADIO ||
				$row["type"] == USER_TYPE_SELECT) {
				// options:日本語名
				// options_value:数値(ロール権限ID等)
				// def_options:実際比較する値
				if ($row["tag_name"] == "role_authority_name") {
					//
					// 権限
					//
					// 権限一覧取得し、set_optionsにセット
					$authoritiesView =& $this->_container->getComponent("authoritiesView");
					$authorities =& $authoritiesView->getAuthorities();
					$count = 0;
					foreach($authorities as $authority) {

						$row["set_options"][$count]["options"] = $authority['role_authority_name'];
						$row["set_options"][$count]["options_value"] = $authority['role_authority_id'];
						$row["set_options"][$count]["def_options"] = $authority['role_authority_id'];
						//会員ベース権限保存
						$row["set_options"][$count]["user_authority_id"] = $authority['user_authority_id'];
						$row["set_options"][$count]["default_selected"] = _OFF;	//_OFF固定
						$count++;
					}
				} else if ($row["tag_name"] == "active_flag_lang") {
					$row["set_options"][0]["options"] = USER_ITEM_ACTIVE_FLAG_ON;
					$row["set_options"][0]["def_options"] = _USER_ACTIVE_FLAG_ON;
					$row["set_options"][0]["options_value"] = _USER_ACTIVE_FLAG_ON;
					$row["set_options"][0]["default_selected"] = _OFF;	//_OFF固定
					$row["set_options"][1]["options"] = USER_ITEM_ACTIVE_FLAG_OFF;
					$row["set_options"][1]["def_options"] = _USER_ACTIVE_FLAG_OFF;
					$row["set_options"][1]["options_value"] = _USER_ACTIVE_FLAG_OFF;
					$row["set_options"][1]["default_selected"] = _OFF;	//_OFF固定
					$actionChain =& $container->getComponent("ActionChain");
					if($actionChain->getCurActionName() == "user_view_main_search") {
						// 検索アクションならば、承認待ち、承認済みを追加
						$row["set_options"][2]["options"] = USER_ITEM_ACTIVE_FLAG_PENDING;
						$row["set_options"][2]["def_options"] = _USER_ACTIVE_FLAG_PENDING;
						$row["set_options"][2]["options_value"] = _USER_ACTIVE_FLAG_PENDING;
						$row["set_options"][2]["default_selected"] = _OFF;	//_OFF固定

						$row["set_options"][3]["options"] = USER_ITEM_ACTIVE_FLAG_MAILED;
						$row["set_options"][3]["def_options"] = _USER_ACTIVE_FLAG_MAILED;
						$row["set_options"][3]["options_value"] = _USER_ACTIVE_FLAG_MAILED;
						$row["set_options"][3]["default_selected"] = _OFF;	//_OFF固定
					}
				} else if ($row["tag_name"] == "lang_dirname_lang") {
					$row["set_options"][$count]["options"] = defined('LANG_NAME_AUTO') ? LANG_NAME_AUTO:'';
					$row["set_options"][$count]["def_options"] = "";
					$count = 1;
					foreach($languages as $key => $language) {
						//	language/lang_dir/global.iniをみて現在、使用可能な言語を取得
						if(file_exists(WEBAPP_DIR."/language/".$key."/global.ini") || $key == '') {
							$row["set_options"][$count]["options"] = $language;
							$row["set_options"][$count]["def_options"] = $key;
							if(!isset($row["content"]) && $key == $session->getParameter("_lang")) {
								$row["set_options"][$count]["default_selected"] = _ON;
							} else if ( $row["content"] == $language) {
								$row["set_options"][$count]["default_selected"] = _ON;
							} else {
								$row["set_options"][$count]["default_selected"] = _OFF;
							}
							$count++;
						}
					}
				} else if ((!isset($row["content"]) || $row["content"] === null) || $init_flag) {
					$row["content"] = "";
					// デフォルト値セット

					$default_selected_options = explode("|", $row["default_selected"]);
					$options = explode("|", $row["options"]);
					$count = 0;
					$total_len = count($default_selected_options);
					foreach($default_selected_options as $key => $default_selected_option) {
						if ($row["define_flag"] == _ON && defined($options[$key])) {
							$value = constant($options[$key]);
						} else {
							$value = $options[$key];
						}
						if($value == "" && $total_len - 1 == $count) continue;		//最後の「|」の後の空文字列
						//if($default_selected_option == _ON) {
							//if($row["content"] == "") {
							//	$row["content"] = $value;
							//} else {
							//	$row["content"] .= ",".$value;
							//}
						//}
						$row["set_options"][$count]["options"] = $value;
						$row["set_options"][$count]["def_options"] = $options[$key];
						if($row["tag_name"] == "timezone_offset_lang") {
							// タイムゾーンならば、	default_TZセット
							if($timezoneMain->getFloatTimeZone($value) == $session->getParameter("_default_TZ")) {
								$row["set_options"][$count]["default_selected"] = _ON;
							} else {
								$row["set_options"][$count]["default_selected"] = _OFF;
							}
						} else {
							$row["set_options"][$count]["default_selected"] = $default_selected_option;
						}
						$count++;
			    	}
				} else {
					//設定済み
					$options = explode("|", $row["options"]);
					$edit_options = explode("|", $row["content"]);
					$count = 0;
					$row["content"] = "";
					$total_len = count($options);
					foreach($options as $option) {
						if($option == "" && $total_len - 1 == $count) continue;		//最後の「|」の後の空文字列
						if ($row["define_flag"] == _ON && defined($option)) {
							$row["set_options"][$count]["options"] = constant($option);
						} else {
							$row["set_options"][$count]["options"] = $option;
						}
						$row["set_options"][$count]["def_options"] = $option;
						if(in_array($option, $edit_options)) {
							$row["set_options"][$count]["default_selected"] = true;

							if($row["content"] == "") {
								$row["content"] = $row["set_options"][$count]["options"];
							} else {
								$row["content"] .= ",".$row["set_options"][$count]["options"];
							}
						}else {
							$row["set_options"][$count]["default_selected"] = false;
						}
						$count++;
					}
				}
			}
			//if($row["type"] == USER_TYPE_SYSTEM) {
			//	//参加ルーム、アクセス状況、レポート
			//	continue;
			//}
			if($id_flag) {
				$ret[] = $row;
			} else {
				$ret[intval($row['col_num'])][intval($row['row_num'])] = $row;
			}
		}
		return $ret;
	}

	/**
	 * ユーザー取得
	 *
	 * @param params:　array: user_id, login_id, user_name, handle,
	 * 						email, role_authority_id, active_flag, system_flag, activate_key
	 * @return  array  取得結果配列
	 * @access	public
	 */
	function &getUsers($where_params, $order_params=null, $func = null, $func_params = null)
	{
		$ret_false = false;

		$db_params = array();
		$sql = "SELECT {users}.*, ".
						"{authorities}.role_authority_id,".
						"{authorities}.role_authority_name,".
						"{authorities}.system_flag AS authority_system_flag,".
						"{authorities}.user_authority_id,".
						"{authorities}.public_createroom_flag,".
						"{authorities}.group_createroom_flag,".
						"{authorities}.private_createroom_flag,".
						"{authorities}.myroom_use_flag".
				" FROM {users}".
				" INNER JOIN {authorities} ON ({users}.role_authority_id={authorities}.role_authority_id) ";

		$params = array();
		if(is_array($where_params) && array_key_exists("user_authority_id", $where_params)) {
			$where_params["{authorities}.user_authority_id"] = $where_params["user_authority_id"];
			unset($where_params["user_authority_id"]);
		}
		if(is_array($where_params) && array_key_exists("myroom_use_flag", $where_params)) {
			$where_params["{authorities}.myroom_use_flag"] = $where_params["myroom_use_flag"];
			unset($where_params["myroom_use_flag"]);
		}
		$sql .= $this->_db->getWhereSQL($params, $where_params);
		$sql .= $this->_db->getOrderSQL($order_params);

		$result = $this->_db->execute($sql, $params, null, null, true, $func, $func_params);
		if ($result === false) {
	       	$this->_db->addError();
	       	return $result;
		}
		return $result;
	}


	/**
	 * fetch時コールバックメソッド
	 * @param result adodb object
	 * @return array users
	 * @access	private
	 */
	function &_getUsersFetchcallback($result) {
		$container =& DIContainerFactory::getContainer();
		$commonMain =& $container->getComponent("commonMain");
		$timezoneMain =& $commonMain->registerClass(WEBAPP_DIR.'/components/timezone/Main.class.php', "Timezone_Main", "timezoneMain");
		$languagesView =& $commonMain->registerClass(WEBAPP_DIR.'/components/languages/View.class.php', "Languages_View", "languagesView");

		$languages =& $languagesView->getLanguagesList();

		$ret = array();
		while ($row = $result->fetchRow()) {
			if(defined("_TZ_GMT0")) {
				//timezone.iniがincludeされているならば
				$row['timezone_offset_lang'] = $timezoneMain->getLangTimeZone($row['timezone_offset']);
			}
			if($row['authority_system_flag'] == _ON && defined($row['role_authority_name'])) {
				$row['role_authority_name'] = constant($row['role_authority_name']);
			}
			if($row['active_flag'] == _USER_ACTIVE_FLAG_PENDING) {
				$row['active_flag_lang'] = USER_ITEM_ACTIVE_FLAG_PENDING;
			} else if($row['active_flag'] == _USER_ACTIVE_FLAG_MAILED) {
				$row['active_flag_lang'] = USER_ITEM_ACTIVE_FLAG_MAILED;
			} else if($row['active_flag'] == _USER_ACTIVE_FLAG_ON) {
				$row['active_flag_lang'] = USER_ITEM_ACTIVE_FLAG_ON;
			} else {
				$row['active_flag_lang'] = USER_ITEM_ACTIVE_FLAG_OFF;
			}
			// 言語
			if(isset($languages[$row['lang_dirname']])) {
				$row['lang_dirname_lang'] = $languages[$row['lang_dirname']];
			}
			$ret[] = $row;
		}
		return $ret;
	}


	/**
	 * user_id, item_idからusers_items_link を取得する
	 * @param int user_id
	 * @param int item_id
	 * @return array users_items_link
	 * @access	public
	 */
	function &getUserItemLinkById($user_id, $item_id = null)
	{
		if($item_id != null) {
			$params = array(
				"user_id" => $user_id,
				"item_id" => $item_id
			);

			$result = $this->_db->execute("SELECT {users_items_link}.* FROM {users_items_link} " .
											" WHERE {users_items_link}.user_id=? AND {users_items_link}.item_id=?",$params);
		} else {
			$params = array(
				"user_id" => $user_id
			);

			$result = $this->_db->execute("SELECT {users_items_link}.* FROM {users_items_link} " .
											" WHERE {users_items_link}.user_id=?",$params, null, null, true, array($this, "_getUserItemLinkByIdFetchcallback"));
		}
		if ($result === false) {
	       	$this->_db->addError();
	       	return $result;
		}
		if($item_id == null) {
			return $result;
		}
		return $result[0];
	}

	/**
	 * fetch時コールバックメソッド
	 * @param result adodb object
	 * @return array
	 * @access	private
	 */
	function &_getUserItemLinkByIdFetchcallback($result) {
		$ret = array();
		while ($row = $result->fetchRow()) {
			$ret[$row['item_id']] = $row;
		}
		return $ret;
	}

	/**
	 * メール送信先一覧取得
	 *
	 * @param int or array(page_id)		$page_id
	 * @param int						$authority_id(モデレータ以上、主担以上等)
	 * 									page_id指定ありの場合、ルーム権限
	 * 									page_id指定なしの場合、会員権限
	 * @param string					$type(text or html) text/plainのメール、あるいは、htmlメールのみのメール配信の場合に指定
	 * 				　					デフォルト：携帯はtext/plain、PCはhtmlメール
	 * @param array						$where_params
	 * @param array						$order_params
	 *
	 * @return  array  取得結果配列
	 * @access	public
	 */
	function &getSendMailUsers($page_id=null, $more_than_authority_id=null, $type = null ,$where_params=array(), $order_params=array()) {
		if(!empty($page_id)) {
			$pagesView =& $this->_container->getComponent("pagesView");
			$page = $pagesView->getPageById(intval($page_id));
			if ($page === false || !isset($page['page_id'])) {
				$this->_db->addError();
		       	return false;
			}
			//if(($page['private_flag'] == _ON ||
			//	($page['private_flag'] == _OFF && $page['space_type'] == _SPACE_TYPE_GROUP && $page['default_entry_flag'] == _ON))
			//	&& $more_than_authority_id == _AUTH_GUEST) {
			//	$more_than_authority_id = _AUTH_GENERAL;
			//}
			//
			// email項目取得
			//
			$sql = "SELECT item_id, allow_email_reception_flag,";
			if($type == null) {
				$sql .= "{items}.type AS type";
			} else {
				$sql .= "\"".$type."\" AS type";
			}
			$sql .= " FROM {items}".
					" WHERE ({items}.type = 'email' OR {items}.type = 'mobile_email')";
			$items = $this->_db->execute($sql, null, null, null, true, array($this, "_getUserItemLinkByIdFetchcallback"));
			if ($items === false) {
		       	$this->_db->addError();
		       	return $items;
			}else if(count($items) == 0) {
				// email項目なし
				return $items;
			}

			$sql = "SELECT {users}.*,".
						"{authorities}.user_authority_id,{pages_users_link}.role_authority_id AS pages_users_role_authority_id,";
			$sql .= "{users_items_link}.item_id, {users_items_link}.content AS email,".
					$page['space_type']." AS space_type, ". $page['private_flag']. " AS private_flag, ". $page['default_entry_flag']. " AS default_entry_flag ".
				" FROM {users_items_link},{users}";
			if(($page['space_type'] == _SPACE_TYPE_PUBLIC ||
				($page['space_type'] == _SPACE_TYPE_GROUP && $page['private_flag'] == _OFF &&
					$page['default_entry_flag'] == _ON)) &&
					$more_than_authority_id <= _AUTH_GENERAL
					) {
				$sql .= " LEFT JOIN {pages_users_link} ON {users}.user_id={pages_users_link}.user_id";
			} else {
				$sql .= " INNER JOIN {pages_users_link} ON {users}.user_id={pages_users_link}.user_id";
			}
			$sql .= " AND {pages_users_link}.room_id = ". $page_id;
			$sql .= " LEFT JOIN {authorities} ON {pages_users_link}.role_authority_id={authorities}.role_authority_id".
						" WHERE {users}.user_id={users_items_link}.user_id ".
						" AND {users}.active_flag="._ON.
						" AND {users_items_link}.content!='' ";
			$sql .= " AND (1!=1";
			foreach($items as $item) {
				if($item['allow_email_reception_flag'] == _OFF) {
					$sql .= " OR {users_items_link}.item_id = ".$item['item_id']."";
				} else {
					$sql .= " OR ({users_items_link}.item_id = ".$item['item_id']." AND ".
						"{users_items_link}.email_reception_flag="._ON.")";
				}
			}
			$sql .= ")";
			$func = array($this, '_fetchcallbackSendMail');
			$authoritiesView =& $this->_container->getComponent("authoritiesView");
			$authorities = $authoritiesView->getAuthorities(null, null, null, null, true);
			$func_params = array($more_than_authority_id, $authorities, $items);
		} else {
			// ルームID指定なし
			// 会員の user_authority_idのみでメールを送信
			//
			$sql = "SELECT {users}.*, ".
						"{authorities}.user_authority_id,";
			if($type == null) {
				$sql .= "{items}.type,";
			} else {
				$sql .= "\"".$type."\" AS type,";
			}
			$sql .= "{users_items_link}.content AS email".
				" FROM {users},{authorities},{users_items_link},{items}".
				" WHERE {users}.role_authority_id={authorities}.role_authority_id ".
				" AND {users}.user_id={users_items_link}.user_id ".
				" AND {users_items_link}.item_id = {items}.item_id ".
				" AND {users}.active_flag="._ON.
				" AND ({items}.type='email' OR {items}.type='mobile_email') ".
				" AND ({items}.allow_email_reception_flag="._OFF." OR {users_items_link}.email_reception_flag="._ON.") ".
				" AND {users_items_link}.content!='' ";
			if($more_than_authority_id != null) {
				$sql .= "AND {authorities}.user_authority_id >= ".$more_than_authority_id;
			}
			$func = null;
			$func_params = null;
		}
		$params = array();
		$sql .= $this->_db->getWhereSQL($params, $where_params, false);
		$sql .= $this->_db->getOrderSQL($order_params);
		$result = $this->_db->execute($sql, $params, null, null, true, $func, $func_params);
		if ($result === false) {
	       	$this->_db->addError();
	       	return $result;
		}
		return $result;
	}

	/**
	 * fetch時コールバックメソッド
	 * @param result adodb object
	 * @param array  $func_param
	 * @return array
	 * @access	public
	 */
	function _fetchcallbackSendMail($result, $func_param) {
		$ret = array();
		$more_than_authority_id = $func_param[0];
		if($more_than_authority_id === null) {
			$more_than_authority_id = _AUTH_GUEST;
		}
		$authorities =& $func_param[1];
		$items =& $func_param[2];
		$session =& $this->_container->getComponent("Session");

		while ($row = $result->fetchRow()) {
			if(!is_null($row["pages_users_role_authority_id"]) && $row["pages_users_role_authority_id"] == _AUTH_OTHER) {
				continue;
			}
			if($row["user_authority_id"] === null) {
				if($row["default_entry_flag"] != _ON) {
					continue;
				}
				if($row['private_flag'] == _ON) {
					$row["user_authority_id"] = $session->getParameter("_default_entry_auth_private");
				} elseif($row['space_type'] == _SPACE_TYPE_PUBLIC) {
					$row["user_authority_id"] = $session->getParameter("_default_entry_auth_public");
				} else {
					$row["user_authority_id"] = $session->getParameter("_default_entry_auth_group");
				}
				if($row['user_authority_id'] === null) {
					continue;
					//$row['user_authority_id'] = _AUTH_OTHER;
				} else if($authorities[$row['role_authority_id']]['user_authority_id'] == _AUTH_GUEST && $row['user_authority_id'] == _AUTH_GENERAL) {
					$row['user_authority_id'] = _AUTH_GUEST;
				}
			}
			$row['type'] = $items[$row['item_id']]['type'];
			if($row['user_authority_id'] >= $more_than_authority_id) {
				$ret[] = $row;
			}
		}
		return $ret;
	}

	/**
	 * itemを取得する
	 *
	 * @param   int   $item_id  項目ID
	 * @return array
	 * @access	public
	 */
	function &getItemById($item_id, $func=null, $func_param=null)
	{
		$session =& $this->_container->getComponent("Session");
		// 権限管理で会員管理で設定された権限を用いる(authorities_modules_linkのauthority_id)
		$_user_auth_id = $session->getParameter("_user_auth_id");
		$sql = "SELECT {items}.*, {items_authorities_link}.under_public_flag, {items_authorities_link}.self_public_flag,{items_authorities_link}.over_public_flag, ".
					" {items_desc}.description, {items_desc}.attribute, {items_options}.options, {items_options}.default_selected ".
					"FROM {items}  ".
					"LEFT JOIN {items_authorities_link} ON ({items}.item_id={items_authorities_link}.item_id AND {items_authorities_link}.user_authority_id=".intval($_user_auth_id).") ".
					"LEFT JOIN {items_desc} ON {items}.item_id={items_desc}.item_id ".
					"LEFT JOIN {items_options} ON {items}.item_id={items_options}.item_id ".
					"WHERE {items}.item_id=".intval($item_id);

		//$result =& $this->_db->selectExecute("items", array("item_id"=>intval($item_id)), null, 1, 0);
		$result = $this->_db->execute($sql, null, 1, 0, true,  $func, $func_param);
		if($result === false) {
			// エラーが発生した場合、エラーリストに追加
			$result = false;
			$this->_db->addError();
			return $result;
		}
		if(!isset($result[0])) {
			return 	$result;
		}
		return $result[0];
	}

	/**
	 * itemを取得する
	 *
	 * @param   int   $item_id  項目ID
	 * @return array
	 * @access	public
	 */
	function &getItems($where_params=null, $order_params=null, $limit = null, $offset = null, $func=null, $func_param=null)
	{
		if($where_params != null && isset($where_params['user_authority_id'])) {
			$sql = "SELECT {items}.*,". 		//" {users_items_link}.user_id, {users_items_link}.content, ".
					" {items_authorities_link}.under_public_flag, {items_authorities_link}.self_public_flag,{items_authorities_link}.over_public_flag,{items_options}.options,{items_options}.default_selected ".
					" FROM {items}  ".
					//" LEFT JOIN {users_items_link} ON ({items}.item_id={users_items_link}.item_id)".
					" LEFT JOIN {items_authorities_link} ON ({items}.item_id={items_authorities_link}.item_id AND {items_authorities_link}.user_authority_id=".intval($where_params['user_authority_id']).") ".
					" LEFT JOIN {items_options} ON ({items}.item_id={items_options}.item_id)";
			unset($where_params['user_authority_id']);
		} else {
			$sql = "SELECT {items}.*, {users_items_link}.user_id, {users_items_link}.content,{items_options}.options,{items_options}.default_selected ".
					"FROM {items}  ".
					" LEFT JOIN {users_items_link} ON ({items}.item_id={users_items_link}.item_id)".
					" LEFT JOIN {items_options} ON ({items}.item_id={items_options}.item_id)";
		}
		$sql .= $this->_db->getWhereSQL($params, $where_params);
		$sql .= $this->_db->getOrderSQL($order_params);

		$result =$this->_db->execute($sql, $params, $limit, $offset, true,  $func, $func_param);
		if($result === false) {
			// エラーが発生した場合、エラーリストに追加
			$this->_db->addError();
			return $result;
		}
		return $result;
	}


	/**
	 * ルームに所属するpages_users_linkテーブルを取得する
	 *
	 * @param  array    $room_id_arr  ルームID
	 * @param	array	 $where_params		キー名称配列、whereデータ配列
	 * @param	array    $order_params		        キー名称配列、orderデータ配列
	 * @param	integer	 $offset	取得し始めるレコードのオフセット
	 * @param	integer	 $limit	取得する件数
	 * @param	function $func	各レコード処理で実行させるメソッド
	 * @param	array	 $func_param	各レコード処理で実行させるメソッドの引数
	 * @return array
	 * @access	public
	 */
	function &getPagesUsersLinkByRoom($room_id_arr, $where_params=null, $order_params=null, $limit = null, $offset = null, $func=null, $func_param=null)
	{
		//if($func == null) $func = array($this, "_getPagesUsersLinkFetchcallback");
		$params = array();
		$sql = "SELECT {pages_users_link}.*,{authorities}.user_authority_id AS authority_id,{authorities}.hierarchy " .
						" FROM {pages_users_link} ".
				" LEFT JOIN {authorities} ON ({pages_users_link}.role_authority_id={authorities}.role_authority_id)".
				" WHERE room_id IN (". implode(",", $room_id_arr). ") ";
		$sql .= $this->_db->getWhereSQL($params, $where_params, false);
		//$sql .= " GROUP BY {pages_users_link}.user_id ";
		$sql .= $this->_db->getOrderSQL($order_params);

		$result =$this->_db->execute($sql, $params, $limit, $offset, true,  $func, $func_param);
		if($result === false) {
			// エラーが発生した場合、エラーリストに追加
			$this->_db->addError();
			return $result;
		}
		return $result;
	}
}
?>
