<?php

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/**
 * メール送信
 *
 * @package     NetCommons
 * @author      Noriko Arai,Ryuji Masukawa
 * @copyright   2006-2007 NetCommons Project
 * @license     http://www.netcommons.org/license.txt  NetCommons License
 * @project     NetCommons Project, supported by National Institute of Informatics
 * @access      public
 */
class Pm_Action_Main_Mail extends Action
{
    // リクエストパラメータを受け取るため
    var $module_id = null;
 	var $room_id = null;
 	var $block_id = null;
	var $page_id = null;

    // 使用コンポーネントを受け取るため
    var $session = null;
	var $configView = null;
	var $pmView = null;
 	var $mailMain = null;
	var $usersView = null;
	var $snscommunityView = null;
	
    /**
     * execute実行
     *
     * @access  public
     */
    function execute()
    {
		$message_id = $this->session->getParameter("pm_mail_message_id");
		$message_id = intval($message_id);
		if ($message_id == 0) {
			return 'success';
		}

		$message = $this->pmView->getMessageById($message_id);
    	if ($message === false) {
			return 'error';
    	}
    	
    	//セキュリティーの為、ユーザーのチェック
		$userID = $this->session->getParameter('_user_id');
		if(empty($userID) || $userID != $message["insert_user_id"]) {
			return 'error';
		}
		
		$userID = $this->session->getParameter('_user_id');
		$userEmail = $this->pmView->getUserEMail();
		$user =& $this->usersView->getUserById($userID);
		$userName = $user['handle'];

		$mail_subject = sprintf(PM_SUBJECT_FORMAT, '', $message["subject"]);
		$mail_body = preg_replace("/\\\\n/s", "\n", PM_MAIL_BODY);
		$this->mailMain->setSubject($mail_subject);
		$this->mailMain->setBody($mail_body);

		$tags["X-TITLE"] = htmlspecialchars($message["subject"]);
		$tags["X-USER"] = htmlspecialchars($message["insert_user_name"]);
		$tags["X-INPUT_TIME"] = timezone_date($message["insert_time"], false, _FULL_DATE_FORMAT);
		$tags["X-BODY"] = ($message["body"] == "" ? PM_MAIL_NO_DISCRIPTION : $message["body"]);
		
		$active_action_name = "active_center";
		
		$tags["X-URL"] = BASE_URL. INDEX_FILE_NAME.
						 "?action=". DEFAULT_ACTION .
						 "&" . $active_action_name . "=pm_view_main_message_detail".
						 "&message_id=". $message["message_id"];
			 
		$this->mailMain->assign($tags);
		$this->mailMain->setFromName($userName);
		$this->mailMain->setFromEmail($userEmail);
		
		$mail_filters = $this->session->getParameter("pm_mail_filters");
		$mail_forwards = $this->session->getParameter("pm_mail_forwards");
		if(!is_array($mail_filters)){ $mail_filters = array(); }
		if(!is_array($mail_forwards)){ $mail_forwards = array(); }

		if(sizeof($mail_filters) || sizeof($mail_forwards)){
			$mail_users = array_merge($mail_forwards, $mail_filters);
			$users = array();
			for($i = 0; $i < sizeof($mail_users); $i++){
				$users[] = array(
					"handle" => $mail_users[$i]["receiver_user_name"],
					"email" => $mail_users[$i]["email"]
				);
			}
		}else{
			$users = false;
		}
		
		if($users == false){
			return 'error';
		}
		
		$this->mailMain->setToUsers($users);
		$this->mailMain->send();
		
		$this->session->removeParameter("pm_mail_forwards");
		$this->session->removeParameter("pm_mail_filters");
		$this->session->removeParameter("pm_mail_message_id");
        return 'success';
    }
}
?>