package car;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.BitSet;

/**
 * キー入力を扱うクラスです。
 * Created on 2004/12/12
 * @author Kumano Tatsuo
 */
public class KeyHandler implements KeyListener {

	/**
	 * 現在押されているキー
	 */
	final private BitSet keys;

	/**
	 * 最後に問い合わせがあってから押されたキー
	 */
	final private BitSet pressedKeys;

	/**
	 * 離されたキー
	 */
	private BitSet releasedKeys;

	/**
	 * コンストラクタです。
	 */
	public KeyHandler() {
		this.keys = new BitSet();
		this.releasedKeys = new BitSet();
		this.pressedKeys = new BitSet();
	}

	/**
	 * キーの情報を初期化します。
	 */
	public void clearKeys() {
		this.keys.clear();
		this.pressedKeys.clear();
	}

	/**
	 * @param keyCode キーコード
	 * @return 指定したキーが現在押されているかどうか
	 */
	public boolean isPressed(final int keyCode) {
		final boolean ret = this.keys.get(keyCode);
		if (this.releasedKeys.get(keyCode)) {
			this.keys.clear(keyCode);
		}
		return ret;
	}

	public void keyPressed(KeyEvent e) {
		this.keys.set(e.getKeyCode());
		this.releasedKeys.clear(e.getKeyCode());
        this.pressedKeys.set(e.getKeyCode());
	}

	public void keyReleased(KeyEvent e) {
		this.releasedKeys.set(e.getKeyCode());
	}

	public void keyTyped(KeyEvent e) {
	}

	/**
	 * @param keyCode キーコード
	 * @return 最後に問い合わせがあってから指定したキーが押されたかどうか
	 */
	public boolean wasPressed(final int keyCode) {
		final boolean ret = this.pressedKeys.get(keyCode);
		this.pressedKeys.clear(keyCode);
		return ret;
	}
}
