package car.character;

import javax.media.j3d.TransformGroup;
import javax.vecmath.Color3f;

import car.Player;

/**
 * プレイヤの個性を設定するインターフェイスです。
 * @author Kumano Tatsuo
 * Created on 2005/09/06
 */
public interface Character {
	/**
	 * @return 舗装道の加速
	 */
	public double getFowardRoadAccel();

	/**
	 * @return 悪路の加速
	 */
	public double getFowardDirtAccel();

	/**
	 * @return 後進の加速
	 */
	public double getRearAccel();

	/**
	 * @return 空気抵抗
	 */
	public double getNormalDecel();

	/**
	 * @return ハンドルを切ったときの減速
	 */
	public double getHandleDecel();

	/**
	 * @return 減速するハンドルの切れ角
	 */
	public double getHandleDecelThreshold();

	/**
	 * @return 舗装道のハンドル
	 */
	public double getFowardRoadHandle();

	/**
	 * @return 悪路のハンドル
	 */
	public double getFowardDirtHandle();

	/**
	 * @return 後進のハンドル
	 */
	public double getRearHandle();

	/**
	 * @return ハンドルの戻り
	 */
	public double getNormalHandleDecel();

	/**
	 * @return 平行移動の減速
	 */
	public double getSlideDecel();

	/**
	 * @param player プレイヤ
	 * @param bodyColor 塗装色
	 * @param rubberColor 座席とタイヤの色
	 * @param personColor 人の色
	 * @param headColor 頭の色
	 * @return 車のグラフィック
	 */
	public TransformGroup getCarTransformGroup(final Player player,
			final Color3f bodyColor, final Color3f rubberColor,
			final Color3f personColor, final Color3f headColor);
	
	/**
	 * @return 幅
	 */
	public double getWidth();
	
	/**
	 * @return 長さ
	 */
	public double getLength();
	
	/**
	 * @return 高さ
	 */
	public double getHeight();
	
	/**
	 * @return エンジンブレーキによる減速
	 */
	public double getEngineDecel();
	
	/**
	 * @return ブレーキによる減速
	 */
	public double getBrakeDecel();
	
	/**
	 * @return ドリフトする横G
	 */
	public double getDriftThreshold();
	
	/**
	 * @return ドリフトする量
	 */
	public double getDriftAmount();
}
