package test;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

import javax.imageio.ImageIO;
import javax.swing.JPanel;

/**
 * デモ用のパネルです。
 * @author Kumano Tatsuo
 * Created on 2005/08/22
 */
public class DemoPanel extends JPanel {
	/**
	 * 描画するオブジェクト
	 */
	private Collection<Shape> shapes;

	/**
	 * ラベル
	 */
	private Map<Shape, String> labels;

	/**
	 * フォント
	 */
	private Map<Shape, Font> fonts;

	/**
	 * 境界色
	 */
	private Map<Shape, Color> borderColors;

	/**
	 * 塗りつぶし色
	 */
	private Map<Shape, Color> fillColors;

	/**
	 * 直前にマウスがいたx座標
	 */
	int lastMouseX;

	/**
	 * 直前にマウスがいたy座標
	 */
	int lastMouseY;

	/**
	 * 選択範囲
	 */
	Rectangle2D selection;

	// test
	/**
	 * 最後にクリックされた点 
	 */
	Point2D lastPoint = null;
	
	/**
	 * コンストラクタです。
	 */
	public DemoPanel() {
		this.shapes = new ArrayList<Shape>();
		this.labels = new HashMap<Shape, String>();
		this.fonts = new HashMap<Shape, Font>();
		this.borderColors = new HashMap<Shape, Color>();
		this.fillColors = new HashMap<Shape, Color>();
		this.selection = new Rectangle2D.Double();
		addMouseListener(new MouseAdapter() {
			public void mousePressed(MouseEvent e) {
				if (e.getButton() == MouseEvent.BUTTON1) {
					DemoPanel.this.lastMouseX = e.getX();
					DemoPanel.this.lastMouseY = e.getY();
					final Point2D point = toVirtualLocation(new Point2D.Double(e.getX(), e.getY()));
					if (DemoPanel.this.lastPoint != null) {
//						System.out.println("new Line2D.Double(" + DemoPanel.this.lastPoint.getX() + "f * this.zoom, " + -DemoPanel.this.lastPoint.getY() + "f * this.zoom, " + point.getX() + "f * this.zoom, " + -point.getY() + "f * this.zoom),");
					}
					DemoPanel.this.lastPoint = point;
//					System.out.println("new Point3f(" + point.getX() + "f * this.zoom, " + -point.getY() + "f * this.zoom, waterHeight),");
				} else {
					DemoPanel.this.lastMouseX = e.getX();
					DemoPanel.this.lastMouseY = e.getY();
				}
			}
			
			public void mouseReleased(MouseEvent e) {
				if (e.getButton() == MouseEvent.BUTTON1) {
					final Point2D p1 = toVirtualLocation(new Point2D.Double(
							DemoPanel.this.lastMouseX,
							DemoPanel.this.lastMouseY));
					final Point2D p2 = toVirtualLocation(new Point2D.Double(e
							.getX(), e.getY()));
					DemoPanel.this.selection.setFrameFromDiagonal(p1, p2);
					DemoPanel.this.isChanged = true;
					repaint();
				}
			}
		});
		addMouseMotionListener(new MouseMotionAdapter() {
			public void mouseDragged(MouseEvent e) {
				if ((e.getModifiers() & InputEvent.BUTTON1_MASK) != 0) {
					final Point2D p1 = toVirtualLocation(new Point2D.Double(
							DemoPanel.this.lastMouseX,
							DemoPanel.this.lastMouseY));
					final Point2D p2 = toVirtualLocation(new Point2D.Double(e
							.getX(), e.getY()));
					DemoPanel.this.selection.setFrameFromDiagonal(p1, p2);
					DemoPanel.this.isChanged = true;
					repaint();
				} else {
					DemoPanel.this.offsetX -= e.getX()
							- DemoPanel.this.lastMouseX;
					DemoPanel.this.offsetY -= e.getY()
							- DemoPanel.this.lastMouseY;
					DemoPanel.this.lastMouseX = e.getX();
					DemoPanel.this.lastMouseY = e.getY();
					DemoPanel.this.isChanged = true;
					repaint();
				}
			}
		});
		addMouseWheelListener(new MouseWheelListener() {
			public void mouseWheelMoved(MouseWheelEvent e) {
				final double newZoom = DemoPanel.this.zoom
						* (1 + (double) e.getWheelRotation() / 10);
				DemoPanel.this.offsetX = ((DemoPanel.this.offsetX + e.getX())
						/ DemoPanel.this.zoom * newZoom - e.getX());
				DemoPanel.this.offsetY = ((DemoPanel.this.offsetY + e.getY())
						/ DemoPanel.this.zoom * newZoom - e.getY());
				DemoPanel.this.zoom = newZoom;
				DemoPanel.this.isChanged = true;
				repaint();
			}
		});
		addComponentListener(new ComponentAdapter() {
			public void componentResized(ComponentEvent e) {
				DemoPanel.this.image = null;
				repaint();
			}
		});
	}

	/**
	 * データをクリアします。
	 */
	public void clear() {
		this.shapes.clear();
		this.isChanged = true;
	}
	
	/**
	 * @param shape 描画するオブジェクト
	 */
	public void add(final Shape shape) {
		this.shapes.add(shape);
		this.isChanged = true;
	}

	/**
	 * @param shape 描画するオブジェクト
	 * @param label ラベル
	 */
	public void setLabel(final Shape shape, final String label) {
		this.labels.put(shape, label);
	}

	/**
	 * @param shape 描画するオブジェクト
	 * @param font フォント
	 */
	public void setFont(final Shape shape, final Font font) {
		this.fonts.put(shape, font);
	}

	/**
	 * @param shape 描画するオブジェクト
	 * @param color 境界色
	 */
	public void setBorderColor(final Shape shape, final Color color) {
		this.borderColors.put(shape, color);
	}

	/**
	 * @param shape 描画するオブジェクト
	 * @param color 塗りつぶし色
	 */
	public void setFillColor(final Shape shape, final Color color) {
		this.fillColors.put(shape, color);
	}

	/**
	 * オフセット
	 */
	double offsetX;

	/**
	 * オフセット
	 */
	double offsetY;

	/**
	 * 表示倍率
	 */
	double zoom;

	/**
	 * ダブルバファリング用のイメージ
	 */
	Image image;

	/**
	 * 再描画する必要があるかどうか
	 */
	boolean isChanged;

	public void paint(final Graphics graphics) {
		if (this.image == null) {
			int minX = Integer.MAX_VALUE;
			int minY = Integer.MAX_VALUE;
			int maxX = Integer.MIN_VALUE;
			int maxY = Integer.MIN_VALUE;
			for (final Shape shape : this.shapes) {
				minX = Math.min(minX, shape.getBounds().x);
				minY = Math.min(minY, shape.getBounds().y);
				maxX = Math.max(maxX, shape.getBounds().x
						+ shape.getBounds().width);
				maxY = Math.max(maxY, shape.getBounds().y
						+ shape.getBounds().height);
			}
			final double zoomX = (double) (getWidth() - 1) / (maxX - minX);
			final double zoomY = (double) (getHeight() - 1) / (maxY - minY);
			this.zoom = zoomX < zoomY ? zoomX : zoomY;
			this.offsetX = (minX + maxX) / 2 * this.zoom - getWidth() / 2;
			this.offsetY = (minY + maxY) / 2 * this.zoom - getHeight() / 2;
			this.image = createImage(getWidth(), getHeight());
			this.isChanged = true;
		}
		if (this.isChanged) {
			final Graphics2D g = (Graphics2D) this.image.getGraphics();
			g.setColor(Color.WHITE);
			g.fillRect(0, 0, getWidth(), getHeight());
			g.translate(-this.offsetX, -this.offsetY);
			g.scale(this.zoom, this.zoom);
			try {
//				g.drawImage(ImageIO.read(new File("img/tsukuba.png")), 0, 0, this);
				g.drawImage(ImageIO.read(new File("img/tsukuba2.png")), 0, 0, this);
			} catch (IOException e) {
				e.printStackTrace();
			}
			for (final Shape shape : this.shapes) {
				if (this.fillColors.containsKey(shape)) {
					g.setColor(this.fillColors.get(shape));
				} else {
					g.setColor(Color.WHITE);
				}
				if (!this.fillColors.containsKey(shape) || this.fillColors.get(shape) != null) {
					g.fill(shape);
				}
				if (this.borderColors.containsKey(shape)) {
					g.setColor(this.borderColors.get(shape));
				} else {
					g.setColor(Color.BLACK);
				}
				g.draw(shape);
			}
			g.setColor(Color.BLACK);
			for (final Map.Entry<Shape, String> entry : this.labels.entrySet()) {
				if (this.fonts.containsKey(entry.getKey())) {
					g.setFont(this.fonts.get(entry.getKey()));
				}
				final FontMetrics metrics = getFontMetrics(g.getFont());
				final Rectangle2D rectangle = metrics.getStringBounds(entry
						.getValue(), g);
				g.drawString(entry.getValue(), (float) (entry.getKey()
						.getBounds().getCenterX() - rectangle.getWidth() / 2),
						(float) (entry.getKey().getBounds().getCenterY()
								+ rectangle.getHeight() / 2 - metrics
								.getDescent()));
			}
			g.setColor(Color.BLACK);
			g.setStroke(new BasicStroke((float) (2 / this.zoom)));
			g.draw(this.selection);
			this.isChanged = false;
		}
		graphics.drawImage(this.image, 0, 0, this);
	}

	/**
	 * 仮想座標を取得します。
	 * @param location 実座標
	 * @return 仮想座標
	 */
	public Point2D toVirtualLocation(Point2D location) {
		return new Point2D.Double((this.offsetX + location.getX()) / this.zoom,
				(this.offsetY + location.getY()) / this.zoom);
	}

	/**
	 * @return 選択されている長方形
	 */
	public Rectangle2D getSelection() {
		return this.selection;
	}
	
}
