"""fixed ON DELETE for foreign keys to old_id

Revision ID: fa9c488d44e4
Revises: 1034996130ac
Create Date: 2018-08-04 15:11:28.136659

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = 'fa9c488d44e4'
down_revision = '1034996130ac'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint('archive_ar_text_id_fkey', 'archive', type_='foreignkey')
    op.create_foreign_key(None, 'archive', 'text', ['ar_text_id'], ['old_id'], ondelete='SET NULL', initially='DEFERRED', deferrable=True)
    op.drop_constraint('revision_rev_text_id_fkey', 'revision', type_='foreignkey')
    op.create_foreign_key(None, 'revision', 'text', ['rev_text_id'], ['old_id'], ondelete='SET NULL', initially='DEFERRED', deferrable=True)
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint(None, 'revision', type_='foreignkey')
    op.create_foreign_key('revision_rev_text_id_fkey', 'revision', 'text', ['rev_text_id'], ['old_id'], initially='DEFERRED', deferrable=True)
    op.drop_constraint(None, 'archive', type_='foreignkey')
    op.create_foreign_key('archive_ar_text_id_fkey', 'archive', 'text', ['ar_text_id'], ['old_id'], initially='DEFERRED', deferrable=True)
    # ### end Alembic commands ###
