/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.amqp;

import java.util.HashMap;
import java.util.Map;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.BrokerServiceAware;
import org.apache.activemq.transport.MutexTransport;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.amqp.AmqpInactivityMonitor;
import org.apache.activemq.transport.amqp.AmqpTransportFilter;
import org.apache.activemq.transport.tcp.SslTransportFactory;
import org.apache.activemq.util.IntrospectionSupport;
import org.apache.activemq.wireformat.WireFormat;

public class AmqpSslTransportFactory
extends SslTransportFactory
implements BrokerServiceAware {
    private BrokerService brokerService = null;

    @Override
    protected String getDefaultWireFormatType() {
        return "amqp";
    }

    @Override
    public Transport compositeConfigure(Transport transport, WireFormat format, Map options) {
        AmqpTransportFilter amqpTransport = new AmqpTransportFilter(transport, format, this.brokerService);
        Map<String, Object> wireFormatOptions = IntrospectionSupport.extractProperties(options, "wireFormat.");
        IntrospectionSupport.setProperties(amqpTransport, options);
        IntrospectionSupport.setProperties(amqpTransport.getWireFormat(), wireFormatOptions);
        return super.compositeConfigure(amqpTransport, format, options);
    }

    @Override
    public Transport serverConfigure(Transport transport, WireFormat format, HashMap options) throws Exception {
        if ((transport = super.serverConfigure(transport, format, options)) instanceof MutexTransport) {
            transport = ((MutexTransport)transport).getNext();
        }
        return transport;
    }

    @Override
    public void setBrokerService(BrokerService brokerService) {
        this.brokerService = brokerService;
    }

    @Override
    protected Transport createInactivityMonitor(Transport transport, WireFormat format) {
        AmqpInactivityMonitor monitor = new AmqpInactivityMonitor(transport, format);
        AmqpTransportFilter filter = transport.narrow(AmqpTransportFilter.class);
        filter.setInactivityMonitor(monitor);
        return monitor;
    }
}

