/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier;

import org.apache.camel.Expression;
import org.apache.camel.NamedNode;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.model.LoopDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.processor.LoopProcessor;
import org.apache.camel.reifier.ExpressionReifier;

public class LoopReifier
extends ExpressionReifier<LoopDefinition> {
    public LoopReifier(Route route, ProcessorDefinition<?> definition) {
        super(route, (LoopDefinition)definition);
    }

    @Override
    public Processor createProcessor() throws Exception {
        Processor output = this.createChildProcessor(true);
        boolean isCopy = this.parseBoolean(((LoopDefinition)this.definition).getCopy(), false);
        boolean isWhile = this.parseBoolean(((LoopDefinition)this.definition).getDoWhile(), false);
        boolean isBreakOnShutdown = this.parseBoolean(((LoopDefinition)this.definition).getBreakOnShutdown(), false);
        Processor prepare = ((LoopDefinition)this.definition).getOnPrepareProcessor();
        if (prepare == null && ((LoopDefinition)this.definition).getOnPrepare() != null) {
            prepare = this.mandatoryLookup(((LoopDefinition)this.definition).getOnPrepare(), Processor.class);
        }
        Predicate predicate = null;
        Expression expression = null;
        if (isWhile) {
            predicate = this.createPredicate(((LoopDefinition)this.definition).getExpression());
        } else {
            expression = this.createExpression(((LoopDefinition)this.definition).getExpression());
        }
        LoopProcessor answer = new LoopProcessor(this.camelContext, output, expression, predicate, prepare, isCopy, isBreakOnShutdown);
        answer.setDisabled(LoopReifier.isDisabled(this.camelContext, (NamedNode)this.definition));
        return answer;
    }
}

