/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.resume;

import org.apache.camel.resume.Offset;

public final class Offsets {
    private Offsets() {
    }

    public static <T> Offset<T> of(T offsetValue) {
        return new AnonymousOffset<T>(offsetValue);
    }

    public static <T> Offset<T> ofNullable(T offsetValue, T defaultValue) {
        if (offsetValue != null) {
            return new AnonymousOffset<T>(offsetValue);
        }
        return Offsets.of(defaultValue);
    }

    private static class AnonymousOffset<T>
    implements Offset<T> {
        private T offset;

        public AnonymousOffset(T offset) {
            this.offset = offset;
        }

        public void update(T offset) {
            this.offset = offset;
        }

        public T getValue() {
            return this.offset;
        }
    }
}

