/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jclouds.cloudstack.domain.AllocationState;
import org.jclouds.cloudstack.domain.NetworkType;
import org.jclouds.cloudstack.domain.Tag;
import org.jclouds.javax.annotation.Nullable;

public class Zone
implements Comparable<Zone> {
    private final String id;
    private final String description;
    private final String displayText;
    private final String dns1;
    private final String dns2;
    private final String domain;
    private final String domainId;
    private final String guestCIDRAddress;
    private final String internalDNS1;
    private final String internalDNS2;
    private final String name;
    private final NetworkType networkType;
    private final String vlan;
    private final boolean securityGroupsEnabled;
    private final AllocationState allocationState;
    private final String dhcpProvider;
    private final String zoneToken;
    private final Set<Tag> tags;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromZone(this);
    }

    @ConstructorProperties(value={"id", "description", "displaytext", "dns1", "dns2", "domain", "domainid", "guestcidraddress", "internaldns1", "internaldns2", "name", "networktype", "vlan", "securitygroupsenabled", "allocationstate", "dhcpprovider", "zonetoken", "tags"})
    protected Zone(String id, @Nullable String description, @Nullable String displayText, @Nullable String dns1, @Nullable String dns2, @Nullable String domain, @Nullable String domainId, @Nullable String guestCIDRAddress, @Nullable String internalDNS1, @Nullable String internalDNS2, @Nullable String name, @Nullable NetworkType networkType, @Nullable String vlan, boolean securityGroupsEnabled, @Nullable AllocationState allocationState, @Nullable String dhcpProvider, @Nullable String zoneToken, @Nullable Set<Tag> tags) {
        this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
        this.description = description;
        this.displayText = displayText;
        this.dns1 = dns1;
        this.dns2 = dns2;
        this.domain = domain;
        this.domainId = domainId;
        this.guestCIDRAddress = guestCIDRAddress;
        this.internalDNS1 = internalDNS1;
        this.internalDNS2 = internalDNS2;
        this.name = name;
        this.networkType = networkType;
        this.vlan = vlan;
        this.securityGroupsEnabled = securityGroupsEnabled;
        this.allocationState = allocationState;
        this.dhcpProvider = dhcpProvider;
        this.zoneToken = zoneToken;
        this.tags = tags != null ? ImmutableSet.copyOf(tags) : ImmutableSet.of();
    }

    public String getId() {
        return this.id;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Nullable
    public String getDisplayText() {
        return this.displayText;
    }

    public List<String> getDNS() {
        ImmutableList.Builder builder = ImmutableList.builder();
        if (this.dns1 != null && !"".equals(this.dns1)) {
            builder.add((Object)this.dns1);
        }
        if (this.dns2 != null && !"".equals(this.dns2)) {
            builder.add((Object)this.dns2);
        }
        return builder.build();
    }

    @Nullable
    public String getDomain() {
        return this.domain;
    }

    @Nullable
    public String getDomainId() {
        return this.domainId;
    }

    @Nullable
    public String getGuestCIDRAddress() {
        return this.guestCIDRAddress;
    }

    public List<String> getInternalDNS() {
        ImmutableList.Builder builder = ImmutableList.builder();
        if (this.internalDNS1 != null && !"".equals(this.internalDNS1)) {
            builder.add((Object)this.internalDNS1);
        }
        if (this.internalDNS2 != null && !"".equals(this.internalDNS2)) {
            builder.add((Object)this.internalDNS2);
        }
        return builder.build();
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public NetworkType getNetworkType() {
        return this.networkType;
    }

    @Nullable
    public String getVLAN() {
        return this.vlan;
    }

    public boolean isSecurityGroupsEnabled() {
        return this.securityGroupsEnabled;
    }

    @Nullable
    public AllocationState getAllocationState() {
        return this.allocationState;
    }

    @Nullable
    public String getDhcpProvider() {
        return this.dhcpProvider;
    }

    @Nullable
    public String getZoneToken() {
        return this.zoneToken;
    }

    public Set<Tag> getTags() {
        return this.tags;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.description, this.displayText, this.dns1, this.dns2, this.domain, this.domainId, this.guestCIDRAddress, this.internalDNS1, this.internalDNS2, this.name, this.networkType, this.vlan, this.securityGroupsEnabled, this.allocationState, this.dhcpProvider, this.zoneToken, this.tags});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Zone that = (Zone)Zone.class.cast(obj);
        return Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)this.description, (Object)that.description) && Objects.equal((Object)this.displayText, (Object)that.displayText) && Objects.equal((Object)this.dns1, (Object)that.dns1) && Objects.equal((Object)this.dns2, (Object)that.dns2) && Objects.equal((Object)this.domain, (Object)that.domain) && Objects.equal((Object)this.domainId, (Object)that.domainId) && Objects.equal((Object)this.guestCIDRAddress, (Object)that.guestCIDRAddress) && Objects.equal((Object)this.internalDNS1, (Object)that.internalDNS1) && Objects.equal((Object)this.internalDNS2, (Object)that.internalDNS2) && Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)((Object)this.networkType), (Object)((Object)that.networkType)) && Objects.equal((Object)this.vlan, (Object)that.vlan) && Objects.equal((Object)this.securityGroupsEnabled, (Object)that.securityGroupsEnabled) && Objects.equal((Object)((Object)this.allocationState), (Object)((Object)that.allocationState)) && Objects.equal((Object)this.dhcpProvider, (Object)that.dhcpProvider) && Objects.equal((Object)this.zoneToken, (Object)that.zoneToken) && Objects.equal(this.tags, that.tags);
    }

    protected MoreObjects.ToStringHelper string() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("description", (Object)this.description).add("displayText", (Object)this.displayText).add("DNS1", (Object)this.dns1).add("DNS2", (Object)this.dns2).add("domain", (Object)this.domain).add("domainId", (Object)this.domainId).add("guestCIDRAddress", (Object)this.guestCIDRAddress).add("internalDNS1", (Object)this.internalDNS1).add("internalDNS2", (Object)this.internalDNS2).add("name", (Object)this.name).add("networkType", (Object)this.networkType).add("VLAN", (Object)this.vlan).add("securityGroupsEnabled", this.securityGroupsEnabled).add("allocationState", (Object)this.allocationState).add("dhcpProvider", (Object)this.dhcpProvider).add("zoneToken", (Object)this.zoneToken).add("tags", this.tags);
    }

    public String toString() {
        return this.string().toString();
    }

    @Override
    public int compareTo(Zone o) {
        return this.id.compareTo(o.getId());
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String id;
        protected String description;
        protected String displayText;
        protected String dns1;
        protected String dns2;
        protected String domain;
        protected String domainId;
        protected String guestCIDRAddress;
        protected String internalDNS1;
        protected String internalDNS2;
        protected String name;
        protected NetworkType networkType;
        protected String vlan;
        protected boolean securityGroupsEnabled;
        protected AllocationState allocationState;
        protected String dhcpProvider;
        protected String zoneToken;
        protected Set<Tag> tags = ImmutableSet.of();

        protected abstract T self();

        public T id(String id) {
            this.id = id;
            return this.self();
        }

        public T description(String description) {
            this.description = description;
            return this.self();
        }

        public T displayText(String displayText) {
            this.displayText = displayText;
            return this.self();
        }

        public T DNS(List<String> DNS) {
            if (!DNS.isEmpty()) {
                this.dns1 = DNS.get(0);
            }
            if (DNS.size() > 1) {
                this.dns2 = DNS.get(1);
            }
            return this.self();
        }

        public T domain(String domain) {
            this.domain = domain;
            return this.self();
        }

        public T domainId(String domainId) {
            this.domainId = domainId;
            return this.self();
        }

        public T guestCIDRAddress(String guestCIDRAddress) {
            this.guestCIDRAddress = guestCIDRAddress;
            return this.self();
        }

        public T internalDNS(List<String> DNS) {
            if (!DNS.isEmpty()) {
                this.internalDNS1 = DNS.get(0);
            }
            if (DNS.size() > 1) {
                this.internalDNS2 = DNS.get(1);
            }
            return this.self();
        }

        public T name(String name) {
            this.name = name;
            return this.self();
        }

        public T networkType(NetworkType networkType) {
            this.networkType = networkType;
            return this.self();
        }

        public T VLAN(String vlan) {
            this.vlan = vlan;
            return this.self();
        }

        public T securityGroupsEnabled(boolean securityGroupsEnabled) {
            this.securityGroupsEnabled = securityGroupsEnabled;
            return this.self();
        }

        public T allocationState(AllocationState allocationState) {
            this.allocationState = allocationState;
            return this.self();
        }

        public T dhcpProvider(String dhcpProvider) {
            this.dhcpProvider = dhcpProvider;
            return this.self();
        }

        public T zoneToken(String zoneToken) {
            this.zoneToken = zoneToken;
            return this.self();
        }

        public T tags(Set<Tag> tags) {
            this.tags = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(tags, (Object)"tags")));
            return this.self();
        }

        public T tags(Tag ... in) {
            return this.tags((Set<Tag>)ImmutableSet.copyOf((Object[])in));
        }

        public Zone build() {
            return new Zone(this.id, this.description, this.displayText, this.dns1, this.dns2, this.domain, this.domainId, this.guestCIDRAddress, this.internalDNS1, this.internalDNS2, this.name, this.networkType, this.vlan, this.securityGroupsEnabled, this.allocationState, this.dhcpProvider, this.zoneToken, this.tags);
        }

        public T fromZone(Zone in) {
            return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)this.id(in.getId())).description(in.getDescription())).displayText(in.getDisplayText())).DNS(in.getDNS())).domain(in.getDomain())).domainId(in.getDomainId())).guestCIDRAddress(in.getGuestCIDRAddress())).internalDNS(in.getInternalDNS())).name(in.getName())).networkType(in.getNetworkType())).VLAN(in.getVLAN())).securityGroupsEnabled(in.isSecurityGroupsEnabled())).allocationState(in.getAllocationState())).dhcpProvider(in.getDhcpProvider())).zoneToken(in.getZoneToken())).tags(in.getTags());
        }
    }
}

