/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.cm.salt;

import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.Map;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.core.sensor.Sensors;
import org.apache.brooklyn.entity.cm.salt.SaltEntityImpl;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.yaml.Yamls;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaltHighstate {
    private static final Logger LOG = LoggerFactory.getLogger(SaltHighstate.class);
    public static final String HIGHSTATE_SENSOR_PREFIX = "salt.state";
    public static TypeToken<Map<String, Object>> STATE_FUNCTION_TYPE = new TypeToken<Map<String, Object>>(){};

    private SaltHighstate() {
    }

    public static void applyHighstate(String contents, Entity entity) {
        String adaptedYaml = SaltHighstate.adaptForSaltYamlTypes(contents);
        LOG.debug("Parsing Salt highstate yaml:\n{}", (Object)adaptedYaml);
        Iterable objects = Yamls.parseAll((String)adaptedYaml);
        for (Object entry : objects) {
            Map scopeMap = (Map)Yamls.getAs(entry, Map.class);
            SaltHighstate.applyStatesInScope(entity, scopeMap);
        }
    }

    private static void applyStatesInScope(Entity entity, Map<String, Object> scopeMap) {
        for (String scope : scopeMap.keySet()) {
            Map stateMap = (Map)Yamls.getAs((Object)scopeMap.get(scope), Map.class);
            for (String id : stateMap.keySet()) {
                SaltHighstate.applyStateSensor(id, stateMap.get(id), entity);
            }
        }
    }

    private static String adaptForSaltYamlTypes(String description) {
        return description.replaceAll("!!python/unicode\\s+", "");
    }

    private static void applyStateSensor(String id, Object stateData, Entity entity) {
        if (SaltHighstate.isSaltInternal(id)) {
            return;
        }
        SaltHighstate.addStateSensor(id, entity);
        try {
            Map stateInfo = (Map)stateData;
            for (String stateModule : stateInfo.keySet()) {
                SaltHighstate.addStateModuleValue(id, entity, stateInfo, stateModule);
            }
        }
        catch (ClassCastException e) {
            LOG.info("Unexpected structure for {} state, skipping ({})", (Object)id, (Object)e.getMessage());
        }
    }

    private static void addStateModuleValue(String id, Entity entity, Map<String, List<Object>> stateInfo, String stateModule) {
        if (SaltHighstate.isSaltInternal(stateModule)) {
            return;
        }
        try {
            List<Object> stateEntries = stateInfo.get(stateModule);
            String stateFunction = "";
            MutableMap moduleSettings = MutableMap.of();
            for (Object entry : stateEntries) {
                if (entry instanceof Map) {
                    moduleSettings.putAll((Map)entry);
                    continue;
                }
                stateFunction = entry.toString();
            }
            String name = SaltHighstate.sensorName(id, stateModule, stateFunction);
            AttributeSensor newSensor = Sensors.newSensor(STATE_FUNCTION_TYPE, (String)("salt.state." + name), (String)name);
            entity.sensors().set(newSensor, (Object)moduleSettings);
            LOG.debug("Sensor set for: {}", (Object)moduleSettings);
        }
        catch (ClassCastException e) {
            LOG.info("Unexpected structure for state module {}, skipping ({})", (Object)(id + "." + stateModule), (Object)e.getMessage());
        }
    }

    private static String sensorName(String ... parts) {
        return Strings.join((Object[])parts, (String)".");
    }

    private static void addStateSensor(String state, Entity entity) {
        List states = (List)entity.sensors().get(SaltEntityImpl.STATES);
        if (null == states || !states.contains(state)) {
            if (null == states) {
                states = MutableList.of();
            }
            states.add(state);
            entity.sensors().set(SaltEntityImpl.STATES, (Object)states);
        }
    }

    private static boolean isSaltInternal(String module) {
        return module.startsWith("__");
    }
}

