/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core;

import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.slf4j.Logger;

public class BrooklynLogging {
    public static final String SSH_IO = "org.apache.brooklyn.SSH";
    public static final String WINRM_IO = "org.apache.brooklyn.WinRm";
    public static final String REST = "org.apache.brooklyn.REST";

    public static final void log(Logger logger, LoggingLevel level, String message, Object ... args) {
        switch (level) {
            case ERROR: {
                logger.error(message, args);
                break;
            }
            case WARN: {
                logger.warn(message, args);
                break;
            }
            case INFO: {
                logger.info(message, args);
                break;
            }
            case DEBUG: {
                logger.debug(message, args);
                break;
            }
            case TRACE: {
                logger.trace(message, args);
            }
        }
    }

    public static final void log(Logger logger, LoggingLevel level, String message, Throwable t) {
        switch (level) {
            case ERROR: {
                logger.error(message, t);
                break;
            }
            case WARN: {
                logger.warn(message, t);
                break;
            }
            case INFO: {
                logger.info(message, t);
                break;
            }
            case DEBUG: {
                logger.debug(message, t);
                break;
            }
            case TRACE: {
                logger.trace(message, t);
            }
        }
    }

    public static LoggingLevel levelDependingIfReadOnly(Entity entity, LoggingLevel levelIfWriting, LoggingLevel levelIfReadOnly, LoggingLevel levelIfUnknown) {
        if (entity == null) {
            return levelIfUnknown;
        }
        Boolean ro = ((EntityInternal)entity).getManagementSupport().isReadOnlyRaw();
        if (ro == null) {
            return levelIfUnknown;
        }
        if (ro.booleanValue()) {
            return levelIfReadOnly;
        }
        return levelIfWriting;
    }

    public static LoggingLevel levelDebugOrTraceIfReadOnly(Entity entity) {
        return BrooklynLogging.levelDependingIfReadOnly(entity, LoggingLevel.DEBUG, LoggingLevel.TRACE, LoggingLevel.DEBUG);
    }

    public static enum LoggingLevel {
        ERROR,
        WARN,
        INFO,
        DEBUG,
        TRACE;

    }
}

