/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.config.external;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.core.config.external.AbstractExternalConfigSupplier;
import org.apache.brooklyn.util.core.ResourceUtils;
import org.apache.brooklyn.util.stream.Streams;

public class PropertiesFileExternalConfigSupplier
extends AbstractExternalConfigSupplier {
    public static final String PROPERTIES_URL = "propertiesUrl";
    private final Properties properties;

    public PropertiesFileExternalConfigSupplier(ManagementContext managementContext, String name, Map<String, String> config) throws IOException {
        super(managementContext, name);
        this.properties = this.loadProperties(config.get(PROPERTIES_URL));
    }

    @Override
    public String get(String key) {
        return this.properties.getProperty(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadProperties(String propertiesUrl) throws IOException {
        Properties properties;
        InputStream is = null;
        try {
            is = ResourceUtils.create(this.getManagementContext()).getResourceFromUrl(propertiesUrl);
            Properties p = new Properties();
            p.load(is);
            properties = p;
        }
        catch (Throwable throwable) {
            Streams.closeQuietly(is);
            throw throwable;
        }
        Streams.closeQuietly((Closeable)is);
        return properties;
    }
}

