/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.typereg;

import java.io.InputStream;
import java.util.function.Supplier;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.core.mgmt.ha.BrooklynBomOsgiArchiveInstaller;
import org.apache.brooklyn.core.mgmt.ha.OsgiBundleInstallationResult;
import org.apache.brooklyn.core.mgmt.ha.OsgiManager;
import org.apache.brooklyn.core.mgmt.internal.ManagementContextInternal;
import org.apache.brooklyn.core.typereg.AbstractCatalogBundleResolver;
import org.apache.brooklyn.core.typereg.BrooklynCatalogBundleResolver;
import org.apache.brooklyn.util.exceptions.ReferenceWithError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrooklynBomBundleCatalogBundleResolver
extends AbstractCatalogBundleResolver {
    private static Logger LOG = LoggerFactory.getLogger(BrooklynBomBundleCatalogBundleResolver.class);
    public static final String FORMAT = "brooklyn-bom-bundle";

    public BrooklynBomBundleCatalogBundleResolver() {
        super(FORMAT, "Brooklyn catalog.bom ZIP", "ZIP with a catalog.bom and/or an OSGi manifest (if just an OSGi manifest, types will not be added but the bundle will be installed)");
    }

    @Override
    public BrooklynBomBundleCatalogBundleResolver withManagementContext(ManagementContext mgmt) {
        return (BrooklynBomBundleCatalogBundleResolver)super.withManagementContext(mgmt);
    }

    @Override
    protected double scoreForNullFormat(Supplier<InputStream> f) {
        try (AbstractCatalogBundleResolver.FileTypeDetector detector = new AbstractCatalogBundleResolver.FileTypeDetector(f);){
            if (detector.isZip()) {
                if (detector.zipFileMatchesGlob("catalog.bom").size() > 0) {
                    double d = 1.0;
                    return d;
                }
                double d = 0.4;
                return d;
            }
            double d = 0.01;
            return d;
        }
    }

    @Override
    public ReferenceWithError<OsgiBundleInstallationResult> install(Supplier<InputStream> input, BrooklynCatalogBundleResolver.BundleInstallationOptions options) {
        LOG.debug("Installing bundle from stream - known details: " + (options == null ? null : options.getKnownBundleMetadata()));
        BrooklynBomOsgiArchiveInstaller installer = new BrooklynBomOsgiArchiveInstaller((OsgiManager)((ManagementContextInternal)this.mgmt).getOsgiManager().get(), options == null ? null : options.getKnownBundleMetadata(), input.get());
        installer.setCatalogBomText(FORMAT, null);
        if (options != null) {
            installer.setStart(options.isStart());
            installer.setLoadCatalogBom(options.isLoadCatalogBom());
            installer.setForce(options.isForceUpdateOfNonSnapshots());
            installer.setDeferredStart(options.isDeferredStart());
            installer.setValidateTypes(options.isValidateTypes());
        }
        return installer.install();
    }
}

