/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.core.task.ssh;

import org.apache.brooklyn.api.mgmt.TaskFactory;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.core.task.ssh.SshFetchTaskWrapper;
import org.apache.brooklyn.util.core.task.ssh.internal.RemoteExecTaskConfigHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshFetchTaskFactory
implements TaskFactory<SshFetchTaskWrapper> {
    private static final Logger log = LoggerFactory.getLogger(SshFetchTaskFactory.class);
    private boolean dirty = false;
    protected SshMachineLocation machine;
    protected RemoteExecTaskConfigHelper.RemoteExecCapability remoteExecCapability;
    protected String remoteFile;
    protected final ConfigBag config = ConfigBag.newInstance();

    public SshFetchTaskFactory(String remoteFile) {
        this.remoteFile(remoteFile);
    }

    public SshFetchTaskFactory(SshMachineLocation machine, String remoteFile) {
        this.machine(machine);
        this.remoteFile(remoteFile);
    }

    protected SshFetchTaskFactory self() {
        return this;
    }

    protected void markDirty() {
        this.dirty = true;
    }

    public SshFetchTaskFactory machine(SshMachineLocation machine) {
        this.markDirty();
        this.machine = machine;
        return this.self();
    }

    public SshMachineLocation getMachine() {
        return this.machine;
    }

    public RemoteExecTaskConfigHelper.RemoteExecCapability getRemoteExecCapability() {
        if (this.remoteExecCapability != null) {
            return this.remoteExecCapability;
        }
        if (this.machine != null) {
            this.remoteExecCapability = new RemoteExecTaskConfigHelper.RemoteExecCapabilityFromLocation(this.machine);
            return this.remoteExecCapability;
        }
        return null;
    }

    public SshFetchTaskFactory remoteFile(String remoteFile) {
        this.remoteFile = remoteFile;
        return this.self();
    }

    public ConfigBag getConfig() {
        return this.config;
    }

    public SshFetchTaskWrapper newTask() {
        this.dirty = false;
        return new SshFetchTaskWrapper(this);
    }

    protected void finalize() throws Throwable {
        if (this.dirty) {
            log.warn("Task " + this + " was modified but modification was never used");
        }
        super.finalize();
    }
}

