/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.brooklyn.rest.domain.BrooklynFeatureSummary;

public class VersionSummary
implements Serializable {
    private static final long serialVersionUID = 7275038546963638540L;
    private final String version;
    private final String buildSha1;
    private final String buildBranch;
    private final List<BrooklynFeatureSummary> features;

    public VersionSummary(String version) {
        this(version, null, null);
    }

    public VersionSummary(String version, String buildSha1, String buildBranch) {
        this(version, buildSha1, buildBranch, Collections.emptyList());
    }

    public VersionSummary(@JsonProperty(value="version") String version, @JsonProperty(value="buildSha1") String buildSha1, @JsonProperty(value="buildBranch") String buildBranch, @JsonProperty(value="features") List<BrooklynFeatureSummary> features) {
        this.version = (String)Preconditions.checkNotNull((Object)version, (Object)"version");
        this.buildSha1 = buildSha1;
        this.buildBranch = buildBranch;
        this.features = (List)Preconditions.checkNotNull(features, (Object)"features");
    }

    @Nonnull
    public String getVersion() {
        return this.version;
    }

    @Nullable
    public String getBuildSha1() {
        return this.buildSha1;
    }

    @Nullable
    public String getBuildBranch() {
        return this.buildBranch;
    }

    @Nonnull
    public List<BrooklynFeatureSummary> getFeatures() {
        return this.features;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VersionSummary)) {
            return false;
        }
        VersionSummary that = (VersionSummary)o;
        return Objects.equals(this.version, that.version) && Objects.equals(this.buildSha1, that.buildSha1) && Objects.equals(this.buildBranch, that.buildBranch) && Objects.equals(this.features, that.features);
    }

    public int hashCode() {
        return Objects.hash(this.version, this.buildSha1, this.buildBranch, this.features);
    }

    public String toString() {
        return "VersionSummary{version='" + this.version + '\'' + ", buildSha1='" + this.buildSha1 + '\'' + ", buildBranch='" + this.buildBranch + '\'' + ", features=" + this.features + '}';
    }
}

