/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.di.spi;

import java.util.List;
import org.apache.cayenne.di.Provider;
import org.apache.cayenne.di.Scope;
import org.apache.cayenne.di.spi.Decoration;
import org.apache.cayenne.di.spi.DecoratorProvider;
import org.apache.cayenne.di.spi.NoScope;

class Binding<T> {
    private Provider<T> original;
    private Provider<T> decorated;
    private Provider<T> scoped;
    private Scope scope;

    Binding(Provider<T> provider, Scope initialScope) {
        this.original = provider;
        this.decorated = provider;
        this.changeScope(initialScope);
    }

    void changeScope(Scope scope) {
        if (scope == null) {
            scope = NoScope.INSTANCE;
        }
        this.scoped = scope.scope(this.original);
        this.scope = scope;
    }

    void decorate(Decoration<T> decoration) {
        List<DecoratorProvider<T>> decorators = decoration.decorators();
        if (decorators.isEmpty()) {
            return;
        }
        Provider<T> provider = this.original;
        for (DecoratorProvider<T> decoratorProvider : decorators) {
            provider = decoratorProvider.get(provider);
        }
        this.decorated = provider;
        this.scoped = this.scope.scope(this.decorated);
    }

    Provider<T> getOriginal() {
        return this.original;
    }

    Provider<T> getScoped() {
        return this.scoped;
    }
}

