/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.model.beans;

import java.util.Locale;
import org.apache.commons.jxpath.JXPathBeanInfo;
import org.apache.commons.jxpath.JXPathIntrospector;
import org.apache.commons.jxpath.ri.QName;
import org.apache.commons.jxpath.ri.model.NodePointer;
import org.apache.commons.jxpath.ri.model.beans.BeanPropertyPointer;
import org.apache.commons.jxpath.ri.model.beans.PropertyOwnerPointer;
import org.apache.commons.jxpath.ri.model.beans.PropertyPointer;

public class BeanPointer
extends PropertyOwnerPointer {
    private static final long serialVersionUID = -8227317938284982440L;
    private final QName qName;
    private final Object bean;
    private final JXPathBeanInfo beanInfo;

    public BeanPointer(NodePointer parent, QName qName, Object bean, JXPathBeanInfo beanInfo) {
        super(parent);
        this.qName = qName;
        this.bean = bean;
        this.beanInfo = beanInfo;
    }

    public BeanPointer(QName qName, Object bean, JXPathBeanInfo beanInfo, Locale locale) {
        super(null, locale);
        this.qName = qName;
        this.bean = bean;
        this.beanInfo = beanInfo;
    }

    @Override
    public String asPath() {
        if (this.parent != null) {
            return super.asPath();
        }
        if (this.bean == null) {
            return "null()";
        }
        if (this.bean instanceof Number) {
            String string = this.bean.toString();
            if (string.endsWith(".0")) {
                string = string.substring(0, string.length() - 2);
            }
            return string;
        }
        if (this.bean instanceof Boolean) {
            return (Boolean)this.bean != false ? "true()" : "false()";
        }
        if (this.bean instanceof String) {
            return "'" + this.bean + "'";
        }
        return "/";
    }

    public boolean equals(Object object) {
        int iOther;
        if (object == this) {
            return true;
        }
        if (!(object instanceof BeanPointer)) {
            return false;
        }
        BeanPointer other = (BeanPointer)object;
        if (!(this.parent == other.parent || this.parent != null && this.parent.equals(other.parent))) {
            return false;
        }
        if (this.qName == null && other.qName != null || this.qName != null && !this.qName.equals(other.qName)) {
            return false;
        }
        int iThis = this.index == Integer.MIN_VALUE ? 0 : this.index;
        int n = iOther = other.index == Integer.MIN_VALUE ? 0 : other.index;
        if (iThis != iOther) {
            return false;
        }
        if (this.bean instanceof Number || this.bean instanceof String || this.bean instanceof Boolean) {
            return this.bean.equals(other.bean);
        }
        return this.bean == other.bean;
    }

    @Override
    public Object getBaseValue() {
        return this.bean;
    }

    @Override
    public int getLength() {
        return 1;
    }

    @Override
    public QName getName() {
        return this.qName;
    }

    @Override
    public PropertyPointer getPropertyPointer() {
        return new BeanPropertyPointer((NodePointer)this, this.beanInfo);
    }

    public int hashCode() {
        return this.qName == null ? 0 : this.qName.hashCode();
    }

    @Override
    public boolean isCollection() {
        return false;
    }

    @Override
    public boolean isLeaf() {
        Object value = this.getNode();
        return value == null || JXPathIntrospector.getBeanInfo(value.getClass()).isAtomic();
    }
}

