/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.websocket.jetty12;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.apache.cxf.transport.http_jetty.JettyHTTPDestination;
import org.apache.cxf.transport.http_jetty.JettyHTTPHandler;
import org.apache.cxf.transport.websocket.jetty12.Jetty12WebSocketDestination;
import org.eclipse.jetty.ee11.servlet.ServletContextHandler;
import org.eclipse.jetty.ee11.websocket.server.JettyWebSocketServerContainer;
import org.eclipse.jetty.ee11.websocket.server.config.JettyWebSocketServletContainerInitializer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.websocket.core.WebSocketComponents;
import org.eclipse.jetty.websocket.core.server.WebSocketServerComponents;

class JettyWebSocketHandler
extends JettyHTTPHandler {
    final Jetty12WebSocketDestination webSocketDestination;
    JettyWebSocketServerContainer webSocketContainer;

    JettyWebSocketHandler(JettyHTTPDestination jhd, boolean cmExact, Jetty12WebSocketDestination wsd) {
        super(jhd, cmExact);
        this.webSocketDestination = wsd;
    }

    public void initHandler(Server server) {
        ServletContextHandler servletContextHandler = this.createContextHandler();
        servletContextHandler.setServer(server);
        this.setServletContext(servletContextHandler.getServletContext());
        this.webSocketContainer = this.webSocketDestination.getWebSocketContainer(this.getServletContext());
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.webSocketContainer.upgrade(this.webSocketDestination.getCreator(), request, response)) {
            return;
        }
        super.service(request, response);
    }

    public ServletContextHandler createContextHandler() {
        ServletContextHandler handler = new ServletContextHandler();
        JettyWebSocketServletContainerInitializer.configure((ServletContextHandler)handler, null);
        handler.setAttribute(WebSocketServerComponents.WEBSOCKET_COMPONENTS_ATTRIBUTE, (Object)new WebSocketComponents());
        return handler;
    }
}

