/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aot.nativex;

import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.aot.hint.ConditionalHint;
import org.springframework.aot.hint.JavaSerializationHint;
import org.springframework.aot.hint.SerializationHints;
import org.springframework.aot.hint.TypeReference;

class SerializationHintsAttributes {
    private static final Comparator<JavaSerializationHint> JAVA_SERIALIZATION_HINT_COMPARATOR = Comparator.comparing(JavaSerializationHint::getType);

    SerializationHintsAttributes() {
    }

    public List<Map<String, Object>> toAttributes(SerializationHints hints) {
        return hints.javaSerializationHints().sorted(JAVA_SERIALIZATION_HINT_COMPARATOR).map(this::toAttributes).toList();
    }

    private Map<String, Object> toAttributes(JavaSerializationHint serializationHint) {
        LinkedHashMap<String, Object> attributes = new LinkedHashMap<String, Object>();
        this.handleCondition(attributes, serializationHint);
        attributes.put("type", serializationHint.getType());
        return attributes;
    }

    private void handleCondition(Map<String, Object> attributes, ConditionalHint hint) {
        if (hint.getReachableType() != null) {
            LinkedHashMap<String, TypeReference> conditionAttributes = new LinkedHashMap<String, TypeReference>();
            conditionAttributes.put("typeReached", hint.getReachableType());
            attributes.put("condition", conditionAttributes);
        }
    }
}

