/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import org.apache.datasketches.common.MemorySegmentStatus;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.Util;
import org.apache.datasketches.theta.CompactThetaSketch;
import org.apache.datasketches.theta.ThetaSetOperation;
import org.apache.datasketches.theta.ThetaSetOperationBuilder;
import org.apache.datasketches.theta.ThetaSketch;
import org.apache.datasketches.theta.ThetaUnion;
import org.apache.datasketches.theta.ThetaUnionImpl;
import org.apache.datasketches.theta.UpdatableThetaSketch;
import org.apache.datasketches.theta.UpdatableThetaSketchBuilder;
import org.testng.Assert;
import org.testng.annotations.Test;

public class UnionImplTest {
    @Test
    public void checkGetCurrentAndMaxBytes() {
        int lgK = 10;
        ThetaUnion union = ThetaSetOperation.builder().setLogNominalEntries(10).buildUnion();
        Assert.assertEquals((int)union.getCurrentBytes(), (int)288);
        Assert.assertEquals((int)union.getMaxUnionBytes(), (int)16416);
    }

    @Test
    public void checkUpdateWithSketch() {
        int k = 16;
        MemorySegment seg = MemorySegment.ofArray(new byte[152]);
        MemorySegment seg2 = MemorySegment.ofArray(new byte[152]);
        UpdatableThetaSketch sketch = UpdatableThetaSketch.builder().setNominalEntries(16).build();
        for (int i = 0; i < 16; ++i) {
            sketch.update((long)i);
        }
        CompactThetaSketch sketchInDirectOrd = sketch.compact(true, seg);
        CompactThetaSketch sketchInDirectUnord = sketch.compact(false, seg2);
        CompactThetaSketch sketchInHeap = sketch.compact(true, null);
        ThetaUnion union = ThetaSetOperation.builder().setNominalEntries(16).buildUnion();
        union.union((ThetaSketch)sketchInDirectOrd);
        union.union((ThetaSketch)sketchInHeap);
        union.union((ThetaSketch)sketchInDirectUnord);
        Assert.assertEquals((double)union.getResult().getEstimate(), (double)16.0, (double)0.0);
    }

    @Test
    public void checkUnorderedAndOrderedMemorySegment() {
        int k = 16;
        MemorySegment seg = MemorySegment.ofArray(new byte[152]);
        UpdatableThetaSketch sketch = UpdatableThetaSketch.builder().setNominalEntries(16).build();
        for (int i = 0; i < 16; ++i) {
            sketch.update((long)i);
        }
        CompactThetaSketch sketchInDirectOrd = sketch.compact(false, seg);
        Assert.assertFalse((boolean)sketchInDirectOrd.isOrdered());
        ThetaUnion union = ThetaSetOperation.builder().setNominalEntries(16).buildUnion();
        union.union((ThetaSketch)sketchInDirectOrd);
        double est1 = union.getResult().getEstimate();
        sketch.compact(true, seg);
        Assert.assertTrue((boolean)sketchInDirectOrd.isOrdered());
        union.union((ThetaSketch)sketchInDirectOrd);
        double est2 = union.getResult().getEstimate();
        Assert.assertEquals((double)est1, (double)est2);
        Assert.assertEquals((int)((int)est1), (int)16);
    }

    @Test
    public void checkUpdateWithSeg() {
        int k = 16;
        MemorySegment skSeg = MemorySegment.ofArray(new byte[280]);
        MemorySegment dirOrdCskSeg = MemorySegment.ofArray(new byte[152]);
        MemorySegment dirUnordCskSeg = MemorySegment.ofArray(new byte[152]);
        UpdatableThetaSketch udSketch = UpdatableThetaSketch.builder().setNominalEntries(16).build(skSeg);
        for (int i = 0; i < 16; ++i) {
            udSketch.update((long)i);
        }
        udSketch.compact(true, dirOrdCskSeg);
        udSketch.compact(false, dirUnordCskSeg);
        ThetaUnion union = ThetaSetOperation.builder().setNominalEntries(16).buildUnion();
        union.union(skSeg);
        union.union(dirOrdCskSeg);
        union.union(dirUnordCskSeg);
        Assert.assertEquals((double)union.getResult().getEstimate(), (double)16.0, (double)0.0);
    }

    @Test
    public void checkUpdateWithSegV4Exact() {
        int n = 1000;
        UpdatableThetaSketch sk = UpdatableThetaSketch.builder().build();
        for (int i = 0; i < 1000; ++i) {
            sk.update((long)i);
        }
        CompactThetaSketch cs = sk.compact();
        Assert.assertFalse((boolean)cs.isEstimationMode());
        byte[] bytes = cs.toByteArrayCompressed();
        ThetaUnion union = ThetaSetOperation.builder().buildUnion();
        union.union(MemorySegment.ofArray(bytes));
        Assert.assertEquals((double)union.getResult().getEstimate(), (double)1000.0, (double)0.0);
    }

    @Test
    public void checkFastWrap() {
        int k = 16;
        long seed = 9001L;
        int unionSize = ThetaSetOperation.getMaxUnionBytes((int)16);
        MemorySegment srcSeg = MemorySegment.ofArray(new byte[unionSize]);
        ThetaUnion union = ThetaSetOperation.builder().setNominalEntries(16).buildUnion(srcSeg);
        for (int i = 0; i < 16; ++i) {
            union.update((long)i);
        }
        Assert.assertEquals((double)union.getResult().getEstimate(), (double)16.0, (double)0.0);
        ThetaUnionImpl union2 = ThetaUnionImpl.fastWrapInstance((MemorySegment)srcSeg, (long)9001L);
        Assert.assertEquals((double)union2.getResult().getEstimate(), (double)16.0, (double)0.0);
        MemorySegment srcSegR = srcSeg;
        ThetaUnionImpl union3 = ThetaUnionImpl.fastWrapInstance((MemorySegment)srcSegR, (long)9001L);
        Assert.assertEquals((double)union3.getResult().getEstimate(), (double)16.0, (double)0.0);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkCorruptFamilyException() {
        int k = 16;
        MemorySegment seg = MemorySegment.ofArray(new byte[152]);
        UpdatableThetaSketch sketch = UpdatableThetaSketch.builder().setNominalEntries(16).build();
        for (int i = 0; i < 16; ++i) {
            sketch.update((long)i);
        }
        sketch.compact(true, seg);
        seg.set(ValueLayout.JAVA_BYTE, 2L, (byte)0);
        ThetaUnion union = ThetaSetOperation.builder().setNominalEntries(16).buildUnion();
        union.union(seg);
    }

    @Test
    public void checkMoveAndResizeOffHeap() {
        MemorySegment uWseg;
        MemorySegment skWseg;
        int k = 4096;
        int u = 8192;
        int bytes = ThetaSketch.getMaxUpdateSketchBytes((int)4096);
        try (Arena arena = Arena.ofConfined();){
            skWseg = arena.allocate(bytes / 2);
            UpdatableThetaSketch sketch = UpdatableThetaSketch.builder().setNominalEntries(4096).build(skWseg);
            Assert.assertTrue((boolean)sketch.isSameResource(skWseg));
            uWseg = arena.allocate(bytes / 2);
            ThetaUnion union = ThetaSetOperation.builder().buildUnion(uWseg);
            Assert.assertTrue((boolean)union.isSameResource(uWseg));
            for (int i = 0; i < 8192; ++i) {
                union.update((long)i);
            }
            Assert.assertFalse((boolean)union.isSameResource(skWseg));
            Assert.assertFalse((boolean)union.isSameResource(uWseg));
            MemorySegment uWsegHeap = MemorySegment.ofArray(new byte[bytes / 2]);
            ThetaUnion union2 = ThetaSetOperation.builder().buildUnion(uWsegHeap);
            Assert.assertTrue((boolean)union2.isSameResource(uWsegHeap));
            Assert.assertFalse((boolean)MemorySegmentStatus.isSameResource((MemorySegment)uWseg, (MemorySegment)uWsegHeap));
            Assert.assertFalse((boolean)MemorySegmentStatus.isSameResource((MemorySegment)uWsegHeap, (MemorySegment)union.getMemorySegment()));
        }
        Assert.assertFalse((boolean)skWseg.scope().isAlive());
        Assert.assertFalse((boolean)uWseg.scope().isAlive());
    }

    @Test
    public void checkRestricted() {
        ThetaUnion union = ThetaSetOperation.builder().buildUnion();
        Assert.assertTrue((boolean)union.isEmpty());
        Assert.assertEquals((long)union.getThetaLong(), (long)Long.MAX_VALUE);
        Assert.assertEquals((short)union.getSeedHash(), (short)Util.computeSeedHash((long)9001L));
        Assert.assertEquals((int)union.getRetainedEntries(), (int)0);
        Assert.assertEquals((int)union.getCache().length, (int)128);
    }

    @Test
    public void checkUnionCompactOrderedSource() {
        int lgK = 12;
        int k = 4096;
        UpdatableThetaSketch sk = UpdatableThetaSketch.builder().build();
        for (int i = 0; i < 4096; ++i) {
            sk.update((long)i);
        }
        double est1 = sk.getEstimate();
        int bytes = ThetaSketch.getCompactSketchMaxBytes((int)12);
        try (Arena arena = Arena.ofConfined();){
            MemorySegment wseg = arena.allocate(bytes);
            CompactThetaSketch csk = sk.compact(true, wseg);
            ThetaUnion union = ThetaSetOperation.builder().buildUnion();
            union.union((ThetaSketch)csk);
            double est2 = union.getResult().getEstimate();
            Assert.assertEquals((double)est2, (double)est1);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkCompactFlagCorruption() {
        int k = 4096;
        int bytes = ThetaSketch.getMaxUpdateSketchBytes((int)4096);
        MemorySegment wseg1 = MemorySegment.ofArray(new byte[bytes]);
        UpdatableThetaSketch sk = UpdatableThetaSketch.builder().setNominalEntries(4096).build(wseg1);
        for (int i = 0; i < 4096; ++i) {
            sk.update((long)i);
        }
        sk.compact(true, wseg1);
        ThetaUnion union = ThetaSetOperation.builder().buildUnion();
        union.union((ThetaSketch)sk);
        CompactThetaSketch csk1 = union.getResult();
        UnionImplTest.println("" + csk1.getEstimate());
    }

    @Test
    public void checkDirectUnionSingleItem() {
        int i;
        int i2;
        int num = 2;
        UpdatableThetaSketch[] skArr = new UpdatableThetaSketch[2];
        for (i2 = 0; i2 < 2; ++i2) {
            skArr[i2] = new UpdatableThetaSketchBuilder().build();
        }
        for (i2 = 0; i2 < 1; ++i2) {
            skArr[i2].update((long)i2);
            skArr[i2 + 1].update((long)i2);
            skArr[i2].update((long)(i2 + 2));
        }
        ThetaUnion union = new ThetaSetOperationBuilder().buildUnion();
        for (int i3 = 0; i3 < 2; ++i3) {
            union.union((ThetaSketch)skArr[i3]);
        }
        CompactThetaSketch csk = union.getResult();
        Assert.assertEquals((double)csk.getEstimate(), (double)2.0);
        MemorySegment[] segArr = new MemorySegment[2];
        for (i = 0; i < 2; ++i) {
            segArr[i] = MemorySegment.ofArray(skArr[i].compact().toByteArray());
        }
        union = new ThetaSetOperationBuilder().buildUnion();
        for (i = 0; i < 2; ++i) {
            union.union(segArr[i]);
        }
        csk = union.getResult();
        Assert.assertEquals((double)csk.getEstimate(), (double)2.0);
    }

    @Test
    public void printlnTest() {
        UnionImplTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(Object o) {
    }
}

