/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.derbynet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import junit.framework.Test;
import org.apache.derby.client.am.ByteArrayCombinerStream;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;

public class ByteArrayCombinerStreamTest
extends BaseTestCase {
    private static final byte[] defaultArray = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88};
    private ByteArrayCombinerStream combiner;

    public ByteArrayCombinerStreamTest(String string) {
        super(string);
    }

    public void testCombineNullRead() throws IOException {
        this.combiner = new ByteArrayCombinerStream(null, 0L);
        ByteArrayCombinerStreamTest.assertEquals((int)-1, (int)this.combiner.read());
    }

    public void testCombineNullReadArray() throws IOException {
        this.combiner = new ByteArrayCombinerStream(null, 0L);
        ByteArrayCombinerStreamTest.assertEquals((int)-1, (int)this.combiner.read(new byte[10], 0, 10));
    }

    public void testCombineAvailableNull() throws IOException {
        this.combiner = new ByteArrayCombinerStream(null, 0L);
        ByteArrayCombinerStreamTest.assertEquals((int)0, (int)this.combiner.available());
    }

    public void testCombineAvailable4bytes() throws IOException {
        byte[] byArray = new byte[]{65, 66, 77, 79};
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>(1);
        arrayList.add(byArray);
        this.combiner = new ByteArrayCombinerStream(arrayList, 4L);
        ByteArrayCombinerStreamTest.assertEquals((int)4, (int)this.combiner.available());
    }

    public void testCombineWithExtraEmptyByteArray() throws IOException {
        byte[] byArray = new byte[]{65, 66, 77, 79};
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>(2);
        arrayList.add(byArray);
        arrayList.add(new byte[4]);
        this.combiner = new ByteArrayCombinerStream(arrayList, (long)byArray.length);
        byte[] byArray2 = new byte[byArray.length];
        ByteArrayCombinerStreamTest.assertEquals((int)byArray.length, (int)this.combiner.read(byArray2, 0, byArray2.length));
        ByteArrayCombinerStreamTest.assertTrue((this.combiner.read() == -1 ? 1 : 0) != 0);
    }

    public void testCombineOneArray() throws IOException {
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>(1);
        arrayList.add(defaultArray);
        this.combiner = new ByteArrayCombinerStream(arrayList, (long)defaultArray.length);
        byte[] byArray = new byte[defaultArray.length];
        ByteArrayCombinerStreamTest.assertEquals((int)defaultArray.length, (int)this.combiner.read(byArray, 0, byArray.length));
        ByteArrayCombinerStreamTest.assertTrue((this.combiner.read() == -1 ? 1 : 0) != 0);
        ByteArrayCombinerStreamTest.assertTrue((boolean)Arrays.equals(defaultArray, byArray));
    }

    public void testCominbe100SmallArrays() throws IOException {
        int n = 100;
        byte[] byArray = new byte[]{65, 66, 77, 79};
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>(n);
        long l = 0L;
        for (int i = 0; i < n; ++i) {
            arrayList.add(byArray);
            l += (long)byArray.length;
        }
        byte[] byArray2 = new byte[(int)l];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            System.arraycopy(byArray, 0, byArray2, n2, byArray.length);
            n2 += byArray.length;
        }
        this.combiner = new ByteArrayCombinerStream(arrayList, l);
        byte[] byArray3 = new byte[(int)l];
        ByteArrayCombinerStreamTest.assertEquals((long)l, (long)this.combiner.read(byArray3, 0, byArray3.length));
        ByteArrayCombinerStreamTest.assertTrue((this.combiner.read() == -1 ? 1 : 0) != 0);
        ByteArrayCombinerStreamTest.assertTrue((this.combiner.read() == -1 ? 1 : 0) != 0);
        ByteArrayCombinerStreamTest.assertTrue((boolean)Arrays.equals(byArray2, byArray3));
    }

    public void testTruncateDataFromOneArray() throws IOException {
        int n = defaultArray.length - 5;
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>(1);
        arrayList.add(defaultArray);
        byte[] byArray = new byte[n];
        System.arraycopy(defaultArray, 0, byArray, 0, n);
        byte[] byArray2 = new byte[n];
        this.combiner = new ByteArrayCombinerStream(arrayList, (long)n);
        ByteArrayCombinerStreamTest.assertEquals((int)n, (int)this.combiner.read(byArray2, 0, n));
        ByteArrayCombinerStreamTest.assertTrue((this.combiner.read() == -1 ? 1 : 0) != 0);
        ByteArrayCombinerStreamTest.assertTrue((boolean)Arrays.equals(byArray, byArray2));
    }

    public void testTruncateDataFromTwoArrays() throws IOException {
        int n = defaultArray.length * 2 - 7;
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>(2);
        arrayList.add(defaultArray);
        arrayList.add(defaultArray);
        byte[] byArray = new byte[n];
        System.arraycopy(defaultArray, 0, byArray, 0, defaultArray.length);
        System.arraycopy(defaultArray, 0, byArray, defaultArray.length, n - defaultArray.length);
        byte[] byArray2 = new byte[n];
        this.combiner = new ByteArrayCombinerStream(arrayList, (long)n);
        ByteArrayCombinerStreamTest.assertEquals((int)n, (int)this.combiner.read(byArray2, 0, n));
        ByteArrayCombinerStreamTest.assertTrue((this.combiner.read() == -1 ? 1 : 0) != 0);
        ByteArrayCombinerStreamTest.assertTrue((boolean)Arrays.equals(byArray, byArray2));
    }

    public void testTooLittleDataNoCombine() {
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>(1);
        arrayList.add(new byte[5]);
        try {
            this.combiner = new ByteArrayCombinerStream(arrayList, 10L);
            ByteArrayCombinerStreamTest.fail((String)"An IllegalArgumentException singalling too little data should have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testTooLittleDataWithCombine() {
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>(3);
        byte[] byArray = new byte[]{65, 66, 67, 68, 69};
        arrayList.add(byArray);
        arrayList.add(byArray);
        arrayList.add(byArray);
        try {
            this.combiner = new ByteArrayCombinerStream(arrayList, (long)(byArray.length * 3 + 1));
            ByteArrayCombinerStreamTest.fail((String)"An IllegalArgumentException singalling too little data should have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testNegativeLengthArgument() {
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>(1);
        arrayList.add(new byte[1234]);
        try {
            this.combiner = new ByteArrayCombinerStream(arrayList, -54L);
            ByteArrayCombinerStreamTest.fail((String)"An IllegalArgumentException singalling negative length should have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testNegativeValueInDataCausesEndOfStream() throws IOException {
        byte by;
        byte[] byArray = new byte[]{66, 67, -123, 68, 69};
        byte[] byArray2 = new byte[]{66, 67, 0, 0, 0};
        byte[] byArray3 = new byte[5];
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>(1);
        arrayList.add(byArray);
        this.combiner = new ByteArrayCombinerStream(arrayList, (long)byArray.length);
        int n = 0;
        while ((by = (byte)this.combiner.read()) > 0) {
            byArray3[n++] = by;
        }
        ByteArrayCombinerStreamTest.assertTrue((boolean)Arrays.equals(byArray2, byArray3));
        ByteArrayCombinerStreamTest.assertEquals((byte)byArray[3], (byte)((byte)this.combiner.read()));
        ByteArrayCombinerStreamTest.assertEquals((byte)byArray[4], (byte)((byte)this.combiner.read()));
        ByteArrayCombinerStreamTest.assertEquals((int)-1, (int)((byte)this.combiner.read()));
    }

    public static Test suite() {
        return new BaseTestSuite(ByteArrayCombinerStreamTest.class, "ByteArrayCombinerStreamTest");
    }
}

