/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import org.apache.derby.iapi.sql.conn.ConnectionUtil;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.store.access.DiskHashtable;
import org.apache.derby.iapi.store.access.KeyHasher;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.SQLInteger;
import org.apache.derby.iapi.types.SQLLongint;
import org.apache.derby.iapi.types.SQLVarchar;
import org.apache.derby.shared.common.error.PublicAPI;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.tools.ij;
import org.apache.derbyTesting.functionTests.util.TestUtil;

public class TestDiskHashtable {
    private TransactionController tc;
    private int failed = 0;
    private static final DataValueDescriptor[] singleKeyTemplate = new DataValueDescriptor[]{new SQLInteger(), new SQLVarchar()};
    private static final int[] singleKeyCols = new int[]{0};
    private static final DataValueDescriptor[][] singleKeyRows = new DataValueDescriptor[][]{{new SQLInteger(1), new SQLVarchar("abcd")}, {new SQLInteger(2), new SQLVarchar("abcd")}, {new SQLInteger(3), new SQLVarchar("e")}, {new SQLInteger(1), new SQLVarchar("zz")}};
    private static final DataValueDescriptor[] multiKeyTemplate = new DataValueDescriptor[]{new SQLLongint(), new SQLVarchar(), new SQLInteger()};
    private static final int[] multiKeyCols = new int[]{1, 0};
    private static final DataValueDescriptor[][] multiKeyRows = new DataValueDescriptor[][]{{new SQLLongint(1L), new SQLVarchar("aa"), multiKeyTemplate[2].getNewNull()}, {new SQLLongint(2L), new SQLVarchar("aa"), new SQLInteger(1)}, {new SQLLongint(2L), new SQLVarchar("aa"), new SQLInteger(2)}, {new SQLLongint(2L), new SQLVarchar("b"), new SQLInteger(1)}};
    private static final int LOTS_OF_ROWS_COUNT = 50000;

    public static void main(String[] stringArray) {
        int n = 1;
        TestDiskHashtable.REPORT("Test DiskHashtable starting");
        try {
            ij.getPropertyArg((String[])stringArray);
            Connection connection = ij.startJBMS();
            Statement statement = connection.createStatement();
            statement.execute("CREATE FUNCTION testDiskHashtable() returns INTEGER EXTERNAL NAME 'org.apache.derbyTesting.functionTests.tests.store.TestDiskHashtable.runTests' LANGUAGE JAVA PARAMETER STYLE JAVA");
            ResultSet resultSet = statement.executeQuery("values( testDiskHashtable())");
            if (resultSet.next()) {
                n = resultSet.getInt(1);
            }
            statement.close();
            connection.close();
        }
        catch (SQLException sQLException) {
            TestUtil.dumpSQLExceptions(sQLException);
            n = 1;
        }
        catch (Throwable throwable) {
            TestDiskHashtable.REPORT("FAIL -- unexpected exception:" + throwable.toString());
            n = 1;
        }
        TestDiskHashtable.REPORT(n == 0 ? "OK" : "FAILED");
        System.exit(n == 0 ? 0 : 1);
    }

    private void REPORT_FAILURE(String string) {
        this.failed = 1;
        TestDiskHashtable.REPORT(string);
    }

    private static void REPORT(String string) {
        System.out.println(string);
    }

    public static int runTests() throws SQLException {
        TestDiskHashtable testDiskHashtable = new TestDiskHashtable();
        return testDiskHashtable.doIt();
    }

    private TestDiskHashtable() throws SQLException {
        LanguageConnectionContext languageConnectionContext = ConnectionUtil.getCurrentLCC();
        if (languageConnectionContext == null) {
            throw new SQLException("Cannot get the LCC");
        }
        this.tc = languageConnectionContext.getTransactionExecute();
    }

    private int doIt() throws SQLException {
        try {
            TestDiskHashtable.REPORT("Starting single key, keep duplicates test");
            this.testOneVariant(this.tc, false, singleKeyTemplate, singleKeyCols, singleKeyRows);
            TestDiskHashtable.REPORT("Starting single key, remove duplicates test");
            this.testOneVariant(this.tc, true, singleKeyTemplate, singleKeyCols, singleKeyRows);
            TestDiskHashtable.REPORT("Starting multiple key, keep duplicates test");
            this.testOneVariant(this.tc, false, multiKeyTemplate, multiKeyCols, multiKeyRows);
            TestDiskHashtable.REPORT("Starting multiple key, remove duplicates test");
            this.testOneVariant(this.tc, true, multiKeyTemplate, multiKeyCols, multiKeyRows);
            this.tc.commit();
        }
        catch (StandardException standardException) {
            throw PublicAPI.wrapStandardException((StandardException)standardException);
        }
        return this.failed;
    }

    private void testOneVariant(TransactionController transactionController, boolean bl, DataValueDescriptor[] dataValueDescriptorArray, int[] nArray, DataValueDescriptor[][] dataValueDescriptorArray2) throws StandardException {
        Object object;
        int n;
        DiskHashtable diskHashtable = new DiskHashtable(transactionController, dataValueDescriptorArray, (int[])null, nArray, bl, false);
        boolean[] blArray = new boolean[dataValueDescriptorArray2.length];
        boolean[] blArray2 = new boolean[dataValueDescriptorArray2.length];
        HashMap<Object, Vector<DataValueDescriptor[]>> hashMap = new HashMap<Object, Vector<DataValueDescriptor[]>>(dataValueDescriptorArray2.length);
        this.testElements(bl, diskHashtable, 0, dataValueDescriptorArray2, blArray, blArray2);
        for (n = 0; n < dataValueDescriptorArray2.length; ++n) {
            object = KeyHasher.buildHashKey((Object[])dataValueDescriptorArray2[n], (int[])nArray);
            Vector<DataValueDescriptor[]> vector = (Vector<DataValueDescriptor[]>)hashMap.get(object);
            boolean bl2 = blArray[n] = vector != null;
            if (vector == null) {
                vector = new Vector<DataValueDescriptor[]>(4);
                hashMap.put(object, vector);
            }
            if (!bl || !blArray[n]) {
                vector.add(dataValueDescriptorArray2[n]);
            }
            if (diskHashtable.put(object, dataValueDescriptorArray2[n]) != (bl ? !blArray[n] : true)) {
                this.REPORT_FAILURE("  put returned wrong value on row " + n);
            }
            for (int i = 0; i <= n; ++i) {
                object = KeyHasher.buildHashKey((Object[])dataValueDescriptorArray2[i], (int[])nArray);
                if (this.rowsEqual(diskHashtable.get(object), hashMap.get(object))) continue;
                this.REPORT_FAILURE("  get returned wrong value on key " + i);
            }
            this.testElements(bl, diskHashtable, n + 1, dataValueDescriptorArray2, blArray, blArray2);
        }
        for (n = 0; n < dataValueDescriptorArray2.length; ++n) {
            object = KeyHasher.buildHashKey((Object[])dataValueDescriptorArray2[n], (int[])nArray);
            if (!this.rowsEqual(diskHashtable.remove(object), hashMap.get(object))) {
                this.REPORT_FAILURE("  remove returned wrong value on key " + n);
            }
            hashMap.remove(object);
            if (diskHashtable.get(object) == null) continue;
            this.REPORT_FAILURE("  remove did not delete key " + n);
        }
        this.testElements(bl, diskHashtable, 0, dataValueDescriptorArray2, blArray, blArray2);
        this.testLargeTable(diskHashtable, nArray, dataValueDescriptorArray2[0]);
        diskHashtable.close();
    }

    private void testLargeTable(DiskHashtable diskHashtable, int[] nArray, DataValueDescriptor[] dataValueDescriptorArray) throws StandardException {
        Object object;
        int n;
        int n2;
        int n3 = nArray.length > 1 ? (int)Math.round(Math.sqrt(50000.0)) : 1;
        int n4 = (50000 + n3 - 1) / n3;
        Object[] objectArray = new DataValueDescriptor[dataValueDescriptorArray.length];
        for (n2 = 0; n2 < objectArray.length; ++n2) {
            objectArray[n2] = dataValueDescriptorArray[n2].cloneValue(false);
        }
        block1: for (n2 = 0; n2 < n4; ++n2) {
            objectArray[nArray[0]].setValue(n2);
            for (n = 0; n < n3; ++n) {
                if (nArray.length > 1) {
                    objectArray[nArray[1]].setValue(n);
                }
                if (diskHashtable.put(object = KeyHasher.buildHashKey((Object[])objectArray, (int[])nArray), objectArray)) continue;
                this.REPORT_FAILURE("  put returned wrong value for key(" + n2 + "," + n + ")");
                n2 = n4;
                continue block1;
            }
        }
        block3: for (n2 = 0; n2 < n4; ++n2) {
            objectArray[nArray[0]].setValue(n2);
            for (n = 0; n < n3; ++n) {
                if (nArray.length > 1) {
                    objectArray[nArray[1]].setValue(n);
                }
                if (this.rowsEqual(diskHashtable.get(object = KeyHasher.buildHashKey((Object[])objectArray, (int[])nArray)), objectArray)) continue;
                this.REPORT_FAILURE("  large table get returned wrong value for key(" + n2 + "," + n + ")");
                n2 = n4;
                continue block3;
            }
        }
        BitSet bitSet = new BitSet(n4 * n3);
        Enumeration enumeration = diskHashtable.elements();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            if (!(object instanceof DataValueDescriptor[])) {
                this.REPORT_FAILURE("  large table enumeration returned wrong element type");
                break;
            }
            DataValueDescriptor[] dataValueDescriptorArray2 = (DataValueDescriptor[])object;
            int n5 = dataValueDescriptorArray2[nArray[0]].getInt() * n3;
            if (nArray.length > 1) {
                n5 += dataValueDescriptorArray2[nArray[1]].getInt();
            }
            if (n5 >= n4 * n3) {
                this.REPORT_FAILURE("  large table enumeration returned invalid element");
                break;
            }
            if (bitSet.get(n5)) {
                this.REPORT_FAILURE("  large table enumeration returned same element twice");
                break;
            }
            bitSet.set(n5);
        }
        for (int i = n4 * n3 - 1; i >= 0; --i) {
            if (bitSet.get(i)) continue;
            this.REPORT_FAILURE("  large table enumeration missed at least one element");
            break;
        }
    }

    private void testElements(boolean bl, DiskHashtable diskHashtable, int n, DataValueDescriptor[][] dataValueDescriptorArray, boolean[] blArray, boolean[] blArray2) throws StandardException {
        for (int i = 0; i < n; ++i) {
            blArray2[i] = false;
        }
        Enumeration enumeration = diskHashtable.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (e == null) {
                this.REPORT_FAILURE("  table enumeration returned a null element");
                return;
            }
            if (e instanceof DataValueDescriptor[]) {
                this.checkElement((DataValueDescriptor[])e, n, dataValueDescriptorArray, blArray2);
                continue;
            }
            if (e instanceof List) {
                List list = (List)e;
                for (int i = 0; i < list.size(); ++i) {
                    this.checkElement((DataValueDescriptor[])list.get(i), n, dataValueDescriptorArray, blArray2);
                }
                continue;
            }
            if (e != null) continue;
            this.REPORT_FAILURE("  table enumeration returned an incorrect element type");
            return;
        }
        for (int i = 0; i < n; ++i) {
            if (bl && blArray[i]) {
                if (!blArray2[i]) continue;
                this.REPORT_FAILURE("  table enumeration did not remove duplicates");
                return;
            }
            if (blArray2[i]) continue;
            this.REPORT_FAILURE("  table enumeration missed at least one element");
            return;
        }
    }

    private void checkElement(DataValueDescriptor[] dataValueDescriptorArray, int n, DataValueDescriptor[][] dataValueDescriptorArray2, boolean[] blArray) throws StandardException {
        for (int i = 0; i < n; ++i) {
            if (!this.rowsEqual(dataValueDescriptorArray, dataValueDescriptorArray2[i])) continue;
            if (blArray[i]) {
                this.REPORT_FAILURE("  table enumeration returned the same element twice");
                return;
            }
            blArray[i] = true;
            return;
        }
        this.REPORT_FAILURE("  table enumeration returned an incorrect element");
    }

    private boolean rowsEqual(Object object, Object object2) throws StandardException {
        if (object == null) {
            return object2 == null;
        }
        if (object instanceof DataValueDescriptor[]) {
            DataValueDescriptor[] dataValueDescriptorArray;
            DataValueDescriptor[] dataValueDescriptorArray2 = (DataValueDescriptor[])object;
            if (object2 instanceof List) {
                List list = (List)object2;
                if (list.size() != 1) {
                    return false;
                }
                dataValueDescriptorArray = (DataValueDescriptor[])list.get(0);
            } else if (object2 instanceof DataValueDescriptor[]) {
                dataValueDescriptorArray = (DataValueDescriptor[])object2;
            } else {
                return false;
            }
            if (dataValueDescriptorArray2.length != dataValueDescriptorArray.length) {
                return false;
            }
            for (int i = 0; i < dataValueDescriptorArray2.length; ++i) {
                if (dataValueDescriptorArray2[i].compare(2, dataValueDescriptorArray[i], true, true)) continue;
                return false;
            }
            return true;
        }
        if (object instanceof List) {
            if (!(object2 instanceof List)) {
                return false;
            }
            List list = (List)object;
            List list2 = (List)object2;
            if (list.size() != list2.size()) {
                return false;
            }
            for (int i = list.size() - 1; i >= 0; --i) {
                if (this.rowsEqual(list.get(i), list2.get(i))) continue;
                return false;
            }
            return true;
        }
        return object.equals(object2);
    }
}

