/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.system.mailjdbc.tasks;

import java.sql.Connection;
import java.sql.SQLException;
import org.apache.derbyTesting.system.mailjdbc.MailJdbc;
import org.apache.derbyTesting.system.mailjdbc.utils.DbTasks;
import org.apache.derbyTesting.system.mailjdbc.utils.LogFile;

public class Refresh
extends Thread {
    private boolean isRunning = false;
    private DbTasks dbtasks = new DbTasks();
    private Connection conn = null;

    public Refresh(String string) throws Exception {
        this.setName(string);
        this.conn = DbTasks.getConnection("REFRESH", "Refresh");
    }

    @Override
    public void run() {
        try {
            this.grantRevoke(this.conn, this.getName());
            while (true) {
                this.doWork();
                try {
                    Thread.sleep(150000L);
                }
                catch (InterruptedException interruptedException) {
                    MailJdbc.logAct.logMsg("#### " + this.getName() + "...Interrupted");
                    this.conn.commit();
                    MailJdbc.logAct.logMsg("#### " + this.getName() + "...commit connection...");
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            MailJdbc.logAct.logMsg(LogFile.ERROR + "Error while sleeping the thread in refresh: " + exception.getMessage());
            return;
        }
    }

    private void doWork() {
        this.isRunning = true;
        try {
            this.insertMail(this.conn, this.getName());
            Thread.sleep(60000L);
        }
        catch (Exception exception) {
            MailJdbc.logAct.logMsg(LogFile.ERROR + "insertMail() failed " + exception.getMessage());
        }
        try {
            MailJdbc.logAct.logMsg(LogFile.INFO + "Deleting mail by Refresh Thread : ");
            this.deleteMailByRefresh(this.conn, this.getName());
        }
        catch (Exception exception) {
            MailJdbc.logAct.logMsg(LogFile.ERROR + "deleteMailByRefresh() failed " + exception.getMessage());
            try {
                this.conn.rollback();
            }
            catch (SQLException sQLException) {
                MailJdbc.logAct.logMsg(LogFile.ERROR + "rollback connection on Refresh failed..." + sQLException.getMessage());
            }
            MailJdbc.logAct.logMsg("#### " + this.getName() + "...rollback connection after deleteMailByRefresh...");
        }
        MailJdbc.logAct.logMsg(LogFile.INFO + "Refresh doWork() completed");
        this.isRunning = false;
    }

    public void grantRevoke(Connection connection, String string) throws Exception {
        this.dbtasks.grantRevoke(connection, string);
    }

    public void insertMail(Connection connection, String string) throws Exception {
        this.dbtasks.insertMail(connection, string);
    }

    public void deleteMailByRefresh(Connection connection, String string) throws Exception {
        this.dbtasks.deleteMailByThread(connection, string);
    }

    public boolean isRunning() {
        return this.isRunning;
    }
}

