/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.system.nstest.utils;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Random;
import org.apache.derbyTesting.system.nstest.NsTest;

public class DbUtil {
    private String threadName = "";
    public static final int TCHAR = 0;
    public static final int TDATE = 1;
    public static final int TDECIMAL = 2;
    public static final int TDECIMALNN = 3;
    public static final int TDOUBLE = 4;
    public static final int TFLOAT = 5;
    public static final int TINT = 6;
    public static final int TLONGINT = 7;
    public static final int TNUMERICLARGE = 8;
    public static final int TREAL = 9;
    public static final int TSMALLINT = 10;
    public static final int TTIME = 11;
    public static final int TTIMESTAMP = 12;
    public static final int TVARCHAR = 13;
    public static final int NUMTYPES = 14;
    public static String[] colnames = new String[]{"t_char", "t_date", "t_decimal", "t_decimal_nn", "t_double", "t_float", "t_int", "t_longint", "t_numeric_large", "t_real", "t_smallint", "t_time", "t_timestamp", "t_varchar"};

    public DbUtil(String string) {
        this.threadName = string;
    }

    public int add_one_row(Connection connection, String string) throws Exception {
        PreparedStatement preparedStatement = null;
        int n = 0;
        try {
            int n2;
            preparedStatement = connection.prepareStatement(" insert into nstesttab (id, t_char, t_date, t_decimal, t_decimal_nn, t_double,  t_float, t_int, t_longint, t_numeric_large, t_real, t_smallint, t_time, t_timestamp, t_varchar,t_clob,t_blob,sequenceColumn) values ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,cast('00000000000000000000000000000000031' as clob(1K)),cast(X'000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000031' as blob(10K)), next value for nstesttab_seq)");
            Random random = new Random();
            int n3 = n2 = random.nextInt();
            Date date = new Date(1L);
            Time time = new Time(1L);
            Timestamp timestamp = new Timestamp(1L);
            String string2 = "asdf qwerqwer 12341234 ZXCVZXCVZXCV !@#$!@#$ asdfasdf 1 q a z asdf ASDF qwerasdfzxcvasdfqwer1234asd#";
            preparedStatement.setInt(1, n2);
            int n4 = Math.abs(n2 % 100);
            String string3 = string2.substring(n4, 99) + string2.substring(0, n4);
            int n5 = n4 < 89 ? n4 + 10 : n4;
            preparedStatement.setString(2, string3.substring(0, n5));
            date.setTime(Math.abs(random.nextLong() / 150000L));
            preparedStatement.setDate(3, date);
            double d = random.nextDouble() * Math.pow(10.0, Math.abs(random.nextInt() % 6));
            preparedStatement.setDouble(4, d);
            double d2 = random.nextDouble();
            preparedStatement.setDouble(5, d2);
            double d3 = random.nextDouble() * Math.pow(10.0, Math.abs(random.nextInt() % 300));
            preparedStatement.setDouble(6, d3);
            float f = random.nextFloat() * (float)Math.pow(10.0, Math.abs(random.nextInt() % 30));
            preparedStatement.setFloat(7, f);
            int n6 = random.nextInt();
            preparedStatement.setInt(8, n6);
            long l = random.nextLong();
            preparedStatement.setLong(9, l);
            double d4 = random.nextDouble() * Math.pow(10.0, Math.abs(random.nextInt() % 20));
            preparedStatement.setDouble(10, d4);
            float f2 = random.nextFloat() * (float)Math.pow(10.0, Math.abs(random.nextInt() % 7));
            preparedStatement.setFloat(11, f2);
            int n7 = random.nextInt() % 32768;
            preparedStatement.setInt(12, n7);
            time.setTime(Math.abs(random.nextInt()));
            preparedStatement.setTime(13, time);
            timestamp.setTime(Math.abs(random.nextLong() / 50000L));
            preparedStatement.setTimestamp(14, timestamp);
            preparedStatement.setString(15, string2.substring(Math.abs(random.nextInt() % 100)));
            try {
                n = preparedStatement.executeUpdate();
            }
            catch (SQLException sQLException) {
                if (NsTest.justCountErrors()) {
                    NsTest.addError(sQLException);
                }
                if (sQLException.getSQLState().equalsIgnoreCase("40XL1")) {
                    NsTest.logger.println("LOCK TIMEOUT obtained during insert - add_one_row() " + sQLException.getSQLState());
                }
                if (sQLException.getSQLState().equalsIgnoreCase("23505")) {
                    NsTest.logger.println("prevented duplicate row - add_one_row(): " + sQLException.getSQLState() + "; " + sQLException.getMessage());
                }
                throw sQLException;
            }
            if (n == 1) {
                NsTest.logger.println(string + " inserted 1 row with id " + n3);
            } else {
                NsTest.logger.println("FAIL: " + string + " inserted " + n + "rows");
            }
        }
        catch (Exception exception) {
            NsTest.logger.println("Exception when preparing or executing insert prepared stmt");
            this.printException("executing/preparing insert stmt in dbUtil", exception);
            exception.printStackTrace(NsTest.logger);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int update_one_row(Connection connection, String string) throws Exception {
        PreparedStatement preparedStatement = null;
        String string2 = null;
        int n = 0;
        Random random = new Random();
        int n2 = 0;
        connection.setTransactionIsolation(2);
        long l = this.pick_one(connection, string);
        if (l == 0L) {
            NsTest.logger.println(string + " could not find a row to update or there was an error.");
            return n2;
        }
        n = Math.abs(random.nextInt());
        string2 = colnames[n % 14];
        try {
            preparedStatement = connection.prepareStatement(" update nstesttab set " + string2 + " = ?  where serialkey = " + l);
        }
        catch (Exception exception) {
            this.printException("closing update prepared stmt in dbUtil.update_one_row() ", exception);
            return n2;
        }
        String string3 = null;
        String string4 = "asdf qwerqwer 12341234 ZXCVZXCVZXCV !@#$!@#$ asdfasdf 1 q a z asdf ASDF qwerasdfzxcvasdfqwer1234asd#";
        double d = 0.0;
        float f = 0.0f;
        int n3 = n % 14;
        switch (n3) {
            case 0: {
                string3 = string4.substring(Math.abs(random.nextInt() % 100));
                preparedStatement.setString(1, string3);
                break;
            }
            case 1: {
                Date date = new Date(1L);
                date.setTime(Math.abs(random.nextLong() / 150000L));
                date.setTime(Math.abs(random.nextLong() / 150000L));
                preparedStatement.setDate(1, date);
                string3 = date.toString();
                break;
            }
            case 2: {
                d = random.nextDouble() * Math.pow(10.0, Math.abs(random.nextInt() % 6));
                preparedStatement.setDouble(1, d);
                string3 = String.valueOf(d);
                break;
            }
            case 3: {
                d = random.nextDouble();
                preparedStatement.setDouble(1, d);
                string3 = String.valueOf(d);
                break;
            }
            case 4: {
                d = random.nextDouble() * Math.pow(10.0, random.nextInt() % 300);
                preparedStatement.setDouble(1, d);
                string3 = String.valueOf(d);
                break;
            }
            case 5: {
                f = random.nextFloat() * (float)Math.pow(10.0, random.nextInt() % 30);
                preparedStatement.setFloat(1, f);
                string3 = String.valueOf(f);
                break;
            }
            case 6: {
                int n4 = random.nextInt();
                string3 = String.valueOf(n4);
                preparedStatement.setInt(1, n4);
                break;
            }
            case 7: {
                long l2 = random.nextLong();
                string3 = String.valueOf(l2);
                preparedStatement.setLong(1, l2);
                break;
            }
            case 8: {
                d = random.nextDouble() * Math.pow(10.0, random.nextInt() % 20);
                preparedStatement.setDouble(1, d);
                string3 = String.valueOf(d);
                break;
            }
            case 9: {
                f = random.nextFloat() * (float)Math.pow(10.0, random.nextInt() % 7);
                preparedStatement.setFloat(1, f);
                string3 = String.valueOf(f);
                break;
            }
            case 10: {
                int n5 = random.nextInt() % 32768;
                short s = (short)n5;
                preparedStatement.setShort(1, s);
                string3 = String.valueOf(s);
                break;
            }
            case 11: {
                Time time = new Time(1L);
                time.setTime(Math.abs(random.nextInt()));
                preparedStatement.setTime(1, time);
                string3 = time.toString();
                break;
            }
            case 12: {
                Timestamp timestamp = new Timestamp(1L);
                timestamp.setTime(Math.abs(random.nextLong() / 50000L));
                preparedStatement.setTimestamp(1, timestamp);
                string3 = timestamp.toString();
                break;
            }
            case 13: {
                string3 = string4.substring(Math.abs(random.nextInt() % 100));
                preparedStatement.setString(1, string3);
            }
        }
        try {
            n2 = preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            NsTest.logger.println(sQLException.getSQLState() + " " + sQLException.getErrorCode() + " " + sQLException.getMessage());
            if (NsTest.justCountErrors()) {
                NsTest.printException(DbUtil.class.getName(), sQLException);
            } else {
                sQLException.printStackTrace(NsTest.logger);
            }
        }
        catch (Exception exception) {
            this.printException("Error in update_one_row()", exception);
            exception.printStackTrace(NsTest.logger);
        }
        finally {
            connection.setTransactionIsolation(1);
        }
        if (n2 > 0) {
            NsTest.logger.println(string + " updated " + n2 + " row with serialkey " + l + " *** SUCCESS *** ");
        } else {
            NsTest.logger.println(string + " update failed, no such row exists");
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int delete_one_row(Connection connection, String string) throws Exception {
        PreparedStatement preparedStatement = null;
        int n = 0;
        connection.setTransactionIsolation(2);
        try {
            preparedStatement = connection.prepareStatement(" delete from nstesttab where serialkey = ?");
        }
        catch (Exception exception) {
            NsTest.logger.println("Unexpected error preparing the statement in delete_one()");
            this.printException("delete_one_row prepare ", exception);
            return n;
        }
        long l = this.pick_one(connection, string);
        if (l == 0L) {
            NsTest.logger.println(string + " could not find a row to delete or there was an error.");
            return n;
        }
        try {
            preparedStatement.setLong(1, l);
            n = preparedStatement.executeUpdate();
        }
        catch (Exception exception) {
            NsTest.logger.println("Error in delete_one(): either with setLong() or executeUpdate");
            this.printException("failure to execute delete stmt", exception);
        }
        finally {
            connection.setTransactionIsolation(1);
        }
        if (n > 0) {
            NsTest.logger.println(string + " deleted row with serialkey " + l + " *** SUCCESS *** ");
        } else {
            NsTest.logger.println(string + " delete for serialkey " + l + " failed, no such row exists.");
        }
        return n;
    }

    public long pick_one(Connection connection, String string) throws Exception {
        Random random = new Random();
        long l = NsTest.NUM_UNTOUCHED_ROWS + 1;
        long l2 = NsTest.numInserts;
        long l3 = l + (long)(random.nextDouble() * (double)(l2 - l));
        return l3;
    }

    public synchronized void printException(String string, Exception exception) {
        if (NsTest.justCountErrors()) {
            NsTest.addError(exception);
            return;
        }
        NsTest.logger.println(exception.toString());
        if (exception instanceof SQLException) {
            SQLException sQLException = (SQLException)exception;
            if (sQLException.getSQLState().equals("40001")) {
                NsTest.logger.println(this.getThreadName() + " dbUtil --> deadlocked detected");
            }
            if (sQLException.getSQLState().equals("40XL1")) {
                NsTest.logger.println(this.getThreadName() + " dbUtil --> lock timeout exception");
            }
            if (sQLException.getSQLState().equals("23500")) {
                NsTest.logger.println(this.getThreadName() + " dbUtil --> duplicate key violation");
            }
            if (sQLException.getNextException() != null) {
                String string2 = sQLException.getNextException().getSQLState();
                NsTest.logger.println(sQLException.getNextException().getMessage() + " SQLSTATE: " + string2);
                NsTest.logger.println(this.getThreadName() + " dbUtil ---> Details of exception: " + sQLException.toString() + " " + sQLException.getErrorCode());
            }
        }
        if (exception.getMessage() == null) {
            NsTest.logger.println(this.getThreadName() + " dbUtil --> NULL error message detected");
            NsTest.logger.println(this.getThreadName() + " dbUtil --> Here is the NULL exection - " + exception.toString());
            NsTest.logger.println(this.getThreadName() + " dbUtil --> Stack trace of the NULL exception - ");
            if (NsTest.justCountErrors()) {
                NsTest.printException(DbUtil.class.getName(), exception);
            } else {
                exception.printStackTrace(NsTest.logger);
            }
        }
        NsTest.logger.println(this.getThreadName() + " dbUtil ----> During " + string + ", exception thrown was : " + exception.toString());
    }

    public String getThreadName() {
        return this.threadName;
    }
}

