/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.unitTests.store;

import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.store.access.AccessFactory;
import org.apache.derby.iapi.store.access.ColumnOrdering;
import org.apache.derby.iapi.store.access.ScanController;
import org.apache.derby.iapi.store.access.ScanInfo;
import org.apache.derby.iapi.store.access.SortController;
import org.apache.derby.iapi.store.access.SortInfo;
import org.apache.derby.iapi.store.access.SortObserver;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.i18n.MessageService;
import org.apache.derbyTesting.unitTests.harness.T_Fail;
import org.apache.derbyTesting.unitTests.harness.T_Generic;
import org.apache.derbyTesting.unitTests.store.T_AccessRow;
import org.apache.derbyTesting.unitTests.store.T_ColumnOrderingImpl;
import org.apache.derbyTesting.unitTests.store.T_DummySortObserver;
import org.apache.derbyTesting.unitTests.store.T_DuplicateEliminator;
import org.apache.derbyTesting.unitTests.store.T_SumForIntCol;
import org.apache.derbyTesting.unitTests.store.T_Util;

public class T_SortController
extends T_Generic {
    private static final String testService = "sortTest";
    protected boolean verbose = false;

    @Override
    public String getModuleToTestProtocolName() {
        return "org.apache.derby.iapi.store.access.AccessFactory";
    }

    private void setSortBufferSize(String string) {
        System.setProperty("derby.storage.sortBufferMax", string);
    }

    @Override
    protected void runTests() throws T_Fail {
        AccessFactory accessFactory;
        int n = 0;
        if (this.startParams == null) {
            this.startParams = new Properties();
        }
        this.startParams.put("derby.database.noAutoBoot", Boolean.TRUE.toString());
        this.startParams.put("derby.__deleteOnCreate", Boolean.TRUE.toString());
        this.startParams = T_Util.setEncryptionParam(this.startParams);
        try {
            this.REPORT("(unitTestMain) Testing sortTest with default sort buffer size 1024");
            AccessFactory accessFactory2 = null;
            n = this.runEachTest(accessFactory2, "1024");
            this.setSortBufferSize("4");
            this.REPORT("(unitTestMain) Testing sortTest with minimum sort buffer size 4");
            accessFactory = null;
        }
        catch (StandardException standardException) {
            String string = standardException.getMessage();
            if (string == null) {
                string = ((Object)((Object)standardException)).getClass().getName();
            }
            this.REPORT("(unitTestMain) unexpected exception: " + string);
            throw T_Fail.exceptionFail(standardException);
        }
        if ((n += this.runEachTest(accessFactory, "4")) != 0) {
            throw T_Fail.testFailMsg("(unitTestMain)" + n + " cases failed.");
        }
        this.REPORT("(unitTestMain) succeeded");
    }

    protected int runEachTest(AccessFactory accessFactory, String string) throws T_Fail, StandardException {
        TransactionController transactionController = null;
        int n = 0;
        try {
            accessFactory = (AccessFactory)T_SortController.createPersistentService(this.getModuleToTestProtocolName(), testService + string, this.startParams);
        }
        catch (StandardException standardException) {
            throw T_Fail.exceptionFail(standardException);
        }
        if (accessFactory == null) {
            throw T_Fail.testFailMsg(this.getModuleToTestProtocolName() + " service not started.");
        }
        transactionController = accessFactory.getTransaction(T_SortController.getContextService().getCurrentContextManager());
        if (!this.sortExample(transactionController)) {
            ++n;
        }
        if (!this.sortBufferCoverage(transactionController)) {
            ++n;
        }
        if (!this.sortBoundaries(transactionController)) {
            ++n;
        }
        if (!this.sortAllDuplicates(transactionController)) {
            ++n;
        }
        if (!this.sortDescending(transactionController)) {
            ++n;
        }
        transactionController.commit();
        transactionController.destroy();
        return n;
    }

    boolean sortExample(TransactionController transactionController) throws StandardException {
        this.REPORT("(sortExample)");
        T_AccessRow[] t_AccessRowArray = new T_AccessRow[]{new T_AccessRow(18, 1, 2), new T_AccessRow(6, 1, 18), new T_AccessRow(18, 1, 2), new T_AccessRow(8, 14, 3)};
        Properties properties = null;
        T_AccessRow t_AccessRow = t_AccessRowArray[0];
        ColumnOrdering[] columnOrderingArray = new ColumnOrdering[]{new T_ColumnOrderingImpl(1, true), new T_ColumnOrderingImpl(2, true)};
        boolean bl = false;
        long l = 10L;
        int n = 12;
        long l2 = transactionController.createSort(properties, t_AccessRow.getRowArray(), columnOrderingArray, (SortObserver)new T_DuplicateEliminator(t_AccessRow), bl, l, n);
        T_AccessRow[] t_AccessRowArray2 = new T_AccessRow[]{new T_AccessRow(18, 1, 2), new T_AccessRow(6, 1, 18), new T_AccessRow(8, 14, 3)};
        return this.testSort(transactionController, t_AccessRowArray, t_AccessRowArray2, l2);
    }

    boolean sortBufferCoverage(TransactionController transactionController) throws StandardException {
        this.REPORT("(sortBufferCoverage)");
        T_AccessRow[] t_AccessRowArray = new T_AccessRow[]{new T_AccessRow(2, 0, 0), new T_AccessRow(2, 0, 0), new T_AccessRow(4, 0, 0), new T_AccessRow(4, 0, 0), new T_AccessRow(1, 0, 0), new T_AccessRow(1, 0, 0), new T_AccessRow(7, 0, 0), new T_AccessRow(7, 0, 0), new T_AccessRow(8, 0, 0), new T_AccessRow(8, 0, 0), new T_AccessRow(3, 0, 0), new T_AccessRow(3, 0, 0), new T_AccessRow(5, 0, 0), new T_AccessRow(5, 0, 0), new T_AccessRow(6, 0, 0), new T_AccessRow(6, 0, 0)};
        Properties properties = null;
        T_AccessRow t_AccessRow = t_AccessRowArray[0];
        ColumnOrdering[] columnOrderingArray = new ColumnOrdering[]{new T_ColumnOrderingImpl(0, true)};
        boolean bl = false;
        long l = 20L;
        int n = 12;
        long l2 = transactionController.createSort(properties, t_AccessRow.getRowArray(), columnOrderingArray, (SortObserver)new T_DummySortObserver(t_AccessRow), bl, l, n);
        T_AccessRow[] t_AccessRowArray2 = new T_AccessRow[]{new T_AccessRow(1, 0, 0), new T_AccessRow(1, 0, 0), new T_AccessRow(2, 0, 0), new T_AccessRow(2, 0, 0), new T_AccessRow(3, 0, 0), new T_AccessRow(3, 0, 0), new T_AccessRow(4, 0, 0), new T_AccessRow(4, 0, 0), new T_AccessRow(5, 0, 0), new T_AccessRow(5, 0, 0), new T_AccessRow(6, 0, 0), new T_AccessRow(6, 0, 0), new T_AccessRow(7, 0, 0), new T_AccessRow(7, 0, 0), new T_AccessRow(8, 0, 0), new T_AccessRow(8, 0, 0)};
        return this.testSort(transactionController, t_AccessRowArray, t_AccessRowArray2, l2);
    }

    boolean sortBoundaries(TransactionController transactionController) throws StandardException {
        int n = 0;
        Properties properties = null;
        T_AccessRow t_AccessRow = new T_AccessRow(1, 1, 1);
        ColumnOrdering[] columnOrderingArray = new ColumnOrdering[]{new T_ColumnOrderingImpl(0, true)};
        long l = 10L;
        int n2 = 12;
        this.REPORT("(sortBoundaries) Sorting no rows");
        T_AccessRow[] t_AccessRowArray = new T_AccessRow[]{};
        T_AccessRow[] t_AccessRowArray2 = new T_AccessRow[]{};
        boolean bl = false;
        long l2 = transactionController.createSort(properties, t_AccessRow.getRowArray(), columnOrderingArray, (SortObserver)new T_DummySortObserver(t_AccessRow), bl, l, n2);
        if (!this.testSort(transactionController, t_AccessRowArray, t_AccessRowArray2, l2)) {
            ++n;
        }
        this.REPORT("(sortBoundaries) Sorting no rows - \"already in order\"");
        t_AccessRowArray = new T_AccessRow[]{};
        t_AccessRowArray2 = new T_AccessRow[]{};
        bl = true;
        l2 = transactionController.createSort(properties, t_AccessRow.getRowArray(), columnOrderingArray, (SortObserver)new T_DummySortObserver(t_AccessRow), bl, l, n2);
        if (!this.testSort(transactionController, t_AccessRowArray, t_AccessRowArray2, l2)) {
            ++n;
        }
        this.REPORT("(sortBoundaries) Sorting a single row");
        t_AccessRowArray = new T_AccessRow[]{new T_AccessRow(99, 88, 77)};
        t_AccessRowArray2 = new T_AccessRow[]{new T_AccessRow(99, 88, 77)};
        bl = false;
        l2 = transactionController.createSort(properties, t_AccessRow.getRowArray(), columnOrderingArray, (SortObserver)new T_DummySortObserver(t_AccessRow), bl, l, n2);
        if (!this.testSort(transactionController, t_AccessRowArray, t_AccessRowArray2, l2)) {
            ++n;
        }
        this.REPORT("(sortBoundaries) Sorting a single row - \"already in order\"");
        t_AccessRowArray = new T_AccessRow[]{new T_AccessRow(99, 88, 77)};
        t_AccessRowArray2 = new T_AccessRow[]{new T_AccessRow(99, 88, 77)};
        bl = true;
        l2 = transactionController.createSort(properties, t_AccessRow.getRowArray(), columnOrderingArray, (SortObserver)new T_DummySortObserver(t_AccessRow), bl, l, n2);
        if (!this.testSort(transactionController, t_AccessRowArray, t_AccessRowArray2, l2)) {
            ++n;
        }
        this.REPORT("(sortBoundaries) Sorting a single row - \"eliminate duplicates\"");
        t_AccessRowArray = new T_AccessRow[]{new T_AccessRow(99, 88, 77)};
        t_AccessRowArray2 = new T_AccessRow[]{new T_AccessRow(99, 88, 77)};
        bl = false;
        l2 = transactionController.createSort(properties, t_AccessRow.getRowArray(), columnOrderingArray, (SortObserver)new T_DuplicateEliminator(t_AccessRow), bl, l, n2);
        if (!this.testSort(transactionController, t_AccessRowArray, t_AccessRowArray2, l2)) {
            ++n;
        }
        return n == 0;
    }

    boolean sortAllDuplicates(TransactionController transactionController) throws StandardException {
        int n = 0;
        Properties properties = null;
        T_AccessRow t_AccessRow = new T_AccessRow(1, 1, 1);
        ColumnOrdering[] columnOrderingArray = new ColumnOrdering[]{new T_ColumnOrderingImpl(0, true), new T_ColumnOrderingImpl(1, true)};
        boolean bl = false;
        long l = 10L;
        int n2 = 12;
        T_AccessRow[] t_AccessRowArray = new T_AccessRow[]{new T_AccessRow(1, 1, 1), new T_AccessRow(1, 1, 1), new T_AccessRow(1, 1, 1), new T_AccessRow(1, 1, 1), new T_AccessRow(1, 1, 1)};
        this.REPORT("(sortAllDuplicates) no aggregation");
        T_AccessRow[] t_AccessRowArray2 = new T_AccessRow[]{new T_AccessRow(1, 1, 1), new T_AccessRow(1, 1, 1), new T_AccessRow(1, 1, 1), new T_AccessRow(1, 1, 1), new T_AccessRow(1, 1, 1)};
        long l2 = transactionController.createSort(properties, t_AccessRow.getRowArray(), columnOrderingArray, (SortObserver)new T_DummySortObserver(t_AccessRow), bl, l, n2);
        if (!this.testSort(transactionController, t_AccessRowArray, t_AccessRowArray2, l2)) {
            ++n;
        }
        this.REPORT("(sortAllDuplicates) eliminate duplicates");
        t_AccessRowArray2 = new T_AccessRow[]{new T_AccessRow(1, 1, 1)};
        l2 = transactionController.createSort(properties, t_AccessRow.getRowArray(), columnOrderingArray, (SortObserver)new T_DuplicateEliminator(t_AccessRow), bl, l, n2);
        if (!this.testSort(transactionController, t_AccessRowArray, t_AccessRowArray2, l2)) {
            ++n;
        }
        this.REPORT("(sortAllDuplicates) sum aggregate");
        t_AccessRowArray2 = new T_AccessRow[]{new T_AccessRow(1, 1, 5)};
        l2 = transactionController.createSort(properties, t_AccessRow.getRowArray(), columnOrderingArray, (SortObserver)new T_SumForIntCol(2), bl, l, n2);
        if (!this.testSort(transactionController, t_AccessRowArray, t_AccessRowArray2, l2)) {
            ++n;
        }
        return n == 0;
    }

    boolean sortDescending(TransactionController transactionController) throws StandardException {
        int n = 0;
        Properties properties = null;
        T_AccessRow t_AccessRow = new T_AccessRow(1, 1, 1);
        boolean bl = false;
        long l = 10L;
        int n2 = 12;
        this.REPORT("(sortDescending) no aggregation");
        ColumnOrdering[] columnOrderingArray = new ColumnOrdering[]{new T_ColumnOrderingImpl(0, false), new T_ColumnOrderingImpl(1, false)};
        T_AccessRow[] t_AccessRowArray = new T_AccessRow[]{new T_AccessRow(8, 1, 1), new T_AccessRow(4, 8, 1), new T_AccessRow(4, 2, 1), new T_AccessRow(4, 1, 1), new T_AccessRow(3, 8, 1), new T_AccessRow(3, 5, 1), new T_AccessRow(3, 3, 1), new T_AccessRow(3, 3, 1), new T_AccessRow(3, 3, 1), new T_AccessRow(1, 1, 1)};
        long l2 = transactionController.createSort(properties, t_AccessRow.getRowArray(), columnOrderingArray, (SortObserver)new T_DummySortObserver(t_AccessRow), bl, l, n2);
        if (!this.testSort(transactionController, this.getSortDescendingInput(), t_AccessRowArray, l2)) {
            ++n;
        }
        this.REPORT("(sortDescending) eliminate duplicates");
        columnOrderingArray = new ColumnOrdering[]{new T_ColumnOrderingImpl(0, false), new T_ColumnOrderingImpl(1, false)};
        t_AccessRowArray = new T_AccessRow[]{new T_AccessRow(8, 1, 1), new T_AccessRow(4, 8, 1), new T_AccessRow(4, 2, 1), new T_AccessRow(4, 1, 1), new T_AccessRow(3, 8, 1), new T_AccessRow(3, 5, 1), new T_AccessRow(3, 3, 1), new T_AccessRow(1, 1, 1)};
        l2 = transactionController.createSort(properties, t_AccessRow.getRowArray(), columnOrderingArray, (SortObserver)new T_DuplicateEliminator(t_AccessRow), bl, l, n2);
        if (!this.testSort(transactionController, this.getSortDescendingInput(), t_AccessRowArray, l2)) {
            ++n;
        }
        this.REPORT("(sortDescending) descending/ascending - eliminate duplicates");
        columnOrderingArray = new ColumnOrdering[]{new T_ColumnOrderingImpl(0, false), new T_ColumnOrderingImpl(1, true)};
        t_AccessRowArray = new T_AccessRow[]{new T_AccessRow(8, 1, 1), new T_AccessRow(4, 1, 1), new T_AccessRow(4, 2, 1), new T_AccessRow(4, 8, 1), new T_AccessRow(3, 3, 1), new T_AccessRow(3, 5, 1), new T_AccessRow(3, 8, 1), new T_AccessRow(1, 1, 1)};
        l2 = transactionController.createSort(properties, t_AccessRow.getRowArray(), columnOrderingArray, (SortObserver)new T_DuplicateEliminator(t_AccessRow), bl, l, n2);
        if (!this.testSort(transactionController, this.getSortDescendingInput(), t_AccessRowArray, l2)) {
            ++n;
        }
        return n == 0;
    }

    private T_AccessRow[] getSortDescendingInput() {
        T_AccessRow[] t_AccessRowArray = new T_AccessRow[]{new T_AccessRow(8, 1, 1), new T_AccessRow(1, 1, 1), new T_AccessRow(3, 5, 1), new T_AccessRow(4, 1, 1), new T_AccessRow(3, 3, 1), new T_AccessRow(3, 8, 1), new T_AccessRow(3, 3, 1), new T_AccessRow(3, 3, 1), new T_AccessRow(4, 2, 1), new T_AccessRow(4, 8, 1)};
        return t_AccessRowArray;
    }

    boolean testSort(TransactionController transactionController, T_AccessRow[] t_AccessRowArray, T_AccessRow[] t_AccessRowArray2, long l) throws StandardException {
        int n;
        SortController sortController = transactionController.openSort(l);
        for (int i = 0; i < t_AccessRowArray.length; ++i) {
            if (this.verbose) {
                this.REPORT("(testSort) in: " + t_AccessRowArray[i]);
            }
            sortController.insert(t_AccessRowArray[i].getRowArray());
        }
        sortController.completedInserts();
        SortInfo sortInfo = sortController.getSortInfo();
        Properties properties = sortInfo.getAllSortInfo(null);
        String string = properties.getProperty(MessageService.getTextMessage((String)"XSAJ8.U", (Object[])new Object[0]));
        int n2 = Integer.parseInt(properties.getProperty(MessageService.getTextMessage((String)"XSAJA.U", (Object[])new Object[0])));
        int n3 = Integer.parseInt(properties.getProperty(MessageService.getTextMessage((String)"XSAJB.U", (Object[])new Object[0])));
        String string2 = MessageService.getTextMessage((String)"XSAJI.U", (Object[])new Object[0]);
        String string3 = MessageService.getTextMessage((String)"XSAJJ.U", (Object[])new Object[0]);
        if (string.compareTo(string3) != 0 && string.compareTo(string2) != 0) {
            this.FAIL("(testSort) unknown sortType.  Expected internal or external, got " + string);
        }
        if (n2 != t_AccessRowArray.length) {
            this.FAIL("(testSort) SortInfo.numRowsInput (value: " + n2 + ") is not equal to in.length (value: " + t_AccessRowArray.length + ")");
        }
        if (n3 != t_AccessRowArray2.length) {
            this.FAIL("(testSort) SortInfo.numRowsOutput (value: " + n3 + ") is not equal to outrow.length (value: " + t_AccessRowArray2.length + ")");
        }
        if (string.equals(string2)) {
            int n4 = Integer.parseInt(properties.getProperty(MessageService.getTextMessage((String)"XSAJC.U", (Object[])new Object[0])));
            Vector<Integer> vector = new Vector<Integer>();
            StringTokenizer stringTokenizer = new StringTokenizer(properties.getProperty(MessageService.getTextMessage((String)"XSAJD.U", (Object[])new Object[0])), "[],", false);
            while (stringTokenizer.hasMoreTokens()) {
                vector.addElement(Integer.valueOf(stringTokenizer.nextToken().trim()));
            }
            if (vector.size() != n4) {
                this.FAIL("(testSort) the number of elements in vector SortInfo.mergeRunsSize (value: " + vector.size() + " ) is not equal to SortInfo.numMergeRuns (value: " + n4 + " )");
            }
            n = 0;
            for (int i = 0; i < vector.size(); ++i) {
                n += ((Integer)vector.elementAt(i)).intValue();
            }
            if (n != n2) {
                this.FAIL("(testSort) the sum of the elements of the vector SortInfo.mergeRunsSize (value: " + n + " ) is not equal to SortInfo.numRowsInput (value: " + n2 + " )");
            }
        }
        sortController = null;
        ScanController scanController = transactionController.openSortScan(l, false);
        boolean bl = false;
        boolean bl2 = false;
        n = 0;
        T_AccessRow t_AccessRow = new T_AccessRow(3);
        for (int i = 0; i < t_AccessRowArray2.length; ++i) {
            if (!scanController.next()) {
                bl2 = true;
                this.FAIL("(testSort) Too few rows in sort output");
                break;
            }
            scanController.fetch(t_AccessRow.getRowArray());
            if (this.verbose) {
                this.REPORT("(testSort) out: " + t_AccessRow);
            }
            if (t_AccessRow.equals(t_AccessRowArray2[i])) continue;
            bl = true;
            this.FAIL("(testSort) row " + t_AccessRow + " != " + t_AccessRowArray2[i]);
        }
        while (scanController.next()) {
            scanController.fetch(t_AccessRow.getRowArray());
            if (this.verbose) {
                this.REPORT("(testSort) out: " + t_AccessRow);
            }
            n = 1;
            this.FAIL("(testSort) Extra row");
        }
        ScanInfo scanInfo = scanController.getScanInfo();
        Properties properties2 = scanInfo.getAllScanInfo(null);
        if (properties2.getProperty(MessageService.getTextMessage((String)"XSAJ0.U", (Object[])new Object[0])).compareTo(MessageService.getTextMessage((String)"XSAJH.U", (Object[])new Object[0])) != 0) {
            this.FAIL("(testSort) wrong scanType.  Expected sort, got " + properties2.getProperty(MessageService.getTextMessage((String)"XSAJ0.U", (Object[])new Object[0])));
        }
        if (transactionController.countOpens(3) != 1) {
            this.FAIL("(testSort) sort count before close is wrong: " + transactionController.countOpens(3));
        }
        scanController.close();
        scanController = null;
        if (transactionController.countOpens(3) != 1) {
            this.FAIL("(testSort) sort count after close is wrong: " + transactionController.countOpens(3));
        }
        transactionController.dropSort(l);
        if (transactionController.countOpens(3) > 0) {
            this.FAIL("(testSort) a sort is still open.");
        }
        return !bl && !bl2 && n == 0;
    }

    private static ContextService getContextService() {
        return ContextService.getFactory();
    }

    private static Object createPersistentService(String string, String string2, Properties properties) throws StandardException {
        return Monitor.createPersistentService((String)string, (String)string2, (Properties)properties);
    }
}

