/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class Derby6131
extends BaseJDBCTestCase {
    public Derby6131(String name) {
        super(name);
    }

    public static Test suite() {
        return TestConfiguration.defaultSuite(Derby6131.class);
    }

    public void setUp() throws SQLException {
        this.getConnection().setAutoCommit(false);
    }

    public void testOrigUserRepro() throws SQLException {
        Statement st = this.createStatement();
        st.executeUpdate("create table myTbl1 (name varchar(1000))");
        st.executeUpdate("create table myTbl2 (name varchar(1000))");
        st.executeUpdate("create view myView (name) as select t1.name from myTbl1 t1 union all select t2.name from myTbl2 t2");
        String sql = "select name from myView where upper(name) in ('AA', 'BB')";
        JDBC.assertFullResultSet(st.executeQuery(sql), new String[0][]);
        this.dropView("myView");
        this.dropTable("myTbl1");
        this.dropTable("myTbl2");
        st.close();
    }

    public void testOrigUserReproWithData() throws SQLException {
        Statement st = this.createStatement();
        st.executeUpdate("create table myTbl1 (name varchar(1000))");
        st.executeUpdate("create table myTbl2 (name varchar(1000))");
        st.executeUpdate("insert into myTbl1 values ('aA'), ('bB'), ('Cc'), ('Dd')");
        st.executeUpdate("insert into myTbl2 values ('eE'), ('fF'), ('GG'), ('hh')");
        st.executeUpdate("create view myView (name) as select t1.name from myTbl1 t1 union all select t2.name from myTbl2 t2");
        String sql = "select name from myView where upper(name) in ('AA', 'BB')";
        JDBC.assertFullResultSet(st.executeQuery(sql), new String[][]{{"aA"}, {"bB"}});
        String prepared_sql = "select name from myView where upper(name) in (?, ?)";
        PreparedStatement pstmt = this.prepareStatement(prepared_sql);
        pstmt.setString(1, "AA");
        pstmt.setString(2, "BB");
        JDBC.assertFullResultSet(pstmt.executeQuery(), new String[][]{{"aA"}, {"bB"}});
        sql = "select name from myView where upper(name) in ('CC', 'HH')";
        JDBC.assertFullResultSet(st.executeQuery(sql), new String[][]{{"Cc"}, {"hh"}});
        pstmt.setString(1, "CC");
        pstmt.setString(2, "HH");
        JDBC.assertFullResultSet(st.executeQuery(sql), new String[][]{{"Cc"}, {"hh"}});
        sql = "select name from myView where upper(name) in ('cc', 'hh')";
        JDBC.assertFullResultSet(st.executeQuery(sql), new String[0][]);
        pstmt.setString(1, "cc");
        pstmt.setString(2, "hh");
        JDBC.assertFullResultSet(st.executeQuery(sql), new String[0][]);
        sql = "select name from myView where lower(name) in ('cc', 'hh')";
        JDBC.assertFullResultSet(st.executeQuery(sql), new String[][]{{"Cc"}, {"hh"}});
        prepared_sql = "select name from myView where upper(name) in (?, ?)";
        pstmt = this.prepareStatement(prepared_sql);
        pstmt.setString(1, "cc");
        pstmt.setString(2, "hh");
        JDBC.assertFullResultSet(st.executeQuery(sql), new String[][]{{"Cc"}, {"hh"}});
        this.dropView("myView");
        this.dropTable("myTbl1");
        this.dropTable("myTbl2");
        st.close();
        pstmt.close();
    }
}

