/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Random;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class MathTrigFunctionsTest
extends BaseJDBCTestCase {
    private static final double PRE_DERBY_3398_SMALLEST_NEG_DERBY_DOUBLE = -1.79769E308;
    private static final double SMALL_NEG_DOUBLE = -1.79768E308;
    private static final double PRE_DERBY_3398_SMALLEST_POS_DERBY_DOUBLE = 2.225E-307;
    private static final double PRE_DERBY_3398_LARGEST_POS_DERBY_DOUBLE = 1.79769E308;
    private static final double PRE_DERBY_3398_LARGEST_NEG_DERBY_DOUBLE = -2.225E-307;
    private static final double[] testRadians = new double[]{-1.0E-9, -0.25, 1.0E-9, 0.25, 0.5, 0.0, 1.0, 2.0, Math.PI, Math.PI};
    private static final double[] testArcValues = new double[]{1.0E-9, -1.0E-9, 0.25, -0.25, 0.5, 0.0, -0.0, 1.0, -1.0};
    private static final double[] logValues = new double[]{1.0E-9, 0.25, 0.5, 1.0, 45.0, 90.0, 135.0, 180.0, 270.0, 2.225E-307, 1.79769E308, 10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7, 1.0E8, 1.0E9};
    private static final double[] testValues = new double[]{-1.79769E308, -1.79768E308, 2.225E-307, 1.79769E308, -2.225E-307, 1.0E-9, -1.0E-9, 0.25, -0.25, 0.5, 0.0, -0.0, 1.0, -1.0, 2.0, 3.0, Math.PI, Math.PI * 2, 4.0, 45.0, 90.0, 135.0, 180.0, 270.0};
    private static final double[] testValuesTwo = new double[]{-1.79769E308, -1.79768E308, 2.225E-307, -2.225E-307, 1.0E-9, -1.0E-9, 0.25, -0.25, 0.5, 0.0, -0.0, 1.0, -1.0, 2.0, 3.0, Math.PI, Math.PI * 2, 4.0, 45.0, 90.0, 135.0, 180.0, 270.0};
    static final double DOUBLE_MIN_NORMAL = Double.MIN_NORMAL;

    public void testAcos() throws SQLException {
        this.executeNullValues("ACOS");
        this.executeNullFn("ACOS");
        this.debug();
        PreparedStatement preparedStatement = this.prepareStatement("VALUES ACOS(?)");
        PreparedStatement preparedStatement2 = this.prepareStatement("VALUES {fn ACOS(?)}");
        for (int i = 0; i < testArcValues.length; ++i) {
            double d = StrictMath.acos(testArcValues[i]);
            double d2 = this.getValue(preparedStatement, testArcValues[i]);
            this.debug("ACOS: input value: " + testArcValues[i] + " expected value: " + d + " return value: " + d2);
            MathTrigFunctionsTest.assertEquals((double)d, (double)d2, (double)0.0);
            double d3 = this.getValue(preparedStatement2, testArcValues[i]);
            MathTrigFunctionsTest.assertEquals((double)d, (double)d3, (double)0.0);
        }
        Random random = new Random();
        for (int i = 0; i < 100; ++i) {
            double d = random.nextDouble();
            double d4 = StrictMath.acos(d);
            double d5 = this.getValue(preparedStatement, d);
            MathTrigFunctionsTest.assertEquals((double)d4, (double)d5, (double)0.0);
            double d6 = this.getValue(preparedStatement2, d);
            MathTrigFunctionsTest.assertEquals((double)d4, (double)d6, (double)0.0);
        }
        try {
            this.getValue(preparedStatement, 2.0);
            MathTrigFunctionsTest.fail((String)"ACOS: Out of range test failed, input value is: 2.0");
        }
        catch (SQLException sQLException) {
            MathTrigFunctionsTest.assertSQLState("22003", sQLException);
        }
        try {
            this.getValue(preparedStatement2, 2.0);
            MathTrigFunctionsTest.fail((String)"ACOS: Out of range test failed, input value is: 2.0");
        }
        catch (SQLException sQLException) {
            MathTrigFunctionsTest.assertSQLState("22003", sQLException);
        }
        preparedStatement.close();
        preparedStatement2.close();
    }

    public void testAsin() throws SQLException {
        this.executeNullValues("ASIN");
        this.executeNullFn("ASIN");
        this.debug();
        PreparedStatement preparedStatement = this.prepareStatement("VALUES ASIN(?)");
        PreparedStatement preparedStatement2 = this.prepareStatement("VALUES {fn ASIN(?)}");
        for (int i = 0; i < testArcValues.length; ++i) {
            double d = StrictMath.asin(testArcValues[i]);
            double d2 = this.getValue(preparedStatement, testArcValues[i]);
            this.debug("ASIN: input value: " + testArcValues[i] + " expected value: " + d + " return value: " + d2);
            MathTrigFunctionsTest.assertEquals((double)d, (double)d2, (double)0.0);
            double d3 = this.getValue(preparedStatement2, testArcValues[i]);
            MathTrigFunctionsTest.assertEquals((double)d, (double)d3, (double)0.0);
        }
        Random random = new Random();
        for (int i = 0; i < 100; ++i) {
            double d = random.nextDouble();
            double d4 = StrictMath.asin(d);
            double d5 = this.getValue(preparedStatement, d);
            MathTrigFunctionsTest.assertEquals((double)d4, (double)d5, (double)0.0);
            double d6 = this.getValue(preparedStatement2, d);
            MathTrigFunctionsTest.assertEquals((double)d4, (double)d6, (double)0.0);
        }
        try {
            this.getValue(preparedStatement, 2.0);
            MathTrigFunctionsTest.fail((String)"ASIN: Out of range test failed, input value is: 2.0");
        }
        catch (SQLException sQLException) {
            MathTrigFunctionsTest.assertSQLState("22003", sQLException);
        }
        try {
            this.getValue(preparedStatement2, 2.0);
            MathTrigFunctionsTest.fail((String)"ASIN: Out of range test failed, input value is: 2.0");
        }
        catch (SQLException sQLException) {
            MathTrigFunctionsTest.assertSQLState("22003", sQLException);
        }
        preparedStatement.close();
        preparedStatement2.close();
    }

    public void testAtan() throws SQLException {
        this.executeNullValues("ATAN");
        this.executeNullFn("ATAN");
        this.debug();
        PreparedStatement preparedStatement = this.prepareStatement("VALUES ATAN(?)");
        PreparedStatement preparedStatement2 = this.prepareStatement("VALUES {fn ATAN(?)}");
        for (int i = 0; i < testValues.length; ++i) {
            double d = StrictMath.atan(testValues[i]);
            double d2 = this.getValue(preparedStatement, testValues[i]);
            this.debug("ATAN: input value: " + testValues[i] + " expected value: " + d + " return value: " + d2);
            MathTrigFunctionsTest.assertEquals((double)d, (double)d2, (double)0.0);
            double d3 = this.getValue(preparedStatement2, testValues[i]);
            MathTrigFunctionsTest.assertEquals((double)d, (double)d3, (double)0.0);
        }
        Random random = new Random();
        for (int i = 0; i < 100; ++i) {
            double d = random.nextDouble();
            double d4 = StrictMath.atan(d);
            double d5 = this.getValue(preparedStatement, d);
            MathTrigFunctionsTest.assertEquals((double)d4, (double)d5, (double)0.0);
            double d6 = this.getValue(preparedStatement2, d);
            MathTrigFunctionsTest.assertEquals((double)d4, (double)d6, (double)0.0);
        }
        preparedStatement.close();
        preparedStatement2.close();
    }

    public void testCos() throws SQLException {
        this.executeNullValues("COS");
        this.executeNullFn("COS");
        this.debug();
        PreparedStatement preparedStatement = this.prepareStatement("VALUES COS(?)");
        PreparedStatement preparedStatement2 = this.prepareStatement("VALUES {fn COS(?)}");
        for (int i = 0; i < testValues.length; ++i) {
            double d = StrictMath.cos(testValues[i]);
            double d2 = this.getValue(preparedStatement, testValues[i]);
            this.debug("COS: input value: " + testValues[i] + " expected value: " + d + " return value: " + d2);
            MathTrigFunctionsTest.assertEquals((double)d, (double)d2, (double)0.0);
            double d3 = this.getValue(preparedStatement2, testValues[i]);
            MathTrigFunctionsTest.assertEquals((double)d, (double)d3, (double)0.0);
        }
        Random random = new Random();
        for (int i = 0; i < 100; ++i) {
            double d = random.nextDouble();
            double d4 = StrictMath.cos(d);
            double d5 = this.getValue(preparedStatement, d);
            MathTrigFunctionsTest.assertEquals((double)d4, (double)d5, (double)0.0);
            double d6 = this.getValue(preparedStatement2, d);
            MathTrigFunctionsTest.assertEquals((double)d4, (double)d6, (double)0.0);
        }
        preparedStatement.close();
        preparedStatement2.close();
    }

    public void testSin() throws SQLException {
        this.executeNullValues("SIN");
        this.executeNullFn("SIN");
        this.debug();
        PreparedStatement preparedStatement = this.prepareStatement("VALUES SIN(?)");
        PreparedStatement preparedStatement2 = this.prepareStatement("VALUES {fn SIN(?)}");
        for (int i = 0; i < testValues.length; ++i) {
            double d = StrictMath.sin(testValues[i]);
            double d2 = this.getValue(preparedStatement, testValues[i]);
            this.debug("SIN: input value: " + testValues[i] + " expected value: " + d + " return value: " + d2);
            MathTrigFunctionsTest.assertEquals((double)d, (double)d2, (double)0.0);
            double d3 = this.getValue(preparedStatement2, testValues[i]);
            MathTrigFunctionsTest.assertEquals((double)d, (double)d3, (double)0.0);
        }
        Random random = new Random();
        for (int i = 0; i < 100; ++i) {
            double d = random.nextDouble();
            double d4 = StrictMath.sin(d);
            double d5 = this.getValue(preparedStatement, d);
            MathTrigFunctionsTest.assertEquals((double)d4, (double)d5, (double)0.0);
            double d6 = this.getValue(preparedStatement2, d);
            MathTrigFunctionsTest.assertEquals((double)d4, (double)d6, (double)0.0);
        }
        preparedStatement.close();
        preparedStatement2.close();
    }

    public void testTan() throws SQLException {
        this.executeNullValues("TAN");
        this.executeNullFn("TAN");
        this.debug();
        PreparedStatement preparedStatement = this.prepareStatement("VALUES TAN(?)");
        PreparedStatement preparedStatement2 = this.prepareStatement("VALUES {fn TAN(?)}");
        for (int i = 0; i < testValues.length; ++i) {
            double d = StrictMath.tan(testValues[i]);
            double d2 = this.getValue(preparedStatement, testValues[i]);
            this.debug("TAN: input value: " + testValues[i] + " expected value: " + d + " return value: " + d2);
            MathTrigFunctionsTest.assertEquals((double)d, (double)d2, (double)0.0);
            double d3 = this.getValue(preparedStatement2, testValues[i]);
            MathTrigFunctionsTest.assertEquals((double)d, (double)d3, (double)0.0);
        }
        Random random = new Random();
        for (int i = 0; i < 100; ++i) {
            double d = random.nextDouble();
            double d4 = StrictMath.tan(d);
            double d5 = this.getValue(preparedStatement, d);
            MathTrigFunctionsTest.assertEquals((double)d4, (double)d5, (double)0.0);
            double d6 = this.getValue(preparedStatement2, d);
            MathTrigFunctionsTest.assertEquals((double)d4, (double)d6, (double)0.0);
        }
        preparedStatement.close();
        preparedStatement2.close();
    }

    public void testCot() throws SQLException {
        this.executeNullValues("COT");
        this.executeNullFn("COT");
        this.debug();
        PreparedStatement preparedStatement = this.prepareStatement("VALUES COT(?)");
        PreparedStatement preparedStatement2 = this.prepareStatement("VALUES {fn COT(?)}");
        for (double d : testValues) {
            this.checkResult(preparedStatement, d, 1.0 / StrictMath.tan(d));
        }
        Object object = new Random();
        for (int i = 0; i < 100; ++i) {
            double d = ((Random)object).nextDouble();
            double d2 = 1.0 / StrictMath.tan(d);
            this.checkResult(preparedStatement, d, d2);
            this.checkResult(preparedStatement2, d, d2);
        }
    }

    private void checkResult(PreparedStatement preparedStatement, double d, double d2) throws SQLException {
        if (d2 == -0.0) {
            d2 = 0.0;
        }
        preparedStatement.setDouble(1, d);
        if (Double.isNaN(d2) || Double.isInfinite(d2)) {
            this.debug("input value: " + d + " expected value: " + d2 + " : OUT OF RANGE");
            MathTrigFunctionsTest.assertStatementError("22003", preparedStatement);
        } else {
            this.debug("input value: " + d + " expected value: " + d2);
            JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), String.valueOf(d2));
        }
    }

    public void testCosh() throws SQLException {
        this.executeNullValues("COSH");
        this.debug();
        PreparedStatement preparedStatement = this.prepareStatement("VALUES COSH(?)");
        this.assertCompileError("42X01", "VALUES {fn COSH(?)}");
        for (double d : testValues) {
            this.checkResult(preparedStatement, d, StrictMath.cosh(d));
        }
        Object object = new Random();
        for (int i = 0; i < 100; ++i) {
            double d = ((Random)object).nextDouble();
            double d2 = StrictMath.cosh(d);
            this.checkResult(preparedStatement, d, d2);
        }
    }

    public void testSinh() throws SQLException {
        this.executeNullValues("SINH");
        this.debug();
        PreparedStatement preparedStatement = this.prepareStatement("VALUES SINH(?)");
        this.assertCompileError("42X01", "VALUES {fn SINH(?)}");
        for (double d : testValues) {
            this.checkResult(preparedStatement, d, StrictMath.sinh(d));
        }
        Object object = new Random();
        for (int i = 0; i < 100; ++i) {
            double d = ((Random)object).nextDouble();
            double d2 = StrictMath.sinh(d);
            this.checkResult(preparedStatement, d, d2);
        }
    }

    public void testTanh() throws SQLException {
        this.executeNullValues("TANH");
        this.debug();
        PreparedStatement preparedStatement = this.prepareStatement("VALUES TANH(?)");
        this.assertCompileError("42X01", "VALUES {fn TANH(?)}");
        for (double d : testValues) {
            this.checkResult(preparedStatement, d, StrictMath.tanh(d));
        }
        Object object = new Random();
        for (int i = 0; i < 100; ++i) {
            double d = ((Random)object).nextDouble();
            double d2 = StrictMath.tanh(d);
            this.checkResult(preparedStatement, d, d2);
        }
    }

    public void testPI() throws SQLException {
        double d = this.executeValues("PI");
        MathTrigFunctionsTest.assertEquals((double)Math.PI, (double)d, (double)0.0);
        double d2 = this.executeFn("PI");
        MathTrigFunctionsTest.assertEquals((double)Math.PI, (double)d2, (double)0.0);
        try {
            this.executeValues("PI", 2.0);
            MathTrigFunctionsTest.fail((String)"PI: Out of range test failed, input value is: 2.0");
        }
        catch (SQLException sQLException) {
            MathTrigFunctionsTest.assertSQLState("42Y03", sQLException);
        }
        try {
            this.executeFn("PI", 2.0);
            MathTrigFunctionsTest.fail((String)"PI: Out of range test failed, input value is: 2.0");
        }
        catch (SQLException sQLException) {
            MathTrigFunctionsTest.assertSQLState("42Y03", sQLException);
        }
    }

    public void testDegrees() throws SQLException {
        this.executeNullValues("DEGREES");
        this.executeNullFn("DEGREES");
        this.debug();
        PreparedStatement preparedStatement = this.prepareStatement("VALUES DEGREES(?)");
        PreparedStatement preparedStatement2 = this.prepareStatement("VALUES {fn DEGREES(?)}");
        for (int i = 0; i < testRadians.length; ++i) {
            double d = StrictMath.toDegrees(testRadians[i]);
            double d2 = this.getValue(preparedStatement, testRadians[i]);
            this.debug("DEGREES: input value: " + testRadians[i] + " expected value: " + d + " return value: " + d2);
            MathTrigFunctionsTest.assertEquals((double)d, (double)d2, (double)0.0);
            double d3 = this.getValue(preparedStatement2, testRadians[i]);
            MathTrigFunctionsTest.assertEquals((double)d, (double)d3, (double)0.0);
        }
        Random random = new Random();
        for (int i = 0; i < 100; ++i) {
            double d = random.nextDouble();
            double d4 = StrictMath.toDegrees(d);
            double d5 = this.getValue(preparedStatement, d);
            MathTrigFunctionsTest.assertEquals((double)d4, (double)d5, (double)0.0);
            double d6 = this.getValue(preparedStatement2, d);
            MathTrigFunctionsTest.assertEquals((double)d4, (double)d6, (double)0.0);
        }
        try {
            this.getValue(preparedStatement, -1.79769E308);
            MathTrigFunctionsTest.fail((String)"DEGREES: Out of range test failed, input value is: -1.79769E308");
        }
        catch (SQLException sQLException) {
            MathTrigFunctionsTest.assertSQLState("22003", sQLException);
        }
        try {
            this.getValue(preparedStatement2, -1.79769E308);
            MathTrigFunctionsTest.fail((String)"DEGREES: Out of range test failed, input value is: -1.79769E308");
        }
        catch (SQLException sQLException) {
            MathTrigFunctionsTest.assertSQLState("22003", sQLException);
        }
        preparedStatement.close();
        preparedStatement2.close();
    }

    public void testRadians() throws SQLException {
        double d;
        this.executeNullValues("RADIANS");
        this.executeNullFn("RADIANS");
        this.debug();
        PreparedStatement preparedStatement = this.prepareStatement("VALUES RADIANS(?)");
        PreparedStatement preparedStatement2 = this.prepareStatement("VALUES {fn RADIANS(?)}");
        for (int i = 0; i < testArcValues.length; ++i) {
            double d2 = StrictMath.toRadians(testArcValues[i]);
            d = this.getValue(preparedStatement, testArcValues[i]);
            this.debug("RADIANS: input value: " + testArcValues[i] + " expected value: " + d2 + " return value: " + d);
            MathTrigFunctionsTest.assertEquals((double)d2, (double)d, (double)0.0);
            double d3 = this.getValue(preparedStatement2, testArcValues[i]);
            MathTrigFunctionsTest.assertEquals((double)d2, (double)d3, (double)0.0);
        }
        Random random = new Random();
        for (int i = 0; i < 100; ++i) {
            double d4 = random.nextDouble();
            double d5 = StrictMath.toRadians(d4);
            double d6 = this.getValue(preparedStatement, d4);
            MathTrigFunctionsTest.assertEquals((double)d5, (double)d6, (double)0.0);
            double d7 = this.getValue(preparedStatement2, d4);
            MathTrigFunctionsTest.assertEquals((double)d5, (double)d7, (double)0.0);
        }
        double[][] dArrayArray = new double[][]{{180.0, Math.PI}, {-1.79769E308, -3.1375609430176863E306}, {Double.MIN_NORMAL, 3.8834864931005E-310}, {Double.MIN_VALUE, 0.0}, {Double.MAX_VALUE, 3.1375664143845866E306}, {2.225E-307, MathTrigFunctionsTest.vmAtLeast(1, 9) ? 3.883357585687384E-309 : 3.88335758568738E-309}, {-2.225E-307, MathTrigFunctionsTest.vmAtLeast(1, 9) ? -3.883357585687384E-309 : -3.88335758568738E-309}};
        for (int i = 0; i < dArrayArray.length; ++i) {
            d = this.getValue(preparedStatement, dArrayArray[i][0]);
            MathTrigFunctionsTest.assertEquals((double)dArrayArray[i][1], (double)d, (double)0.0);
            d = this.getValue(preparedStatement2, dArrayArray[i][0]);
            MathTrigFunctionsTest.assertEquals((double)dArrayArray[i][1], (double)d, (double)0.0);
        }
        preparedStatement.close();
        preparedStatement2.close();
    }

    public void testExp() throws SQLException {
        this.executeNullValues("EXP");
        this.executeNullFn("EXP");
        this.debug();
        PreparedStatement preparedStatement = this.prepareStatement("VALUES EXP(?)");
        PreparedStatement preparedStatement2 = this.prepareStatement("VALUES {fn EXP(?)}");
        for (int i = 0; i < testValuesTwo.length; ++i) {
            double d = StrictMath.exp(testValuesTwo[i]);
            double d2 = this.getValue(preparedStatement, testValuesTwo[i]);
            this.debug("EXP: input value: " + testValuesTwo[i] + " expected value: " + d + " return value: " + d2);
            MathTrigFunctionsTest.assertEquals((double)d, (double)d2, (double)0.0);
            double d3 = this.getValue(preparedStatement2, testValuesTwo[i]);
            MathTrigFunctionsTest.assertEquals((double)d, (double)d3, (double)0.0);
        }
        Random random = new Random();
        for (int i = 0; i < 100; ++i) {
            double d = random.nextDouble();
            double d4 = StrictMath.exp(d);
            double d5 = this.getValue(preparedStatement, d);
            MathTrigFunctionsTest.assertEquals((double)d4, (double)d5, (double)0.0);
            double d6 = this.getValue(preparedStatement2, d);
            MathTrigFunctionsTest.assertEquals((double)d4, (double)d6, (double)0.0);
        }
        try {
            this.getValue(preparedStatement, 1.79769E308);
            MathTrigFunctionsTest.fail((String)"EXP: Out of range test failed, input value is: 1.79769E308");
        }
        catch (SQLException sQLException) {
            MathTrigFunctionsTest.assertSQLState("22003", sQLException);
        }
        try {
            this.getValue(preparedStatement2, 1.79769E308);
            MathTrigFunctionsTest.fail((String)"EXP: Out of range test failed, input value is: 1.79769E308");
        }
        catch (SQLException sQLException) {
            MathTrigFunctionsTest.assertSQLState("22003", sQLException);
        }
        preparedStatement.close();
        preparedStatement2.close();
    }

    public void testLog10() throws SQLException {
        this.executeNullValues("LOG10");
        this.executeNullFn("LOG10");
        this.debug();
        PreparedStatement preparedStatement = this.prepareStatement("VALUES LOG10(?)");
        PreparedStatement preparedStatement2 = this.prepareStatement("VALUES {fn LOG10(?)}");
        for (int i = 0; i < logValues.length; ++i) {
            double d = StrictMath.log10(logValues[i]);
            double d2 = this.getValue(preparedStatement, logValues[i]);
            this.debug("LOG10: input value: " + logValues[i] + " expected value: " + d + " return value: " + d2);
            MathTrigFunctionsTest.assertEquals((double)d, (double)d2, (double)0.0);
            double d3 = this.getValue(preparedStatement2, logValues[i]);
            MathTrigFunctionsTest.assertEquals((double)d, (double)d3, (double)0.0);
        }
        Random random = new Random();
        for (int i = 0; i < 100; ++i) {
            double d = random.nextDouble();
            double d4 = StrictMath.log10(d);
            double d5 = this.getValue(preparedStatement, d);
            MathTrigFunctionsTest.assertEquals((double)d4, (double)d5, (double)0.0);
            double d6 = this.getValue(preparedStatement2, d);
            MathTrigFunctionsTest.assertEquals((double)d4, (double)d6, (double)0.0);
        }
        try {
            this.getValue(preparedStatement, 0.0);
            MathTrigFunctionsTest.fail((String)"LOG10: Out of range test failed, input value is: 0.0");
        }
        catch (SQLException sQLException) {
            MathTrigFunctionsTest.assertSQLState("22003", sQLException);
        }
        try {
            this.getValue(preparedStatement, -1.0);
            MathTrigFunctionsTest.fail((String)"LOG10: Out of range test failed, input value is: -1.0");
        }
        catch (SQLException sQLException) {
            MathTrigFunctionsTest.assertSQLState("22003", sQLException);
        }
        try {
            this.getValue(preparedStatement2, 0.0);
            MathTrigFunctionsTest.fail((String)"LOG10: Out of range test failed, input value is: 0.0");
        }
        catch (SQLException sQLException) {
            MathTrigFunctionsTest.assertSQLState("22003", sQLException);
        }
        try {
            this.getValue(preparedStatement2, -1.0);
            MathTrigFunctionsTest.fail((String)"LOG10: Out of range test failed, input value is: -1.0");
        }
        catch (SQLException sQLException) {
            MathTrigFunctionsTest.assertSQLState("22003", sQLException);
        }
        preparedStatement.close();
        preparedStatement2.close();
    }

    public void testLog() throws SQLException {
        this.executeNullValues("LOG");
        this.executeNullFn("LOG");
        this.debug();
        PreparedStatement preparedStatement = this.prepareStatement("VALUES LOG(?)");
        PreparedStatement preparedStatement2 = this.prepareStatement("VALUES {fn LOG(?)}");
        for (int i = 0; i < logValues.length; ++i) {
            double d = StrictMath.log(logValues[i]);
            double d2 = this.getValue(preparedStatement, logValues[i]);
            this.debug("LOG: input value: " + logValues[i] + " expected value: " + d + " return value: " + d2);
            MathTrigFunctionsTest.assertEquals((double)d, (double)d2, (double)0.0);
            double d3 = this.getValue(preparedStatement2, logValues[i]);
            MathTrigFunctionsTest.assertEquals((double)d, (double)d3, (double)0.0);
        }
        Random random = new Random();
        for (int i = 0; i < 100; ++i) {
            double d = random.nextDouble();
            double d4 = StrictMath.log(d);
            double d5 = this.getValue(preparedStatement, d);
            MathTrigFunctionsTest.assertEquals((double)d4, (double)d5, (double)0.0);
            double d6 = this.getValue(preparedStatement2, d);
            MathTrigFunctionsTest.assertEquals((double)d4, (double)d6, (double)0.0);
        }
        try {
            this.getValue(preparedStatement, 0.0);
            MathTrigFunctionsTest.fail((String)"LOG: Out of range test failed, input value is: 0.0");
        }
        catch (SQLException sQLException) {
            MathTrigFunctionsTest.assertSQLState("22003", sQLException);
        }
        try {
            this.getValue(preparedStatement2, 0.0);
            MathTrigFunctionsTest.fail((String)"LOG: Out of range test failed, input value is: 0.0");
        }
        catch (SQLException sQLException) {
            MathTrigFunctionsTest.assertSQLState("22003", sQLException);
        }
        preparedStatement.close();
        preparedStatement2.close();
    }

    public void testLn() throws SQLException {
        this.executeNullValues("LN");
        this.debug();
        PreparedStatement preparedStatement = this.prepareStatement("VALUES LN(?)");
        for (int i = 0; i < logValues.length; ++i) {
            double d = StrictMath.log(logValues[i]);
            double d2 = this.getValue(preparedStatement, logValues[i]);
            this.debug("LOG: input value: " + logValues[i] + " expected value: " + d + " return value: " + d2);
            MathTrigFunctionsTest.assertEquals((double)d, (double)d2, (double)0.0);
        }
        Random random = new Random();
        for (int i = 0; i < 100; ++i) {
            double d = random.nextDouble();
            double d3 = StrictMath.log(d);
            double d4 = this.getValue(preparedStatement, d);
            MathTrigFunctionsTest.assertEquals((double)d3, (double)d4, (double)0.0);
        }
        try {
            this.getValue(preparedStatement, 0.0);
            MathTrigFunctionsTest.fail((String)"LOG: Out of range test failed, input value is: 0.0");
        }
        catch (SQLException sQLException) {
            MathTrigFunctionsTest.assertSQLState("22003", sQLException);
        }
        preparedStatement.close();
    }

    public void testCeil() throws SQLException {
        this.executeNullValues("CEIL");
        this.debug();
        PreparedStatement preparedStatement = this.prepareStatement("VALUES CEIL(?)");
        for (int i = 0; i < testValues.length; ++i) {
            double d = StrictMath.ceil(testValues[i]);
            double d2 = this.getValue(preparedStatement, testValues[i]);
            this.debug("CEIL: input value: " + testValues[i] + " expected value: " + d + " return value: " + d2);
            MathTrigFunctionsTest.assertEquals((double)d, (double)d2, (double)0.0);
        }
        Random random = new Random();
        for (int i = 0; i < 100; ++i) {
            double d = random.nextDouble();
            double d3 = StrictMath.ceil(d);
            double d4 = this.getValue(preparedStatement, d);
            MathTrigFunctionsTest.assertEquals((double)d3, (double)d4, (double)0.0);
        }
        preparedStatement.close();
    }

    public void testCeiling() throws SQLException {
        this.executeNullValues("CEILING");
        this.executeNullFn("CEILING");
        PreparedStatement preparedStatement = this.prepareStatement("VALUES CEILING(?)");
        PreparedStatement preparedStatement2 = this.prepareStatement("VALUES {fn CEILING(?)}");
        this.debug();
        for (int i = 0; i < testValues.length; ++i) {
            double d = StrictMath.ceil(testValues[i]);
            double d2 = this.getValue(preparedStatement, testValues[i]);
            this.debug("CEILING: input value: " + testValues[i] + " expected value: " + d + " return value: " + d2);
            MathTrigFunctionsTest.assertEquals((double)d, (double)d2, (double)0.0);
            double d3 = this.getValue(preparedStatement2, testValues[i]);
            MathTrigFunctionsTest.assertEquals((double)d, (double)d3, (double)0.0);
        }
        Random random = new Random();
        for (int i = 0; i < 100; ++i) {
            double d = random.nextDouble();
            double d4 = StrictMath.ceil(d);
            double d5 = this.getValue(preparedStatement, d);
            MathTrigFunctionsTest.assertEquals((double)d4, (double)d5, (double)0.0);
            double d6 = this.getValue(preparedStatement2, d);
            MathTrigFunctionsTest.assertEquals((double)d4, (double)d6, (double)0.0);
        }
        preparedStatement.close();
        preparedStatement2.close();
    }

    public void testFloor() throws SQLException {
        this.executeNullValues("FLOOR");
        this.executeNullFn("FLOOR");
        this.debug();
        PreparedStatement preparedStatement = this.prepareStatement("VALUES FLOOR(?)");
        PreparedStatement preparedStatement2 = this.prepareStatement("VALUES {fn FLOOR(?)}");
        for (int i = 0; i < testValues.length; ++i) {
            double d = StrictMath.floor(testValues[i]);
            double d2 = this.getValue(preparedStatement, testValues[i]);
            this.debug("FLOOR: input value: " + testValues[i] + " expected value: " + d + " return value: " + d2);
            MathTrigFunctionsTest.assertEquals((double)d, (double)d2, (double)0.0);
            double d3 = this.getValue(preparedStatement2, testValues[i]);
            MathTrigFunctionsTest.assertEquals((double)d, (double)d3, (double)0.0);
        }
        Random random = new Random();
        for (int i = 0; i < 100; ++i) {
            double d = random.nextDouble();
            double d4 = StrictMath.floor(d);
            double d5 = this.getValue(preparedStatement, d);
            MathTrigFunctionsTest.assertEquals((double)d4, (double)d5, (double)0.0);
            double d6 = this.getValue(preparedStatement2, d);
            MathTrigFunctionsTest.assertEquals((double)d4, (double)d6, (double)0.0);
        }
        preparedStatement.close();
        preparedStatement2.close();
    }

    private double executeValues(String string) throws SQLException {
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("values " + string + "()");
        double d = 0.0;
        while (resultSet.next()) {
            d = resultSet.getDouble(1);
        }
        resultSet.close();
        statement.close();
        return d;
    }

    private double executeValues(String string, double d) throws SQLException {
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("values " + string + "(" + d + ")");
        double d2 = 0.0;
        while (resultSet.next()) {
            d2 = resultSet.getDouble(1);
        }
        resultSet.close();
        statement.close();
        return d2;
    }

    private double getValue(PreparedStatement preparedStatement, double d) throws SQLException {
        preparedStatement.setDouble(1, d);
        ResultSet resultSet = preparedStatement.executeQuery();
        resultSet.next();
        double d2 = resultSet.getDouble(1);
        resultSet.close();
        return d2;
    }

    private void executeNullValues(String string) throws SQLException {
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("values " + string + "(null)");
        resultSet.next();
        MathTrigFunctionsTest.assertNull((Object)resultSet.getObject(1));
        MathTrigFunctionsTest.assertTrue((boolean)resultSet.wasNull());
        resultSet.close();
        statement.close();
    }

    private double executeFn(String string) throws SQLException {
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("values {fn " + string + "()}");
        double d = 0.0;
        while (resultSet.next()) {
            d = resultSet.getDouble(1);
        }
        resultSet.close();
        statement.close();
        return d;
    }

    private double executeFn(String string, double d) throws SQLException {
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("values {fn  " + string + "(" + d + ")}");
        double d2 = 0.0;
        while (resultSet.next()) {
            d2 = resultSet.getDouble(1);
        }
        resultSet.close();
        statement.close();
        return d2;
    }

    private void executeNullFn(String string) throws SQLException {
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("values {fn  " + string + "(null)}");
        resultSet.next();
        MathTrigFunctionsTest.assertNull((Object)resultSet.getObject(1));
        MathTrigFunctionsTest.assertTrue((boolean)resultSet.wasNull());
        resultSet.close();
        statement.close();
    }

    private void debug(String string) {
        MathTrigFunctionsTest.println(string);
    }

    private void debug() {
        MathTrigFunctionsTest.println("");
    }

    public MathTrigFunctionsTest(String string) {
        super(string);
    }

    public static Test suite() {
        return TestConfiguration.defaultSuite(MathTrigFunctionsTest.class);
    }
}

