/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.unitTests.store;

import java.util.Properties;
import org.apache.derby.iapi.db.Database;
import org.apache.derby.iapi.services.context.Context;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.store.access.AccessFactory;
import org.apache.derby.iapi.store.access.ColumnOrdering;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.Qualifier;
import org.apache.derby.iapi.store.access.RowUtil;
import org.apache.derby.iapi.store.access.ScanController;
import org.apache.derby.iapi.store.access.ScanInfo;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.store.access.conglomerate.TransactionManager;
import org.apache.derby.iapi.store.raw.LockingPolicy;
import org.apache.derby.iapi.store.raw.RawStoreFactory;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.iapi.types.SQLChar;
import org.apache.derby.iapi.types.SQLLongint;
import org.apache.derby.impl.store.access.btree.BTree;
import org.apache.derby.impl.store.access.btree.index.B2I;
import org.apache.derby.impl.store.access.btree.index.B2IController;
import org.apache.derby.impl.store.access.btree.index.B2IForwardScan;
import org.apache.derby.impl.store.access.conglomerate.TemplateRow;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.i18n.MessageService;
import org.apache.derbyTesting.unitTests.harness.T_Fail;
import org.apache.derbyTesting.unitTests.harness.T_MultiIterations;
import org.apache.derbyTesting.unitTests.store.T_ColumnOrderingImpl;
import org.apache.derbyTesting.unitTests.store.T_CreateConglomRet;
import org.apache.derbyTesting.unitTests.store.T_QualifierTest;
import org.apache.derbyTesting.unitTests.store.T_SecondaryIndexRow;
import org.apache.derbyTesting.unitTests.store.T_Util;

public class T_b2i
extends T_MultiIterations {
    private static final String testService = "b2iTest";
    private Object store_module = null;
    private ContextService contextService = null;

    @Override
    protected void setupTest() throws T_Fail {
        if (this.startParams == null) {
            this.startParams = new Properties();
        }
        this.startParams.put("derby.database.noAutoBoot", Boolean.TRUE.toString());
        this.startParams.put("derby.__deleteOnCreate", Boolean.TRUE.toString());
        this.startParams = T_Util.setEncryptionParam(this.startParams);
        try {
            this.store_module = T_b2i.createPersistentService(this.getModuleToTestProtocolName(), testService, this.startParams);
            this.contextService = T_b2i.getContextService();
        }
        catch (StandardException standardException) {
            throw T_Fail.exceptionFail(standardException);
        }
    }

    @Override
    public String getModuleToTestProtocolName() {
        return "org.apache.derby.iapi.store.access.AccessFactory";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void runTestSet() throws T_Fail {
        AccessFactory accessFactory = null;
        TransactionController transactionController = null;
        boolean bl = false;
        this.out.println("executing b2i test");
        accessFactory = (AccessFactory)this.store_module;
        if (accessFactory == null) {
            throw T_Fail.testFailMsg(this.getModuleToTestProtocolName() + " service not started.");
        }
        ContextManager contextManager = this.contextService.newContextManager();
        this.contextService.setCurrentContextManager(contextManager);
        this.REPORT("(unitTestMain) Testing b2iTest");
        try {
            transactionController = accessFactory.getTransaction(contextManager);
            bl = true;
            if (this.t_005(transactionController) && this.t_001(transactionController) && this.t_003(transactionController) && this.t_004(transactionController) && this.t_005(transactionController) && this.t_006(transactionController) && this.t_009(transactionController) && this.t_010(transactionController) && this.t_011(transactionController) && this.t_012(transactionController) && this.t_013(transactionController) && this.t_014(transactionController) && this.t_017(transactionController) && this.t_018(transactionController) && this.t_019(transactionController) && this.t_020(transactionController) && this.t_021(transactionController)) {
                bl = true;
            }
            transactionController.commit();
            transactionController.destroy();
        }
        catch (StandardException standardException) {
            String string = standardException.getMessage();
            if (string == null) {
                string = ((Object)((Object)standardException)).getClass().getName();
            }
            this.REPORT(string);
            standardException.printStackTrace(this.out.getPrintWriter());
            contextManager.cleanupOnError((Throwable)standardException, this.isdbActive());
            bl = false;
        }
        catch (Throwable throwable) {
            String string = throwable.getMessage();
            if (string == null) {
                string = throwable.getClass().getName();
            }
            this.REPORT(string);
            throwable.printStackTrace(this.out.getPrintWriter());
            contextManager.cleanupOnError(throwable, this.isdbActive());
            bl = false;
        }
        finally {
            this.contextService.resetCurrentContextManager(contextManager);
        }
        if (!bl) {
            throw T_Fail.testFailMsg("");
        }
    }

    void createCongloms(TransactionController transactionController, int n, boolean bl, boolean bl2, int n2, T_CreateConglomRet t_CreateConglomRet) throws StandardException {
        T_SecondaryIndexRow t_SecondaryIndexRow = new T_SecondaryIndexRow();
        DataValueDescriptor[] dataValueDescriptorArray = TemplateRow.newU8Row((int)n);
        if (bl2) {
            SQLChar sQLChar = new SQLChar();
            dataValueDescriptorArray[0] = sQLChar;
        }
        long l = 0L;
        l = transactionController.createConglomerate("heap", dataValueDescriptorArray, null, null, null, 0);
        ConglomerateController conglomerateController = transactionController.openConglomerate(l, false, 4, 6, 5);
        RowLocation rowLocation = conglomerateController.newRowLocationTemplate();
        t_SecondaryIndexRow.init(dataValueDescriptorArray, rowLocation, n + 1);
        Properties properties = T_b2i.createProperties(null, false, n + 1, bl ? n : n + 1, true, l, n);
        if (n2 > 1 && BTree.PROPERTY_MAX_ROWS_PER_PAGE_PARAMETER != null) {
            properties.put(BTree.PROPERTY_MAX_ROWS_PER_PAGE_PARAMETER, String.valueOf(n2));
        }
        long l2 = transactionController.createConglomerate("BTREE", t_SecondaryIndexRow.getRow(), null, null, properties, 0);
        t_CreateConglomRet.base_conglomid = l;
        t_CreateConglomRet.index_conglomid = l2;
        t_CreateConglomRet.index_template_row = t_SecondaryIndexRow.getRow();
    }

    protected static Properties createProperties(Properties properties, boolean bl, int n, int n2, boolean bl2, long l, int n3) throws StandardException {
        Properties properties2 = properties == null ? new Properties() : properties;
        properties2.put("allowDuplicates", String.valueOf(bl));
        properties2.put("nKeyFields", String.valueOf(n));
        properties2.put("nUniqueColumns", String.valueOf(n2));
        properties2.put("maintainParentLinks", String.valueOf(bl2));
        properties2.put("baseConglomerateId", String.valueOf(l));
        properties2.put("rowLocationColumn", String.valueOf(n3));
        return properties2;
    }

    protected boolean t_scan(TransactionController transactionController, long l, DataValueDescriptor[] dataValueDescriptorArray, DataValueDescriptor[] dataValueDescriptorArray2, int n, Qualifier[][] qualifierArray, DataValueDescriptor[] dataValueDescriptorArray3, int n2, int n3, int n4) throws StandardException {
        ScanController scanController = transactionController.openScan(l, false, 4, 6, 5, (FormatableBitSet)null, dataValueDescriptorArray2, n, qualifierArray, dataValueDescriptorArray3, n2);
        long l2 = -42L;
        long l3 = 0L;
        while (scanController.next()) {
            scanController.fetch(dataValueDescriptorArray);
            l2 = ((SQLLongint)dataValueDescriptorArray[2]).getLong();
            if (l2 != (long)n4) {
                return this.FAIL("(t_scan) wrong key, expected (" + n4 + ")but got (" + l2 + ").");
            }
            ++n4;
            ++l3;
        }
        ((B2IForwardScan)scanController).checkConsistency();
        scanController.close();
        if (l3 != (long)n3) {
            return this.FAIL("(t_scan) wrong number of rows. Expected " + n3 + " rows, but got " + l3 + "rows.");
        }
        return true;
    }

    protected boolean t_delete(TransactionController transactionController, long l, DataValueDescriptor[] dataValueDescriptorArray, boolean bl) throws StandardException {
        SQLLongint sQLLongint = new SQLLongint(-1L);
        SQLLongint sQLLongint2 = new SQLLongint(-1L);
        int n = 4;
        if (bl) {
            n |= 0x1000;
        }
        ScanController scanController = transactionController.openScan(l, false, n, 6, 5, (FormatableBitSet)null, dataValueDescriptorArray, 1, null, dataValueDescriptorArray, -1);
        long l2 = ((SQLLongint)dataValueDescriptorArray[1]).getLong();
        int n2 = 0;
        DataValueDescriptor[] dataValueDescriptorArray2 = new DataValueDescriptor[]{sQLLongint, sQLLongint2};
        while (scanController.next()) {
            ++n2;
            scanController.fetch(dataValueDescriptorArray2);
            if (sQLLongint.getLong() != 1L) {
                return this.FAIL("(t_delete) column[0] value is not 1");
            }
            if (sQLLongint2.getLong() != l2) {
                return this.FAIL("(t_delete) column[1]  value is not " + l2);
            }
            if (!scanController.delete()) {
                return this.FAIL("(t_delete): delete of row failed");
            }
            if (!scanController.delete()) continue;
            return this.FAIL("(t_delete): re-delete of row succeeded");
        }
        scanController.close();
        if (n2 != 1) {
            return this.FAIL("(t_delete) wrong number of rows. Expected 1 row, but got " + n2 + "rows.");
        }
        return true;
    }

    protected boolean t_001(TransactionController transactionController) throws StandardException, T_Fail {
        this.REPORT("Starting t_001");
        T_CreateConglomRet t_CreateConglomRet = new T_CreateConglomRet();
        this.createCongloms(transactionController, 2, false, false, 0, t_CreateConglomRet);
        ConglomerateController conglomerateController = transactionController.openConglomerate(t_CreateConglomRet.base_conglomid, false, 4, 6, 5);
        ConglomerateController conglomerateController2 = transactionController.openConglomerate(t_CreateConglomRet.index_conglomid, false, 4, 6, 5);
        if (!(conglomerateController2 instanceof B2IController)) {
            throw T_Fail.testFailMsg("openConglomerate returned wrong type");
        }
        if (!conglomerateController2.isKeyed()) {
            throw T_Fail.testFailMsg("btree is not keyed.");
        }
        conglomerateController2.checkConsistency();
        DataValueDescriptor[] dataValueDescriptorArray = TemplateRow.newU8Row((int)2);
        T_SecondaryIndexRow t_SecondaryIndexRow = new T_SecondaryIndexRow();
        RowLocation rowLocation = conglomerateController.newRowLocationTemplate();
        t_SecondaryIndexRow.init(dataValueDescriptorArray, rowLocation, 3);
        ((SQLLongint)dataValueDescriptorArray[0]).setValue(2);
        ((SQLLongint)dataValueDescriptorArray[1]).setValue(2);
        conglomerateController.insertAndFetchLocation(dataValueDescriptorArray, rowLocation);
        if (conglomerateController2.insert(t_SecondaryIndexRow.getRow()) != 0) {
            throw T_Fail.testFailMsg("insert failed");
        }
        DataValueDescriptor[] dataValueDescriptorArray2 = TemplateRow.newU8Row((int)2);
        T_SecondaryIndexRow t_SecondaryIndexRow2 = new T_SecondaryIndexRow();
        RowLocation rowLocation2 = conglomerateController.newRowLocationTemplate();
        t_SecondaryIndexRow2.init(dataValueDescriptorArray2, rowLocation2, 3);
        if (!conglomerateController.fetch(rowLocation, dataValueDescriptorArray2, (FormatableBitSet)null)) {
            return this.FAIL("(t_001) insert into base table failed");
        }
        if (((SQLLongint)dataValueDescriptorArray2[0]).getLong() != 2L || ((SQLLongint)dataValueDescriptorArray2[1]).getLong() != 2L) {
            return this.FAIL("(t_001) insert into base table failed");
        }
        ScanController scanController = transactionController.openScan(t_CreateConglomRet.index_conglomid, false, 4, 6, 5, (FormatableBitSet)null, null, 0, null, null, 0);
        scanController.next();
        scanController.fetch(t_SecondaryIndexRow2.getRow());
        if (scanController.isCurrentPositionDeleted()) {
            throw T_Fail.testFailMsg("current row should not be deleted\n");
        }
        if (!scanController.doesCurrentPositionQualify()) {
            throw T_Fail.testFailMsg("current row should still qualify\n");
        }
        scanController.delete();
        if (!scanController.isCurrentPositionDeleted()) {
            throw T_Fail.testFailMsg("current row should be deleted\n");
        }
        if (scanController.doesCurrentPositionQualify()) {
            throw T_Fail.testFailMsg("deleted row should not qualify\n");
        }
        this.REPORT("Calling scan.tostring(): " + String.valueOf(scanController));
        if (scanController.next() || ((SQLLongint)t_SecondaryIndexRow2.getRow()[0]).getLong() != 2L || ((SQLLongint)t_SecondaryIndexRow2.getRow()[1]).getLong() != 2L) {
            return this.FAIL("(t_001) insert into index failed in base cols");
        }
        ScanInfo scanInfo = scanController.getScanInfo();
        Properties properties = scanInfo.getAllScanInfo(null);
        if (Integer.parseInt(properties.getProperty(MessageService.getTextMessage((String)"XSAJ1.U", (Object[])new Object[0]))) != 1) {
            throw T_Fail.testFailMsg("(scanInfo) wrong numPagesVisited.  Expected 1, got " + Integer.parseInt(properties.getProperty(MessageService.getTextMessage((String)"XSAJ1.U", (Object[])new Object[0]))));
        }
        if (Integer.parseInt(properties.getProperty(MessageService.getTextMessage((String)"XSAJ2.U", (Object[])new Object[0]))) != 1) {
            throw T_Fail.testFailMsg("(scanInfo) wrong numRowsVisited. Expected 1, got " + Integer.parseInt(properties.getProperty(MessageService.getTextMessage((String)"XSAJ2.U", (Object[])new Object[0]))));
        }
        if (Integer.parseInt(properties.getProperty(MessageService.getTextMessage((String)"XSAJ4.U", (Object[])new Object[0]))) != 1) {
            throw T_Fail.testFailMsg("(scanInfo) wrong numRowsQualified. Expected 1, got " + Integer.parseInt(properties.getProperty(MessageService.getTextMessage((String)"XSAJ4.U", (Object[])new Object[0]))));
        }
        int n = rowLocation.compare((DataValueDescriptor)rowLocation2);
        if (n != 0) {
            return this.FAIL("(t_001) insert into index failed in recordhandle.\n\texpected RecordHandle = " + String.valueOf(rowLocation) + "\n\tgot      RecordHandle = " + String.valueOf(rowLocation2) + "\tcompare result = " + n);
        }
        conglomerateController2.checkConsistency();
        conglomerateController.close();
        conglomerateController2.close();
        try {
            conglomerateController.insert(dataValueDescriptorArray);
            return this.FAIL("(t_001) insert on closed conglomerate worked");
        }
        catch (StandardException standardException) {
            try {
                if (conglomerateController2.insert(dataValueDescriptorArray) != 0) {
                    throw T_Fail.testFailMsg("insert failed");
                }
                return this.FAIL("(t_001) insert on closed conglomerate worked");
            }
            catch (StandardException standardException2) {
                transactionController.commit();
                this.REPORT("Ending t_001");
                return true;
            }
        }
    }

    protected boolean t_002(TransactionController transactionController) throws StandardException, T_Fail {
        int n;
        ScanController scanController = null;
        this.REPORT("Starting t_002");
        T_CreateConglomRet t_CreateConglomRet = new T_CreateConglomRet();
        this.createCongloms(transactionController, 2, false, false, 2, t_CreateConglomRet);
        ConglomerateController conglomerateController = transactionController.openConglomerate(t_CreateConglomRet.base_conglomid, false, 4, 6, 5);
        ConglomerateController conglomerateController2 = transactionController.openConglomerate(t_CreateConglomRet.index_conglomid, false, 4, 6, 5);
        if (!(conglomerateController2 instanceof B2IController)) {
            throw T_Fail.testFailMsg("openConglomerate returned wrong type");
        }
        conglomerateController2.checkConsistency();
        DataValueDescriptor[] dataValueDescriptorArray = TemplateRow.newU8Row((int)2);
        T_SecondaryIndexRow t_SecondaryIndexRow = new T_SecondaryIndexRow();
        RowLocation rowLocation = conglomerateController.newRowLocationTemplate();
        t_SecondaryIndexRow.init(dataValueDescriptorArray, rowLocation, 3);
        transactionController.commit();
        String[] stringArray = new String[]{"leaf_split_growRoot1", "leaf_split_growRoot2", "leaf_split_growRoot3", "leaf_split_growRoot4", "leaf_split_growRoot5", "leaf_split_abort1", "leaf_split_abort2", "leaf_split_abort3", "leaf_split_abort4", "branch_split_abort1", "branch_split_abort2", "branch_split_abort3", "branch_split_abort4", "BTreeController_doIns2"};
        for (n = 0; n < stringArray.length; ++n) {
            this.REPORT("Doing abort test: " + stringArray[n]);
            try {
                conglomerateController = transactionController.openConglomerate(t_CreateConglomRet.base_conglomid, false, 4, 6, 5);
                conglomerateController2 = transactionController.openConglomerate(t_CreateConglomRet.index_conglomid, false, 4, 6, 5);
                ((SQLLongint)dataValueDescriptorArray[0]).setValue(2);
                ((SQLLongint)dataValueDescriptorArray[1]).setValue(10000 + n);
                conglomerateController.insertAndFetchLocation(dataValueDescriptorArray, rowLocation);
                if (conglomerateController2.insert(t_SecondaryIndexRow.getRow()) != 0) {
                    throw T_Fail.testFailMsg("insert failed");
                }
                for (int i = 100; i > 0; i -= 2) {
                    ((SQLLongint)dataValueDescriptorArray[0]).setValue(2);
                    ((SQLLongint)dataValueDescriptorArray[1]).setValue(i);
                    conglomerateController.insertAndFetchLocation(dataValueDescriptorArray, rowLocation);
                    if (conglomerateController2.insert(t_SecondaryIndexRow.getRow()) == 0) continue;
                    throw T_Fail.testFailMsg("insert failed");
                }
                throw T_Fail.testFailMsg("debug flag (" + stringArray[n] + ")did not cause exception.");
            }
            catch (StandardException standardException) {
                ContextService contextService = T_b2i.getContextService();
                ContextManager contextManager = contextService.getCurrentContextManager();
                contextManager.cleanupOnError((Throwable)standardException, this.isdbActive());
                scanController = transactionController.openScan(t_CreateConglomRet.index_conglomid, false, 4, 6, 5, (FormatableBitSet)null, null, 0, null, null, 0);
                conglomerateController2 = transactionController.openConglomerate(t_CreateConglomRet.index_conglomid, false, 4, 6, 5);
                conglomerateController2.checkConsistency();
                conglomerateController2.close();
                if (scanController.next()) {
                    throw T_Fail.testFailMsg("t_002: there are still rows in table.");
                }
                scanController.close();
                continue;
            }
        }
        transactionController.commit();
        conglomerateController = transactionController.openConglomerate(t_CreateConglomRet.base_conglomid, false, 4, 6, 5);
        conglomerateController2 = transactionController.openConglomerate(t_CreateConglomRet.index_conglomid, false, 4, 6, 5);
        for (n = 0; n < 3; ++n) {
            ((SQLLongint)dataValueDescriptorArray[0]).setValue(2);
            ((SQLLongint)dataValueDescriptorArray[1]).setValue(n);
            conglomerateController.insertAndFetchLocation(dataValueDescriptorArray, rowLocation);
            if (conglomerateController2.insert(t_SecondaryIndexRow.getRow()) == 0) continue;
            throw T_Fail.testFailMsg("insert failed");
        }
        transactionController.abort();
        ScanController scanController2 = transactionController.openScan(t_CreateConglomRet.index_conglomid, false, 0, 6, 5, (FormatableBitSet)null, null, 0, null, null, 0);
        if (scanController2.next()) {
            throw T_Fail.testFailMsg("t_002: there are still rows in table.");
        }
        transactionController.commit();
        this.REPORT("Ending t_002");
        return true;
    }

    private boolean t_003_scan_test_cases(TransactionController transactionController, long l, T_SecondaryIndexRow t_SecondaryIndexRow) throws StandardException, T_Fail {
        boolean bl = true;
        DataValueDescriptor[] dataValueDescriptorArray = TemplateRow.newU8Row((int)1);
        DataValueDescriptor[] dataValueDescriptorArray2 = TemplateRow.newU8Row((int)1);
        this.REPORT("scan (x = 5)");
        ((SQLLongint)dataValueDescriptorArray[0]).setValue(5);
        ((SQLLongint)dataValueDescriptorArray2[0]).setValue(5);
        if (!T_QualifierTest.t_scan(transactionController, l, t_SecondaryIndexRow.getRow(), t_SecondaryIndexRow.getRow(), dataValueDescriptorArray, 1, null, dataValueDescriptorArray2, -1, 3, 16, 1)) {
            bl = false;
        }
        this.REPORT("scan (x > 5)");
        ((SQLLongint)dataValueDescriptorArray[0]).setValue(5);
        if (!T_QualifierTest.t_scan(transactionController, l, t_SecondaryIndexRow.getRow(), t_SecondaryIndexRow.getRow(), dataValueDescriptorArray, -1, null, null, 0, 3, 19, 1)) {
            bl = false;
        }
        this.REPORT("scan (x >= 5)");
        ((SQLLongint)dataValueDescriptorArray[0]).setValue(5);
        if (!T_QualifierTest.t_scan(transactionController, l, t_SecondaryIndexRow.getRow(), t_SecondaryIndexRow.getRow(), dataValueDescriptorArray, 1, null, null, 0, 6, 16, 1)) {
            bl = false;
        }
        this.REPORT("scan (x <= 5)");
        ((SQLLongint)dataValueDescriptorArray2[0]).setValue(5);
        if (!T_QualifierTest.t_scan(transactionController, l, t_SecondaryIndexRow.getRow(), t_SecondaryIndexRow.getRow(), null, 0, null, dataValueDescriptorArray2, -1, 8, 11, 1)) {
            bl = false;
        }
        this.REPORT("scan (x < 5)");
        ((SQLLongint)dataValueDescriptorArray2[0]).setValue(5);
        if (!T_QualifierTest.t_scan(transactionController, l, t_SecondaryIndexRow.getRow(), t_SecondaryIndexRow.getRow(), null, 0, null, dataValueDescriptorArray2, 1, 5, 11, 1)) {
            bl = false;
        }
        this.REPORT("scan (x >= 5 and x <= 7)");
        ((SQLLongint)dataValueDescriptorArray[0]).setValue(5);
        ((SQLLongint)dataValueDescriptorArray2[0]).setValue(7);
        if (!T_QualifierTest.t_scan(transactionController, l, t_SecondaryIndexRow.getRow(), t_SecondaryIndexRow.getRow(), dataValueDescriptorArray, 1, null, dataValueDescriptorArray2, -1, 5, 16, 1)) {
            bl = false;
        }
        this.REPORT("scan (x = 5 and y > 2)");
        dataValueDescriptorArray = TemplateRow.newU8Row((int)2);
        dataValueDescriptorArray2 = TemplateRow.newU8Row((int)1);
        ((SQLLongint)dataValueDescriptorArray[0]).setValue(5);
        ((SQLLongint)dataValueDescriptorArray[1]).setValue(2);
        ((SQLLongint)dataValueDescriptorArray2[0]).setValue(5);
        if (!T_QualifierTest.t_scan(transactionController, l, t_SecondaryIndexRow.getRow(), t_SecondaryIndexRow.getRow(), dataValueDescriptorArray, -1, null, dataValueDescriptorArray2, -1, 2, 17, 1)) {
            bl = false;
        }
        this.REPORT("scan (x = 5 and y >= 2)");
        dataValueDescriptorArray = TemplateRow.newU8Row((int)2);
        dataValueDescriptorArray2 = TemplateRow.newU8Row((int)1);
        ((SQLLongint)dataValueDescriptorArray[0]).setValue(5);
        ((SQLLongint)dataValueDescriptorArray[1]).setValue(2);
        ((SQLLongint)dataValueDescriptorArray2[0]).setValue(5);
        if (!T_QualifierTest.t_scan(transactionController, l, t_SecondaryIndexRow.getRow(), t_SecondaryIndexRow.getRow(), dataValueDescriptorArray, 1, null, dataValueDescriptorArray2, -1, 3, 16, 1)) {
            bl = false;
        }
        this.REPORT("scan (x = 5 and y < 5)");
        dataValueDescriptorArray = TemplateRow.newU8Row((int)1);
        dataValueDescriptorArray2 = TemplateRow.newU8Row((int)2);
        ((SQLLongint)dataValueDescriptorArray[0]).setValue(5);
        ((SQLLongint)dataValueDescriptorArray2[0]).setValue(5);
        ((SQLLongint)dataValueDescriptorArray2[1]).setValue(5);
        if (!T_QualifierTest.t_scan(transactionController, l, t_SecondaryIndexRow.getRow(), t_SecondaryIndexRow.getRow(), dataValueDescriptorArray, 1, null, dataValueDescriptorArray2, 1, 2, 16, 1)) {
            bl = false;
        }
        this.REPORT("scan (x = 2)");
        dataValueDescriptorArray = TemplateRow.newU8Row((int)1);
        dataValueDescriptorArray2 = TemplateRow.newU8Row((int)1);
        ((SQLLongint)dataValueDescriptorArray[0]).setValue(2);
        ((SQLLongint)dataValueDescriptorArray2[0]).setValue(2);
        if (!T_QualifierTest.t_scan(transactionController, l, t_SecondaryIndexRow.getRow(), t_SecondaryIndexRow.getRow(), dataValueDescriptorArray, 1, null, dataValueDescriptorArray2, -1, 0, 0, 1)) {
            bl = false;
        }
        this.REPORT("max on btree, row locked.");
        if (!transactionController.fetchMaxOnBtree(l, 0, 6, 5, (FormatableBitSet)null, t_SecondaryIndexRow.getRow())) {
            throw T_Fail.testFailMsg("found no max.");
        }
        long l2 = ((SQLLongint)t_SecondaryIndexRow.getRow()[2]).getLong();
        if (l2 != 21L) {
            throw T_Fail.testFailMsg("wrong max found.");
        }
        this.REPORT("max on btree, table locked.");
        if (!transactionController.fetchMaxOnBtree(l, 0, 7, 5, (FormatableBitSet)null, t_SecondaryIndexRow.getRow())) {
            throw T_Fail.testFailMsg("found no max.");
        }
        l2 = ((SQLLongint)t_SecondaryIndexRow.getRow()[2]).getLong();
        if (l2 != 21L) {
            throw T_Fail.testFailMsg("wrong max found.");
        }
        this.REPORT("max on btree, row locked.");
        if (!transactionController.fetchMaxOnBtree(l, 0, 6, 2, (FormatableBitSet)null, t_SecondaryIndexRow.getRow())) {
            throw T_Fail.testFailMsg("found no max.");
        }
        l2 = ((SQLLongint)t_SecondaryIndexRow.getRow()[2]).getLong();
        if (l2 != 21L) {
            throw T_Fail.testFailMsg("wrong max found.");
        }
        this.REPORT("max on btree, table locked.");
        if (!transactionController.fetchMaxOnBtree(l, 0, 7, 2, (FormatableBitSet)null, t_SecondaryIndexRow.getRow())) {
            throw T_Fail.testFailMsg("found no max.");
        }
        l2 = ((SQLLongint)t_SecondaryIndexRow.getRow()[2]).getLong();
        if (l2 != 21L) {
            throw T_Fail.testFailMsg("wrong max found.");
        }
        return bl;
    }

    protected boolean t_003(TransactionController transactionController) throws StandardException, T_Fail {
        int n;
        boolean bl;
        T_SecondaryIndexRow t_SecondaryIndexRow = new T_SecondaryIndexRow();
        DataValueDescriptor[] dataValueDescriptorArray = TemplateRow.newU8Row((int)4);
        dataValueDescriptorArray[3] = new SQLChar();
        Object object = new String();
        for (bl = false; bl < 300 != 0; bl += 1) {
            object = (String)object + "mikem";
        }
        bl = true;
        long l = -1L;
        long[] lArray = new long[]{1L, 3L, 4L, 4L, 4L, 5L, 5L, 5L, 6L, 7L, 9L};
        long[] lArray2 = new long[]{1L, 1L, 2L, 4L, 6L, 2L, 4L, 6L, 1L, 1L, 1L};
        long[] lArray3 = new long[]{11L, 12L, 13L, 14L, 15L, 16L, 17L, 18L, 19L, 20L, 21L};
        long[] lArray4 = new long[]{0L, 2L, 3L, 4L, 4L, 5L, 5L, 5L, 6L, 7L, 8L, 10L, 11L, 12L};
        long[] lArray5 = new long[]{1L, 1L, 2L, 3L, 5L, 0L, 3L, 5L, 0L, 0L, 1L, 42L, 42L, 1L};
        long[] lArray6 = new long[]{91L, 92L, 93L, 94L, 95L, 96L, 97L, 98L, 99L, 100L, 101L, 102L, 103L, 104L};
        this.REPORT("Starting t_003");
        long l2 = transactionController.createConglomerate("heap", dataValueDescriptorArray, null, null, null, 0);
        ConglomerateController conglomerateController = transactionController.openConglomerate(l2, false, 4, 6, 5);
        t_SecondaryIndexRow.init(dataValueDescriptorArray, conglomerateController.newRowLocationTemplate(), 5);
        Properties properties = T_b2i.createProperties(null, false, 5, 5, true, l2, 4);
        long l3 = transactionController.createConglomerate("BTREE", t_SecondaryIndexRow.getRow(), null, null, properties, 0);
        ConglomerateController conglomerateController2 = transactionController.openConglomerate(l3, false, 4, 6, 5);
        T_SecondaryIndexRow t_SecondaryIndexRow2 = new T_SecondaryIndexRow();
        RowLocation rowLocation = conglomerateController.newRowLocationTemplate();
        t_SecondaryIndexRow2.init(dataValueDescriptorArray, rowLocation, 5);
        for (n = lArray.length - 1; n >= 0; --n) {
            ((SQLLongint)t_SecondaryIndexRow2.getRow()[0]).setValue(lArray[n]);
            ((SQLLongint)t_SecondaryIndexRow2.getRow()[1]).setValue(lArray2[n]);
            ((SQLLongint)t_SecondaryIndexRow2.getRow()[2]).setValue(lArray3[n]);
            dataValueDescriptorArray[3] = new SQLChar((String)object);
            conglomerateController.insertAndFetchLocation(dataValueDescriptorArray, rowLocation);
            if (conglomerateController2.insert(t_SecondaryIndexRow2.getRow()) == 0) continue;
            throw T_Fail.testFailMsg("insert failed");
        }
        conglomerateController2.checkConsistency();
        ((B2IController)conglomerateController2).debugConglomerate();
        bl = this.t_003_scan_test_cases(transactionController, l3, t_SecondaryIndexRow2);
        for (n = lArray4.length - 1; n >= 0; --n) {
            ((SQLLongint)t_SecondaryIndexRow2.getRow()[0]).setValue(lArray4[n]);
            ((SQLLongint)t_SecondaryIndexRow2.getRow()[1]).setValue(lArray5[n]);
            ((SQLLongint)t_SecondaryIndexRow2.getRow()[2]).setValue(lArray6[n]);
            dataValueDescriptorArray[3] = new SQLChar((String)object);
            conglomerateController.insertAndFetchLocation(dataValueDescriptorArray, rowLocation);
            if (conglomerateController2.insert(t_SecondaryIndexRow2.getRow()) != 0) {
                throw T_Fail.testFailMsg("insert failed");
            }
            conglomerateController.delete(rowLocation);
            ScanController scanController = transactionController.openScan(l3, false, 4, 6, 5, (FormatableBitSet)null, t_SecondaryIndexRow2.getRow(), 1, null, t_SecondaryIndexRow2.getRow(), -1);
            if (!scanController.next()) {
                throw T_Fail.testFailMsg("delete could not find key");
            }
            scanController.delete();
            if (scanController.next()) {
                throw T_Fail.testFailMsg("delete found more than one key");
            }
            scanController.close();
        }
        bl = this.t_003_scan_test_cases(transactionController, l3, t_SecondaryIndexRow2);
        conglomerateController2.close();
        transactionController.commit();
        this.REPORT("Ending t_003");
        return bl;
    }

    protected boolean t_004(TransactionController transactionController) throws StandardException, T_Fail {
        this.REPORT("Starting t_004");
        T_CreateConglomRet t_CreateConglomRet = new T_CreateConglomRet();
        this.createCongloms(transactionController, 2, false, false, 0, t_CreateConglomRet);
        Properties properties = T_b2i.createProperties(null, false, 4, 4, true, t_CreateConglomRet.base_conglomid, 3);
        T_QualifierTest t_QualifierTest = new T_QualifierTest("BTREE", properties, false, this.out, 1);
        boolean bl = t_QualifierTest.t_testqual(transactionController);
        this.REPORT("Ending t_004");
        return bl;
    }

    protected boolean t_005(TransactionController transactionController) throws StandardException, T_Fail {
        int n;
        int n2;
        int n3;
        boolean bl = true;
        this.REPORT("Starting t_005");
        T_CreateConglomRet t_CreateConglomRet = new T_CreateConglomRet();
        this.createCongloms(transactionController, 2, false, false, 0, t_CreateConglomRet);
        ConglomerateController conglomerateController = transactionController.openConglomerate(t_CreateConglomRet.base_conglomid, false, 4, 6, 5);
        ConglomerateController conglomerateController2 = transactionController.openConglomerate(t_CreateConglomRet.index_conglomid, false, 4, 6, 5);
        T_SecondaryIndexRow t_SecondaryIndexRow = new T_SecondaryIndexRow();
        RowLocation rowLocation = conglomerateController.newRowLocationTemplate();
        DataValueDescriptor[] dataValueDescriptorArray = TemplateRow.newU8Row((int)2);
        t_SecondaryIndexRow.init(dataValueDescriptorArray, rowLocation, 3);
        for (n3 = 200; n3 >= 0; n3 -= 4) {
            ((SQLLongint)dataValueDescriptorArray[0]).setValue(1);
            ((SQLLongint)dataValueDescriptorArray[1]).setValue(n3);
            conglomerateController.insertAndFetchLocation(dataValueDescriptorArray, rowLocation);
            if (conglomerateController2.insert(t_SecondaryIndexRow.getRow()) == 0) continue;
            throw T_Fail.testFailMsg("insert failed");
        }
        for (n3 = 199; n3 >= 0; n3 -= 4) {
            ((SQLLongint)dataValueDescriptorArray[0]).setValue(1);
            ((SQLLongint)dataValueDescriptorArray[1]).setValue(n3);
            conglomerateController.insertAndFetchLocation(dataValueDescriptorArray, rowLocation);
            if (conglomerateController2.insert(t_SecondaryIndexRow.getRow()) == 0) continue;
            throw T_Fail.testFailMsg("insert failed");
        }
        conglomerateController2.checkConsistency();
        conglomerateController2.close();
        transactionController.commit();
        DataValueDescriptor[] dataValueDescriptorArray2 = TemplateRow.newU8Row((int)2);
        for (n2 = 200; n2 >= 0; n2 -= 4) {
            ((SQLLongint)dataValueDescriptorArray2[0]).setValue(1);
            ((SQLLongint)dataValueDescriptorArray2[1]).setValue(n2);
            if (this.t_delete(transactionController, t_CreateConglomRet.index_conglomid, dataValueDescriptorArray2, false)) continue;
            bl = false;
        }
        for (n2 = 199; n2 >= 0; n2 -= 4) {
            ((SQLLongint)dataValueDescriptorArray2[0]).setValue(1);
            ((SQLLongint)dataValueDescriptorArray2[1]).setValue(n2);
            if (this.t_delete(transactionController, t_CreateConglomRet.index_conglomid, dataValueDescriptorArray2, false)) continue;
            bl = false;
        }
        transactionController.commit();
        conglomerateController = transactionController.openConglomerate(t_CreateConglomRet.base_conglomid, false, 4, 6, 5);
        conglomerateController2 = transactionController.openConglomerate(t_CreateConglomRet.index_conglomid, false, 4, 6, 5);
        RawStoreFactory rawStoreFactory = (RawStoreFactory)T_b2i.findServiceModule(this.store_module, "org.apache.derby.iapi.store.raw.RawStoreFactory");
        rawStoreFactory.idle();
        for (n = 200; n >= 0; n -= 3) {
            ((SQLLongint)dataValueDescriptorArray[0]).setValue(1);
            ((SQLLongint)dataValueDescriptorArray[1]).setValue(n);
            conglomerateController.insertAndFetchLocation(dataValueDescriptorArray, rowLocation);
            if (conglomerateController2.insert(t_SecondaryIndexRow.getRow()) == 0) continue;
            throw T_Fail.testFailMsg("insert failed");
        }
        for (n = 200; n >= 0; n -= 3) {
            ((SQLLongint)dataValueDescriptorArray2[0]).setValue(1);
            ((SQLLongint)dataValueDescriptorArray2[1]).setValue(n);
            if (this.t_delete(transactionController, t_CreateConglomRet.index_conglomid, dataValueDescriptorArray2, false)) continue;
            bl = false;
        }
        ScanController scanController = transactionController.openScan(t_CreateConglomRet.index_conglomid, false, 0, 6, 5, (FormatableBitSet)null, null, 0, null, null, 0);
        if (scanController.next()) {
            throw T_Fail.testFailMsg("t_005: there are still rows in table.");
        }
        conglomerateController2.checkConsistency();
        for (int i = 600; i >= 400; i -= 3) {
            ((SQLLongint)dataValueDescriptorArray[0]).setValue(1);
            ((SQLLongint)dataValueDescriptorArray[1]).setValue(i);
            conglomerateController.insertAndFetchLocation(dataValueDescriptorArray, rowLocation);
            if (conglomerateController2.insert(t_SecondaryIndexRow.getRow()) == 0) continue;
            throw T_Fail.testFailMsg("insert failed");
        }
        conglomerateController2.checkConsistency();
        transactionController.abort();
        scanController = transactionController.openScan(t_CreateConglomRet.index_conglomid, false, 0, 6, 5, (FormatableBitSet)null, null, 0, null, null, 0);
        if (scanController.next()) {
            throw T_Fail.testFailMsg("t_005: there are still rows in table.");
        }
        this.REPORT("Ending t_005");
        return bl;
    }

    protected boolean t_006(TransactionController transactionController) throws StandardException, T_Fail {
        this.REPORT("Starting t_006");
        T_CreateConglomRet t_CreateConglomRet = new T_CreateConglomRet();
        this.createCongloms(transactionController, 2, false, false, 0, t_CreateConglomRet);
        ConglomerateController conglomerateController = transactionController.openConglomerate(t_CreateConglomRet.base_conglomid, false, 4, 6, 5);
        ConglomerateController conglomerateController2 = transactionController.openConglomerate(t_CreateConglomRet.index_conglomid, false, 4, 6, 5);
        DataValueDescriptor[] dataValueDescriptorArray = TemplateRow.newU8Row((int)2);
        RowLocation rowLocation = conglomerateController.newRowLocationTemplate();
        T_SecondaryIndexRow t_SecondaryIndexRow = new T_SecondaryIndexRow();
        t_SecondaryIndexRow.init(dataValueDescriptorArray, rowLocation, 3);
        ((SQLLongint)dataValueDescriptorArray[0]).setValue(1);
        T_SecondaryIndexRow t_SecondaryIndexRow2 = new T_SecondaryIndexRow();
        t_SecondaryIndexRow2.init(TemplateRow.newU8Row((int)2), conglomerateController.newRowLocationTemplate(), 3);
        ((SQLLongint)dataValueDescriptorArray[1]).setValue(1000);
        conglomerateController.insertAndFetchLocation(dataValueDescriptorArray, rowLocation);
        if (conglomerateController2.insert(t_SecondaryIndexRow.getRow()) != 0) {
            throw T_Fail.testFailMsg("insert failed");
        }
        try {
            conglomerateController2.delete(null);
            return this.FAIL("t_006: ConglomerateController.delete() succeeded.");
        }
        catch (StandardException standardException) {
            try {
                if (!conglomerateController2.fetch(null, RowUtil.EMPTY_ROW, (FormatableBitSet)null)) {
                    return this.FAIL("t_006: ConglomerateController.fetch() bad ret.");
                }
                return this.FAIL("t_006: ConglomerateController.fetch() succeeded.");
            }
            catch (StandardException standardException2) {
                try {
                    conglomerateController2.insertAndFetchLocation((DataValueDescriptor[])null, null);
                    return this.FAIL("t_006: ConglomerateController.insertAndFetchLocation() succeeded.");
                }
                catch (StandardException standardException3) {
                    try {
                        RowLocation rowLocation2 = conglomerateController2.newRowLocationTemplate();
                        return this.FAIL("t_006: ConglomerateController.newRowLocationTemplate() succeeded.");
                    }
                    catch (StandardException standardException4) {
                        try {
                            conglomerateController2.replace(null, null, null);
                            return this.FAIL("t_006: ConglomerateController.replace() succeeded.");
                        }
                        catch (StandardException standardException5) {
                            conglomerateController2.close();
                            ScanController scanController = transactionController.openScan(t_CreateConglomRet.index_conglomid, false, 0, 6, 5, (FormatableBitSet)null, null, 0, null, null, 0);
                            int n = 0;
                            while (scanController.next()) {
                                ++n;
                                scanController.fetch(t_SecondaryIndexRow.getRow());
                                try {
                                    scanController.fetchLocation(null);
                                    return this.FAIL("t_006: scan.fetchLocation() succeeded");
                                }
                                catch (StandardException standardException6) {
                                    try {
                                        RowLocation rowLocation3 = scanController.newRowLocationTemplate();
                                        return this.FAIL("t_006: scan.newRowLocationTemplate() succeeded");
                                    }
                                    catch (StandardException standardException7) {
                                        try {
                                            scanController.replace(t_SecondaryIndexRow.getRow(), (FormatableBitSet)null);
                                            return this.FAIL("t_006: scan.replace() succeeded");
                                        }
                                        catch (StandardException standardException8) {
                                        }
                                    }
                                }
                            }
                            if (scanController.next()) {
                                return this.FAIL("t_006: scan.next() returned true after false.");
                            }
                            scanController.close();
                            if (n != 1) {
                                return this.FAIL("(t_scan) wrong number of rows. Expected 1 row, but got " + n + "rows.");
                            }
                            this.REPORT("Ending t_006");
                            return true;
                        }
                    }
                }
            }
        }
    }

    protected boolean t_007(TransactionController transactionController) throws StandardException, T_Fail {
        boolean bl = true;
        this.REPORT("Starting t_007");
        T_CreateConglomRet t_CreateConglomRet = new T_CreateConglomRet();
        this.createCongloms(transactionController, 2, false, false, 0, t_CreateConglomRet);
        ConglomerateController conglomerateController = transactionController.openConglomerate(t_CreateConglomRet.base_conglomid, false, 4, 6, 5);
        ConglomerateController conglomerateController2 = transactionController.openConglomerate(t_CreateConglomRet.index_conglomid, false, 4, 6, 5);
        T_SecondaryIndexRow t_SecondaryIndexRow = new T_SecondaryIndexRow();
        DataValueDescriptor[] dataValueDescriptorArray = TemplateRow.newU8Row((int)2);
        RowLocation rowLocation = conglomerateController.newRowLocationTemplate();
        t_SecondaryIndexRow.init(dataValueDescriptorArray, rowLocation, 3);
        ((SQLLongint)t_SecondaryIndexRow.getRow()[0]).setValue(1);
        ((SQLLongint)t_SecondaryIndexRow.getRow()[1]).setValue(3);
        conglomerateController.insertAndFetchLocation(dataValueDescriptorArray, rowLocation);
        if (conglomerateController2.insert(t_SecondaryIndexRow.getRow()) != 0) {
            throw T_Fail.testFailMsg("insert failed");
        }
        ((SQLLongint)t_SecondaryIndexRow.getRow()[1]).setValue(5);
        conglomerateController.insertAndFetchLocation(dataValueDescriptorArray, rowLocation);
        if (conglomerateController2.insert(t_SecondaryIndexRow.getRow()) != 0) {
            throw T_Fail.testFailMsg("insert failed");
        }
        ScanController scanController = transactionController.openScan(t_CreateConglomRet.index_conglomid, false, 0, 6, 5, (FormatableBitSet)null, null, 0, null, null, 0);
        scanController.fetch(t_SecondaryIndexRow.getRow());
        long l = ((SQLLongint)t_SecondaryIndexRow.getRow()[1]).getLong();
        ((SQLLongint)t_SecondaryIndexRow.getRow()[1]).setValue(1);
        conglomerateController.insertAndFetchLocation(dataValueDescriptorArray, rowLocation);
        if (conglomerateController2.insert(t_SecondaryIndexRow.getRow()) != 0) {
            throw T_Fail.testFailMsg("insert failed");
        }
        ((SQLLongint)t_SecondaryIndexRow.getRow()[1]).setValue(2);
        conglomerateController.insertAndFetchLocation(dataValueDescriptorArray, rowLocation);
        if (conglomerateController2.insert(t_SecondaryIndexRow.getRow()) != 0) {
            throw T_Fail.testFailMsg("insert failed");
        }
        scanController.fetch(t_SecondaryIndexRow.getRow());
        l = ((SQLLongint)t_SecondaryIndexRow.getRow()[1]).getLong();
        scanController.fetch(t_SecondaryIndexRow.getRow());
        l = ((SQLLongint)t_SecondaryIndexRow.getRow()[1]).getLong();
        conglomerateController2.close();
        scanController.close();
        this.REPORT("Ending t_007");
        return bl;
    }

    protected boolean t_008(TransactionController transactionController) throws StandardException, T_Fail {
        boolean bl = true;
        this.REPORT("Starting t_008");
        T_CreateConglomRet t_CreateConglomRet = new T_CreateConglomRet();
        this.createCongloms(transactionController, 2, false, false, 0, t_CreateConglomRet);
        ConglomerateController conglomerateController = transactionController.openConglomerate(t_CreateConglomRet.base_conglomid, false, 4, 6, 5);
        ConglomerateController conglomerateController2 = transactionController.openConglomerate(t_CreateConglomRet.index_conglomid, false, 4, 6, 5);
        DataValueDescriptor[] dataValueDescriptorArray = TemplateRow.newU8Row((int)2);
        RowLocation rowLocation = conglomerateController.newRowLocationTemplate();
        T_SecondaryIndexRow t_SecondaryIndexRow = new T_SecondaryIndexRow();
        t_SecondaryIndexRow.init(dataValueDescriptorArray, rowLocation, 3);
        ((SQLLongint)dataValueDescriptorArray[0]).setValue(1);
        T_SecondaryIndexRow t_SecondaryIndexRow2 = new T_SecondaryIndexRow();
        t_SecondaryIndexRow2.init(TemplateRow.newU8Row((int)2), conglomerateController.newRowLocationTemplate(), 3);
        ((SQLLongint)dataValueDescriptorArray[1]).setValue(1000);
        conglomerateController.insertAndFetchLocation(dataValueDescriptorArray, rowLocation);
        if (conglomerateController2.insert(t_SecondaryIndexRow.getRow()) != 0) {
            throw T_Fail.testFailMsg("insert failed");
        }
        ScanController scanController = transactionController.openScan(t_CreateConglomRet.index_conglomid, false, 0, 6, 5, (FormatableBitSet)null, null, 0, null, null, 0);
        scanController.fetch(t_SecondaryIndexRow2.getRow());
        long l = ((SQLLongint)t_SecondaryIndexRow2.getRow()[1]).getLong();
        for (int i = 0; i < 6; ++i) {
            ((SQLLongint)dataValueDescriptorArray[1]).setValue(i);
            conglomerateController.insertAndFetchLocation(dataValueDescriptorArray, rowLocation);
            if (conglomerateController2.insert(t_SecondaryIndexRow.getRow()) != 0) {
                throw T_Fail.testFailMsg("insert failed");
            }
            if (i % 10 != 0) continue;
            scanController.fetch(t_SecondaryIndexRow2.getRow());
            l = ((SQLLongint)t_SecondaryIndexRow2.getRow()[1]).getLong();
        }
        ((SQLLongint)dataValueDescriptorArray[1]).setValue(3000);
        conglomerateController.insertAndFetchLocation(dataValueDescriptorArray, rowLocation);
        if (conglomerateController2.insert(t_SecondaryIndexRow.getRow()) != 0) {
            throw T_Fail.testFailMsg("insert failed");
        }
        scanController.fetch(t_SecondaryIndexRow2.getRow());
        l = ((SQLLongint)t_SecondaryIndexRow2.getRow()[1]).getLong();
        scanController.fetch(t_SecondaryIndexRow2.getRow());
        l = ((SQLLongint)t_SecondaryIndexRow2.getRow()[1]).getLong();
        conglomerateController2.checkConsistency();
        conglomerateController2.close();
        scanController.close();
        this.REPORT("Ending t_008");
        return bl;
    }

    protected boolean t_009(TransactionController transactionController) throws StandardException, T_Fail {
        Object var2_2 = null;
        this.REPORT("Starting t_009");
        T_CreateConglomRet t_CreateConglomRet = new T_CreateConglomRet();
        this.createCongloms(transactionController, 2, false, false, 2, t_CreateConglomRet);
        ConglomerateController conglomerateController = transactionController.openConglomerate(t_CreateConglomRet.base_conglomid, false, 4, 6, 5);
        ConglomerateController conglomerateController2 = transactionController.openConglomerate(t_CreateConglomRet.index_conglomid, false, 4, 6, 5);
        DataValueDescriptor[] dataValueDescriptorArray = TemplateRow.newU8Row((int)2);
        T_SecondaryIndexRow t_SecondaryIndexRow = new T_SecondaryIndexRow();
        RowLocation rowLocation = conglomerateController.newRowLocationTemplate();
        t_SecondaryIndexRow.init(dataValueDescriptorArray, rowLocation, 3);
        ((SQLLongint)dataValueDescriptorArray[0]).setValue(1);
        ((SQLLongint)dataValueDescriptorArray[1]).setValue(1000);
        conglomerateController.insertAndFetchLocation(dataValueDescriptorArray, rowLocation);
        if (conglomerateController2.insert(t_SecondaryIndexRow.getRow()) != 0) {
            throw T_Fail.testFailMsg("insert failed");
        }
        if (conglomerateController2.insert(t_SecondaryIndexRow.getRow()) != 1) {
            throw T_Fail.testFailMsg("insert of duplicate returned wrong return value:");
        }
        DataValueDescriptor[] dataValueDescriptorArray2 = TemplateRow.newU8Row((int)2);
        ((SQLLongint)dataValueDescriptorArray2[0]).setValue(1);
        ((SQLLongint)dataValueDescriptorArray2[1]).setValue(1000);
        if (!this.t_delete(transactionController, t_CreateConglomRet.index_conglomid, dataValueDescriptorArray2, false)) {
            throw T_Fail.testFailMsg("t_008: could not delete key.");
        }
        if (conglomerateController2.insert(t_SecondaryIndexRow.getRow()) != 0) {
            throw T_Fail.testFailMsg("insert failed");
        }
        transactionController.commit();
        t_CreateConglomRet = new T_CreateConglomRet();
        this.createCongloms(transactionController, 2, true, false, 2, t_CreateConglomRet);
        conglomerateController = transactionController.openConglomerate(t_CreateConglomRet.base_conglomid, false, 4, 6, 5);
        conglomerateController2 = transactionController.openConglomerate(t_CreateConglomRet.index_conglomid, false, 4, 6, 5);
        dataValueDescriptorArray = TemplateRow.newU8Row((int)2);
        t_SecondaryIndexRow = new T_SecondaryIndexRow();
        rowLocation = conglomerateController.newRowLocationTemplate();
        t_SecondaryIndexRow.init(dataValueDescriptorArray, rowLocation, 3);
        ((SQLLongint)dataValueDescriptorArray[0]).setValue(1);
        ((SQLLongint)dataValueDescriptorArray[1]).setValue(1000);
        conglomerateController.insertAndFetchLocation(dataValueDescriptorArray, rowLocation);
        if (conglomerateController2.insert(t_SecondaryIndexRow.getRow()) != 0) {
            throw T_Fail.testFailMsg("insert failed");
        }
        conglomerateController.insertAndFetchLocation(dataValueDescriptorArray, rowLocation);
        if (conglomerateController2.insert(t_SecondaryIndexRow.getRow()) != 1) {
            throw T_Fail.testFailMsg("insert of duplicate returned wrong return value:");
        }
        dataValueDescriptorArray2 = TemplateRow.newU8Row((int)2);
        ((SQLLongint)dataValueDescriptorArray2[0]).setValue(1);
        ((SQLLongint)dataValueDescriptorArray2[1]).setValue(1000);
        if (!this.t_delete(transactionController, t_CreateConglomRet.index_conglomid, dataValueDescriptorArray2, false)) {
            throw T_Fail.testFailMsg("t_008: could not delete key.");
        }
        if (conglomerateController2.insert(t_SecondaryIndexRow.getRow()) != 0) {
            throw T_Fail.testFailMsg("insert failed");
        }
        this.REPORT("Ending t_009");
        return true;
    }

    protected boolean t_010(TransactionController transactionController) throws StandardException, T_Fail {
        this.REPORT("Starting t_006");
        B2I b2I = new B2I();
        b2I.restoreToNull();
        if (!b2I.isNull()) {
            throw T_Fail.testFailMsg("bad restoreToNull/isNull");
        }
        try {
            TransactionManager transactionManager = (TransactionManager)transactionController;
            ConglomerateController conglomerateController = b2I.open(transactionManager, transactionManager.getRawStoreXact(), false, 0, 0, (LockingPolicy)null, null, null);
            throw T_Fail.testFailMsg("bad open succeeded.");
        }
        catch (StandardException standardException) {
            DataValueDescriptor[] dataValueDescriptorArray = TemplateRow.newU8Row((int)2);
            T_SecondaryIndexRow t_SecondaryIndexRow = new T_SecondaryIndexRow();
            long l = transactionController.createConglomerate("heap", dataValueDescriptorArray, null, null, null, 0);
            ConglomerateController conglomerateController = transactionController.openConglomerate(l, false, 0, 6, 5);
            RowLocation rowLocation = conglomerateController.newRowLocationTemplate();
            t_SecondaryIndexRow.init(dataValueDescriptorArray, rowLocation, 3);
            Properties properties = T_b2i.createProperties(null, false, 3, 2, true, -42L, 2);
            TransactionManager transactionManager = (TransactionManager)transactionController;
            try {
                b2I.create(transactionManager, -1, 0L, t_SecondaryIndexRow.getRow(), null, null, null, 1);
                throw T_Fail.testFailMsg("bad create succeeded.");
            }
            catch (StandardException standardException2) {
                properties = T_b2i.createProperties(null, false, 3, 1, true, -42L, 2);
                try {
                    long l2 = transactionController.createConglomerate("BTREE", t_SecondaryIndexRow.getRow(), null, null, properties, 0);
                    throw T_Fail.testFailMsg("bad create succeeded.");
                }
                catch (Throwable throwable) {
                    this.REPORT("Ending t_010");
                    return true;
                }
            }
        }
    }

    protected boolean t_011(TransactionController transactionController) throws StandardException, T_Fail {
        int n;
        boolean bl = true;
        this.REPORT("Starting t_011");
        T_CreateConglomRet t_CreateConglomRet = new T_CreateConglomRet();
        this.createCongloms(transactionController, 2, false, true, 0, t_CreateConglomRet);
        ConglomerateController conglomerateController = transactionController.openConglomerate(t_CreateConglomRet.base_conglomid, false, 4, 6, 5);
        ConglomerateController conglomerateController2 = transactionController.openConglomerate(t_CreateConglomRet.index_conglomid, false, 4, 6, 5);
        T_SecondaryIndexRow t_SecondaryIndexRow = new T_SecondaryIndexRow();
        RowLocation rowLocation = conglomerateController.newRowLocationTemplate();
        DataValueDescriptor[] dataValueDescriptorArray = TemplateRow.newU8Row((int)2);
        dataValueDescriptorArray[0] = new SQLChar("aaaaaaaaaa");
        t_SecondaryIndexRow.init(dataValueDescriptorArray, rowLocation, 3);
        ((SQLChar)dataValueDescriptorArray[0]).setValue(T_b2i.repeatString("a", 1000));
        ((SQLLongint)dataValueDescriptorArray[1]).setValue(1);
        conglomerateController.insertAndFetchLocation(dataValueDescriptorArray, rowLocation);
        ((SQLChar)dataValueDescriptorArray[0]).setValue(T_b2i.repeatString("m", 1000));
        ((SQLLongint)dataValueDescriptorArray[1]).setValue(0);
        conglomerateController.insertAndFetchLocation(dataValueDescriptorArray, rowLocation);
        if (conglomerateController2.insert(t_SecondaryIndexRow.getRow()) != 0) {
            throw T_Fail.testFailMsg("insert failed");
        }
        ((SQLChar)dataValueDescriptorArray[0]).setValue(T_b2i.repeatString("a", 1000));
        for (n = 0; n < 5; ++n) {
            ((SQLLongint)dataValueDescriptorArray[1]).setValue(n);
            conglomerateController.insertAndFetchLocation(dataValueDescriptorArray, rowLocation);
            if (conglomerateController2.insert(t_SecondaryIndexRow.getRow()) == 0) continue;
            throw T_Fail.testFailMsg("insert failed");
        }
        ((SQLChar)dataValueDescriptorArray[0]).setValue(T_b2i.repeatString("z", 500));
        for (n = 10; n > 8; --n) {
            ((SQLLongint)dataValueDescriptorArray[1]).setValue(n);
            conglomerateController.insertAndFetchLocation(dataValueDescriptorArray, rowLocation);
            if (conglomerateController2.insert(t_SecondaryIndexRow.getRow()) == 0) continue;
            throw T_Fail.testFailMsg("insert failed");
        }
        conglomerateController2.checkConsistency();
        conglomerateController2.close();
        transactionController.dropConglomerate(t_CreateConglomRet.index_conglomid);
        transactionController.dropConglomerate(t_CreateConglomRet.base_conglomid);
        transactionController.abort();
        this.REPORT("Ending t_011");
        return bl;
    }

    protected boolean t_012(TransactionController transactionController) throws StandardException, T_Fail {
        int n;
        boolean bl = true;
        this.REPORT("Starting t_011");
        T_CreateConglomRet t_CreateConglomRet = new T_CreateConglomRet();
        this.createCongloms(transactionController, 2, false, true, 0, t_CreateConglomRet);
        ConglomerateController conglomerateController = transactionController.openConglomerate(t_CreateConglomRet.base_conglomid, false, 4, 6, 5);
        ConglomerateController conglomerateController2 = transactionController.openConglomerate(t_CreateConglomRet.index_conglomid, false, 4, 6, 5);
        T_SecondaryIndexRow t_SecondaryIndexRow = new T_SecondaryIndexRow();
        RowLocation rowLocation = conglomerateController.newRowLocationTemplate();
        DataValueDescriptor[] dataValueDescriptorArray = TemplateRow.newU8Row((int)2);
        dataValueDescriptorArray[0] = new SQLChar("aaaaaaaaaa");
        t_SecondaryIndexRow.init(dataValueDescriptorArray, rowLocation, 3);
        ((SQLChar)dataValueDescriptorArray[0]).setValue(T_b2i.repeatString("a", 1000));
        ((SQLLongint)dataValueDescriptorArray[1]).setValue(1);
        conglomerateController.insertAndFetchLocation(dataValueDescriptorArray, rowLocation);
        ((SQLChar)dataValueDescriptorArray[0]).setValue(T_b2i.repeatString("ma", 500));
        for (n = 0; n < 3; ++n) {
            ((SQLLongint)dataValueDescriptorArray[1]).setValue(n);
            conglomerateController.insertAndFetchLocation(dataValueDescriptorArray, rowLocation);
            if (conglomerateController2.insert(t_SecondaryIndexRow.getRow()) == 0) continue;
            throw T_Fail.testFailMsg("insert failed");
        }
        ((SQLChar)dataValueDescriptorArray[0]).setValue(T_b2i.repeatString("m", 1000));
        for (n = 3; n < 23; ++n) {
            ((SQLLongint)dataValueDescriptorArray[1]).setValue(n);
            conglomerateController.insertAndFetchLocation(dataValueDescriptorArray, rowLocation);
            if (conglomerateController2.insert(t_SecondaryIndexRow.getRow()) == 0) continue;
            throw T_Fail.testFailMsg("insert failed");
        }
        ((SQLChar)dataValueDescriptorArray[0]).setValue(T_b2i.repeatString("a", 600));
        for (n = 123; n > 111; --n) {
            ((SQLLongint)dataValueDescriptorArray[1]).setValue(n * 2);
            conglomerateController.insertAndFetchLocation(dataValueDescriptorArray, rowLocation);
            if (conglomerateController2.insert(t_SecondaryIndexRow.getRow()) == 0) continue;
            throw T_Fail.testFailMsg("insert failed");
        }
        ((SQLLongint)dataValueDescriptorArray[1]).setValue(227);
        conglomerateController.insertAndFetchLocation(dataValueDescriptorArray, rowLocation);
        if (conglomerateController2.insert(t_SecondaryIndexRow.getRow()) != 0) {
            throw T_Fail.testFailMsg("insert failed");
        }
        transactionController.commit();
        conglomerateController2.close();
        this.REPORT("Ending t_012");
        return bl;
    }

    protected boolean t_013(TransactionController transactionController) throws StandardException, T_Fail {
        int n;
        Object var2_2 = null;
        this.REPORT("Starting t_013");
        T_CreateConglomRet t_CreateConglomRet = new T_CreateConglomRet();
        this.createCongloms(transactionController, 2, true, false, 5, t_CreateConglomRet);
        ConglomerateController conglomerateController = transactionController.openConglomerate(t_CreateConglomRet.base_conglomid, false, 4, 6, 5);
        ConglomerateController conglomerateController2 = transactionController.openConglomerate(t_CreateConglomRet.index_conglomid, false, 4, 6, 5);
        DataValueDescriptor[] dataValueDescriptorArray = TemplateRow.newU8Row((int)2);
        T_SecondaryIndexRow t_SecondaryIndexRow = new T_SecondaryIndexRow();
        RowLocation rowLocation = conglomerateController.newRowLocationTemplate();
        t_SecondaryIndexRow.init(dataValueDescriptorArray, rowLocation, 3);
        DataValueDescriptor[] dataValueDescriptorArray2 = TemplateRow.newU8Row((int)2);
        T_SecondaryIndexRow t_SecondaryIndexRow2 = new T_SecondaryIndexRow();
        RowLocation rowLocation2 = conglomerateController.newRowLocationTemplate();
        t_SecondaryIndexRow2.init(dataValueDescriptorArray2, rowLocation2, 3);
        transactionController.commit();
        transactionController.commit();
        conglomerateController = transactionController.openConglomerate(t_CreateConglomRet.base_conglomid, false, 4, 6, 5);
        conglomerateController2 = transactionController.openConglomerate(t_CreateConglomRet.index_conglomid, false, 4, 6, 5);
        ((SQLLongint)dataValueDescriptorArray[0]).setValue(1);
        ((SQLLongint)dataValueDescriptorArray[1]).setValue(100);
        conglomerateController.insertAndFetchLocation(dataValueDescriptorArray, rowLocation);
        if (conglomerateController2.insert(t_SecondaryIndexRow.getRow()) != 0) {
            throw T_Fail.testFailMsg("insert failed");
        }
        for (n = 0; n < 10; ++n) {
            ((SQLLongint)dataValueDescriptorArray2[1]).setValue(n);
            conglomerateController.insertAndFetchLocation(dataValueDescriptorArray2, rowLocation2);
            if (conglomerateController2.insert(t_SecondaryIndexRow2.getRow()) == 0) continue;
            throw T_Fail.testFailMsg("insert failed");
        }
        if (!this.t_delete(transactionController, t_CreateConglomRet.index_conglomid, t_SecondaryIndexRow.getRow(), false)) {
            throw T_Fail.testFailMsg("t_008: could not delete key.");
        }
        conglomerateController.delete(rowLocation);
        for (n = 10; n < 20; ++n) {
            ((SQLLongint)dataValueDescriptorArray2[1]).setValue(n);
            conglomerateController.insertAndFetchLocation(dataValueDescriptorArray2, rowLocation2);
            if (conglomerateController2.insert(t_SecondaryIndexRow2.getRow()) == 0) continue;
            throw T_Fail.testFailMsg("insert failed");
        }
        ((SQLLongint)dataValueDescriptorArray[1]).setValue(100);
        conglomerateController.insertAndFetchLocation(dataValueDescriptorArray, rowLocation);
        if (conglomerateController2.insert(t_SecondaryIndexRow.getRow()) != 0) {
            throw T_Fail.testFailMsg("insert failed");
        }
        for (n = 20; n < 30; ++n) {
            ((SQLLongint)dataValueDescriptorArray2[1]).setValue(n);
            conglomerateController.insertAndFetchLocation(dataValueDescriptorArray2, rowLocation2);
            if (conglomerateController2.insert(t_SecondaryIndexRow2.getRow()) == 0) continue;
            throw T_Fail.testFailMsg("insert failed");
        }
        transactionController.abort();
        ScanController scanController = transactionController.openScan(t_CreateConglomRet.index_conglomid, false, 0, 6, 5, (FormatableBitSet)null, null, 0, null, null, 0);
        if (scanController.next()) {
            throw T_Fail.testFailMsg("t_002: there are still rows in table.");
        }
        transactionController.commit();
        this.REPORT("Ending t_013");
        return true;
    }

    protected boolean t_014(TransactionController transactionController) throws StandardException, T_Fail {
        Object var2_2 = null;
        this.REPORT("Starting t_014");
        DataValueDescriptor[] dataValueDescriptorArray = TemplateRow.newU8Row((int)2);
        T_SecondaryIndexRow t_SecondaryIndexRow = new T_SecondaryIndexRow();
        long l = transactionController.createConglomerate("heap", dataValueDescriptorArray, null, null, null, 0);
        ConglomerateController conglomerateController = transactionController.openConglomerate(l, false, 0, 6, 5);
        RowLocation rowLocation = conglomerateController.newRowLocationTemplate();
        t_SecondaryIndexRow.init(dataValueDescriptorArray, rowLocation, 3);
        Properties properties = T_b2i.createProperties(null, false, 3, 2, true, l, 2);
        properties.put("derby.storage.pageSize", "8192");
        properties.put("derby.storage.pageReservedSpace", "99");
        properties.put("derby.storage.minimumRecordSize", "42");
        TransactionManager transactionManager = (TransactionManager)transactionController;
        long l2 = transactionController.createConglomerate("BTREE", t_SecondaryIndexRow.getRow(), null, null, properties, 0);
        ConglomerateController conglomerateController2 = transactionController.openConglomerate(l2, false, 4, 6, 5);
        Properties properties2 = new Properties();
        properties2.put("derby.storage.pageSize", "");
        properties2.put("derby.storage.pageReservedSpace", "");
        properties2.put("derby.storage.minimumRecordSize", "");
        conglomerateController2.getTableProperties(properties2);
        if (properties2.getProperty("derby.storage.pageSize").compareTo("8192") != 0 || properties2.getProperty("derby.storage.pageReservedSpace").compareTo("0") != 0 || properties2.getProperty("derby.storage.minimumRecordSize").compareTo("1") != 0) {
            throw T_Fail.testFailMsg("(getTableProperties) Did not get expected table propertes.\nGot pageSize = " + properties2.getProperty("derby.storage.pageSize") + "\nGot reserved = " + properties2.getProperty("derby.storage.pageReservedSpace") + "\nGot minimum record size = " + properties2.getProperty("derby.storage.minimumRecordSize"));
        }
        transactionController.commit();
        this.REPORT("Ending t_014");
        return true;
    }

    protected boolean t_015(TransactionController transactionController) throws StandardException, T_Fail {
        ScanController scanController = null;
        this.REPORT("Starting t_015");
        T_CreateConglomRet t_CreateConglomRet = new T_CreateConglomRet();
        this.createCongloms(transactionController, 2, false, false, 2, t_CreateConglomRet);
        ConglomerateController conglomerateController = transactionController.openConglomerate(t_CreateConglomRet.base_conglomid, false, 4, 6, 5);
        ConglomerateController conglomerateController2 = transactionController.openConglomerate(t_CreateConglomRet.index_conglomid, false, 4, 6, 5);
        if (!(conglomerateController2 instanceof B2IController)) {
            throw T_Fail.testFailMsg("openConglomerate returned wrong type");
        }
        conglomerateController2.checkConsistency();
        DataValueDescriptor[] dataValueDescriptorArray = TemplateRow.newU8Row((int)2);
        T_SecondaryIndexRow t_SecondaryIndexRow = new T_SecondaryIndexRow();
        RowLocation rowLocation = conglomerateController.newRowLocationTemplate();
        t_SecondaryIndexRow.init(dataValueDescriptorArray, rowLocation, 3);
        transactionController.commit();
        conglomerateController = transactionController.openConglomerate(t_CreateConglomRet.base_conglomid, false, 4, 6, 5);
        conglomerateController2 = transactionController.openConglomerate(t_CreateConglomRet.index_conglomid, false, 4, 6, 5);
        for (int i = 100; i > 0; i -= 2) {
            ((SQLLongint)dataValueDescriptorArray[0]).setValue(2);
            ((SQLLongint)dataValueDescriptorArray[1]).setValue(i);
            conglomerateController.insertAndFetchLocation(dataValueDescriptorArray, rowLocation);
            if (conglomerateController2.insert(t_SecondaryIndexRow.getRow()) == 0) continue;
            throw T_Fail.testFailMsg("insert failed");
        }
        String[] stringArray = new String[]{"B2iRowLocking3_1_lockScanRow1", "B2iRowLocking3_2_lockScanRow1", "BTreeScan_positionAtStartPosition1", "BTreeScan_fetchNextGroup1"};
        for (int i = 0; i < stringArray.length; ++i) {
            this.REPORT("Doing latch release tests: " + stringArray[i]);
            scanController = transactionController.openScan(t_CreateConglomRet.index_conglomid, false, 0, 6, 5, (FormatableBitSet)null, null, 0, null, null, 0);
            int n = 0;
            while (scanController.next()) {
                ++n;
            }
            scanController.close();
            if (n == 50) continue;
            throw T_Fail.testFailMsg("wrong scan count = " + n);
        }
        transactionController.abort();
        this.REPORT("Ending t_015");
        return true;
    }

    protected boolean t_016(TransactionController transactionController) throws StandardException, T_Fail {
        ScanController scanController = null;
        this.REPORT("Starting t_016");
        T_CreateConglomRet t_CreateConglomRet = new T_CreateConglomRet();
        this.createCongloms(transactionController, 2, false, false, 2, t_CreateConglomRet);
        ConglomerateController conglomerateController = transactionController.openConglomerate(t_CreateConglomRet.base_conglomid, false, 4, 6, 5);
        ConglomerateController conglomerateController2 = transactionController.openConglomerate(t_CreateConglomRet.index_conglomid, false, 4, 6, 5);
        if (!(conglomerateController2 instanceof B2IController)) {
            throw T_Fail.testFailMsg("openConglomerate returned wrong type");
        }
        conglomerateController2.checkConsistency();
        DataValueDescriptor[] dataValueDescriptorArray = TemplateRow.newU8Row((int)2);
        T_SecondaryIndexRow t_SecondaryIndexRow = new T_SecondaryIndexRow();
        RowLocation rowLocation = conglomerateController.newRowLocationTemplate();
        t_SecondaryIndexRow.init(dataValueDescriptorArray, rowLocation, 3);
        transactionController.commit();
        conglomerateController = transactionController.openConglomerate(t_CreateConglomRet.base_conglomid, false, 4, 6, 5);
        conglomerateController2 = transactionController.openConglomerate(t_CreateConglomRet.index_conglomid, false, 4, 6, 5);
        for (int i = 100; i > 0; i -= 2) {
            ((SQLLongint)dataValueDescriptorArray[0]).setValue(2);
            ((SQLLongint)dataValueDescriptorArray[1]).setValue(i);
            conglomerateController.insertAndFetchLocation(dataValueDescriptorArray, rowLocation);
            if (conglomerateController2.insert(t_SecondaryIndexRow.getRow()) == 0) continue;
            throw T_Fail.testFailMsg("insert failed");
        }
        transactionController.abort();
        String[] stringArray = new String[]{"B2iRowLocking3_1_lockScanRow2", "B2iRowLocking3_2_lockScanRow2", "BTreeScan_positionAtStartPosition2", "BTreeScan_fetchNextGroup2"};
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                this.REPORT("Doing deadlock tests: " + stringArray[i]);
                scanController = transactionController.openScan(t_CreateConglomRet.index_conglomid, false, 0, 6, 5, (FormatableBitSet)null, null, 0, null, null, 0);
                int n = 0;
                while (scanController.next()) {
                    ++n;
                }
                scanController.close();
                throw T_Fail.testFailMsg("expected deadlock");
            }
            catch (StandardException standardException) {
                if (!standardException.getMessageId().equals("40001")) {
                    throw standardException;
                }
                ContextService contextService = T_b2i.getContextService();
                ContextManager contextManager = contextService.getCurrentContextManager();
                contextManager.cleanupOnError((Throwable)standardException, this.isdbActive());
                continue;
            }
        }
        transactionController.commit();
        this.REPORT("Ending t_016");
        return true;
    }

    protected boolean t_perf(TransactionController transactionController) throws StandardException, T_Fail {
        boolean bl = true;
        this.REPORT("Starting t_005");
        T_CreateConglomRet t_CreateConglomRet = new T_CreateConglomRet();
        this.createCongloms(transactionController, 2, false, false, 0, t_CreateConglomRet);
        ConglomerateController conglomerateController = transactionController.openConglomerate(t_CreateConglomRet.base_conglomid, false, 4, 6, 5);
        ConglomerateController conglomerateController2 = transactionController.openConglomerate(t_CreateConglomRet.index_conglomid, false, 4, 6, 5);
        T_SecondaryIndexRow t_SecondaryIndexRow = new T_SecondaryIndexRow();
        RowLocation rowLocation = conglomerateController.newRowLocationTemplate();
        DataValueDescriptor[] dataValueDescriptorArray = TemplateRow.newU8Row((int)2);
        t_SecondaryIndexRow.init(dataValueDescriptorArray, rowLocation, 3);
        ((SQLLongint)dataValueDescriptorArray[0]).setValue(1);
        ((SQLLongint)dataValueDescriptorArray[1]).setValue(1);
        conglomerateController.insertAndFetchLocation(dataValueDescriptorArray, rowLocation);
        long l = System.currentTimeMillis();
        for (int i = 0; i < 2000; ++i) {
            ((SQLLongint)dataValueDescriptorArray[1]).setValue(i);
            if (conglomerateController2.insert(t_SecondaryIndexRow.getRow()) == 0) continue;
            throw T_Fail.testFailMsg("insert failed");
        }
        transactionController.commit();
        long l2 = System.currentTimeMillis();
        long l3 = l2 - l;
        System.out.println("  Elapsed (ms)      " + l3);
        System.out.println("  inserts/second " + 1000000L / l3);
        conglomerateController2.close();
        this.REPORT("Ending t_011");
        return bl;
    }

    private boolean t_desc_scan_test_cases(TransactionController transactionController, long l, T_SecondaryIndexRow t_SecondaryIndexRow) throws StandardException, T_Fail {
        boolean bl = true;
        DataValueDescriptor[] dataValueDescriptorArray = TemplateRow.newU8Row((int)1);
        DataValueDescriptor[] dataValueDescriptorArray2 = TemplateRow.newU8Row((int)1);
        this.REPORT("scan (x = 5)");
        ((SQLLongint)dataValueDescriptorArray[0]).setValue(5);
        ((SQLLongint)dataValueDescriptorArray2[0]).setValue(5);
        if (!T_QualifierTest.t_scan(transactionController, l, t_SecondaryIndexRow.getRow(), t_SecondaryIndexRow.getRow(), dataValueDescriptorArray, 1, null, dataValueDescriptorArray2, -1, 3, 18, 4)) {
            bl = false;
        }
        this.REPORT("scan (x > 5)");
        ((SQLLongint)dataValueDescriptorArray2[0]).setValue(5);
        if (!T_QualifierTest.t_scan(transactionController, l, t_SecondaryIndexRow.getRow(), t_SecondaryIndexRow.getRow(), null, 0, null, dataValueDescriptorArray2, 1, 3, 21, 4)) {
            bl = false;
        }
        this.REPORT("scan (x >= 5)");
        ((SQLLongint)dataValueDescriptorArray2[0]).setValue(5);
        if (!T_QualifierTest.t_scan(transactionController, l, t_SecondaryIndexRow.getRow(), t_SecondaryIndexRow.getRow(), null, 0, null, dataValueDescriptorArray2, -1, 6, 21, 4)) {
            bl = false;
        }
        this.REPORT("scan (x <= 5)");
        ((SQLLongint)dataValueDescriptorArray[0]).setValue(5);
        if (!T_QualifierTest.t_scan(transactionController, l, t_SecondaryIndexRow.getRow(), t_SecondaryIndexRow.getRow(), dataValueDescriptorArray, 1, null, null, 0, 8, 18, 4)) {
            bl = false;
        }
        this.REPORT("scan (x < 5)");
        ((SQLLongint)dataValueDescriptorArray[0]).setValue(5);
        if (!T_QualifierTest.t_scan(transactionController, l, t_SecondaryIndexRow.getRow(), t_SecondaryIndexRow.getRow(), dataValueDescriptorArray, -1, null, null, 0, 5, 15, 4)) {
            bl = false;
        }
        this.REPORT("scan (x >= 5 and x <= 7)");
        ((SQLLongint)dataValueDescriptorArray[0]).setValue(7);
        ((SQLLongint)dataValueDescriptorArray2[0]).setValue(5);
        if (!T_QualifierTest.t_scan(transactionController, l, t_SecondaryIndexRow.getRow(), t_SecondaryIndexRow.getRow(), dataValueDescriptorArray, 1, null, dataValueDescriptorArray2, -1, 5, 20, 4)) {
            bl = false;
        }
        this.REPORT("scan (x = 5 and y > 2)");
        dataValueDescriptorArray = TemplateRow.newU8Row((int)1);
        dataValueDescriptorArray2 = TemplateRow.newU8Row((int)2);
        ((SQLLongint)dataValueDescriptorArray[0]).setValue(5);
        ((SQLLongint)dataValueDescriptorArray2[0]).setValue(5);
        ((SQLLongint)dataValueDescriptorArray2[1]).setValue(2);
        if (!T_QualifierTest.t_scan(transactionController, l, t_SecondaryIndexRow.getRow(), t_SecondaryIndexRow.getRow(), dataValueDescriptorArray, 1, null, dataValueDescriptorArray2, 1, 2, 18, 4)) {
            bl = false;
        }
        this.REPORT("scan (x = 5 and y >= 2)");
        dataValueDescriptorArray = TemplateRow.newU8Row((int)1);
        dataValueDescriptorArray2 = TemplateRow.newU8Row((int)2);
        ((SQLLongint)dataValueDescriptorArray[0]).setValue(5);
        ((SQLLongint)dataValueDescriptorArray2[0]).setValue(5);
        ((SQLLongint)dataValueDescriptorArray2[1]).setValue(2);
        if (!T_QualifierTest.t_scan(transactionController, l, t_SecondaryIndexRow.getRow(), t_SecondaryIndexRow.getRow(), dataValueDescriptorArray, 1, null, dataValueDescriptorArray2, -1, 3, 18, 4)) {
            bl = false;
        }
        this.REPORT("scan (x = 5 and y < 5)");
        dataValueDescriptorArray = TemplateRow.newU8Row((int)2);
        dataValueDescriptorArray2 = TemplateRow.newU8Row((int)1);
        ((SQLLongint)dataValueDescriptorArray[0]).setValue(5);
        ((SQLLongint)dataValueDescriptorArray[1]).setValue(5);
        ((SQLLongint)dataValueDescriptorArray2[0]).setValue(5);
        if (!T_QualifierTest.t_scan(transactionController, l, t_SecondaryIndexRow.getRow(), t_SecondaryIndexRow.getRow(), dataValueDescriptorArray, 1, null, dataValueDescriptorArray2, -1, 2, 17, 4)) {
            bl = false;
        }
        this.REPORT("scan (x = 2)");
        dataValueDescriptorArray = TemplateRow.newU8Row((int)1);
        dataValueDescriptorArray2 = TemplateRow.newU8Row((int)1);
        ((SQLLongint)dataValueDescriptorArray[0]).setValue(2);
        ((SQLLongint)dataValueDescriptorArray2[0]).setValue(2);
        if (!T_QualifierTest.t_scan(transactionController, l, t_SecondaryIndexRow.getRow(), t_SecondaryIndexRow.getRow(), dataValueDescriptorArray, 1, null, dataValueDescriptorArray2, -1, 0, 0, 4)) {
            bl = false;
        }
        this.REPORT("minimum on btree, row locked.");
        if (!transactionController.fetchMaxOnBtree(l, 0, 6, 5, (FormatableBitSet)null, t_SecondaryIndexRow.getRow())) {
            throw T_Fail.testFailMsg("found no min.");
        }
        long l2 = ((SQLLongint)t_SecondaryIndexRow.getRow()[2]).getLong();
        if (l2 != 11L) {
            throw T_Fail.testFailMsg("wrong minimum found.");
        }
        this.REPORT("min on btree, table locked.");
        if (!transactionController.fetchMaxOnBtree(l, 0, 7, 5, (FormatableBitSet)null, t_SecondaryIndexRow.getRow())) {
            throw T_Fail.testFailMsg("found no min.");
        }
        l2 = ((SQLLongint)t_SecondaryIndexRow.getRow()[2]).getLong();
        if (l2 != 11L) {
            throw T_Fail.testFailMsg("wrong min found.");
        }
        this.REPORT("min on btree, row locked.");
        if (!transactionController.fetchMaxOnBtree(l, 0, 6, 2, (FormatableBitSet)null, t_SecondaryIndexRow.getRow())) {
            throw T_Fail.testFailMsg("found no max.");
        }
        l2 = ((SQLLongint)t_SecondaryIndexRow.getRow()[2]).getLong();
        if (l2 != 11L) {
            throw T_Fail.testFailMsg("wrong min found.");
        }
        this.REPORT("min on btree, table locked.");
        if (!transactionController.fetchMaxOnBtree(l, 0, 7, 2, (FormatableBitSet)null, t_SecondaryIndexRow.getRow())) {
            throw T_Fail.testFailMsg("found no min.");
        }
        l2 = ((SQLLongint)t_SecondaryIndexRow.getRow()[2]).getLong();
        if (l2 != 11L) {
            throw T_Fail.testFailMsg("wrong min found.");
        }
        return bl;
    }

    protected boolean t_017(TransactionController transactionController) throws StandardException, T_Fail {
        int n;
        boolean bl;
        T_SecondaryIndexRow t_SecondaryIndexRow = new T_SecondaryIndexRow();
        DataValueDescriptor[] dataValueDescriptorArray = TemplateRow.newU8Row((int)4);
        dataValueDescriptorArray[3] = new SQLChar();
        Object object = new String();
        for (bl = false; bl < 300 != 0; bl += 1) {
            object = (String)object + "mikem";
        }
        bl = true;
        long l = -1L;
        long[] lArray = new long[]{1L, 3L, 4L, 4L, 4L, 5L, 5L, 5L, 6L, 7L, 9L};
        long[] lArray2 = new long[]{1L, 1L, 2L, 4L, 6L, 2L, 4L, 6L, 1L, 1L, 1L};
        long[] lArray3 = new long[]{11L, 12L, 13L, 14L, 15L, 16L, 17L, 18L, 19L, 20L, 21L};
        long[] lArray4 = new long[]{0L, 2L, 3L, 4L, 4L, 5L, 5L, 5L, 6L, 7L, 8L, 10L, 11L, 12L};
        long[] lArray5 = new long[]{1L, 1L, 2L, 3L, 5L, 0L, 3L, 5L, 0L, 0L, 1L, 42L, 42L, 1L};
        long[] lArray6 = new long[]{91L, 92L, 93L, 94L, 95L, 96L, 97L, 98L, 99L, 100L, 101L, 102L, 103L, 104L};
        this.REPORT("Starting t_017");
        long l2 = transactionController.createConglomerate("heap", dataValueDescriptorArray, null, null, null, 0);
        ConglomerateController conglomerateController = transactionController.openConglomerate(l2, false, 4, 6, 5);
        t_SecondaryIndexRow.init(dataValueDescriptorArray, conglomerateController.newRowLocationTemplate(), 5);
        Properties properties = T_b2i.createProperties(null, false, 5, 5, true, l2, 4);
        ColumnOrdering[] columnOrderingArray = new ColumnOrdering[]{new T_ColumnOrderingImpl(0, false), new T_ColumnOrderingImpl(1, false), new T_ColumnOrderingImpl(2, false), new T_ColumnOrderingImpl(3, false), new T_ColumnOrderingImpl(4, true)};
        long l3 = transactionController.createConglomerate("BTREE", t_SecondaryIndexRow.getRow(), columnOrderingArray, null, properties, 0);
        ConglomerateController conglomerateController2 = transactionController.openConglomerate(l3, false, 4, 6, 5);
        T_SecondaryIndexRow t_SecondaryIndexRow2 = new T_SecondaryIndexRow();
        RowLocation rowLocation = conglomerateController.newRowLocationTemplate();
        t_SecondaryIndexRow2.init(dataValueDescriptorArray, rowLocation, 5);
        for (n = lArray.length - 1; n >= 0; --n) {
            ((SQLLongint)t_SecondaryIndexRow2.getRow()[0]).setValue(lArray[n]);
            ((SQLLongint)t_SecondaryIndexRow2.getRow()[1]).setValue(lArray2[n]);
            ((SQLLongint)t_SecondaryIndexRow2.getRow()[2]).setValue(lArray3[n]);
            dataValueDescriptorArray[3] = new SQLChar((String)object);
            conglomerateController.insertAndFetchLocation(dataValueDescriptorArray, rowLocation);
            if (conglomerateController2.insert(t_SecondaryIndexRow2.getRow()) == 0) continue;
            throw T_Fail.testFailMsg("insert failed");
        }
        conglomerateController2.checkConsistency();
        ((B2IController)conglomerateController2).debugConglomerate();
        bl = this.t_desc_scan_test_cases(transactionController, l3, t_SecondaryIndexRow2);
        for (n = lArray4.length - 1; n >= 0; --n) {
            ((SQLLongint)t_SecondaryIndexRow2.getRow()[0]).setValue(lArray4[n]);
            ((SQLLongint)t_SecondaryIndexRow2.getRow()[1]).setValue(lArray5[n]);
            ((SQLLongint)t_SecondaryIndexRow2.getRow()[2]).setValue(lArray6[n]);
            dataValueDescriptorArray[3] = new SQLChar((String)object);
            conglomerateController.insertAndFetchLocation(dataValueDescriptorArray, rowLocation);
            if (conglomerateController2.insert(t_SecondaryIndexRow2.getRow()) != 0) {
                throw T_Fail.testFailMsg("insert failed");
            }
            conglomerateController.delete(rowLocation);
            ScanController scanController = transactionController.openScan(l3, false, 4, 6, 5, (FormatableBitSet)null, t_SecondaryIndexRow2.getRow(), 1, null, t_SecondaryIndexRow2.getRow(), -1);
            if (!scanController.next()) {
                throw T_Fail.testFailMsg("delete could not find key");
            }
            scanController.delete();
            if (scanController.next()) {
                throw T_Fail.testFailMsg("delete found more than one key");
            }
            scanController.close();
        }
        bl = this.t_desc_scan_test_cases(transactionController, l3, t_SecondaryIndexRow2);
        conglomerateController2.close();
        transactionController.commit();
        this.REPORT("Ending t_017");
        return bl;
    }

    private boolean t_ascdesc_scan_test_cases(TransactionController transactionController, long l, T_SecondaryIndexRow t_SecondaryIndexRow) throws StandardException, T_Fail {
        boolean bl = true;
        DataValueDescriptor[] dataValueDescriptorArray = TemplateRow.newU8Row((int)1);
        DataValueDescriptor[] dataValueDescriptorArray2 = TemplateRow.newU8Row((int)1);
        this.REPORT("scan (x = 5)");
        ((SQLLongint)dataValueDescriptorArray[0]).setValue(5);
        ((SQLLongint)dataValueDescriptorArray2[0]).setValue(5);
        if (!T_QualifierTest.t_scan(transactionController, l, t_SecondaryIndexRow.getRow(), t_SecondaryIndexRow.getRow(), dataValueDescriptorArray, 1, null, dataValueDescriptorArray2, -1, 3, 18, 4)) {
            bl = false;
        }
        this.REPORT("scan (x > 5)");
        ((SQLLongint)dataValueDescriptorArray[0]).setValue(5);
        if (!T_QualifierTest.t_scan(transactionController, l, t_SecondaryIndexRow.getRow(), t_SecondaryIndexRow.getRow(), dataValueDescriptorArray, -1, null, null, 0, 3, 19, 1)) {
            bl = false;
        }
        this.REPORT("scan (x >= 5)");
        ((SQLLongint)dataValueDescriptorArray[0]).setValue(5);
        if (!T_QualifierTest.t_scan(transactionController, l, t_SecondaryIndexRow.getRow(), t_SecondaryIndexRow.getRow(), dataValueDescriptorArray, 1, null, null, 0, 6, 16, 3)) {
            bl = false;
        }
        this.REPORT("scan (x <= 5)");
        ((SQLLongint)dataValueDescriptorArray2[0]).setValue(5);
        if (!T_QualifierTest.t_scan(transactionController, l, t_SecondaryIndexRow.getRow(), t_SecondaryIndexRow.getRow(), null, 0, null, dataValueDescriptorArray2, -1, 8, 11, 3)) {
            bl = false;
        }
        this.REPORT("scan (x < 5)");
        ((SQLLongint)dataValueDescriptorArray2[0]).setValue(5);
        if (!T_QualifierTest.t_scan(transactionController, l, t_SecondaryIndexRow.getRow(), t_SecondaryIndexRow.getRow(), null, 0, null, dataValueDescriptorArray2, 1, 5, 11, 3)) {
            bl = false;
        }
        this.REPORT("scan (x >= 5 and x <= 7)");
        ((SQLLongint)dataValueDescriptorArray[0]).setValue(5);
        ((SQLLongint)dataValueDescriptorArray2[0]).setValue(7);
        if (!T_QualifierTest.t_scan(transactionController, l, t_SecondaryIndexRow.getRow(), t_SecondaryIndexRow.getRow(), dataValueDescriptorArray, 1, null, dataValueDescriptorArray2, -1, 5, 16, 3)) {
            bl = false;
        }
        this.REPORT("scan (x = 5 and y > 2)");
        dataValueDescriptorArray = TemplateRow.newU8Row((int)1);
        dataValueDescriptorArray2 = TemplateRow.newU8Row((int)2);
        ((SQLLongint)dataValueDescriptorArray[0]).setValue(5);
        ((SQLLongint)dataValueDescriptorArray2[0]).setValue(5);
        ((SQLLongint)dataValueDescriptorArray2[1]).setValue(2);
        if (!T_QualifierTest.t_scan(transactionController, l, t_SecondaryIndexRow.getRow(), t_SecondaryIndexRow.getRow(), dataValueDescriptorArray, 1, null, dataValueDescriptorArray2, 1, 2, 18, 4)) {
            bl = false;
        }
        this.REPORT("scan (x = 5 and y >= 2)");
        dataValueDescriptorArray = TemplateRow.newU8Row((int)1);
        dataValueDescriptorArray2 = TemplateRow.newU8Row((int)2);
        ((SQLLongint)dataValueDescriptorArray[0]).setValue(5);
        ((SQLLongint)dataValueDescriptorArray2[0]).setValue(5);
        ((SQLLongint)dataValueDescriptorArray2[1]).setValue(2);
        if (!T_QualifierTest.t_scan(transactionController, l, t_SecondaryIndexRow.getRow(), t_SecondaryIndexRow.getRow(), dataValueDescriptorArray, 1, null, dataValueDescriptorArray2, -1, 3, 18, 4)) {
            bl = false;
        }
        this.REPORT("scan (x = 5 and y < 5)");
        dataValueDescriptorArray = TemplateRow.newU8Row((int)2);
        dataValueDescriptorArray2 = TemplateRow.newU8Row((int)1);
        ((SQLLongint)dataValueDescriptorArray[0]).setValue(5);
        ((SQLLongint)dataValueDescriptorArray[1]).setValue(5);
        ((SQLLongint)dataValueDescriptorArray2[0]).setValue(5);
        if (!T_QualifierTest.t_scan(transactionController, l, t_SecondaryIndexRow.getRow(), t_SecondaryIndexRow.getRow(), dataValueDescriptorArray, 1, null, dataValueDescriptorArray2, -1, 2, 17, 4)) {
            bl = false;
        }
        this.REPORT("scan (x = 2)");
        dataValueDescriptorArray = TemplateRow.newU8Row((int)1);
        dataValueDescriptorArray2 = TemplateRow.newU8Row((int)1);
        ((SQLLongint)dataValueDescriptorArray[0]).setValue(2);
        ((SQLLongint)dataValueDescriptorArray2[0]).setValue(2);
        if (!T_QualifierTest.t_scan(transactionController, l, t_SecondaryIndexRow.getRow(), t_SecondaryIndexRow.getRow(), dataValueDescriptorArray, 1, null, dataValueDescriptorArray2, -1, 0, 0, 4)) {
            bl = false;
        }
        this.REPORT("minimum on btree, row locked.");
        if (!transactionController.fetchMaxOnBtree(l, 0, 6, 5, (FormatableBitSet)null, t_SecondaryIndexRow.getRow())) {
            throw T_Fail.testFailMsg("found last row in the last leaf.");
        }
        long l2 = ((SQLLongint)t_SecondaryIndexRow.getRow()[2]).getLong();
        if (l2 != 21L) {
            throw T_Fail.testFailMsg("wrong last row in the last leaf.");
        }
        this.REPORT("last row in the last leaf, table locked.");
        if (!transactionController.fetchMaxOnBtree(l, 0, 7, 5, (FormatableBitSet)null, t_SecondaryIndexRow.getRow())) {
            throw T_Fail.testFailMsg("found no min.");
        }
        l2 = ((SQLLongint)t_SecondaryIndexRow.getRow()[2]).getLong();
        if (l2 != 21L) {
            throw T_Fail.testFailMsg("wrong last row in the last leaf found.");
        }
        this.REPORT("last row in the last leaf, row locked.");
        if (!transactionController.fetchMaxOnBtree(l, 0, 6, 2, (FormatableBitSet)null, t_SecondaryIndexRow.getRow())) {
            throw T_Fail.testFailMsg("found no max.");
        }
        l2 = ((SQLLongint)t_SecondaryIndexRow.getRow()[2]).getLong();
        if (l2 != 21L) {
            throw T_Fail.testFailMsg("wrong last row in the last leaf found.");
        }
        this.REPORT("last row in the last leaf, table locked.");
        if (!transactionController.fetchMaxOnBtree(l, 0, 7, 2, (FormatableBitSet)null, t_SecondaryIndexRow.getRow())) {
            throw T_Fail.testFailMsg("found no last row in the last leaf");
        }
        l2 = ((SQLLongint)t_SecondaryIndexRow.getRow()[2]).getLong();
        if (l2 != 21L) {
            throw T_Fail.testFailMsg("wrong last row in the last leaf found.");
        }
        return bl;
    }

    protected boolean t_018(TransactionController transactionController) throws StandardException, T_Fail {
        int n;
        boolean bl;
        T_SecondaryIndexRow t_SecondaryIndexRow = new T_SecondaryIndexRow();
        DataValueDescriptor[] dataValueDescriptorArray = TemplateRow.newU8Row((int)4);
        dataValueDescriptorArray[3] = new SQLChar();
        Object object = new String();
        for (bl = false; bl < 300 != 0; bl += 1) {
            object = (String)object + "mikem";
        }
        bl = true;
        long l = -1L;
        long[] lArray = new long[]{1L, 3L, 4L, 4L, 4L, 5L, 5L, 5L, 6L, 7L, 9L};
        long[] lArray2 = new long[]{1L, 1L, 2L, 4L, 6L, 2L, 4L, 6L, 1L, 1L, 1L};
        long[] lArray3 = new long[]{11L, 12L, 13L, 14L, 15L, 16L, 17L, 18L, 19L, 20L, 21L};
        long[] lArray4 = new long[]{0L, 2L, 3L, 4L, 4L, 5L, 5L, 5L, 6L, 7L, 8L, 10L, 11L, 12L};
        long[] lArray5 = new long[]{1L, 1L, 2L, 3L, 5L, 0L, 3L, 5L, 0L, 0L, 1L, 42L, 42L, 1L};
        long[] lArray6 = new long[]{91L, 92L, 93L, 94L, 95L, 96L, 97L, 98L, 99L, 100L, 101L, 102L, 103L, 104L};
        this.REPORT("Starting t_018");
        long l2 = transactionController.createConglomerate("heap", dataValueDescriptorArray, null, null, null, 0);
        ConglomerateController conglomerateController = transactionController.openConglomerate(l2, false, 4, 6, 5);
        t_SecondaryIndexRow.init(dataValueDescriptorArray, conglomerateController.newRowLocationTemplate(), 5);
        Properties properties = T_b2i.createProperties(null, false, 5, 5, true, l2, 4);
        ColumnOrdering[] columnOrderingArray = new ColumnOrdering[]{new T_ColumnOrderingImpl(0, true), new T_ColumnOrderingImpl(1, false), new T_ColumnOrderingImpl(2, true), new T_ColumnOrderingImpl(3, false), new T_ColumnOrderingImpl(4, true)};
        long l3 = transactionController.createConglomerate("BTREE", t_SecondaryIndexRow.getRow(), columnOrderingArray, null, properties, 0);
        ConglomerateController conglomerateController2 = transactionController.openConglomerate(l3, false, 4, 6, 5);
        T_SecondaryIndexRow t_SecondaryIndexRow2 = new T_SecondaryIndexRow();
        RowLocation rowLocation = conglomerateController.newRowLocationTemplate();
        t_SecondaryIndexRow2.init(dataValueDescriptorArray, rowLocation, 5);
        for (n = lArray.length - 1; n >= 0; --n) {
            ((SQLLongint)t_SecondaryIndexRow2.getRow()[0]).setValue(lArray[n]);
            ((SQLLongint)t_SecondaryIndexRow2.getRow()[1]).setValue(lArray2[n]);
            ((SQLLongint)t_SecondaryIndexRow2.getRow()[2]).setValue(lArray3[n]);
            dataValueDescriptorArray[3] = new SQLChar((String)object);
            conglomerateController.insertAndFetchLocation(dataValueDescriptorArray, rowLocation);
            if (conglomerateController2.insert(t_SecondaryIndexRow2.getRow()) == 0) continue;
            throw T_Fail.testFailMsg("insert failed");
        }
        conglomerateController2.checkConsistency();
        ((B2IController)conglomerateController2).debugConglomerate();
        bl = this.t_ascdesc_scan_test_cases(transactionController, l3, t_SecondaryIndexRow2);
        for (n = lArray4.length - 1; n >= 0; --n) {
            ((SQLLongint)t_SecondaryIndexRow2.getRow()[0]).setValue(lArray4[n]);
            ((SQLLongint)t_SecondaryIndexRow2.getRow()[1]).setValue(lArray5[n]);
            ((SQLLongint)t_SecondaryIndexRow2.getRow()[2]).setValue(lArray6[n]);
            dataValueDescriptorArray[3] = new SQLChar((String)object);
            conglomerateController.insertAndFetchLocation(dataValueDescriptorArray, rowLocation);
            if (conglomerateController2.insert(t_SecondaryIndexRow2.getRow()) != 0) {
                throw T_Fail.testFailMsg("insert failed");
            }
            conglomerateController.delete(rowLocation);
            ScanController scanController = transactionController.openScan(l3, false, 4, 6, 5, (FormatableBitSet)null, t_SecondaryIndexRow2.getRow(), 1, null, t_SecondaryIndexRow2.getRow(), -1);
            if (!scanController.next()) {
                throw T_Fail.testFailMsg("delete could not find key");
            }
            scanController.delete();
            if (scanController.next()) {
                throw T_Fail.testFailMsg("delete found more than one key");
            }
            scanController.close();
        }
        bl = this.t_ascdesc_scan_test_cases(transactionController, l3, t_SecondaryIndexRow2);
        conglomerateController2.close();
        transactionController.commit();
        this.REPORT("Ending t_018");
        return bl;
    }

    private boolean t_ascdesc1_scan_test_cases(TransactionController transactionController, long l, T_SecondaryIndexRow t_SecondaryIndexRow) throws StandardException, T_Fail {
        boolean bl = true;
        DataValueDescriptor[] dataValueDescriptorArray = TemplateRow.newU8Row((int)1);
        DataValueDescriptor[] dataValueDescriptorArray2 = TemplateRow.newU8Row((int)1);
        this.REPORT("scan (x = 5)");
        ((SQLLongint)dataValueDescriptorArray[0]).setValue(5);
        ((SQLLongint)dataValueDescriptorArray2[0]).setValue(5);
        if (!T_QualifierTest.t_scan(transactionController, l, t_SecondaryIndexRow.getRow(), t_SecondaryIndexRow.getRow(), dataValueDescriptorArray, 1, null, dataValueDescriptorArray2, -1, 3, 16, 1)) {
            bl = false;
        }
        this.REPORT("scan (x > 5)");
        ((SQLLongint)dataValueDescriptorArray2[0]).setValue(5);
        if (!T_QualifierTest.t_scan(transactionController, l, t_SecondaryIndexRow.getRow(), t_SecondaryIndexRow.getRow(), null, 0, null, dataValueDescriptorArray2, 1, 3, 21, 4)) {
            bl = false;
        }
        this.REPORT("scan (x >= 5)");
        ((SQLLongint)dataValueDescriptorArray2[0]).setValue(5);
        if (!T_QualifierTest.t_scan(transactionController, l, t_SecondaryIndexRow.getRow(), t_SecondaryIndexRow.getRow(), null, 0, null, dataValueDescriptorArray2, -1, 6, 16, 3)) {
            bl = false;
        }
        this.REPORT("scan (x <= 5)");
        ((SQLLongint)dataValueDescriptorArray[0]).setValue(5);
        if (!T_QualifierTest.t_scan(transactionController, l, t_SecondaryIndexRow.getRow(), t_SecondaryIndexRow.getRow(), dataValueDescriptorArray, 1, null, null, 0, 8, 11, 3)) {
            bl = false;
        }
        this.REPORT("scan (x < 5)");
        ((SQLLongint)dataValueDescriptorArray[0]).setValue(5);
        if (!T_QualifierTest.t_scan(transactionController, l, t_SecondaryIndexRow.getRow(), t_SecondaryIndexRow.getRow(), dataValueDescriptorArray, -1, null, null, 0, 5, 11, 3)) {
            bl = false;
        }
        this.REPORT("scan (x >= 5 and x <= 7)");
        ((SQLLongint)dataValueDescriptorArray[0]).setValue(7);
        ((SQLLongint)dataValueDescriptorArray2[0]).setValue(5);
        if (!T_QualifierTest.t_scan(transactionController, l, t_SecondaryIndexRow.getRow(), t_SecondaryIndexRow.getRow(), dataValueDescriptorArray, 1, null, dataValueDescriptorArray2, -1, 5, 16, 3)) {
            bl = false;
        }
        this.REPORT("scan (x = 5 and y > 2)");
        dataValueDescriptorArray = TemplateRow.newU8Row((int)2);
        dataValueDescriptorArray2 = TemplateRow.newU8Row((int)1);
        ((SQLLongint)dataValueDescriptorArray[0]).setValue(5);
        ((SQLLongint)dataValueDescriptorArray[1]).setValue(2);
        ((SQLLongint)dataValueDescriptorArray2[0]).setValue(5);
        if (!T_QualifierTest.t_scan(transactionController, l, t_SecondaryIndexRow.getRow(), t_SecondaryIndexRow.getRow(), dataValueDescriptorArray, -1, null, dataValueDescriptorArray2, -1, 2, 17, 1)) {
            bl = false;
        }
        this.REPORT("scan (x = 5 and y >= 2)");
        dataValueDescriptorArray = TemplateRow.newU8Row((int)2);
        dataValueDescriptorArray2 = TemplateRow.newU8Row((int)1);
        ((SQLLongint)dataValueDescriptorArray[0]).setValue(5);
        ((SQLLongint)dataValueDescriptorArray[1]).setValue(2);
        ((SQLLongint)dataValueDescriptorArray2[0]).setValue(5);
        if (!T_QualifierTest.t_scan(transactionController, l, t_SecondaryIndexRow.getRow(), t_SecondaryIndexRow.getRow(), dataValueDescriptorArray, 1, null, dataValueDescriptorArray2, -1, 3, 16, 1)) {
            bl = false;
        }
        this.REPORT("scan (x = 5 and y < 5)");
        dataValueDescriptorArray = TemplateRow.newU8Row((int)1);
        dataValueDescriptorArray2 = TemplateRow.newU8Row((int)2);
        ((SQLLongint)dataValueDescriptorArray[0]).setValue(5);
        ((SQLLongint)dataValueDescriptorArray2[0]).setValue(5);
        ((SQLLongint)dataValueDescriptorArray2[1]).setValue(5);
        if (!T_QualifierTest.t_scan(transactionController, l, t_SecondaryIndexRow.getRow(), t_SecondaryIndexRow.getRow(), dataValueDescriptorArray, 1, null, dataValueDescriptorArray2, -1, 2, 16, 1)) {
            bl = false;
        }
        this.REPORT("scan (x = 2)");
        dataValueDescriptorArray = TemplateRow.newU8Row((int)1);
        dataValueDescriptorArray2 = TemplateRow.newU8Row((int)1);
        ((SQLLongint)dataValueDescriptorArray[0]).setValue(2);
        ((SQLLongint)dataValueDescriptorArray2[0]).setValue(2);
        if (!T_QualifierTest.t_scan(transactionController, l, t_SecondaryIndexRow.getRow(), t_SecondaryIndexRow.getRow(), dataValueDescriptorArray, 1, null, dataValueDescriptorArray2, -1, 0, 0, 4)) {
            bl = false;
        }
        this.REPORT("scan (x > 2)");
        dataValueDescriptorArray2 = TemplateRow.newU8Row((int)1);
        ((SQLLongint)dataValueDescriptorArray2[0]).setValue(2);
        if (!T_QualifierTest.t_scan(transactionController, l, t_SecondaryIndexRow.getRow(), t_SecondaryIndexRow.getRow(), null, 0, null, dataValueDescriptorArray2, 1, 10, 12, 3)) {
            bl = false;
        }
        this.REPORT("scan (x >= 2)");
        dataValueDescriptorArray2 = TemplateRow.newU8Row((int)1);
        ((SQLLongint)dataValueDescriptorArray2[0]).setValue(2);
        if (!T_QualifierTest.t_scan(transactionController, l, t_SecondaryIndexRow.getRow(), t_SecondaryIndexRow.getRow(), null, 0, null, dataValueDescriptorArray2, -1, 10, 12, 3)) {
            bl = false;
        }
        this.REPORT("scan (x < 2)");
        dataValueDescriptorArray = TemplateRow.newU8Row((int)1);
        ((SQLLongint)dataValueDescriptorArray[0]).setValue(2);
        if (!T_QualifierTest.t_scan(transactionController, l, t_SecondaryIndexRow.getRow(), t_SecondaryIndexRow.getRow(), dataValueDescriptorArray, -1, null, null, 0, 1, 11, 3)) {
            bl = false;
        }
        this.REPORT("scan (x <= 2)");
        dataValueDescriptorArray = TemplateRow.newU8Row((int)1);
        ((SQLLongint)dataValueDescriptorArray[0]).setValue(2);
        if (!T_QualifierTest.t_scan(transactionController, l, t_SecondaryIndexRow.getRow(), t_SecondaryIndexRow.getRow(), dataValueDescriptorArray, 1, null, null, 0, 1, 11, 3)) {
            bl = false;
        }
        this.REPORT("scan (x >= 2 and x <= 7)");
        ((SQLLongint)dataValueDescriptorArray[0]).setValue(7);
        ((SQLLongint)dataValueDescriptorArray2[0]).setValue(2);
        if (!T_QualifierTest.t_scan(transactionController, l, t_SecondaryIndexRow.getRow(), t_SecondaryIndexRow.getRow(), dataValueDescriptorArray, 1, null, dataValueDescriptorArray2, -1, 9, 12, 3)) {
            bl = false;
        }
        this.REPORT("scan (x = 2 and y > 2)");
        dataValueDescriptorArray = TemplateRow.newU8Row((int)2);
        dataValueDescriptorArray2 = TemplateRow.newU8Row((int)1);
        ((SQLLongint)dataValueDescriptorArray[0]).setValue(2);
        ((SQLLongint)dataValueDescriptorArray[1]).setValue(2);
        ((SQLLongint)dataValueDescriptorArray2[0]).setValue(2);
        if (!T_QualifierTest.t_scan(transactionController, l, t_SecondaryIndexRow.getRow(), t_SecondaryIndexRow.getRow(), dataValueDescriptorArray, -1, null, dataValueDescriptorArray2, -1, 0, 0, 3)) {
            bl = false;
        }
        this.REPORT("scan (x = 2 and y >= 2)");
        dataValueDescriptorArray = TemplateRow.newU8Row((int)2);
        dataValueDescriptorArray2 = TemplateRow.newU8Row((int)1);
        ((SQLLongint)dataValueDescriptorArray[0]).setValue(2);
        ((SQLLongint)dataValueDescriptorArray[1]).setValue(2);
        ((SQLLongint)dataValueDescriptorArray2[0]).setValue(2);
        if (!T_QualifierTest.t_scan(transactionController, l, t_SecondaryIndexRow.getRow(), t_SecondaryIndexRow.getRow(), dataValueDescriptorArray, 1, null, dataValueDescriptorArray2, -1, 0, 0, 3)) {
            bl = false;
        }
        this.REPORT("scan (x = 4 and y <=2)");
        dataValueDescriptorArray = TemplateRow.newU8Row((int)1);
        dataValueDescriptorArray2 = TemplateRow.newU8Row((int)2);
        ((SQLLongint)dataValueDescriptorArray[0]).setValue(4);
        ((SQLLongint)dataValueDescriptorArray2[0]).setValue(4);
        ((SQLLongint)dataValueDescriptorArray2[1]).setValue(2);
        if (!T_QualifierTest.t_scan(transactionController, l, t_SecondaryIndexRow.getRow(), t_SecondaryIndexRow.getRow(), dataValueDescriptorArray, 1, null, dataValueDescriptorArray2, -1, 1, 13, 4)) {
            bl = false;
        }
        this.REPORT("last row in the last leaf, row locked.");
        if (!transactionController.fetchMaxOnBtree(l, 0, 6, 5, (FormatableBitSet)null, t_SecondaryIndexRow.getRow())) {
            throw T_Fail.testFailMsg("found last row in the last leaf.");
        }
        long l2 = ((SQLLongint)t_SecondaryIndexRow.getRow()[2]).getLong();
        if (l2 != 11L) {
            throw T_Fail.testFailMsg("wrong last row in the last leaf.");
        }
        this.REPORT("last row in the last leaf, table locked.");
        if (!transactionController.fetchMaxOnBtree(l, 0, 7, 5, (FormatableBitSet)null, t_SecondaryIndexRow.getRow())) {
            throw T_Fail.testFailMsg("found no min.");
        }
        l2 = ((SQLLongint)t_SecondaryIndexRow.getRow()[2]).getLong();
        if (l2 != 11L) {
            throw T_Fail.testFailMsg("wrong last row in the last leaf found.");
        }
        this.REPORT("last row in the last leaf, row locked.");
        if (!transactionController.fetchMaxOnBtree(l, 0, 6, 2, (FormatableBitSet)null, t_SecondaryIndexRow.getRow())) {
            throw T_Fail.testFailMsg("found no max.");
        }
        l2 = ((SQLLongint)t_SecondaryIndexRow.getRow()[2]).getLong();
        if (l2 != 11L) {
            throw T_Fail.testFailMsg("wrong last row in the last leaf found.");
        }
        this.REPORT("last row in the last leaf, table locked.");
        if (!transactionController.fetchMaxOnBtree(l, 0, 7, 2, (FormatableBitSet)null, t_SecondaryIndexRow.getRow())) {
            throw T_Fail.testFailMsg("found no last row in the last leaf");
        }
        l2 = ((SQLLongint)t_SecondaryIndexRow.getRow()[2]).getLong();
        if (l2 != 11L) {
            throw T_Fail.testFailMsg("wrong last row in the last leaf found.");
        }
        return bl;
    }

    protected boolean t_019(TransactionController transactionController) throws StandardException, T_Fail {
        int n;
        boolean bl;
        T_SecondaryIndexRow t_SecondaryIndexRow = new T_SecondaryIndexRow();
        DataValueDescriptor[] dataValueDescriptorArray = TemplateRow.newU8Row((int)4);
        dataValueDescriptorArray[3] = new SQLChar();
        Object object = new String();
        for (bl = false; bl < 300 != 0; bl += 1) {
            object = (String)object + "mikem";
        }
        bl = true;
        long l = -1L;
        long[] lArray = new long[]{1L, 3L, 4L, 4L, 4L, 5L, 5L, 5L, 6L, 7L, 9L};
        long[] lArray2 = new long[]{1L, 1L, 2L, 4L, 6L, 2L, 4L, 6L, 1L, 1L, 1L};
        long[] lArray3 = new long[]{11L, 12L, 13L, 14L, 15L, 16L, 17L, 18L, 19L, 20L, 21L};
        long[] lArray4 = new long[]{0L, 2L, 3L, 4L, 4L, 5L, 5L, 5L, 6L, 7L, 8L, 10L, 11L, 12L};
        long[] lArray5 = new long[]{1L, 1L, 2L, 3L, 5L, 0L, 3L, 5L, 0L, 0L, 1L, 42L, 42L, 1L};
        long[] lArray6 = new long[]{91L, 92L, 93L, 94L, 95L, 96L, 97L, 98L, 99L, 100L, 101L, 102L, 103L, 104L};
        this.REPORT("Starting t_019");
        long l2 = transactionController.createConglomerate("heap", dataValueDescriptorArray, null, null, null, 0);
        ConglomerateController conglomerateController = transactionController.openConglomerate(l2, false, 4, 6, 5);
        t_SecondaryIndexRow.init(dataValueDescriptorArray, conglomerateController.newRowLocationTemplate(), 5);
        Properties properties = T_b2i.createProperties(null, false, 5, 5, true, l2, 4);
        ColumnOrdering[] columnOrderingArray = new ColumnOrdering[]{new T_ColumnOrderingImpl(0, false), new T_ColumnOrderingImpl(1, true), new T_ColumnOrderingImpl(2, true), new T_ColumnOrderingImpl(3, false), new T_ColumnOrderingImpl(4, true)};
        long l3 = transactionController.createConglomerate("BTREE", t_SecondaryIndexRow.getRow(), columnOrderingArray, null, properties, 0);
        ConglomerateController conglomerateController2 = transactionController.openConglomerate(l3, false, 4, 6, 5);
        T_SecondaryIndexRow t_SecondaryIndexRow2 = new T_SecondaryIndexRow();
        RowLocation rowLocation = conglomerateController.newRowLocationTemplate();
        t_SecondaryIndexRow2.init(dataValueDescriptorArray, rowLocation, 5);
        for (n = lArray.length - 1; n >= 0; --n) {
            ((SQLLongint)t_SecondaryIndexRow2.getRow()[0]).setValue(lArray[n]);
            ((SQLLongint)t_SecondaryIndexRow2.getRow()[1]).setValue(lArray2[n]);
            ((SQLLongint)t_SecondaryIndexRow2.getRow()[2]).setValue(lArray3[n]);
            dataValueDescriptorArray[3] = new SQLChar((String)object);
            conglomerateController.insertAndFetchLocation(dataValueDescriptorArray, rowLocation);
            if (conglomerateController2.insert(t_SecondaryIndexRow2.getRow()) == 0) continue;
            throw T_Fail.testFailMsg("insert failed");
        }
        conglomerateController2.checkConsistency();
        ((B2IController)conglomerateController2).debugConglomerate();
        bl = this.t_ascdesc1_scan_test_cases(transactionController, l3, t_SecondaryIndexRow2);
        for (n = lArray4.length - 1; n >= 0; --n) {
            ((SQLLongint)t_SecondaryIndexRow2.getRow()[0]).setValue(lArray4[n]);
            ((SQLLongint)t_SecondaryIndexRow2.getRow()[1]).setValue(lArray5[n]);
            ((SQLLongint)t_SecondaryIndexRow2.getRow()[2]).setValue(lArray6[n]);
            dataValueDescriptorArray[3] = new SQLChar((String)object);
            conglomerateController.insertAndFetchLocation(dataValueDescriptorArray, rowLocation);
            if (conglomerateController2.insert(t_SecondaryIndexRow2.getRow()) != 0) {
                throw T_Fail.testFailMsg("insert failed");
            }
            conglomerateController.delete(rowLocation);
            ScanController scanController = transactionController.openScan(l3, false, 4, 6, 5, (FormatableBitSet)null, t_SecondaryIndexRow2.getRow(), 1, null, t_SecondaryIndexRow2.getRow(), -1);
            if (!scanController.next()) {
                throw T_Fail.testFailMsg("delete could not find key");
            }
            scanController.delete();
            if (scanController.next()) {
                throw T_Fail.testFailMsg("delete found more than one key");
            }
            scanController.close();
        }
        bl = this.t_ascdesc1_scan_test_cases(transactionController, l3, t_SecondaryIndexRow2);
        conglomerateController2.close();
        transactionController.commit();
        this.REPORT("Ending t_019");
        return bl;
    }

    protected boolean t_020(TransactionController transactionController) throws StandardException, T_Fail {
        Object var2_2 = null;
        this.REPORT("Starting t_020");
        T_CreateConglomRet t_CreateConglomRet = new T_CreateConglomRet();
        this.createCongloms(transactionController, 2, false, false, 2, t_CreateConglomRet);
        ConglomerateController conglomerateController = transactionController.openConglomerate(t_CreateConglomRet.base_conglomid, false, 4, 6, 5);
        ConglomerateController conglomerateController2 = transactionController.openConglomerate(t_CreateConglomRet.index_conglomid, false, 4, 6, 5);
        DataValueDescriptor[] dataValueDescriptorArray = TemplateRow.newU8Row((int)2);
        T_SecondaryIndexRow t_SecondaryIndexRow = new T_SecondaryIndexRow();
        RowLocation rowLocation = conglomerateController.newRowLocationTemplate();
        t_SecondaryIndexRow.init(dataValueDescriptorArray, rowLocation, 3);
        conglomerateController = transactionController.openConglomerate(t_CreateConglomRet.base_conglomid, false, 4, 6, 5);
        conglomerateController2 = transactionController.openConglomerate(t_CreateConglomRet.index_conglomid, false, 4, 6, 5);
        ((SQLLongint)dataValueDescriptorArray[0]).setValue(2);
        ((SQLLongint)dataValueDescriptorArray[1]).setValue(10000);
        conglomerateController.insertAndFetchLocation(dataValueDescriptorArray, rowLocation);
        if (conglomerateController2.insert(t_SecondaryIndexRow.getRow()) != 0) {
            throw T_Fail.testFailMsg("insert failed");
        }
        transactionController.commit();
        transactionController.commit();
        this.REPORT("Ending t_020");
        return true;
    }

    protected boolean t_021(TransactionController transactionController) throws StandardException, T_Fail {
        this.REPORT("Starting t_021");
        boolean bl = true;
        T_CreateConglomRet t_CreateConglomRet = new T_CreateConglomRet();
        this.createCongloms(transactionController, 2, false, false, 2, t_CreateConglomRet);
        ConglomerateController conglomerateController = transactionController.openConglomerate(t_CreateConglomRet.base_conglomid, false, 4, 6, 5);
        ConglomerateController conglomerateController2 = transactionController.openConglomerate(t_CreateConglomRet.index_conglomid, false, 4, 6, 5);
        DataValueDescriptor[] dataValueDescriptorArray = TemplateRow.newU8Row((int)2);
        T_SecondaryIndexRow t_SecondaryIndexRow = new T_SecondaryIndexRow();
        RowLocation rowLocation = conglomerateController.newRowLocationTemplate();
        t_SecondaryIndexRow.init(dataValueDescriptorArray, rowLocation, 3);
        ((SQLLongint)dataValueDescriptorArray[0]).setValue(1);
        ((SQLLongint)dataValueDescriptorArray[1]).setValue(1);
        conglomerateController.insertAndFetchLocation(dataValueDescriptorArray, rowLocation);
        if (conglomerateController2.insert(t_SecondaryIndexRow.getRow()) != 0) {
            throw T_Fail.testFailMsg("insert failed");
        }
        transactionController.commit();
        DataValueDescriptor[] dataValueDescriptorArray2 = TemplateRow.newU8Row((int)2);
        ((SQLLongint)dataValueDescriptorArray2[0]).setValue(1);
        ((SQLLongint)dataValueDescriptorArray2[1]).setValue(1);
        if (!this.t_delete(transactionController, t_CreateConglomRet.index_conglomid, dataValueDescriptorArray2, true)) {
            bl = false;
        }
        transactionController.commit();
        this.REPORT("Ending t_021");
        return bl;
    }

    public static String repeatString(String string, int n) {
        Object object = string;
        for (int i = 1; i < n; ++i) {
            object = (String)object + string;
        }
        return object;
    }

    public boolean isdbActive() {
        LanguageConnectionContext languageConnectionContext = (LanguageConnectionContext)T_b2i.getContextOrNull("LanguageConnectionContext");
        Database database = languageConnectionContext != null ? languageConnectionContext.getDatabase() : null;
        return database != null ? database.isActive() : false;
    }

    private static ContextService getContextService() {
        return ContextService.getFactory();
    }

    private static Context getContextOrNull(String string) {
        return ContextService.getContextOrNull((String)string);
    }

    private static Object findServiceModule(Object object, String string) throws StandardException {
        return Monitor.findServiceModule((Object)object, (String)string);
    }

    private static Object createPersistentService(String string, String string2, Properties properties) throws StandardException {
        return Monitor.createPersistentService((String)string, (String)string2, (Properties)properties);
    }
}

