/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.stages.task;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import org.apache.helix.HelixManager;
import org.apache.helix.controller.LogUtil;
import org.apache.helix.controller.dataproviders.WorkflowControllerDataProvider;
import org.apache.helix.controller.pipeline.AbstractBaseStage;
import org.apache.helix.controller.pipeline.StageException;
import org.apache.helix.controller.rebalancer.Rebalancer;
import org.apache.helix.controller.rebalancer.SemiAutoRebalancer;
import org.apache.helix.controller.rebalancer.internal.MappingCalculator;
import org.apache.helix.controller.stages.AttributeName;
import org.apache.helix.controller.stages.BestPossibleStateOutput;
import org.apache.helix.controller.stages.ClusterEvent;
import org.apache.helix.controller.stages.CurrentStateOutput;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.Partition;
import org.apache.helix.model.Resource;
import org.apache.helix.model.ResourceAssignment;
import org.apache.helix.monitoring.mbeans.ClusterStatusMonitor;
import org.apache.helix.task.AssignableInstanceManager;
import org.apache.helix.task.TaskRebalancer;
import org.apache.helix.task.WorkflowConfig;
import org.apache.helix.task.WorkflowContext;
import org.apache.helix.task.WorkflowDispatcher;
import org.apache.helix.util.HelixUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskSchedulingStage
extends AbstractBaseStage {
    private static final Logger logger = LoggerFactory.getLogger((String)TaskSchedulingStage.class.getName());
    private Map<String, PriorityQueue<WorkflowObject>> _quotaBasedWorkflowPQs = Maps.newHashMap();
    private WorkflowDispatcher _workflowDispatcher;

    @Override
    public void process(ClusterEvent event) throws Exception {
        this._eventId = event.getEventId();
        CurrentStateOutput currentStateOutput = (CurrentStateOutput)event.getAttribute(AttributeName.CURRENT_STATE.name());
        Map resourceMap = (Map)event.getAttribute(AttributeName.RESOURCES_TO_REBALANCE.name());
        WorkflowControllerDataProvider cache = (WorkflowControllerDataProvider)event.getAttribute(AttributeName.ControllerDataProvider.name());
        if (currentStateOutput == null || resourceMap == null || cache == null) {
            throw new StageException("Missing attributes in event:" + event + ". Requires CURRENT_STATE|RESOURCES|DataCache");
        }
        cache.resetActiveTaskCount(currentStateOutput);
        this.buildQuotaBasedWorkflowPQsAndInitDispatchers(cache, (HelixManager)event.getAttribute(AttributeName.helixmanager.name()), (ClusterStatusMonitor)event.getAttribute(AttributeName.clusterStatusMonitor.name()));
        BestPossibleStateOutput bestPossibleStateOutput = this.compute(event, resourceMap, currentStateOutput);
        event.addAttribute(AttributeName.BEST_POSSIBLE_STATE.name(), bestPossibleStateOutput);
    }

    private BestPossibleStateOutput compute(ClusterEvent event, Map<String, Resource> resourceMap, CurrentStateOutput currentStateOutput) {
        HashMap<String, Resource> restOfResources = new HashMap<String, Resource>(resourceMap);
        WorkflowControllerDataProvider cache = (WorkflowControllerDataProvider)event.getAttribute(AttributeName.ControllerDataProvider.name());
        BestPossibleStateOutput output = new BestPossibleStateOutput();
        ArrayList<String> failureResources = new ArrayList<String>();
        this.scheduleWorkflows(resourceMap, cache, restOfResources, failureResources, currentStateOutput, output);
        for (String jobName : cache.getTaskDataCache().getDispatchedJobs()) {
            this.updateResourceMap(jobName, resourceMap, output.getPartitionStateMap(jobName).partitionSet());
            restOfResources.remove(jobName);
        }
        for (Resource resource : restOfResources.values()) {
            if (this.computeResourceBestPossibleState(event, cache, currentStateOutput, resource, output)) continue;
            failureResources.add(resource.getResourceName());
            LogUtil.logWarn(logger, this._eventId, "Failed to calculate best possible states for " + resource.getResourceName());
        }
        return output;
    }

    private boolean computeResourceBestPossibleState(ClusterEvent event, WorkflowControllerDataProvider cache, CurrentStateOutput currentStateOutput, Resource resource, BestPossibleStateOutput output) {
        String resourceName = resource.getResourceName();
        LogUtil.logDebug(logger, this._eventId, "Processing resource:" + resourceName);
        IdealState idealState = cache.getIdealState(resourceName);
        if (idealState == null) {
            LogUtil.logInfo(logger, this._eventId, "resource:" + resourceName + " does not exist anymore");
            idealState = new IdealState(resourceName);
            idealState.setStateModelDefRef(resource.getStateModelDefRef());
        }
        if (!idealState.getStateModelDefRef().equals("Task")) {
            LogUtil.logWarn(logger, this._eventId, String.format("Resource %s should not be processed by %s pipeline", resourceName, cache.getPipelineName()));
            return false;
        }
        Rebalancer rebalancer = null;
        String rebalancerClassName = idealState.getRebalancerClassName();
        if (rebalancerClassName != null) {
            if (logger.isDebugEnabled()) {
                LogUtil.logDebug(logger, this._eventId, "resource " + resourceName + " use idealStateRebalancer " + rebalancerClassName);
            }
            try {
                rebalancer = (Rebalancer)Rebalancer.class.cast(HelixUtil.loadClass(this.getClass(), rebalancerClassName).newInstance());
            }
            catch (Exception e) {
                LogUtil.logError(logger, this._eventId, "Exception while invoking custom rebalancer class:" + rebalancerClassName, e);
            }
        }
        SemiAutoRebalancer<WorkflowControllerDataProvider> mappingCalculator = null;
        if (rebalancer != null) {
            try {
                mappingCalculator = (SemiAutoRebalancer<WorkflowControllerDataProvider>)MappingCalculator.class.cast(rebalancer);
            }
            catch (ClassCastException e) {
                LogUtil.logWarn(logger, this._eventId, "Rebalancer does not have a mapping calculator, defaulting to SEMI_AUTO, resource: " + resourceName);
            }
        } else {
            rebalancer = new SemiAutoRebalancer();
            mappingCalculator = new SemiAutoRebalancer<WorkflowControllerDataProvider>();
        }
        if (rebalancer instanceof TaskRebalancer) {
            TaskRebalancer taskRebalancer = (TaskRebalancer)TaskRebalancer.class.cast(rebalancer);
            taskRebalancer.setClusterStatusMonitor((ClusterStatusMonitor)event.getAttribute(AttributeName.clusterStatusMonitor.name()));
        }
        ResourceAssignment partitionStateAssignment = null;
        try {
            HelixManager manager = (HelixManager)event.getAttribute(AttributeName.helixmanager.name());
            rebalancer.init(manager);
            partitionStateAssignment = mappingCalculator.computeBestPossiblePartitionState(cache, idealState, resource, currentStateOutput);
            this._workflowDispatcher.updateBestPossibleStateOutput(resource.getResourceName(), partitionStateAssignment, output);
            return true;
        }
        catch (Exception e) {
            LogUtil.logError(logger, this._eventId, "Error computing assignment for resource " + resourceName + ". Skipping.", e);
            StringBuilder sb = new StringBuilder();
            sb.append(String.format("HelixManager is null : %s\n", event.getAttribute("helixmanager") == null));
            sb.append(String.format("Rebalancer is null : %s\n", rebalancer == null));
            sb.append(String.format("Calculated idealState is null : %s\n", idealState == null));
            sb.append(String.format("MappingCaculator is null : %s\n", mappingCalculator == null));
            sb.append(String.format("PartitionAssignment is null : %s\n", partitionStateAssignment == null));
            sb.append(String.format("Output is null : %s\n", output == null));
            LogUtil.logError(logger, this._eventId, sb.toString());
            return false;
        }
    }

    private void buildQuotaBasedWorkflowPQsAndInitDispatchers(WorkflowControllerDataProvider cache, HelixManager manager, ClusterStatusMonitor monitor) {
        this._quotaBasedWorkflowPQs.clear();
        Map<String, String> quotaRatioMap = cache.getClusterConfig().getTaskQuotaRatioMap();
        if (quotaRatioMap == null || quotaRatioMap.size() == 0) {
            this._quotaBasedWorkflowPQs.put("DEFAULT", new PriorityQueue());
        } else {
            for (String quotaType : quotaRatioMap.keySet()) {
                this._quotaBasedWorkflowPQs.put(quotaType, new PriorityQueue());
            }
        }
        for (String workflowId : cache.getWorkflowConfigMap().keySet()) {
            WorkflowConfig workflowConfig = cache.getWorkflowConfig(workflowId);
            String workflowType = this.getQuotaType(workflowConfig);
            this._quotaBasedWorkflowPQs.get(workflowType).add(new WorkflowObject(workflowId, workflowConfig.getRecord().getCreationTime()));
        }
        if (this._workflowDispatcher == null) {
            this._workflowDispatcher = new WorkflowDispatcher();
        }
        this._workflowDispatcher.init(manager);
        this._workflowDispatcher.setClusterStatusMonitor(monitor);
        this._workflowDispatcher.updateCache(cache);
    }

    private void scheduleWorkflows(Map<String, Resource> resourceMap, WorkflowControllerDataProvider cache, Map<String, Resource> restOfResources, List<String> failureResources, CurrentStateOutput currentStateOutput, BestPossibleStateOutput bestPossibleOutput) {
        AssignableInstanceManager assignableInstanceManager = cache.getAssignableInstanceManager();
        for (PriorityQueue<WorkflowObject> quotaBasedWorkflowPQ : this._quotaBasedWorkflowPQs.values()) {
            Iterator<WorkflowObject> it = quotaBasedWorkflowPQ.iterator();
            while (it.hasNext()) {
                String workflowId = it.next()._workflowId;
                Resource resource = resourceMap.get(workflowId);
                if (resource == null) continue;
                try {
                    WorkflowContext context = this._workflowDispatcher.getOrInitializeWorkflowContext(workflowId, cache.getTaskDataCache());
                    this._workflowDispatcher.updateWorkflowStatus(workflowId, cache.getWorkflowConfig(workflowId), context, currentStateOutput, bestPossibleOutput);
                    String quotaType = this.getQuotaType(cache.getWorkflowConfig(workflowId));
                    restOfResources.remove(workflowId);
                    if (assignableInstanceManager.hasGlobalCapacity(quotaType)) {
                        this._workflowDispatcher.assignWorkflow(workflowId, cache.getWorkflowConfig(workflowId), context, currentStateOutput, bestPossibleOutput);
                        continue;
                    }
                    LogUtil.logInfo(logger, this._eventId, String.format("Fail to schedule new jobs assignment for Workflow %s due to quota %s is full", workflowId, quotaType));
                }
                catch (Exception e) {
                    LogUtil.logError(logger, this._eventId, "Error computing assignment for Workflow " + workflowId + ". Skipping.", e);
                    failureResources.add(workflowId);
                }
            }
        }
    }

    private void updateResourceMap(String jobName, Map<String, Resource> resourceMap, Set<Partition> partitionSet) {
        Resource resource = new Resource(jobName);
        for (Partition partition : partitionSet) {
            resource.addPartition(partition.getPartitionName());
        }
        resource.setStateModelDefRef("Task");
        resource.setStateModelFactoryName("DEFAULT");
        resourceMap.put(jobName, resource);
    }

    private String getQuotaType(WorkflowConfig workflowConfig) {
        String workflowType = workflowConfig.getWorkflowType();
        if (workflowType == null || !this._quotaBasedWorkflowPQs.containsKey(workflowType)) {
            workflowType = "DEFAULT";
        }
        return workflowType;
    }

    class WorkflowObject
    implements Comparable<WorkflowObject> {
        String _workflowId;
        Long _rankingValue;

        public WorkflowObject(String workflowId, long rankingValue) {
            this._workflowId = workflowId;
            this._rankingValue = rankingValue;
        }

        @Override
        public int compareTo(WorkflowObject o) {
            return (int)(this._rankingValue - o._rankingValue);
        }
    }
}

