/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.manager.zk.zookeeper;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;
import javax.management.JMException;
import org.I0Itec.zkclient.DataUpdater;
import org.I0Itec.zkclient.IZkChildListener;
import org.I0Itec.zkclient.IZkConnection;
import org.I0Itec.zkclient.IZkDataListener;
import org.I0Itec.zkclient.IZkStateListener;
import org.I0Itec.zkclient.ZkLock;
import org.I0Itec.zkclient.exception.ZkBadVersionException;
import org.I0Itec.zkclient.exception.ZkException;
import org.I0Itec.zkclient.exception.ZkInterruptedException;
import org.I0Itec.zkclient.exception.ZkMarshallingError;
import org.I0Itec.zkclient.exception.ZkNoNodeException;
import org.I0Itec.zkclient.exception.ZkNodeExistsException;
import org.I0Itec.zkclient.exception.ZkTimeoutException;
import org.I0Itec.zkclient.serialize.ZkSerializer;
import org.apache.helix.HelixException;
import org.apache.helix.api.listeners.PreFetch;
import org.apache.helix.manager.zk.BasicZkSerializer;
import org.apache.helix.manager.zk.PathBasedZkSerializer;
import org.apache.helix.manager.zk.ZkAsyncCallbacks;
import org.apache.helix.manager.zk.zookeeper.ZkConnection;
import org.apache.helix.manager.zk.zookeeper.ZkEventThread;
import org.apache.helix.monitoring.mbeans.ZkClientMonitor;
import org.apache.helix.util.ExponentialBackoffStrategy;
import org.apache.helix.util.ZNRecordUtil;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Op;
import org.apache.zookeeper.OpResult;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkClient
implements Watcher {
    private static final Logger LOG = LoggerFactory.getLogger(ZkClient.class);
    private static final long MAX_RECONNECT_INTERVAL_MS = 30000L;
    private static final int NUM_CHILDREN_LIMIT = 100000;
    private static final int WRITE_SIZE_LIMIT = Integer.getInteger("jute.maxbuffer", 1024000);
    private final IZkConnection _connection;
    private final long _operationRetryTimeoutInMillis;
    private final Map<String, Set<IZkChildListener>> _childListener = new ConcurrentHashMap<String, Set<IZkChildListener>>();
    private final ConcurrentHashMap<String, Set<IZkDataListenerEntry>> _dataListener = new ConcurrentHashMap();
    private final Set<IZkStateListener> _stateListener = new CopyOnWriteArraySet<IZkStateListener>();
    private Watcher.Event.KeeperState _currentState;
    private final ZkLock _zkEventLock = new ZkLock();
    private boolean _shutdownTriggered;
    private ZkEventThread _eventThread;
    private Thread _zookeeperEventThread;
    private volatile boolean _closed;
    private PathBasedZkSerializer _pathBasedZkSerializer;
    private ZkClientMonitor _monitor;

    protected ZkClient(IZkConnection zkConnection, int connectionTimeout, long operationRetryTimeout, PathBasedZkSerializer zkSerializer, String monitorType, String monitorKey, String monitorInstanceName, boolean monitorRootPathOnly) {
        if (zkConnection == null) {
            throw new NullPointerException("Zookeeper connection is null!");
        }
        this.validateWriteSizeLimitConfig();
        this._connection = zkConnection;
        this._pathBasedZkSerializer = zkSerializer;
        this._operationRetryTimeoutInMillis = operationRetryTimeout;
        this.connect(connectionTimeout, this);
        try {
            if (monitorKey != null && !monitorKey.isEmpty() && monitorType != null && !monitorType.isEmpty()) {
                this._monitor = new ZkClientMonitor(monitorType, monitorKey, monitorInstanceName, monitorRootPathOnly, this._eventThread);
                this._monitor.register();
            } else {
                LOG.info("ZkClient monitor key or type is not provided. Skip monitoring.");
            }
        }
        catch (JMException e) {
            LOG.error("Error in creating ZkClientMonitor", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> subscribeChildChanges(String path, IZkChildListener listener) {
        Map<String, Set<IZkChildListener>> map = this._childListener;
        synchronized (map) {
            Set<IZkChildListener> listeners = this._childListener.get(path);
            if (listeners == null) {
                listeners = new CopyOnWriteArraySet<IZkChildListener>();
                this._childListener.put(path, listeners);
            }
            listeners.add(listener);
        }
        return this.watchForChilds(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribeChildChanges(String path, IZkChildListener childListener) {
        Map<String, Set<IZkChildListener>> map = this._childListener;
        synchronized (map) {
            Set<IZkChildListener> listeners = this._childListener.get(path);
            if (listeners != null) {
                listeners.remove(childListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribeDataChanges(String path, IZkDataListener listener) {
        ConcurrentHashMap<String, Set<IZkDataListenerEntry>> concurrentHashMap = this._dataListener;
        synchronized (concurrentHashMap) {
            Set<IZkDataListenerEntry> listenerEntries = this._dataListener.get(path);
            if (listenerEntries == null) {
                listenerEntries = new CopyOnWriteArraySet<IZkDataListenerEntry>();
                this._dataListener.put(path, listenerEntries);
            }
            boolean prefetchEnabled = this.isPrefetchEnabled(listener);
            IZkDataListenerEntry listenerEntry = new IZkDataListenerEntry(listener, prefetchEnabled);
            listenerEntries.add(listenerEntry);
            if (prefetchEnabled && LOG.isDebugEnabled()) {
                LOG.debug("Subscribed data changes for " + path + ", listener: " + listener + ", prefetch data: " + prefetchEnabled);
            }
        }
        this.watchForData(path);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Subscribed data changes for " + path);
        }
    }

    private boolean isPrefetchEnabled(IZkDataListener dataListener) {
        PreFetch preFetch = dataListener.getClass().getAnnotation(PreFetch.class);
        if (preFetch != null) {
            return preFetch.enabled();
        }
        Method callbackMethod = IZkDataListener.class.getMethods()[0];
        try {
            Method method = dataListener.getClass().getMethod(callbackMethod.getName(), callbackMethod.getParameterTypes());
            PreFetch preFetchInMethod = method.getAnnotation(PreFetch.class);
            if (preFetchInMethod != null) {
                return preFetchInMethod.enabled();
            }
        }
        catch (NoSuchMethodException e) {
            LOG.warn("No method " + callbackMethod.getName() + " defined in listener " + dataListener.getClass().getCanonicalName());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribeDataChanges(String path, IZkDataListener dataListener) {
        ConcurrentHashMap<String, Set<IZkDataListenerEntry>> concurrentHashMap = this._dataListener;
        synchronized (concurrentHashMap) {
            Set<IZkDataListenerEntry> listeners = this._dataListener.get(path);
            if (listeners != null) {
                IZkDataListenerEntry listenerEntry = new IZkDataListenerEntry(dataListener);
                listeners.remove(listenerEntry);
            }
            if (listeners == null || listeners.isEmpty()) {
                this._dataListener.remove(path);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribeStateChanges(IZkStateListener listener) {
        Set<IZkStateListener> set = this._stateListener;
        synchronized (set) {
            this._stateListener.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribeStateChanges(IZkStateListener stateListener) {
        Set<IZkStateListener> set = this._stateListener;
        synchronized (set) {
            this._stateListener.remove(stateListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribeAll() {
        Object object = this._childListener;
        synchronized (object) {
            this._childListener.clear();
        }
        object = this._dataListener;
        synchronized (object) {
            this._dataListener.clear();
        }
        object = this._stateListener;
        synchronized (object) {
            this._stateListener.clear();
        }
    }

    public void createPersistent(String path) throws ZkInterruptedException, IllegalArgumentException, ZkException, RuntimeException {
        this.createPersistent(path, false);
    }

    public void createPersistent(String path, boolean createParents) throws ZkInterruptedException, IllegalArgumentException, ZkException, RuntimeException {
        this.createPersistent(path, createParents, (List<ACL>)ZooDefs.Ids.OPEN_ACL_UNSAFE);
    }

    public void createPersistent(String path, boolean createParents, List<ACL> acl) throws ZkInterruptedException, IllegalArgumentException, ZkException, RuntimeException {
        try {
            this.create(path, null, acl, CreateMode.PERSISTENT);
        }
        catch (ZkNodeExistsException e) {
            if (!createParents) {
                throw e;
            }
        }
        catch (ZkNoNodeException e) {
            if (!createParents) {
                throw e;
            }
            String parentDir = path.substring(0, path.lastIndexOf(47));
            this.createPersistent(parentDir, createParents, acl);
            this.createPersistent(path, createParents, acl);
        }
    }

    public void createPersistent(String path, Object data) throws ZkInterruptedException, IllegalArgumentException, ZkException, RuntimeException {
        this.create(path, data, CreateMode.PERSISTENT);
    }

    public void createPersistent(String path, Object data, List<ACL> acl) {
        this.create(path, data, acl, CreateMode.PERSISTENT);
    }

    public String createPersistentSequential(String path, Object data) throws ZkInterruptedException, IllegalArgumentException, ZkException, RuntimeException {
        return this.create(path, data, CreateMode.PERSISTENT_SEQUENTIAL);
    }

    public String createPersistentSequential(String path, Object data, List<ACL> acl) throws ZkInterruptedException, IllegalArgumentException, ZkException, RuntimeException {
        return this.create(path, data, acl, CreateMode.PERSISTENT_SEQUENTIAL);
    }

    public void createEphemeral(String path) throws ZkInterruptedException, IllegalArgumentException, ZkException, RuntimeException {
        this.create(path, null, CreateMode.EPHEMERAL);
    }

    public void createEphemeral(String path, List<ACL> acl) throws ZkInterruptedException, IllegalArgumentException, ZkException, RuntimeException {
        this.create(path, null, acl, CreateMode.EPHEMERAL);
    }

    public String create(String path, Object data, CreateMode mode) throws ZkInterruptedException, IllegalArgumentException, ZkException, RuntimeException {
        return this.create(path, data, ZooDefs.Ids.OPEN_ACL_UNSAFE, mode);
    }

    public String create(final String path, Object datat, final List<ACL> acl, final CreateMode mode) throws IllegalArgumentException, ZkException {
        if (path == null) {
            throw new NullPointerException("Path must not be null.");
        }
        if (acl == null || acl.size() == 0) {
            throw new NullPointerException("Missing value for ACL");
        }
        long startT = System.currentTimeMillis();
        try {
            final byte[] data = datat == null ? null : this.serialize(datat, path);
            this.checkDataSizeLimit(path, data);
            String actualPath = this.retryUntilConnected(new Callable<String>(){

                @Override
                public String call() throws Exception {
                    return ZkClient.this.getConnection().create(path, data, acl, mode);
                }
            });
            this.record(path, data, startT, ZkClientMonitor.AccessType.WRITE);
            String string = actualPath;
            return string;
        }
        catch (Exception e) {
            this.recordFailure(path, ZkClientMonitor.AccessType.WRITE);
            throw e;
        }
        finally {
            long endT = System.currentTimeMillis();
            if (LOG.isTraceEnabled()) {
                LOG.trace("create, path: " + path + ", time: " + (endT - startT) + " ms");
            }
        }
    }

    public void createEphemeral(String path, Object data) throws ZkInterruptedException, IllegalArgumentException, ZkException, RuntimeException {
        this.create(path, data, CreateMode.EPHEMERAL);
    }

    public void createEphemeral(String path, Object data, List<ACL> acl) throws ZkInterruptedException, IllegalArgumentException, ZkException, RuntimeException {
        this.create(path, data, acl, CreateMode.EPHEMERAL);
    }

    public String createEphemeralSequential(String path, Object data) throws ZkInterruptedException, IllegalArgumentException, ZkException, RuntimeException {
        return this.create(path, data, CreateMode.EPHEMERAL_SEQUENTIAL);
    }

    public String createEphemeralSequential(String path, Object data, List<ACL> acl) throws ZkInterruptedException, IllegalArgumentException, ZkException, RuntimeException {
        return this.create(path, data, acl, CreateMode.EPHEMERAL_SEQUENTIAL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(WatchedEvent event) {
        boolean dataChanged;
        long notificationTime = System.currentTimeMillis();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Received event: " + event);
        }
        this._zookeeperEventThread = Thread.currentThread();
        boolean stateChanged = event.getPath() == null;
        boolean znodeChanged = event.getPath() != null;
        boolean bl = dataChanged = event.getType() == Watcher.Event.EventType.NodeDataChanged || event.getType() == Watcher.Event.EventType.NodeDeleted || event.getType() == Watcher.Event.EventType.NodeCreated || event.getType() == Watcher.Event.EventType.NodeChildrenChanged;
        if (event.getType() == Watcher.Event.EventType.NodeDeleted && LOG.isDebugEnabled()) {
            String path = event.getPath();
            LOG.debug(path);
        }
        this.getEventLock().lock();
        try {
            if (this.getShutdownTrigger()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("ignoring event '{" + event.getType() + " | " + event.getPath() + "}' since shutdown triggered");
                }
                return;
            }
            if (stateChanged) {
                this.processStateChanged(event);
            }
            if (dataChanged) {
                this.processDataOrChildChange(event, notificationTime);
            }
        }
        finally {
            if (stateChanged) {
                this.getEventLock().getStateChangedCondition().signalAll();
                if (event.getState() == Watcher.Event.KeeperState.Expired) {
                    this.getEventLock().getZNodeEventCondition().signalAll();
                    this.getEventLock().getDataChangedCondition().signalAll();
                    this.fireAllEvents();
                }
            }
            if (znodeChanged) {
                this.getEventLock().getZNodeEventCondition().signalAll();
            }
            if (dataChanged) {
                this.getEventLock().getDataChangedCondition().signalAll();
            }
            this.getEventLock().unlock();
            this.recordStateChange(stateChanged, dataChanged);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Leaving process event");
            }
        }
    }

    private void fireAllEvents() {
        for (Map.Entry<String, Set<IZkChildListener>> entry : this._childListener.entrySet()) {
            this.fireChildChangedEvents(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Set<Object>> entry : this._dataListener.entrySet()) {
            this.fireDataChangedEvents(entry.getKey(), entry.getValue(), OptionalLong.empty());
        }
    }

    public List<String> getChildren(String path) {
        return this.getChildren(path, this.hasListeners(path));
    }

    protected List<String> getChildren(final String path, final boolean watch) {
        long startT = System.currentTimeMillis();
        try {
            List<String> children = this.retryUntilConnected(new Callable<List<String>>(){
                private int connectionLossRetryCount = 0;

                @Override
                public List<String> call() throws Exception {
                    try {
                        return ZkClient.this.getConnection().getChildren(path, watch);
                    }
                    catch (KeeperException.ConnectionLossException e) {
                        ++this.connectionLossRetryCount;
                        if (this.connectionLossRetryCount >= 3) {
                            ZkClient.this.checkNumChildrenLimit(path);
                            this.connectionLossRetryCount = 0;
                        }
                        throw e;
                    }
                }
            });
            this.record(path, null, startT, ZkClientMonitor.AccessType.READ);
            List<String> list = children;
            return list;
        }
        catch (ZkNoNodeException e) {
            this.record(path, null, startT, ZkClientMonitor.AccessType.READ);
            throw e;
        }
        catch (Exception e) {
            this.recordFailure(path, ZkClientMonitor.AccessType.READ);
            throw e;
        }
        finally {
            long endT = System.currentTimeMillis();
            if (LOG.isTraceEnabled()) {
                LOG.trace("getChildren, path: " + path + ", time: " + (endT - startT) + " ms");
            }
        }
    }

    public int countChildren(String path) {
        try {
            return this.getChildren(path).size();
        }
        catch (ZkNoNodeException e) {
            return 0;
        }
    }

    public boolean exists(String path) {
        return this.exists(path, this.hasListeners(path));
    }

    protected boolean exists(final String path, final boolean watch) {
        long startT = System.currentTimeMillis();
        try {
            boolean exists = this.retryUntilConnected(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return ZkClient.this.getConnection().exists(path, watch);
                }
            });
            this.record(path, null, startT, ZkClientMonitor.AccessType.READ);
            boolean bl = exists;
            return bl;
        }
        catch (ZkNoNodeException e) {
            this.record(path, null, startT, ZkClientMonitor.AccessType.READ);
            throw e;
        }
        catch (Exception e) {
            this.recordFailure(path, ZkClientMonitor.AccessType.READ);
            throw e;
        }
        finally {
            long endT = System.currentTimeMillis();
            if (LOG.isTraceEnabled()) {
                LOG.trace("exists, path: " + path + ", time: " + (endT - startT) + " ms");
            }
        }
    }

    public Stat getStat(String path) {
        return this.getStat(path, false);
    }

    private Stat getStat(String path, boolean watch) {
        long startT = System.currentTimeMillis();
        try {
            Stat stat = this.retryUntilConnected(() -> ((ZkConnection)this.getConnection()).getZookeeper().exists(path, watch));
            this.record(path, null, startT, ZkClientMonitor.AccessType.READ);
            Stat stat2 = stat;
            return stat2;
        }
        catch (ZkNoNodeException e) {
            this.record(path, null, startT, ZkClientMonitor.AccessType.READ);
            throw e;
        }
        catch (Exception e) {
            this.recordFailure(path, ZkClientMonitor.AccessType.READ);
            throw e;
        }
        finally {
            long endT = System.currentTimeMillis();
            if (LOG.isTraceEnabled()) {
                LOG.trace("exists, path: " + path + ", time: " + (endT - startT) + " ms");
            }
        }
    }

    protected void processStateChanged(WatchedEvent event) {
        LOG.info("zookeeper state changed (" + event.getState() + ")");
        this.setCurrentState(event.getState());
        if (this.getShutdownTrigger()) {
            return;
        }
        this.fireStateChangedEvent(event.getState());
        if (this.isManagingZkConnection() && event.getState() == Watcher.Event.KeeperState.Expired) {
            this.reconnectOnExpiring();
        }
    }

    private void reconnectOnExpiring() {
        int retryCount = 0;
        ExponentialBackoffStrategy retryStrategy = new ExponentialBackoffStrategy(30000L, true);
        Throwable reconnectException = new ZkException("Shutdown triggered.");
        while (!this.isClosed()) {
            try {
                this.reconnect();
                this.fireNewSessionEvents();
                return;
            }
            catch (ZkInterruptedException interrupt) {
                reconnectException = interrupt;
                break;
            }
            catch (Exception e) {
                reconnectException = e;
                long waitInterval = retryStrategy.getNextWaitInterval(retryCount++);
                LOG.warn("ZkClient reconnect on expiring failed. Will retry after {} ms", (Object)waitInterval, (Object)e);
                try {
                    Thread.sleep(waitInterval);
                }
                catch (InterruptedException ex) {
                    reconnectException = ex;
                    break;
                }
            }
        }
        LOG.info("Unable to re-establish connection. Notifying consumer of the following exception: ", reconnectException);
        this.fireSessionEstablishmentError(reconnectException);
    }

    private void reconnect() {
        this.getEventLock().lock();
        try {
            ZkConnection connection = (ZkConnection)this.getConnection();
            connection.reconnect(this);
        }
        catch (InterruptedException e) {
            throw new ZkInterruptedException(e);
        }
        finally {
            this.getEventLock().unlock();
        }
    }

    private void fireNewSessionEvents() {
        for (final IZkStateListener stateListener : this._stateListener) {
            this._eventThread.send(new ZkEventThread.ZkEvent("New session event sent to " + stateListener){

                @Override
                public void run() throws Exception {
                    stateListener.handleNewSession();
                }
            });
        }
    }

    protected void fireStateChangedEvent(final Watcher.Event.KeeperState state) {
        for (final IZkStateListener stateListener : this._stateListener) {
            this._eventThread.send(new ZkEventThread.ZkEvent("State changed to " + state + " sent to " + stateListener){

                @Override
                public void run() throws Exception {
                    stateListener.handleStateChanged(state);
                }
            });
        }
    }

    private void fireSessionEstablishmentError(final Throwable error) {
        for (final IZkStateListener stateListener : this._stateListener) {
            this._eventThread.send(new ZkEventThread.ZkEvent("Session establishment error(" + error + ") sent to " + stateListener){

                @Override
                public void run() throws Exception {
                    stateListener.handleSessionEstablishmentError(error);
                }
            });
        }
    }

    private boolean hasListeners(String path) {
        Set<IZkDataListenerEntry> dataListeners = this._dataListener.get(path);
        if (dataListeners != null && dataListeners.size() > 0) {
            return true;
        }
        Set<IZkChildListener> childListeners = this._childListener.get(path);
        return childListeners != null && childListeners.size() > 0;
    }

    @Deprecated
    public boolean deleteRecursive(String path) {
        try {
            this.deleteRecursively(path);
            return true;
        }
        catch (HelixException e) {
            LOG.error("Failed to recursively delete path " + path, (Throwable)e);
            return false;
        }
    }

    public void deleteRecursively(String path) throws HelixException {
        List<String> children;
        try {
            children = this.getChildren(path, false);
        }
        catch (ZkNoNodeException e) {
            return;
        }
        for (String subPath : children) {
            this.deleteRecursively(path + "/" + subPath);
        }
        try {
            this.delete(path);
        }
        catch (Exception e) {
            LOG.error("Failed to delete " + path, (Throwable)e);
            throw new HelixException("Failed to delete " + path, e);
        }
    }

    private void processDataOrChildChange(WatchedEvent event, long notificationTime) {
        Set<IZkDataListenerEntry> listeners;
        Set<IZkChildListener> childListeners;
        String path = event.getPath();
        if (!(event.getType() != Watcher.Event.EventType.NodeChildrenChanged && event.getType() != Watcher.Event.EventType.NodeCreated && event.getType() != Watcher.Event.EventType.NodeDeleted || (childListeners = this._childListener.get(path)) == null || childListeners.isEmpty())) {
            this.fireChildChangedEvents(path, childListeners);
        }
        if (!(event.getType() != Watcher.Event.EventType.NodeDataChanged && event.getType() != Watcher.Event.EventType.NodeDeleted && event.getType() != Watcher.Event.EventType.NodeCreated || (listeners = this._dataListener.get(path)) == null || listeners.isEmpty())) {
            this.fireDataChangedEvents(event.getPath(), listeners, OptionalLong.of(notificationTime));
        }
    }

    private void fireDataChangedEvents(final String path, Set<IZkDataListenerEntry> listeners, final OptionalLong notificationTime) {
        try {
            final ZkPathStatRecord pathStatRecord = new ZkPathStatRecord(path);
            for (final IZkDataListenerEntry listener : listeners) {
                this._eventThread.send(new ZkEventThread.ZkEvent("Data of " + path + " changed sent to " + listener.getDataListener() + " prefetch data: " + listener.isPrefetchData()){

                    @Override
                    public void run() throws Exception {
                        if (!pathStatRecord.pathChecked()) {
                            pathStatRecord.recordPathStat(ZkClient.this.getStat(path, true), notificationTime);
                        }
                        if (!pathStatRecord.pathExists()) {
                            listener.getDataListener().handleDataDeleted(path);
                        } else {
                            Object data = null;
                            if (listener.isPrefetchData()) {
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug("Prefetch data for path: {}", (Object)path);
                                }
                                try {
                                    data = ZkClient.this.readData(path, null, true);
                                }
                                catch (ZkNoNodeException e) {
                                    LOG.warn("Prefetch data for path: {} failed.", (Object)path, (Object)e);
                                    listener.getDataListener().handleDataDeleted(path);
                                    return;
                                }
                            }
                            listener.getDataListener().handleDataChange(path, data);
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            LOG.error("Failed to fire data changed event for path: {}", (Object)path, (Object)e);
        }
    }

    private void fireChildChangedEvents(final String path, Set<IZkChildListener> childListeners) {
        try {
            final ZkPathStatRecord pathStatRecord = new ZkPathStatRecord(path);
            for (final IZkChildListener listener : childListeners) {
                this._eventThread.send(new ZkEventThread.ZkEvent("Children of " + path + " changed sent to " + listener){

                    @Override
                    public void run() throws Exception {
                        if (!pathStatRecord.pathChecked()) {
                            pathStatRecord.recordPathStat(ZkClient.this.getStat(path, ZkClient.this.hasListeners(path)), OptionalLong.empty());
                        }
                        List<String> children = null;
                        if (pathStatRecord.pathExists()) {
                            try {
                                children = ZkClient.this.getChildren(path);
                            }
                            catch (ZkNoNodeException e) {
                                LOG.warn("Get children under path: {} failed.", (Object)path, (Object)e);
                            }
                        }
                        listener.handleChildChange(path, children);
                    }
                });
            }
        }
        catch (Exception e) {
            LOG.error("Failed to fire child changed event. Unable to getChildren.", (Throwable)e);
        }
    }

    public boolean waitUntilExists(String path, TimeUnit timeUnit, long time) throws ZkInterruptedException {
        Date timeout = new Date(System.currentTimeMillis() + timeUnit.toMillis(time));
        if (LOG.isDebugEnabled()) {
            LOG.debug("Waiting until znode '" + path + "' becomes available.");
        }
        if (this.exists(path)) {
            return true;
        }
        this.acquireEventLock();
        try {
            boolean gotSignal;
            while (!this.exists(path, true)) {
                gotSignal = this.getEventLock().getZNodeEventCondition().awaitUntil(timeout);
                if (gotSignal) continue;
                boolean bl = false;
                return bl;
            }
            gotSignal = true;
            return gotSignal;
        }
        catch (InterruptedException e) {
            throw new ZkInterruptedException(e);
        }
        finally {
            this.getEventLock().unlock();
        }
    }

    public IZkConnection getConnection() {
        return this._connection;
    }

    public boolean waitUntilConnected(long time, TimeUnit timeUnit) throws ZkInterruptedException {
        return this.waitForKeeperState(Watcher.Event.KeeperState.SyncConnected, time, timeUnit);
    }

    public boolean waitForKeeperState(Watcher.Event.KeeperState keeperState, long time, TimeUnit timeUnit) throws ZkInterruptedException {
        if (this._zookeeperEventThread != null && Thread.currentThread() == this._zookeeperEventThread) {
            throw new IllegalArgumentException("Must not be done in the zookeeper event thread.");
        }
        Date timeout = new Date(System.currentTimeMillis() + timeUnit.toMillis(time));
        LOG.debug("Waiting for keeper state " + keeperState);
        this.acquireEventLock();
        try {
            boolean stillWaiting = true;
            while (this._currentState != keeperState) {
                if (!stillWaiting) {
                    boolean bl = false;
                    return bl;
                }
                stillWaiting = this.getEventLock().getStateChangedCondition().awaitUntil(timeout);
            }
            LOG.debug("State is " + (this._currentState == null ? "CLOSED" : this._currentState));
            boolean bl = true;
            return bl;
        }
        catch (InterruptedException e) {
            throw new ZkInterruptedException(e);
        }
        finally {
            this.getEventLock().unlock();
        }
    }

    private void acquireEventLock() {
        try {
            this.getEventLock().lockInterruptibly();
        }
        catch (InterruptedException e) {
            throw new ZkInterruptedException(e);
        }
    }

    /*
     * Exception decompiling
     */
    public <T> T retryUntilConnected(Callable<T> callable) throws IllegalArgumentException, ZkException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void waitForRetry() {
        this.waitUntilConnected(this._operationRetryTimeoutInMillis, TimeUnit.MILLISECONDS);
    }

    public void setCurrentState(Watcher.Event.KeeperState currentState) {
        this.getEventLock().lock();
        try {
            this._currentState = currentState;
        }
        finally {
            this.getEventLock().unlock();
        }
    }

    public ZkLock getEventLock() {
        return this._zkEventLock;
    }

    public boolean delete(final String path) {
        boolean success;
        long startT = System.currentTimeMillis();
        try {
            block8: {
                try {
                    this.retryUntilConnected(new Callable<Object>(){

                        @Override
                        public Object call() throws Exception {
                            ZkClient.this.getConnection().delete(path);
                            return null;
                        }
                    });
                    success = true;
                }
                catch (ZkNoNodeException e) {
                    success = false;
                    if (!LOG.isDebugEnabled()) break block8;
                    LOG.debug("Failed to delete path " + path + ", znode does not exist!");
                }
            }
            this.record(path, null, startT, ZkClientMonitor.AccessType.WRITE);
        }
        catch (Exception e) {
            this.recordFailure(path, ZkClientMonitor.AccessType.WRITE);
            LOG.warn("Failed to delete path " + path + "! " + e);
            throw e;
        }
        finally {
            long endT = System.currentTimeMillis();
            if (LOG.isTraceEnabled()) {
                LOG.trace("delete, path: " + path + ", time: " + (endT - startT) + " ms");
            }
        }
        return success;
    }

    public void setZkSerializer(ZkSerializer zkSerializer) {
        this._pathBasedZkSerializer = new BasicZkSerializer(zkSerializer);
    }

    public void setZkSerializer(PathBasedZkSerializer zkSerializer) {
        this._pathBasedZkSerializer = zkSerializer;
    }

    public PathBasedZkSerializer getZkSerializer() {
        return this._pathBasedZkSerializer;
    }

    public byte[] serialize(Object data, String path) {
        return this._pathBasedZkSerializer.serialize(data, path);
    }

    public <T> T deserialize(byte[] data, String path) {
        if (data == null) {
            return null;
        }
        return (T)this._pathBasedZkSerializer.deserialize(data, path);
    }

    public <T> T readData(String path) {
        return this.readData(path, false);
    }

    public <T> T readData(String path, boolean returnNullIfPathNotExists) {
        T data;
        block2: {
            data = null;
            try {
                data = this.readData(path, null);
            }
            catch (ZkNoNodeException e) {
                if (returnNullIfPathNotExists) break block2;
                throw e;
            }
        }
        return data;
    }

    public <T> T readData(String path, Stat stat) {
        return this.readData(path, stat, this.hasListeners(path));
    }

    public <T> T readData(final String path, final Stat stat, final boolean watch) {
        long startT = System.currentTimeMillis();
        byte[] data = null;
        try {
            data = this.retryUntilConnected(new Callable<byte[]>(){

                @Override
                public byte[] call() throws Exception {
                    return ZkClient.this.getConnection().readData(path, stat, watch);
                }
            });
            this.record(path, data, startT, ZkClientMonitor.AccessType.READ);
            T t = this.deserialize(data, path);
            return t;
        }
        catch (ZkNoNodeException e) {
            this.record(path, data, startT, ZkClientMonitor.AccessType.READ);
            throw e;
        }
        catch (Exception e) {
            this.recordFailure(path, ZkClientMonitor.AccessType.READ);
            throw e;
        }
        finally {
            long endT = System.currentTimeMillis();
            if (LOG.isTraceEnabled()) {
                LOG.trace("getData, path: " + path + ", time: " + (endT - startT) + " ms");
            }
        }
    }

    public <T> T readDataAndStat(String path, Stat stat, boolean returnNullIfPathNotExists) {
        T data;
        block2: {
            data = null;
            try {
                data = this.readData(path, stat);
            }
            catch (ZkNoNodeException e) {
                if (returnNullIfPathNotExists) break block2;
                throw e;
            }
        }
        return data;
    }

    public void writeData(String path, Object object) {
        this.writeData(path, object, -1);
    }

    public <T> void updateDataSerialized(String path, DataUpdater<T> updater) {
        boolean retry;
        Stat stat = new Stat();
        do {
            retry = false;
            try {
                T oldData = this.readData(path, stat);
                Object newData = updater.update(oldData);
                this.writeData(path, newData, stat.getVersion());
            }
            catch (ZkBadVersionException e) {
                retry = true;
            }
        } while (retry);
    }

    public void writeData(String path, Object datat, int expectedVersion) {
        this.writeDataReturnStat(path, datat, expectedVersion);
    }

    public Stat writeDataReturnStat(final String path, Object datat, final int expectedVersion) {
        long startT = System.currentTimeMillis();
        try {
            final byte[] data = this.serialize(datat, path);
            this.checkDataSizeLimit(path, data);
            Stat stat = (Stat)this.retryUntilConnected(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    return ZkClient.this.getConnection().writeDataReturnStat(path, data, expectedVersion);
                }
            });
            this.record(path, data, startT, ZkClientMonitor.AccessType.WRITE);
            Stat stat2 = stat;
            return stat2;
        }
        catch (Exception e) {
            this.recordFailure(path, ZkClientMonitor.AccessType.WRITE);
            throw e;
        }
        finally {
            long endT = System.currentTimeMillis();
            if (LOG.isTraceEnabled()) {
                LOG.trace("setData, path: " + path + ", time: " + (endT - startT) + " ms");
            }
        }
    }

    public Stat writeDataGetStat(String path, Object datat, int expectedVersion) {
        return this.writeDataReturnStat(path, datat, expectedVersion);
    }

    public void asyncCreate(String path, Object datat, CreateMode mode, ZkAsyncCallbacks.CreateCallbackHandler cb) {
        long startT = System.currentTimeMillis();
        byte[] data = null;
        try {
            data = datat == null ? null : this.serialize(datat, path);
        }
        catch (ZkMarshallingError e) {
            cb.processResult(KeeperException.Code.MARSHALLINGERROR.intValue(), path, new ZkAsyncCallbacks.ZkAsyncCallContext(this._monitor, startT, 0, false), null);
            return;
        }
        byte[] finalData = data;
        this.retryUntilConnected(() -> {
            ((ZkConnection)this.getConnection()).getZookeeper().create(path, finalData, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, mode, (AsyncCallback.StringCallback)cb, (Object)new ZkAsyncCallbacks.ZkAsyncCallContext(this._monitor, startT, finalData == null ? 0 : finalData.length, false));
            return null;
        });
    }

    public void asyncSetData(String path, Object datat, int version, ZkAsyncCallbacks.SetDataCallbackHandler cb) {
        long startT = System.currentTimeMillis();
        byte[] data = null;
        try {
            data = this.serialize(datat, path);
        }
        catch (ZkMarshallingError e) {
            cb.processResult(KeeperException.Code.MARSHALLINGERROR.intValue(), path, new ZkAsyncCallbacks.ZkAsyncCallContext(this._monitor, startT, 0, false), null);
            return;
        }
        byte[] finalData = data;
        this.retryUntilConnected(() -> {
            ((ZkConnection)this.getConnection()).getZookeeper().setData(path, finalData, version, (AsyncCallback.StatCallback)cb, (Object)new ZkAsyncCallbacks.ZkAsyncCallContext(this._monitor, startT, finalData == null ? 0 : finalData.length, false));
            return null;
        });
    }

    public void asyncGetData(final String path, final ZkAsyncCallbacks.GetDataCallbackHandler cb) {
        final long startT = System.currentTimeMillis();
        this.retryUntilConnected(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                ((ZkConnection)ZkClient.this.getConnection()).getZookeeper().getData(path, null, (AsyncCallback.DataCallback)cb, (Object)new ZkAsyncCallbacks.ZkAsyncCallContext(ZkClient.this._monitor, startT, 0, true));
                return null;
            }
        });
    }

    public void asyncExists(final String path, final ZkAsyncCallbacks.ExistsCallbackHandler cb) {
        final long startT = System.currentTimeMillis();
        this.retryUntilConnected(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                ((ZkConnection)ZkClient.this.getConnection()).getZookeeper().exists(path, null, (AsyncCallback.StatCallback)cb, (Object)new ZkAsyncCallbacks.ZkAsyncCallContext(ZkClient.this._monitor, startT, 0, true));
                return null;
            }
        });
    }

    public void asyncDelete(final String path, final ZkAsyncCallbacks.DeleteCallbackHandler cb) {
        final long startT = System.currentTimeMillis();
        this.retryUntilConnected(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                ((ZkConnection)ZkClient.this.getConnection()).getZookeeper().delete(path, -1, (AsyncCallback.VoidCallback)cb, (Object)new ZkAsyncCallbacks.ZkAsyncCallContext(ZkClient.this._monitor, startT, 0, false));
                return null;
            }
        });
    }

    private void checkDataSizeLimit(String path, byte[] data) {
        if (data == null) {
            return;
        }
        if (data.length > WRITE_SIZE_LIMIT) {
            throw new HelixException("Data size of path " + path + " is greater than write size limit " + WRITE_SIZE_LIMIT + " bytes");
        }
    }

    public void watchForData(final String path) {
        this.retryUntilConnected(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                ZkClient.this.getConnection().exists(path, true);
                return null;
            }
        });
    }

    public List<String> watchForChilds(final String path) {
        if (this._zookeeperEventThread != null && Thread.currentThread() == this._zookeeperEventThread) {
            throw new IllegalArgumentException("Must not be done in the zookeeper event thread.");
        }
        return this.retryUntilConnected(new Callable<List<String>>(){

            @Override
            public List<String> call() throws Exception {
                ZkClient.this.exists(path, true);
                try {
                    return ZkClient.this.getChildren(path, true);
                }
                catch (ZkNoNodeException zkNoNodeException) {
                    return null;
                }
            }
        });
    }

    public void addAuthInfo(final String scheme, final byte[] auth) {
        this.retryUntilConnected(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                ZkClient.this.getConnection().addAuthInfo(scheme, auth);
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(long maxMsToWaitUntilConnected, Watcher watcher) throws ZkInterruptedException, ZkTimeoutException, IllegalStateException {
        if (this.isClosed()) {
            throw new IllegalStateException("ZkClient already closed!");
        }
        boolean started = false;
        this.acquireEventLock();
        try {
            this.setShutdownTrigger(false);
            IZkConnection zkConnection = this.getConnection();
            this._eventThread = new ZkEventThread(zkConnection.getServers());
            this._eventThread.start();
            if (this.isManagingZkConnection()) {
                zkConnection.connect(watcher);
                LOG.debug("Awaiting connection to Zookeeper server");
                if (!this.waitUntilConnected(maxMsToWaitUntilConnected, TimeUnit.MILLISECONDS)) {
                    throw new ZkTimeoutException("Unable to connect to zookeeper server within timeout: " + maxMsToWaitUntilConnected);
                }
            } else {
                if (this.isConnectionClosed()) {
                    throw new HelixException("Unable to connect to zookeeper server with the specified ZkConnection");
                }
                this.setCurrentState(Watcher.Event.KeeperState.SyncConnected);
            }
            started = true;
        }
        finally {
            this.getEventLock().unlock();
            if (!started) {
                this.close();
            }
        }
    }

    public long getCreationTime(String path) {
        this.acquireEventLock();
        try {
            long l = this.getConnection().getCreateTime(path);
            return l;
        }
        catch (KeeperException e) {
            throw ZkException.create((KeeperException)e);
        }
        catch (InterruptedException e) {
            throw new ZkInterruptedException(e);
        }
        finally {
            this.getEventLock().unlock();
        }
    }

    public String getServers() {
        return this.getConnection().getServers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws ZkInterruptedException {
        block13: {
            if (LOG.isTraceEnabled()) {
                StackTraceElement[] calls = Thread.currentThread().getStackTrace();
                LOG.trace("closing a zkclient. callStack: " + Arrays.asList(calls));
            }
            this.getEventLock().lock();
            IZkConnection connection = this.getConnection();
            try {
                if (connection == null || this._closed) {
                    return;
                }
                this.setShutdownTrigger(true);
                this._eventThread.interrupt();
                this._eventThread.join(2000L);
                if (this.isManagingZkConnection()) {
                    LOG.info("Closing zkclient: " + ((ZkConnection)connection).getZookeeper());
                    connection.close();
                }
                this._closed = true;
                this.setCurrentState(null);
                this.getEventLock().getStateChangedCondition().signalAll();
            }
            catch (InterruptedException e) {
                if (connection == null) break block13;
                try {
                    Thread.interrupted();
                    if (this.isManagingZkConnection()) {
                        connection.close();
                    }
                    Thread.currentThread().interrupt();
                }
                catch (InterruptedException e1) {
                    throw new ZkInterruptedException(e1);
                }
            }
            finally {
                this.getEventLock().unlock();
                if (this._monitor != null) {
                    this._monitor.unregister();
                }
                LOG.info("Closed zkclient");
            }
        }
    }

    public boolean isClosed() {
        try {
            this.getEventLock().lock();
            boolean bl = this._closed;
            return bl;
        }
        finally {
            this.getEventLock().unlock();
        }
    }

    public boolean isConnectionClosed() {
        IZkConnection connection = this.getConnection();
        return connection == null || connection.getZookeeperState() == null || !connection.getZookeeperState().isAlive();
    }

    public void setShutdownTrigger(boolean triggerState) {
        this._shutdownTriggered = triggerState;
    }

    public boolean getShutdownTrigger() {
        return this._shutdownTriggered;
    }

    public int numberOfListeners() {
        int listeners = 0;
        for (Set<IZkChildListener> set : this._childListener.values()) {
            listeners += set.size();
        }
        for (Set<Object> set : this._dataListener.values()) {
            listeners += set.size();
        }
        return listeners += this._stateListener.size();
    }

    public List<OpResult> multi(final Iterable<Op> ops) throws ZkException {
        if (ops == null) {
            throw new NullPointerException("ops must not be null.");
        }
        return this.retryUntilConnected(new Callable<List<OpResult>>(){

            @Override
            public List<OpResult> call() throws Exception {
                return ZkClient.this.getConnection().multi(ops);
            }
        });
    }

    protected boolean isManagingZkConnection() {
        return true;
    }

    public long getSessionId() {
        ZkConnection zkConnection = (ZkConnection)this.getConnection();
        ZooKeeper zk = zkConnection.getZookeeper();
        if (zk == null) {
            throw new HelixException("ZooKeeper connection information is not available now. ZkClient might be disconnected.");
        }
        return zkConnection.getZookeeper().getSessionId();
    }

    private void record(String path, byte[] data, long startTimeMilliSec, ZkClientMonitor.AccessType accessType) {
        if (this._monitor != null) {
            int dataSize = data != null ? data.length : 0;
            this._monitor.record(path, dataSize, startTimeMilliSec, accessType);
        }
    }

    private void recordFailure(String path, ZkClientMonitor.AccessType accessType) {
        if (this._monitor != null) {
            this._monitor.recordFailure(path, accessType);
        }
    }

    private void recordStateChange(boolean stateChanged, boolean dataChanged) {
        if (this._monitor != null) {
            if (stateChanged) {
                this._monitor.increaseStateChangeEventCounter();
            }
            if (dataChanged) {
                this._monitor.increaseDataChangeEventCounter();
            }
        }
    }

    private void checkNumChildrenLimit(String path) throws KeeperException {
        Stat stat = this.getStat(path);
        if (stat == null) {
            return;
        }
        if (stat.getNumChildren() > 100000) {
            LOG.error("Failed to get children for path {} because of connection loss. Number of children {} exceeds limit {}, aborting retry.", new Object[]{path, stat.getNumChildren(), stat.getNumChildren(), 100000});
            throw new KeeperException.MarshallingErrorException();
        }
        LOG.debug("Number of children {} is less than limit {}, not exiting retry.", (Object)stat.getNumChildren(), (Object)100000);
    }

    private void validateWriteSizeLimitConfig() {
        int serializerSize = ZNRecordUtil.getSerializerWriteSizeLimit();
        LOG.info("ZNRecord serializer write size limit: {}; ZkClient write size limit: {}", (Object)serializerSize, (Object)WRITE_SIZE_LIMIT);
        if (serializerSize > WRITE_SIZE_LIMIT) {
            throw new IllegalStateException("ZNRecord serializer write size limit " + serializerSize + " is greater than ZkClient size limit " + WRITE_SIZE_LIMIT);
        }
    }

    private class ZkPathStatRecord {
        private final String _path;
        private Stat _stat = null;
        private boolean _checked = false;

        public ZkPathStatRecord(String path) {
            this._path = path;
        }

        public boolean pathExists() {
            return this._stat != null;
        }

        public boolean pathChecked() {
            return this._checked;
        }

        public void recordPathStat(Stat stat, OptionalLong notificationTime) {
            this._checked = true;
            this._stat = stat;
            if (ZkClient.this._monitor != null && stat != null && notificationTime.isPresent()) {
                long updateTime = Math.max(stat.getCtime(), stat.getMtime());
                if (notificationTime.getAsLong() > updateTime) {
                    ZkClient.this._monitor.recordDataPropagationLatency(this._path, notificationTime.getAsLong() - updateTime);
                }
            }
        }
    }

    private class IZkDataListenerEntry {
        final IZkDataListener _dataListener;
        final boolean _prefetchData;

        public IZkDataListenerEntry(IZkDataListener dataListener, boolean prefetchData) {
            this._dataListener = dataListener;
            this._prefetchData = prefetchData;
        }

        public IZkDataListenerEntry(IZkDataListener dataListener) {
            this._dataListener = dataListener;
            this._prefetchData = false;
        }

        public IZkDataListener getDataListener() {
            return this._dataListener;
        }

        public boolean isPrefetchData() {
            return this._prefetchData;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof IZkDataListenerEntry)) {
                return false;
            }
            IZkDataListenerEntry that = (IZkDataListenerEntry)o;
            return this._dataListener.equals(that._dataListener);
        }

        public int hashCode() {
            return this._dataListener.hashCode();
        }
    }
}

